# coding: utf-8

"""
    Mtmai API

    The Mtmai API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from mtmaisdk.clients.rest.models.artifact_v3 import ArtifactV3
from mtmaisdk.clients.rest.models.chat_message import ChatMessage
from mtmaisdk.clients.rest.models.code_highlight import CodeHighlight
from mtmaisdk.clients.rest.models.node_run_action import NodeRunAction
from mtmaisdk.clients.rest.models.text_highlight import TextHighlight
from typing import Optional, Set
from typing_extensions import Self

class CanvasGraphParams(BaseModel):
    """
    CanvasGraphParams
    """ # noqa: E501
    step_limit: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="步骤限制(没用上)", alias="stepLimit")
    messages: Optional[List[ChatMessage]] = None
    action: Optional[NodeRunAction] = None
    language: Optional[StrictStr] = Field(default=None, description="语言")
    custom_quick_action_id: Optional[StrictStr] = Field(default=None, description="自定义快速动作ID", alias="customQuickActionId")
    artifact_id: Optional[StrictStr] = Field(default=None, description="工件ID", alias="artifactId")
    fix_bugs: Optional[StrictBool] = Field(default=None, description="是否修复bug", alias="fixBugs")
    highlighted_code: Optional[CodeHighlight] = Field(default=None, alias="highlightedCode")
    highlighted_text: Optional[TextHighlight] = Field(default=None, alias="highlightedText")
    regenerate_with_emojis: Optional[StrictBool] = Field(default=None, description="是否使用表情符号重新生成", alias="regenerateWithEmojis")
    reading_level: Optional[StrictStr] = Field(default=None, description="阅读级别", alias="readingLevel")
    artifact_length: Optional[StrictStr] = Field(default=None, description="工具内容长度,(文章,代码内容长度)", alias="artifactLength")
    artifact: Optional[ArtifactV3] = None
    add_comments: Optional[StrictBool] = Field(default=None, alias="addComments")
    add_logs: Optional[StrictBool] = Field(default=None, alias="addLogs")
    port_language: Optional[StrictStr] = Field(default=None, alias="portLanguage")
    __properties: ClassVar[List[str]] = ["stepLimit", "messages", "action", "language", "customQuickActionId", "artifactId", "fixBugs", "highlightedCode", "highlightedText", "regenerateWithEmojis", "readingLevel", "artifactLength", "artifact", "addComments", "addLogs", "portLanguage"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CanvasGraphParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in messages (list)
        _items = []
        if self.messages:
            for _item_messages in self.messages:
                if _item_messages:
                    _items.append(_item_messages.to_dict())
            _dict['messages'] = _items
        # override the default output from pydantic by calling `to_dict()` of action
        if self.action:
            _dict['action'] = self.action.to_dict()
        # override the default output from pydantic by calling `to_dict()` of highlighted_code
        if self.highlighted_code:
            _dict['highlightedCode'] = self.highlighted_code.to_dict()
        # override the default output from pydantic by calling `to_dict()` of highlighted_text
        if self.highlighted_text:
            _dict['highlightedText'] = self.highlighted_text.to_dict()
        # override the default output from pydantic by calling `to_dict()` of artifact
        if self.artifact:
            _dict['artifact'] = self.artifact.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CanvasGraphParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "stepLimit": obj.get("stepLimit"),
            "messages": [ChatMessage.from_dict(_item) for _item in obj["messages"]] if obj.get("messages") is not None else None,
            "action": NodeRunAction.from_dict(obj["action"]) if obj.get("action") is not None else None,
            "language": obj.get("language"),
            "customQuickActionId": obj.get("customQuickActionId"),
            "artifactId": obj.get("artifactId"),
            "fixBugs": obj.get("fixBugs"),
            "highlightedCode": CodeHighlight.from_dict(obj["highlightedCode"]) if obj.get("highlightedCode") is not None else None,
            "highlightedText": TextHighlight.from_dict(obj["highlightedText"]) if obj.get("highlightedText") is not None else None,
            "regenerateWithEmojis": obj.get("regenerateWithEmojis"),
            "readingLevel": obj.get("readingLevel"),
            "artifactLength": obj.get("artifactLength"),
            "artifact": ArtifactV3.from_dict(obj["artifact"]) if obj.get("artifact") is not None else None,
            "addComments": obj.get("addComments"),
            "addLogs": obj.get("addLogs"),
            "portLanguage": obj.get("portLanguage")
        })
        return _obj


