# coding: utf-8

"""
    Mtmai API

    The Mtmai API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from mtmaisdk.clients.rest.models.quick_start import QuickStart
from typing import Optional, Set
from typing_extensions import Self

class ChatWelcome(BaseModel):
    """
    ChatWelcome
    """ # noqa: E501
    title: Optional[StrictStr] = Field(default=None, description="欢迎语标题")
    content: Optional[StrictStr] = Field(default=None, description="欢迎语内容")
    sub_title: Optional[StrictStr] = Field(default=None, description="主标题", alias="subTitle")
    quick_starts: Optional[List[QuickStart]] = None
    __properties: ClassVar[List[str]] = ["title", "content", "subTitle", "quick_starts"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ChatWelcome from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in quick_starts (list)
        _items = []
        if self.quick_starts:
            for _item_quick_starts in self.quick_starts:
                if _item_quick_starts:
                    _items.append(_item_quick_starts.to_dict())
            _dict['quick_starts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ChatWelcome from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "title": obj.get("title"),
            "content": obj.get("content"),
            "subTitle": obj.get("subTitle"),
            "quick_starts": [QuickStart.from_dict(_item) for _item in obj["quick_starts"]] if obj.get("quick_starts") is not None else None
        })
        return _obj


