# coding: utf-8

"""
    Mtmai API

    The Mtmai API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from mtmaisdk.clients.rest.models.dash_sidebar_item_leaf import DashSidebarItemLeaf
from typing import Optional, Set
from typing_extensions import Self

class DashSidebarItem(BaseModel):
    """
    DashSidebarItem
    """ # noqa: E501
    title: StrictStr = Field(description="名称")
    url: StrictStr = Field(description="url 例如/login")
    icon: Optional[StrictStr] = Field(default=None, description="图标")
    default_expanded: Optional[StrictBool] = Field(default=None, description="默认展开", alias="defaultExpanded")
    admin_only: Optional[StrictBool] = Field(default=None, description="只允许超级管理员查看", alias="adminOnly")
    children: Optional[List[DashSidebarItemLeaf]] = None
    __properties: ClassVar[List[str]] = ["title", "url", "icon", "defaultExpanded", "adminOnly", "children"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DashSidebarItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in children (list)
        _items = []
        if self.children:
            for _item_children in self.children:
                if _item_children:
                    _items.append(_item_children.to_dict())
            _dict['children'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DashSidebarItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "title": obj.get("title"),
            "url": obj.get("url"),
            "icon": obj.get("icon"),
            "defaultExpanded": obj.get("defaultExpanded"),
            "adminOnly": obj.get("adminOnly"),
            "children": [DashSidebarItemLeaf.from_dict(_item) for _item in obj["children"]] if obj.get("children") is not None else None
        })
        return _obj


