# coding: utf-8

"""
    Mtmai API

    The Mtmai API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List
from mtmaisdk.clients.rest.models.component_model import ComponentModel
from typing import Optional, Set
from typing_extensions import Self

class GalleryComponents(BaseModel):
    """
    GalleryComponents
    """ # noqa: E501
    agents: List[ComponentModel]
    models: List[ComponentModel]
    tools: List[ComponentModel]
    terminations: List[ComponentModel]
    __properties: ClassVar[List[str]] = ["agents", "models", "tools", "terminations"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GalleryComponents from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in agents (list)
        _items = []
        if self.agents:
            for _item_agents in self.agents:
                if _item_agents:
                    _items.append(_item_agents.to_dict())
            _dict['agents'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in models (list)
        _items = []
        if self.models:
            for _item_models in self.models:
                if _item_models:
                    _items.append(_item_models.to_dict())
            _dict['models'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tools (list)
        _items = []
        if self.tools:
            for _item_tools in self.tools:
                if _item_tools:
                    _items.append(_item_tools.to_dict())
            _dict['tools'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in terminations (list)
        _items = []
        if self.terminations:
            for _item_terminations in self.terminations:
                if _item_terminations:
                    _items.append(_item_terminations.to_dict())
            _dict['terminations'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GalleryComponents from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "agents": [ComponentModel.from_dict(_item) for _item in obj["agents"]] if obj.get("agents") is not None else None,
            "models": [ComponentModel.from_dict(_item) for _item in obj["models"]] if obj.get("models") is not None else None,
            "tools": [ComponentModel.from_dict(_item) for _item in obj["tools"]] if obj.get("tools") is not None else None,
            "terminations": [ComponentModel.from_dict(_item) for _item in obj["terminations"]] if obj.get("terminations") is not None else None
        })
        return _obj


