# coding: utf-8

"""
    Mtmai API

    The Mtmai API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from mtmaisdk.clients.rest.models.api_resource_meta import APIResourceMeta
from mtmaisdk.clients.rest.models.workflow_trigger_cron_ref import WorkflowTriggerCronRef
from mtmaisdk.clients.rest.models.workflow_trigger_event_ref import WorkflowTriggerEventRef
from typing import Optional, Set
from typing_extensions import Self

class WorkflowTriggers(BaseModel):
    """
    WorkflowTriggers
    """ # noqa: E501
    metadata: Optional[APIResourceMeta] = None
    workflow_version_id: Optional[StrictStr] = None
    tenant_id: Optional[StrictStr] = None
    events: Optional[List[WorkflowTriggerEventRef]] = None
    crons: Optional[List[WorkflowTriggerCronRef]] = None
    __properties: ClassVar[List[str]] = ["metadata", "workflow_version_id", "tenant_id", "events", "crons"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkflowTriggers from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in events (list)
        _items = []
        if self.events:
            for _item_events in self.events:
                if _item_events:
                    _items.append(_item_events.to_dict())
            _dict['events'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in crons (list)
        _items = []
        if self.crons:
            for _item_crons in self.crons:
                if _item_crons:
                    _items.append(_item_crons.to_dict())
            _dict['crons'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkflowTriggers from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "metadata": APIResourceMeta.from_dict(obj["metadata"]) if obj.get("metadata") is not None else None,
            "workflow_version_id": obj.get("workflow_version_id"),
            "tenant_id": obj.get("tenant_id"),
            "events": [WorkflowTriggerEventRef.from_dict(_item) for _item in obj["events"]] if obj.get("events") is not None else None,
            "crons": [WorkflowTriggerCronRef.from_dict(_item) for _item in obj["crons"]] if obj.get("crons") is not None else None
        })
        return _obj


