# coding: utf-8

"""
    Data Repository API

    This document defines the REST API for Data Repository. **Status: design in progress** There are four top-level endpoints (besides some used by swagger):  * /swagger-ui.html - generated by swagger: swagger API page that provides this documentation and a live UI for      submitting REST requests  * /status - provides the operational status of the service  * /api    - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The overall API (/api) currently supports two interfaces:  * Repository - a general and default interface for initial setup, managing ingest and repository metadata  * Resource - an interface for managing billing accounts and resources  The API endpoints are organized by interface. Each interface is separately versioned. ## Notes on Naming All of the reference items are suffixed with \"Model\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. ## Editing and debugging I have found it best to edit this file directly to make changes and then use the swagger-editor to validate. The errors out of swagger-codegen are not that helpful. In the swagger-editor, it gives you nice errors and links to the place in the YAML where the errors are. But... the swagger-editor has been a bit of a pain for me to run. I tried the online website and was not able to load my YAML. Instead, I run it locally in a docker container, like this: ``` docker pull swaggerapi/swagger-editor docker run -p 9090:8080 swaggerapi/swagger-editor ``` Then navigate to localhost:9090 in your browser. I have not been able to get the file upload to work. It is a bit of a PITA, but I copy-paste the source code, replacing what is in the editor. Then make any fixes. Then copy-paste the resulting, valid file back into our source code. Not elegant, but easier than playing detective with the swagger-codegen errors. This might be something about my browser or environment, so give it a try yourself and see how it goes. ## Merging the DRS standard swagger into this swagger ## The merging is done in three sections:  1. Merging the security definitions into our security definitions  2. This section of paths. We make all paths explicit (prefixed with /ga4gh/drs/v1)     All standard DRS definitions and parameters are prefixed with 'DRS' to separate them     from our native definitions and parameters. We remove the x-swagger-router-controller lines.  3. A separate part of the definitions section for the DRS definitions  NOTE: the code here does not relect the DRS spec anymore. See DR-409.   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class BulkLoadFileResultModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'source_path': 'str',
        'target_path': 'str',
        'state': 'BulkLoadFileState',
        'file_id': 'str',
        'error': 'str'
    }

    attribute_map = {
        'source_path': 'sourcePath',
        'target_path': 'targetPath',
        'state': 'state',
        'file_id': 'fileId',
        'error': 'error'
    }

    def __init__(self, source_path=None, target_path=None, state=None, file_id=None, error=None, local_vars_configuration=None):  # noqa: E501
        """BulkLoadFileResultModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._source_path = None
        self._target_path = None
        self._state = None
        self._file_id = None
        self._error = None
        self.discriminator = None

        self.source_path = source_path
        self.target_path = target_path
        if state is not None:
            self.state = state
        if file_id is not None:
            self.file_id = file_id
        if error is not None:
            self.error = error

    @property
    def source_path(self):
        """Gets the source_path of this BulkLoadFileResultModel.  # noqa: E501

        gs URL of the source file to load  # noqa: E501

        :return: The source_path of this BulkLoadFileResultModel.  # noqa: E501
        :rtype: str
        """
        return self._source_path

    @source_path.setter
    def source_path(self, source_path):
        """Sets the source_path of this BulkLoadFileResultModel.

        gs URL of the source file to load  # noqa: E501

        :param source_path: The source_path of this BulkLoadFileResultModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and source_path is None:  # noqa: E501
            raise ValueError("Invalid value for `source_path`, must not be `None`")  # noqa: E501

        self._source_path = source_path

    @property
    def target_path(self):
        """Gets the target_path of this BulkLoadFileResultModel.  # noqa: E501

        Full path within the dataset where the file should be placed. The path must start with /.   # noqa: E501

        :return: The target_path of this BulkLoadFileResultModel.  # noqa: E501
        :rtype: str
        """
        return self._target_path

    @target_path.setter
    def target_path(self, target_path):
        """Sets the target_path of this BulkLoadFileResultModel.

        Full path within the dataset where the file should be placed. The path must start with /.   # noqa: E501

        :param target_path: The target_path of this BulkLoadFileResultModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and target_path is None:  # noqa: E501
            raise ValueError("Invalid value for `target_path`, must not be `None`")  # noqa: E501

        self._target_path = target_path

    @property
    def state(self):
        """Gets the state of this BulkLoadFileResultModel.  # noqa: E501


        :return: The state of this BulkLoadFileResultModel.  # noqa: E501
        :rtype: BulkLoadFileState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this BulkLoadFileResultModel.


        :param state: The state of this BulkLoadFileResultModel.  # noqa: E501
        :type: BulkLoadFileState
        """

        self._state = state

    @property
    def file_id(self):
        """Gets the file_id of this BulkLoadFileResultModel.  # noqa: E501

        The fileId of the loaded file; non-null if state is SUCCEEDED  # noqa: E501

        :return: The file_id of this BulkLoadFileResultModel.  # noqa: E501
        :rtype: str
        """
        return self._file_id

    @file_id.setter
    def file_id(self, file_id):
        """Sets the file_id of this BulkLoadFileResultModel.

        The fileId of the loaded file; non-null if state is SUCCEEDED  # noqa: E501

        :param file_id: The file_id of this BulkLoadFileResultModel.  # noqa: E501
        :type: str
        """

        self._file_id = file_id

    @property
    def error(self):
        """Gets the error of this BulkLoadFileResultModel.  # noqa: E501

        The error message if state is FAILED  # noqa: E501

        :return: The error of this BulkLoadFileResultModel.  # noqa: E501
        :rtype: str
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this BulkLoadFileResultModel.

        The error message if state is FAILED  # noqa: E501

        :param error: The error of this BulkLoadFileResultModel.  # noqa: E501
        :type: str
        """

        self._error = error

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BulkLoadFileResultModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BulkLoadFileResultModel):
            return True

        return self.to_dict() != other.to_dict()
