# coding: utf-8

"""
    Data Repository API

    This document defines the REST API for Data Repository. **Status: design in progress** There are four top-level endpoints (besides some used by swagger):  * /swagger-ui.html - generated by swagger: swagger API page that provides this documentation and a live UI for      submitting REST requests  * /status - provides the operational status of the service  * /api    - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The overall API (/api) currently supports two interfaces:  * Repository - a general and default interface for initial setup, managing ingest and repository metadata  * Resource - an interface for managing billing accounts and resources  The API endpoints are organized by interface. Each interface is separately versioned. ## Notes on Naming All of the reference items are suffixed with \"Model\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. ## Editing and debugging I have found it best to edit this file directly to make changes and then use the swagger-editor to validate. The errors out of swagger-codegen are not that helpful. In the swagger-editor, it gives you nice errors and links to the place in the YAML where the errors are. But... the swagger-editor has been a bit of a pain for me to run. I tried the online website and was not able to load my YAML. Instead, I run it locally in a docker container, like this: ``` docker pull swaggerapi/swagger-editor docker run -p 9090:8080 swaggerapi/swagger-editor ``` Then navigate to localhost:9090 in your browser. I have not been able to get the file upload to work. It is a bit of a PITA, but I copy-paste the source code, replacing what is in the editor. Then make any fixes. Then copy-paste the resulting, valid file back into our source code. Not elegant, but easier than playing detective with the swagger-codegen errors. This might be something about my browser or environment, so give it a try yourself and see how it goes. ## Merging the DRS standard swagger into this swagger ## The merging is done in three sections:  1. Merging the security definitions into our security definitions  2. This section of paths. We make all paths explicit (prefixed with /ga4gh/drs/v1)     All standard DRS definitions and parameters are prefixed with 'DRS' to separate them     from our native definitions and parameters. We remove the x-swagger-router-controller lines.  3. A separate part of the definitions section for the DRS definitions  NOTE: the code here does not relect the DRS spec anymore. See DR-409.   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class ConfigFaultCountedModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'skip_for': 'int',
        'insert': 'int',
        'rate': 'int',
        'rate_style': 'str'
    }

    attribute_map = {
        'skip_for': 'skipFor',
        'insert': 'insert',
        'rate': 'rate',
        'rate_style': 'rateStyle'
    }

    def __init__(self, skip_for=None, insert=None, rate=None, rate_style=None, local_vars_configuration=None):  # noqa: E501
        """ConfigFaultCountedModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._skip_for = None
        self._insert = None
        self._rate = None
        self._rate_style = None
        self.discriminator = None

        if skip_for is not None:
            self.skip_for = skip_for
        if insert is not None:
            self.insert = insert
        if rate is not None:
            self.rate = rate
        if rate_style is not None:
            self.rate_style = rate_style

    @property
    def skip_for(self):
        """Gets the skip_for of this ConfigFaultCountedModel.  # noqa: E501

        number of fault tests to skip before beginning fault insertion  # noqa: E501

        :return: The skip_for of this ConfigFaultCountedModel.  # noqa: E501
        :rtype: int
        """
        return self._skip_for

    @skip_for.setter
    def skip_for(self, skip_for):
        """Sets the skip_for of this ConfigFaultCountedModel.

        number of fault tests to skip before beginning fault insertion  # noqa: E501

        :param skip_for: The skip_for of this ConfigFaultCountedModel.  # noqa: E501
        :type: int
        """

        self._skip_for = skip_for

    @property
    def insert(self):
        """Gets the insert of this ConfigFaultCountedModel.  # noqa: E501

        total number of times to insert the fault; -1 means insert forever  # noqa: E501

        :return: The insert of this ConfigFaultCountedModel.  # noqa: E501
        :rtype: int
        """
        return self._insert

    @insert.setter
    def insert(self, insert):
        """Sets the insert of this ConfigFaultCountedModel.

        total number of times to insert the fault; -1 means insert forever  # noqa: E501

        :param insert: The insert of this ConfigFaultCountedModel.  # noqa: E501
        :type: int
        """

        self._insert = insert

    @property
    def rate(self):
        """Gets the rate of this ConfigFaultCountedModel.  # noqa: E501

        insert a fault rate percent of the time. If rate is 100, the fault will always be inserted regardless of rate.   # noqa: E501

        :return: The rate of this ConfigFaultCountedModel.  # noqa: E501
        :rtype: int
        """
        return self._rate

    @rate.setter
    def rate(self, rate):
        """Sets the rate of this ConfigFaultCountedModel.

        insert a fault rate percent of the time. If rate is 100, the fault will always be inserted regardless of rate.   # noqa: E501

        :param rate: The rate of this ConfigFaultCountedModel.  # noqa: E501
        :type: int
        """

        self._rate = rate

    @property
    def rate_style(self):
        """Gets the rate_style of this ConfigFaultCountedModel.  # noqa: E501

        fixed style means insert the fault; skip for rate-1; ... random style means randomly insert the fault with probability of 1:<rate>   # noqa: E501

        :return: The rate_style of this ConfigFaultCountedModel.  # noqa: E501
        :rtype: str
        """
        return self._rate_style

    @rate_style.setter
    def rate_style(self, rate_style):
        """Sets the rate_style of this ConfigFaultCountedModel.

        fixed style means insert the fault; skip for rate-1; ... random style means randomly insert the fault with probability of 1:<rate>   # noqa: E501

        :param rate_style: The rate_style of this ConfigFaultCountedModel.  # noqa: E501
        :type: str
        """
        allowed_values = ["fixed", "random"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and rate_style not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `rate_style` ({0}), must be one of {1}"  # noqa: E501
                .format(rate_style, allowed_values)
            )

        self._rate_style = rate_style

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ConfigFaultCountedModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ConfigFaultCountedModel):
            return True

        return self.to_dict() != other.to_dict()
