"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManagedInstanceRole = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
class ManagedInstanceRole extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        var managedPolicies = props.managedPolicies === undefined ? [] : props.managedPolicies;
        let domainJoinEnabled = props.domainJoinEnabled === undefined ||
            props.domainJoinEnabled === true;
        let ssmManagementEnabled = props.ssmManagementEnabled === undefined ||
            props.domainJoinEnabled === undefined ||
            props.domainJoinEnabled === true ||
            props.ssmManagementEnabled === true;
        if (ssmManagementEnabled) {
            managedPolicies.push(iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        }
        ;
        if (domainJoinEnabled) {
            managedPolicies.push(iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMDirectoryServiceAccess'));
        }
        ;
        const role = new iam.Role(this, 'role', {
            assumedBy: new iam.ServicePrincipal('ec2.amazonaws.com'),
            managedPolicies,
        });
        this.instanceProfile = new iam.CfnInstanceProfile(this, 'instanceProfile', {
            roles: [role.roleName],
        });
    }
}
exports.ManagedInstanceRole = ManagedInstanceRole;
_a = JSII_RTTI_SYMBOL_1;
ManagedInstanceRole[_a] = { fqn: "@renovosolutions/cdk-library-managed-instance-role.ManagedInstanceRole", version: "1.0.188" };
//# sourceMappingURL=data:application/json;base64,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