"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Account = exports.AccountProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const redis_generated_1 = require("./redis.generated");
Object.defineProperty(exports, "AccountProperty", { enumerable: true, get: function () { return redis_generated_1.RosAccount; } });
/**
 * A ROS resource type:  `ALIYUN::REDIS::Account`
 */
class Account extends ros.Resource {
    /**
     * Create a new `ALIYUN::REDIS::Account`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosAccount = new redis_generated_1.RosAccount(this, id, {
            accountDescription: props.accountDescription,
            instanceId: props.instanceId,
            accountPrivilege: props.accountPrivilege,
            accountType: props.accountType ? props.accountType : 'Normal',
            accountName: props.accountName,
            accountPassword: props.accountPassword,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosAccount;
        this.attrAccountName = rosAccount.attrAccountName;
        this.attrInstanceId = rosAccount.attrInstanceId;
    }
}
exports.Account = Account;
//# sourceMappingURL=data:application/json;base64,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