"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.InstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const redis_generated_1 = require("./redis.generated");
Object.defineProperty(exports, "InstanceProperty", { enumerable: true, get: function () { return redis_generated_1.RosInstance; } });
/**
 * A ROS resource type:  `ALIYUN::REDIS::Instance`
 */
class Instance extends ros.Resource {
    /**
     * Create a new `ALIYUN::REDIS::Instance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosInstance = new redis_generated_1.RosInstance(this, id, {
            engineVersion: props.engineVersion,
            evictionPolicy: props.evictionPolicy,
            zoneId: props.zoneId,
            vSwitchId: props.vSwitchId,
            securityGroupId: props.securityGroupId,
            instanceMaintainTime: props.instanceMaintainTime,
            instanceClass: props.instanceClass,
            vpcPasswordFree: props.vpcPasswordFree,
            instanceConnection: props.instanceConnection,
            instanceName: props.instanceName,
            vpcId: props.vpcId,
            sslEnabled: props.sslEnabled,
            capacity: props.capacity,
            tags: ros.tagFactory(props.tags),
            backupPolicy: props.backupPolicy,
            password: props.password,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstance;
        this.attrConnectionDomain = rosInstance.attrConnectionDomain;
        this.attrInstanceId = rosInstance.attrInstanceId;
        this.attrOrderId = rosInstance.attrOrderId;
        this.attrPort = rosInstance.attrPort;
    }
}
exports.Instance = Instance;
//# sourceMappingURL=data:application/json;base64,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