"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Whitelist = exports.WhitelistProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const redis_generated_1 = require("./redis.generated");
Object.defineProperty(exports, "WhitelistProperty", { enumerable: true, get: function () { return redis_generated_1.RosWhitelist; } });
/**
 * A ROS resource type:  `ALIYUN::REDIS::Whitelist`
 */
class Whitelist extends ros.Resource {
    /**
     * Create a new `ALIYUN::REDIS::Whitelist`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosWhitelist = new redis_generated_1.RosWhitelist(this, id, {
            securityIpGroupAttribute: props.securityIpGroupAttribute,
            securityIps: props.securityIps,
            instanceId: props.instanceId,
            securityIpGroupName: props.securityIpGroupName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosWhitelist;
        this.attrSecurityIpGroupAttribute = rosWhitelist.attrSecurityIpGroupAttribute;
        this.attrSecurityIpGroupName = rosWhitelist.attrSecurityIpGroupName;
        this.attrSecurityIps = rosWhitelist.attrSecurityIps;
    }
}
exports.Whitelist = Whitelist;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoid2hpdGVsaXN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsid2hpdGVsaXN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDhDQUE4QztBQUM5Qyx1REFBaUQ7QUFFeEIsa0dBRmhCLDhCQUFZLE9BRXFCO0FBNEIxQzs7R0FFRztBQUNILE1BQWEsU0FBVSxTQUFRLEdBQUcsQ0FBQyxRQUFRO0lBc0J2Qzs7Ozs7O09BTUc7SUFDSCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQXFCLEVBQUUsbUNBQTJDLElBQUk7UUFDaEgsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLFlBQVksR0FBRyxJQUFJLDhCQUFZLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRztZQUM3Qyx3QkFBd0IsRUFBRSxLQUFLLENBQUMsd0JBQXdCO1lBQ3hELFdBQVcsRUFBRSxLQUFLLENBQUMsV0FBVztZQUM5QixVQUFVLEVBQUUsS0FBSyxDQUFDLFVBQVU7WUFDNUIsbUJBQW1CLEVBQUUsS0FBSyxDQUFDLG1CQUFtQjtTQUNqRCxFQUFFLGdDQUFnQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUNwRixJQUFJLENBQUMsUUFBUSxHQUFHLFlBQVksQ0FBQztRQUM3QixJQUFJLENBQUMsNEJBQTRCLEdBQUcsWUFBWSxDQUFDLDRCQUE0QixDQUFDO1FBQzlFLElBQUksQ0FBQyx1QkFBdUIsR0FBRyxZQUFZLENBQUMsdUJBQXVCLENBQUM7UUFDcEUsSUFBSSxDQUFDLGVBQWUsR0FBRyxZQUFZLENBQUMsZUFBZSxDQUFDO0lBQ3hELENBQUM7Q0FDSjtBQTNDRCw4QkEyQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyByb3MgZnJvbSAnQGFsaWNsb3VkL3Jvcy1jZGstY29yZSc7XHJcbmltcG9ydCB7IFJvc1doaXRlbGlzdCB9IGZyb20gJy4vcmVkaXMuZ2VuZXJhdGVkJztcclxuLy8gR2VuZXJhdGVkIGZyb20gdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBTcGVjaWZpY2F0aW9uXHJcbmV4cG9ydCB7IFJvc1doaXRlbGlzdCBhcyBXaGl0ZWxpc3RQcm9wZXJ0eSB9O1xyXG5cclxuLyoqXHJcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYEFMSVlVTjo6UkVESVM6OldoaXRlbGlzdGBcclxuICovXHJcbmV4cG9ydCBpbnRlcmZhY2UgV2hpdGVsaXN0UHJvcHMge1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGluc3RhbmNlSWQ6IEluc3RhbmNlIElEIChnbG9iYWxseSB1bmlxdWUpXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IGluc3RhbmNlSWQ6IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBzZWN1cml0eUlwczogSVAgYWRkcmVzcyB3aGl0ZWxpc3QgdG8gYmUgbW9kaWZpZWRcclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgc2VjdXJpdHlJcHM6IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBzZWN1cml0eUlwR3JvdXBBdHRyaWJ1dGU6IFRoZSBkZWZhdWx0IGlzIGVtcHR5LiBGb3IgZGlzdGluZ3Vpc2hpbmcgYmV0d2VlbiBkaWZmZXJlbnQgYXR0cmlidXRlIHZhbHVlcywgdGhlIGNvbnNvbGUgd2lsbCBub3QgZGlzcGxheSB0aGUgdmFsdWUgb2YgaGlkZGVuIHdoaXRlbGlzdCBwYWNrZXQuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IHNlY3VyaXR5SXBHcm91cEF0dHJpYnV0ZT86IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBzZWN1cml0eUlwR3JvdXBOYW1lOiBXaGl0ZWxpc3QgZ3JvdXBcclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgc2VjdXJpdHlJcEdyb3VwTmFtZT86IHN0cmluZztcclxufVxyXG5cclxuLyoqXHJcbiAqIEEgUk9TIHJlc291cmNlIHR5cGU6ICBgQUxJWVVOOjpSRURJUzo6V2hpdGVsaXN0YFxyXG4gKi9cclxuZXhwb3J0IGNsYXNzIFdoaXRlbGlzdCBleHRlbmRzIHJvcy5SZXNvdXJjZSB7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBBIGZhY3RvcnkgbWV0aG9kIHRoYXQgY3JlYXRlcyBhIG5ldyBpbnN0YW5jZSBvZiB0aGlzIGNsYXNzIGZyb20gYW4gb2JqZWN0XHJcbiAgICAgKiBjb250YWluaW5nIHRoZSBwcm9wZXJ0aWVzIG9mIHRoaXMgUk9TIHJlc291cmNlLCB3aGljaCB3aWxsIGJlIGFzc2lnbmVkIHRvIFJPUyByZXNvdXJjZS5cclxuICAgICAqL1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQEF0dHJpYnV0ZSBTZWN1cml0eUlwR3JvdXBBdHRyaWJ1dGU6IFRoZSBkZWZhdWx0IGlzIGVtcHR5LiBGb3IgZGlzdGluZ3Vpc2hpbmcgYmV0d2VlbiBkaWZmZXJlbnQgYXR0cmlidXRlIHZhbHVlcywgdGhlIGNvbnNvbGUgd2lsbCBub3QgZGlzcGxheSB0aGUgdmFsdWUgb2YgaGlkZGVuIHdoaXRlbGlzdCBwYWNrZXQuXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyByZWFkb25seSBhdHRyU2VjdXJpdHlJcEdyb3VwQXR0cmlidXRlOiBhbnk7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAQXR0cmlidXRlIFNlY3VyaXR5SXBHcm91cE5hbWU6IFdoaXRlbGlzdCBncm91cFxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0clNlY3VyaXR5SXBHcm91cE5hbWU6IGFueTtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBBdHRyaWJ1dGUgU2VjdXJpdHlJcHM6IElQIGFkZHJlc3Mgd2hpdGVsaXN0IHRvIGJlIG1vZGlmaWVkXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyByZWFkb25seSBhdHRyU2VjdXJpdHlJcHM6IGFueTtcclxuXHJcbiAgICAvKipcclxuICAgICAqIENyZWF0ZSBhIG5ldyBgQUxJWVVOOjpSRURJUzo6V2hpdGVsaXN0YC5cclxuICAgICAqXHJcbiAgICAgKiBAcGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcclxuICAgICAqIEBwYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcclxuICAgICAqIEBwYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcclxuICAgICAqL1xyXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IHJvcy5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBXaGl0ZWxpc3RQcm9wcywgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6Ym9vbGVhbiA9IHRydWUpIHtcclxuICAgICAgICBzdXBlcihzY29wZSwgaWQpO1xyXG5cclxuICAgICAgICBjb25zdCByb3NXaGl0ZWxpc3QgPSBuZXcgUm9zV2hpdGVsaXN0KHRoaXMsIGlkLCAge1xyXG4gICAgICAgICAgICBzZWN1cml0eUlwR3JvdXBBdHRyaWJ1dGU6IHByb3BzLnNlY3VyaXR5SXBHcm91cEF0dHJpYnV0ZSxcclxuICAgICAgICAgICAgc2VjdXJpdHlJcHM6IHByb3BzLnNlY3VyaXR5SXBzLFxyXG4gICAgICAgICAgICBpbnN0YW5jZUlkOiBwcm9wcy5pbnN0YW5jZUlkLFxyXG4gICAgICAgICAgICBzZWN1cml0eUlwR3JvdXBOYW1lOiBwcm9wcy5zZWN1cml0eUlwR3JvdXBOYW1lLFxyXG4gICAgICAgIH0sIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50ICYmIHRoaXMuc3RhY2suZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQpO1xyXG4gICAgICAgIHRoaXMucmVzb3VyY2UgPSByb3NXaGl0ZWxpc3Q7XHJcbiAgICAgICAgdGhpcy5hdHRyU2VjdXJpdHlJcEdyb3VwQXR0cmlidXRlID0gcm9zV2hpdGVsaXN0LmF0dHJTZWN1cml0eUlwR3JvdXBBdHRyaWJ1dGU7XHJcbiAgICAgICAgdGhpcy5hdHRyU2VjdXJpdHlJcEdyb3VwTmFtZSA9IHJvc1doaXRlbGlzdC5hdHRyU2VjdXJpdHlJcEdyb3VwTmFtZTtcclxuICAgICAgICB0aGlzLmF0dHJTZWN1cml0eUlwcyA9IHJvc1doaXRlbGlzdC5hdHRyU2VjdXJpdHlJcHM7XHJcbiAgICB9XHJcbn1cclxuIl19