# mypy: ignore-errors

# generated by datamodel-codegen:
#   filename:  https://schemas.getdbt.com/dbt/catalog/v1.json
#   timestamp: 2021-10-01T15:10:19+00:00

from __future__ import annotations

from datetime import datetime
from typing import Dict, List, Optional, Union

from pydantic import BaseModel, Extra, Field


class CatalogMetadata(BaseModel):
    class Config:
        extra = Extra.forbid

    dbt_schema_version: Optional[str] = 'https://schemas.getdbt.com/dbt/catalog/v1.json'
    dbt_version: Optional[str] = '0.20.0rc1'
    generated_at: Optional[datetime] = '2021-06-07T14:49:01.098234Z'
    invocation_id: Optional[Optional[str]] = None
    env: Optional[Dict[str, str]] = {}


class TableMetadata(BaseModel):
    class Config:
        extra = Extra.forbid

    type: str
    schema_: str = Field(..., alias='schema')
    name: str
    database: Optional[Optional[str]] = None
    comment: Optional[Optional[str]] = None
    owner: Optional[Optional[str]] = None


class ColumnMetadata(BaseModel):
    class Config:
        extra = Extra.forbid

    type: str
    index: int
    name: str
    comment: Optional[Optional[str]] = None


class StatsItem(BaseModel):
    class Config:
        extra = Extra.forbid

    id: str
    label: str
    value: Optional[Optional[Union[bool, str, float]]] = None
    include: bool
    description: Optional[Optional[str]] = None


class CatalogTable(BaseModel):
    class Config:
        extra = Extra.forbid

    metadata: TableMetadata
    columns: Dict[str, ColumnMetadata]
    stats: Dict[str, StatsItem]
    unique_id: Optional[Optional[str]] = None


class DbtCatalog(BaseModel):
    class Config:
        extra = Extra.forbid

    metadata: CatalogMetadata
    nodes: Dict[str, CatalogTable]
    sources: Dict[str, CatalogTable]
    errors: Optional[Optional[List[str]]] = None
