# Generated by Django 3.2.16 on 2023-01-30 09:52

import django.utils.timezone
import model_utils.fields
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('outcome_surveys', '0002_learnercourseevent_already_sent'),
    ]

    operations = [
        migrations.CreateModel(
            name='MultiChoiceResponse',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('answer', models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name='SurveyExport',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('survey_id', models.IntegerField()),
                ('last_successfull_export_at', models.DateTimeField()),
            ],
        ),
        migrations.CreateModel(
            name='CourseReflection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('survey_id', models.IntegerField()),
                ('survey_response_id', models.IntegerField()),
                ('enrollment_type', models.CharField(help_text='Enrollment type. B2C or B2B', max_length=16, null=True)),
                ('lms_enrollment_id', models.IntegerField(help_text="Learner's LMS course enrollment id.", null=True)),
                ('help_reach_goal', models.CharField(help_text='How confident are you that the learning you did in this course will help you reach your goal?', max_length=256, null=True)),
                ('course_rating', models.IntegerField(help_text='How would you rate the quality of this course?', null=True)),
                ('course_experience', models.TextField(help_text="Is there anything else you'd like to add about your experience in the course?", null=True)),
                ('open_to_outreach', models.BooleanField(help_text='Would you be open to someone from edX reaching out to learn more about your experience?', null=True)),
                ('goal_decisions', models.ManyToManyField(help_text='How did you decide on that goal?', related_name='_outcome_surveys_coursereflection_goal_decisions_+', to='outcome_surveys.MultiChoiceResponse')),
                ('online_learning_goals', models.ManyToManyField(help_text='What is your goal with online learning?', related_name='_outcome_surveys_coursereflection_online_learning_goals_+', to='outcome_surveys.MultiChoiceResponse')),
            ],
        ),
        migrations.CreateModel(
            name='CourseGoal',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('survey_id', models.IntegerField()),
                ('survey_response_id', models.IntegerField()),
                ('enrollment_type', models.CharField(help_text='Enrollment type. B2C or B2B', max_length=16, null=True)),
                ('lms_enrollment_id', models.IntegerField(help_text="Learner's LMS course enrollment id.", null=True)),
                ('goal_achieved', models.BooleanField(help_text='Did you achieve that goal?', null=True)),
                ('online_learning_goal', models.TextField(help_text='In a few words, describe your goal for online learning.', null=True)),
                ('open_to_outreach', models.BooleanField(help_text='Would you be open to someone from edX reaching out to learn more about your experience?', null=True)),
                ('salary_change', models.BooleanField(help_text='Did you experience any salary changes as a result of meeting this goal?', null=True)),
                ('job_promotion', models.BooleanField(help_text='Did you experience a job promotion or job change as a result of meeting this goal?', null=True)),
                ('learning_experience_importance', models.CharField(help_text='How important was the learning experience you had on edX for achieving that goal?', max_length=256, null=True)),
                ('experience_impacted_goals', models.TextField(help_text='Is there anything else you’d like to share about how your experience on edX impacted your goals?', null=True)),
                ('close_to_goal', models.CharField(help_text='How close are you from achieving your goal?', max_length=256, null=True)),
                ('factors_influenced_timeline', models.TextField(help_text='What factors influenced the timeline for your goal?', null=True)),
                ('achieve_goal_sooner', models.TextField(help_text='Is there anything that could have gone different with your experience on edX to help you achieve your goal sooner?', null=True)),
                ('online_learning_goals', models.ManyToManyField(help_text='What is your goal with online learning?', related_name='_outcome_surveys_coursegoal_online_learning_goals_+', to='outcome_surveys.MultiChoiceResponse')),
            ],
        ),
        migrations.AddIndex(
            model_name='coursereflection',
            index=models.Index(fields=['lms_enrollment_id'], name='outcome_sur_lms_enr_245902_idx'),
        ),
        migrations.AddIndex(
            model_name='coursegoal',
            index=models.Index(fields=['lms_enrollment_id'], name='outcome_sur_lms_enr_9c26bd_idx'),
        ),
    ]
