import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudDatacenterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/datacenter#id DataIonoscloudDatacenter#id}
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/datacenter#location DataIonoscloudDatacenter#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/datacenter#name DataIonoscloudDatacenter#name}
    */
    readonly name?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/datacenter#timeouts DataIonoscloudDatacenter#timeouts}
    */
    readonly timeouts?: DataIonoscloudDatacenterTimeouts;
}
export interface DataIonoscloudDatacenterCpuArchitecture {
}
export declare function dataIonoscloudDatacenterCpuArchitectureToTerraform(struct?: DataIonoscloudDatacenterCpuArchitecture): any;
export declare class DataIonoscloudDatacenterCpuArchitectureOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudDatacenterCpuArchitecture | undefined;
    set internalValue(value: DataIonoscloudDatacenterCpuArchitecture | undefined);
    get cpuFamily(): string;
    get maxCores(): number;
    get maxRam(): number;
    get vendor(): string;
}
export declare class DataIonoscloudDatacenterCpuArchitectureList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudDatacenterCpuArchitectureOutputReference;
}
export interface DataIonoscloudDatacenterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/datacenter#create DataIonoscloudDatacenter#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/datacenter#default DataIonoscloudDatacenter#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/datacenter#delete DataIonoscloudDatacenter#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/datacenter#update DataIonoscloudDatacenter#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudDatacenterTimeoutsToTerraform(struct?: DataIonoscloudDatacenterTimeoutsOutputReference | DataIonoscloudDatacenterTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudDatacenterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudDatacenterTimeouts | undefined;
    set internalValue(value: DataIonoscloudDatacenterTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/datacenter ionoscloud_datacenter}
*/
export declare class DataIonoscloudDatacenter extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_datacenter";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/datacenter ionoscloud_datacenter} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudDatacenterConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataIonoscloudDatacenterConfig);
    private _cpuArchitecture;
    get cpuArchitecture(): DataIonoscloudDatacenterCpuArchitectureList;
    get description(): string;
    get features(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get secAuthProtection(): cdktf.IResolvable;
    get version(): number;
    private _timeouts;
    get timeouts(): DataIonoscloudDatacenterTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudDatacenterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataIonoscloudDatacenterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-ionoscloud-datacenter.d.ts.map