import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudK8SNodePoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_node_pool#id DataIonoscloudK8SNodePool#id}
    */
    readonly id?: string;
    /**
    * The UUID of an existing kubernetes cluster
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_node_pool#k8s_cluster_id DataIonoscloudK8SNodePool#k8s_cluster_id}
    */
    readonly k8SClusterId: string;
    /**
    * The desired name for the node pool
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_node_pool#name DataIonoscloudK8SNodePool#name}
    */
    readonly name?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_node_pool#timeouts DataIonoscloudK8SNodePool#timeouts}
    */
    readonly timeouts?: DataIonoscloudK8SNodePoolTimeouts;
}
export interface DataIonoscloudK8SNodePoolAutoScaling {
}
export declare function dataIonoscloudK8SNodePoolAutoScalingToTerraform(struct?: DataIonoscloudK8SNodePoolAutoScaling): any;
export declare class DataIonoscloudK8SNodePoolAutoScalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudK8SNodePoolAutoScaling | undefined;
    set internalValue(value: DataIonoscloudK8SNodePoolAutoScaling | undefined);
    get maxNodeCount(): number;
    get minNodeCount(): number;
}
export declare class DataIonoscloudK8SNodePoolAutoScalingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudK8SNodePoolAutoScalingOutputReference;
}
export interface DataIonoscloudK8SNodePoolLansRoutes {
}
export declare function dataIonoscloudK8SNodePoolLansRoutesToTerraform(struct?: DataIonoscloudK8SNodePoolLansRoutes): any;
export declare class DataIonoscloudK8SNodePoolLansRoutesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudK8SNodePoolLansRoutes | undefined;
    set internalValue(value: DataIonoscloudK8SNodePoolLansRoutes | undefined);
    get gatewayIp(): string;
    get network(): string;
}
export declare class DataIonoscloudK8SNodePoolLansRoutesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudK8SNodePoolLansRoutesOutputReference;
}
export interface DataIonoscloudK8SNodePoolLans {
}
export declare function dataIonoscloudK8SNodePoolLansToTerraform(struct?: DataIonoscloudK8SNodePoolLans): any;
export declare class DataIonoscloudK8SNodePoolLansOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudK8SNodePoolLans | undefined;
    set internalValue(value: DataIonoscloudK8SNodePoolLans | undefined);
    get dhcp(): cdktf.IResolvable;
    get id(): number;
    private _routes;
    get routes(): DataIonoscloudK8SNodePoolLansRoutesList;
}
export declare class DataIonoscloudK8SNodePoolLansList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudK8SNodePoolLansOutputReference;
}
export interface DataIonoscloudK8SNodePoolMaintenanceWindow {
}
export declare function dataIonoscloudK8SNodePoolMaintenanceWindowToTerraform(struct?: DataIonoscloudK8SNodePoolMaintenanceWindow): any;
export declare class DataIonoscloudK8SNodePoolMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudK8SNodePoolMaintenanceWindow | undefined;
    set internalValue(value: DataIonoscloudK8SNodePoolMaintenanceWindow | undefined);
    get dayOfTheWeek(): string;
    get time(): string;
}
export declare class DataIonoscloudK8SNodePoolMaintenanceWindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudK8SNodePoolMaintenanceWindowOutputReference;
}
export interface DataIonoscloudK8SNodePoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_node_pool#create DataIonoscloudK8SNodePool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_node_pool#default DataIonoscloudK8SNodePool#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_node_pool#delete DataIonoscloudK8SNodePool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_node_pool#update DataIonoscloudK8SNodePool#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudK8SNodePoolTimeoutsToTerraform(struct?: DataIonoscloudK8SNodePoolTimeoutsOutputReference | DataIonoscloudK8SNodePoolTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudK8SNodePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudK8SNodePoolTimeouts | undefined;
    set internalValue(value: DataIonoscloudK8SNodePoolTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_node_pool ionoscloud_k8s_node_pool}
*/
export declare class DataIonoscloudK8SNodePool extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_k8s_node_pool";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_node_pool ionoscloud_k8s_node_pool} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudK8SNodePoolConfig
    */
    constructor(scope: Construct, id: string, config: DataIonoscloudK8SNodePoolConfig);
    annotations(key: string): string | cdktf.IResolvable;
    private _autoScaling;
    get autoScaling(): DataIonoscloudK8SNodePoolAutoScalingList;
    get availabilityZone(): string;
    get availableUpgradeVersions(): string[];
    get coresCount(): number;
    get cpuFamily(): string;
    get datacenterId(): string;
    get gatewayIp(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _k8SClusterId?;
    get k8SClusterId(): string;
    set k8SClusterId(value: string);
    get k8SClusterIdInput(): string | undefined;
    get k8SVersion(): string;
    labels(key: string): string | cdktf.IResolvable;
    private _lans;
    get lans(): DataIonoscloudK8SNodePoolLansList;
    private _maintenanceWindow;
    get maintenanceWindow(): DataIonoscloudK8SNodePoolMaintenanceWindowList;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get nodeCount(): number;
    get publicIps(): string[];
    get ramSize(): number;
    get state(): string;
    get storageSize(): number;
    get storageType(): string;
    private _timeouts;
    get timeouts(): DataIonoscloudK8SNodePoolTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudK8SNodePoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataIonoscloudK8SNodePoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-ionoscloud-k8s-node-pool.d.ts.map