import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudPgVersionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/pg_versions#cluster_id DataIonoscloudPgVersions#cluster_id}
    */
    readonly clusterId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/pg_versions#timeouts DataIonoscloudPgVersions#timeouts}
    */
    readonly timeouts?: DataIonoscloudPgVersionsTimeouts;
}
export interface DataIonoscloudPgVersionsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/pg_versions#create DataIonoscloudPgVersions#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/pg_versions#default DataIonoscloudPgVersions#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/pg_versions#delete DataIonoscloudPgVersions#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/pg_versions#update DataIonoscloudPgVersions#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudPgVersionsTimeoutsToTerraform(struct?: DataIonoscloudPgVersionsTimeoutsOutputReference | DataIonoscloudPgVersionsTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudPgVersionsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudPgVersionsTimeouts | undefined;
    set internalValue(value: DataIonoscloudPgVersionsTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/pg_versions ionoscloud_pg_versions}
*/
export declare class DataIonoscloudPgVersions extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_pg_versions";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/pg_versions ionoscloud_pg_versions} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudPgVersionsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataIonoscloudPgVersionsConfig);
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    resetClusterId(): void;
    get clusterIdInput(): string | undefined;
    get id(): string;
    get postgresVersions(): string[];
    private _timeouts;
    get timeouts(): DataIonoscloudPgVersionsTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudPgVersionsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataIonoscloudPgVersionsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-ionoscloud-pg-versions.d.ts.map