import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudResourceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/resource#resource_id DataIonoscloudResource#resource_id}
    */
    readonly resourceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/resource#resource_type DataIonoscloudResource#resource_type}
    */
    readonly resourceType?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/resource#timeouts DataIonoscloudResource#timeouts}
    */
    readonly timeouts?: DataIonoscloudResourceTimeouts;
}
export interface DataIonoscloudResourceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/resource#create DataIonoscloudResource#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/resource#default DataIonoscloudResource#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/resource#delete DataIonoscloudResource#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/resource#update DataIonoscloudResource#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudResourceTimeoutsToTerraform(struct?: DataIonoscloudResourceTimeoutsOutputReference | DataIonoscloudResourceTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudResourceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudResourceTimeouts | undefined;
    set internalValue(value: DataIonoscloudResourceTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/resource ionoscloud_resource}
*/
export declare class DataIonoscloudResource extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_resource";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/resource ionoscloud_resource} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudResourceConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataIonoscloudResourceConfig);
    get id(): string;
    private _resourceId?;
    get resourceId(): string;
    set resourceId(value: string);
    resetResourceId(): void;
    get resourceIdInput(): string | undefined;
    private _resourceType?;
    get resourceType(): string;
    set resourceType(value: string);
    resetResourceType(): void;
    get resourceTypeInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataIonoscloudResourceTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudResourceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataIonoscloudResourceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-ionoscloud-resource.d.ts.map