import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IpfailoverConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/ipfailover#datacenter_id Ipfailover#datacenter_id}
    */
    readonly datacenterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/ipfailover#ip Ipfailover#ip}
    */
    readonly ip: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/ipfailover#lan_id Ipfailover#lan_id}
    */
    readonly lanId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/ipfailover#nicuuid Ipfailover#nicuuid}
    */
    readonly nicuuid: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/ipfailover#timeouts Ipfailover#timeouts}
    */
    readonly timeouts?: IpfailoverTimeouts;
}
export interface IpfailoverTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/ipfailover#create Ipfailover#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/ipfailover#default Ipfailover#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/ipfailover#delete Ipfailover#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/ipfailover#update Ipfailover#update}
    */
    readonly update?: string;
}
export declare function ipfailoverTimeoutsToTerraform(struct?: IpfailoverTimeoutsOutputReference | IpfailoverTimeouts | cdktf.IResolvable): any;
export declare class IpfailoverTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IpfailoverTimeouts | undefined;
    set internalValue(value: IpfailoverTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/r/ipfailover ionoscloud_ipfailover}
*/
export declare class Ipfailover extends cdktf.TerraformResource {
    static readonly tfResourceType = "ionoscloud_ipfailover";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/r/ipfailover ionoscloud_ipfailover} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IpfailoverConfig
    */
    constructor(scope: Construct, id: string, config: IpfailoverConfig);
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    get datacenterIdInput(): string | undefined;
    get id(): string;
    private _ip?;
    get ip(): string;
    set ip(value: string);
    get ipInput(): string | undefined;
    private _lanId?;
    get lanId(): string;
    set lanId(value: string);
    get lanIdInput(): string | undefined;
    private _nicuuid?;
    get nicuuid(): string;
    set nicuuid(value: string);
    get nicuuidInput(): string | undefined;
    private _timeouts;
    get timeouts(): IpfailoverTimeoutsOutputReference;
    putTimeouts(value: IpfailoverTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): IpfailoverTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=ipfailover.d.ts.map