import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NicConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/nic#datacenter_id Nic#datacenter_id}
    */
    readonly datacenterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/nic#dhcp Nic#dhcp}
    */
    readonly dhcp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/nic#firewall_active Nic#firewall_active}
    */
    readonly firewallActive?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/nic#firewall_type Nic#firewall_type}
    */
    readonly firewallType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/nic#ips Nic#ips}
    */
    readonly ips?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/nic#lan Nic#lan}
    */
    readonly lan: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/nic#name Nic#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/nic#server_id Nic#server_id}
    */
    readonly serverId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/nic#timeouts Nic#timeouts}
    */
    readonly timeouts?: NicTimeouts;
}
export interface NicTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/nic#create Nic#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/nic#default Nic#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/nic#delete Nic#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/nic#update Nic#update}
    */
    readonly update?: string;
}
export declare function nicTimeoutsToTerraform(struct?: NicTimeoutsOutputReference | NicTimeouts | cdktf.IResolvable): any;
export declare class NicTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NicTimeouts | undefined;
    set internalValue(value: NicTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/r/nic ionoscloud_nic}
*/
export declare class Nic extends cdktf.TerraformResource {
    static readonly tfResourceType = "ionoscloud_nic";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/r/nic ionoscloud_nic} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NicConfig
    */
    constructor(scope: Construct, id: string, config: NicConfig);
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    get datacenterIdInput(): string | undefined;
    get deviceNumber(): number;
    private _dhcp?;
    get dhcp(): boolean | cdktf.IResolvable;
    set dhcp(value: boolean | cdktf.IResolvable);
    resetDhcp(): void;
    get dhcpInput(): boolean | cdktf.IResolvable | undefined;
    private _firewallActive?;
    get firewallActive(): boolean | cdktf.IResolvable;
    set firewallActive(value: boolean | cdktf.IResolvable);
    resetFirewallActive(): void;
    get firewallActiveInput(): boolean | cdktf.IResolvable | undefined;
    private _firewallType?;
    get firewallType(): string;
    set firewallType(value: string);
    resetFirewallType(): void;
    get firewallTypeInput(): string | undefined;
    get id(): string;
    private _ips?;
    get ips(): string[];
    set ips(value: string[]);
    resetIps(): void;
    get ipsInput(): string[] | undefined;
    private _lan?;
    get lan(): number;
    set lan(value: number);
    get lanInput(): number | undefined;
    get mac(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get pciSlot(): number;
    private _serverId?;
    get serverId(): string;
    set serverId(value: string);
    get serverIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): NicTimeoutsOutputReference;
    putTimeouts(value: NicTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): NicTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=nic.d.ts.map