/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Iterator;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;

public class PatternSponsor
extends Expression {
    private Pattern pattern;

    public PatternSponsor(Pattern pattern) {
        this.pattern = pattern;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public int getImplementationMethod() {
        return 1;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.pattern = this.pattern.simplify(visitor);
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.pattern = this.pattern.analyze(visitor, contextItemType);
        return this;
    }

    protected int computeCardinality() {
        return 57344;
    }

    public Expression copy() {
        throw new UnsupportedOperationException("copy");
    }

    public Expression promote(PromotionOffer offer) throws XPathException {
        this.pattern.promote(offer);
        return this;
    }

    public boolean hasLoopingSubexpression(Expression child) {
        return true;
    }

    public int getCardinality() {
        return 16384;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }

    public int getDependencies() {
        return this.pattern.getDependencies();
    }

    public Iterator iterateSubExpressions() {
        return this.pattern.iterateSubExpressions();
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        return this.pattern.replaceSubExpression(original, replacement);
    }

    public Container getContainer() {
        return this.pattern;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return SingletonIterator.makeIterator(this.evaluateItem(context));
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        Item contextItem = context.getContextItem();
        return contextItem instanceof NodeInfo && this.pattern.matches((NodeInfo)contextItem, context);
    }

    public CharSequence evaluateAsString(XPathContext context) throws XPathException {
        return this.evaluateItem(context).getStringValueCS();
    }

    public void process(XPathContext context) throws XPathException {
        throw new UnsupportedOperationException("Patterns cannot be evaluated in push mode");
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("pattern");
        out.emitAttribute("match", this.pattern.toString());
        out.endElement();
    }

    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        throw new UnsupportedOperationException("checkPermittedContents() is not applicable to a pattern");
    }
}

