[![DagsHub Client](https://github.com/DagsHub/client/raw/master/dagshub_github.png)](https://dagshub.com)

<div align="center">
    <h3>🚀 Launching <a href="#data-streaming">Streaming</a> and <a href="#data-streaming">Upload</a> of DVC versioned Data 🚀</h3>
</div>
<br/>

[![Tests](https://github.com/dagshub/client/actions/workflows/python-package.yml/badge.svg?branch=master)](https://github.com/DAGsHub/client/actions/workflows/python-package.yml)
[![pip](https://img.shields.io/pypi/v/dagshub.svg?label=pip&logo=PyPI&logoColor=white)](https://pypi.org/project/dagshub)
[![License](https://img.shields.io/pypi/l/dagshub)](/LICENSE)

[![DagsHub Sign Up](https://img.shields.io/badge/DagsHub-Sign%20Up-%231F4C55?logo=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAB4AAAAeCAYAAAA7MK6iAAAACXBIWXMAAACXAAAAlwHUBiyCAAACmUlEQVRIieVXsYoUQRB9nouY7QQGBoITGumYiCDimBiYuKZnMibG+wfOJ6z+wE2kmbbBgSa6CwoqCHtofnuIoTCbiUlJ6euz7O3p23U9LvBBM71d3fVqqqqrZo+JCI4CG0fCCqDHZwZgyPmY41CxYciUvAXgAIwOgXRAnp+6lTgnqSNxzuGN+ReoSPiIBhQQkVJExiJSyy9MRaQQkUZEZiJSiUimSfgXQ8+NqPOOiLTkKr2wJYFFRaMayusViD1hy/NXOW9pRN6je9Wt5wKXbgG4SzflDIWiBlBG3O8TMuN8ynMt530AEwDXAMx8VjckCLFl5BqbXQD3qWBGpRkJChJkfHp9augFzr/wLKxrvBtiKLhvEMTbmb0au3t0sZcXga6HXm7josTbHcRNRyzrYF8oD19km8b/Ubk0hvOIuyemuKSwE5HZevAJwE2fC5a4oeCNWZsztu0SxLE9qvMB5+8APPP7LPGYG/u0DkyQZUhT0OT6DOCG9UDYJNSlHwAcB/DYXKF1oIY/AfDS9oBYd1Ky9wA2I7L8gN9dcOHZGHHBOxpbnzIcdi00KrzHiIVrlX5cMf4D00h07HH4hlKyYNibsEDcCxcS8IoaEtY0pG+OOK7fDnr6QkhWIQZdOGK99djhG6nbb3FMTA+A6cW/Eak2VaRSlWyRqYqWR+RaRs+zKuZWZ4w4J4kl7YIqHLImu449H0VkTj1JYpC4NPN14Tj2ObqyesQk0bidPSDurzhSyBc+oxJfEWNa2Sbe9rmZP03sdWHepD7oM1O7FRc518bxFsAJANeDM68BfAVwCsAVZvd3AJfCzE5dp5abh6Z4gM/TdN8LAN+4fhLAZSo/w7WCv0texX2s8xcmM1UMLLNu2W72n/13AvADffO77cDRF5EAAAAASUVORK5CYII=)](https://dagshub.com/user/sign_up?redirect_to=)
[![Discord](https://img.shields.io/discord/698874030052212737?logo=data%3Aimage%2Fpng%3Bbase64%2CiVBORw0KGgoAAAANSUhEUgAAAB4AAAAXCAYAAAAcP%2F9qAAAACXBIWXMAAAsTAAALEwEAmpwYAAAFN2lUWHRYTUw6Y29tLmFkb2JlLnhtcAAAAAAAPD94cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4gPHg6eG1wbWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNi4wLWMwMDMgNzkuMTY0NTI3LCAyMDIwLzEwLzE1LTE3OjQ4OjMyICAgICAgICAiPiA8cmRmOlJERiB4bWxuczpyZGY9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkvMDIvMjItcmRmLXN5bnRheC1ucyMiPiA8cmRmOkRlc2NyaXB0aW9uIHJkZjphYm91dD0iIiB4bWxuczp0aWZmPSJodHRwOi8vbnMuYWRvYmUuY29tL3RpZmYvMS4wLyIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczpkYz0iaHR0cDovL3B1cmwub3JnL2RjL2VsZW1lbnRzLzEuMS8iIHhtbG5zOnBob3Rvc2hvcD0iaHR0cDovL25zLmFkb2JlLmNvbS9waG90b3Nob3AvMS4wLyIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0RXZ0PSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VFdmVudCMiIHRpZmY6T3JpZW50YXRpb249IjEiIHhtcDpDcmVhdGVEYXRlPSIyMDIxLTEwLTIzVDE2OjI5OjAyKzAzOjAwIiB4bXA6TW9kaWZ5RGF0ZT0iMjAyMS0xMC0yM1QxNjozNDoxMiswMzowMCIgeG1wOk1ldGFkYXRhRGF0ZT0iMjAyMS0xMC0yM1QxNjozNDoxMiswMzowMCIgZGM6Zm9ybWF0PSJpbWFnZS9wbmciIHBob3Rvc2hvcDpDb2xvck1vZGU9IjMiIHBob3Rvc2hvcDpJQ0NQcm9maWxlPSJzUkdCIElFQzYxOTY2LTIuMSIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDpiMTBhMTRjOC1iNzg5LTQ2OTgtYmVhMi1kZTI4NDg3ZmEyMjIiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6YjEwYTE0YzgtYjc4OS00Njk4LWJlYTItZGUyODQ4N2ZhMjIyIiB4bXBNTTpPcmlnaW5hbERvY3VtZW50SUQ9InhtcC5kaWQ6YjEwYTE0YzgtYjc4OS00Njk4LWJlYTItZGUyODQ4N2ZhMjIyIj4gPHhtcE1NOkhpc3Rvcnk%2BIDxyZGY6U2VxPiA8cmRmOmxpIHN0RXZ0OmFjdGlvbj0ic2F2ZWQiIHN0RXZ0Omluc3RhbmNlSUQ9InhtcC5paWQ6YjEwYTE0YzgtYjc4OS00Njk4LWJlYTItZGUyODQ4N2ZhMjIyIiBzdEV2dDp3aGVuPSIyMDIxLTEwLTIzVDE2OjM0OjEyKzAzOjAwIiBzdEV2dDpzb2Z0d2FyZUFnZW50PSJBZG9iZSBQaG90b3Nob3AgMjIuMSAoTWFjaW50b3NoKSIgc3RFdnQ6Y2hhbmdlZD0iLyIvPiA8L3JkZjpTZXE%2BIDwveG1wTU06SGlzdG9yeT4gPC9yZGY6RGVzY3JpcHRpb24%2BIDwvcmRmOlJERj4gPC94OnhtcG1ldGE%2BIDw%2FeHBhY2tldCBlbmQ9InIiPz4jeahYAAACnElEQVRIx62WPWxOURjH7%2Fu%2BrTdN1RsGIkgw2BBLQwxCmvgamzAxCAs2xCYGSZWBWYihSUcDFhJpJJ1M0kUqJS1BlRCk%2Bno%2F7s%2FyPPV38lwtcZKTc%2B89z33%2B%2F%2BfznAzIkllO3lcD%2FcAloBbI%2B9wMDAB7ArlSKl8EWgWOAA%2BAWX6Ni8AaoA84AOwDdhm5%2ByL3ARgG9haBK2jF1rXAJL%2BPps2ikdvaANrJ3sMIXIE7bL1jP3w3sDxRjilv2WwX7DeAur2fM92dKbCD7hbmRZbli%2Fjmo2XrF2ClhtPN99g%2BWgD4X8YPWwfUao3tDnFT%2Fh%2BBPRQfJdtL6vebCcM0uRoLEGrbv61gzz14wq32GPcA7xOGHr92Qdz%2B9K0VEMdCmQFlB96fCKRZOgIMAd8Cxf48CdwCxgID%2FHnWynU%2Bq68GSeUKz0rJbQTeiTInOqqlYiTVkFz09SvwSCLo65go67b1tJB0r2yXkGXAKusDaq0bddmBu4BXiZUuNCx1Xklq3cl9NSCtkArwrEDnPQdeF7BzpU%2Bk6N3i44HFWxOLVxihSOdTB95SkFDO9Ki4uwZMyL4ru5scNteDZHV9U0A1s%2FhErU%2Bfh%2BxYnAqyui3euWAnGkHNu9wMUNOOFfXcZtA%2BF1PH9aD%2BtYMtz4BeAckDQeS0qssR2RJ3N4E5yRUKTiyAaaAnAzbI5lzSrW6biz%2F%2FRW9%2BCZwBHgtg23QDPNc67pOSQs7RF8ApYBtwGLhhzWICeAu8AcatFV6zW0mvkf1kRtRF7yiwyYH9SOwCrhTcNA4mWdtppbNUatfnYBD3GeCkXrGy9GYArLdymE5KpWqNpBRc9ErAElu7gdf27zhw3gi6XEd69SknBJYBx4yIesYvDj5LQsat3wkcCrw0T%2FonycbE%2FgQEhDUAAAAASUVORK5CYII%3D)](https://discord.com/invite/9gU36Y6)
[![DagsHub on Twitter](https://img.shields.io/twitter/follow/TheRealDAGsHub.svg?style=social)](https://twitter.com/TheRealDAGsHub)

# What is DagsHub?
**DagsHub** is a platform where machine learning and data science teams can build, manage, and collaborate on their projects.
With DagsHub you can:
1. **Version code, data, and models** in one place. Use the free provided DagsHub storage or connect it to your cloud storage
2. **Track Experiments** using Git, DVC or MLflow, to provide a fully reproducible environment
3. **Visualize** pipelines, data, and notebooks in and interactive, diff-able, and dynamic way
4. **Label** your data directly on the platform using Label Studio
5. **Share** your work with your team members
6. **Stream and upload** your data in an intuitive and easy way, while preserving versioning and structure.

DagsHub is built firmly around open, standard formats for your project. In particular:
* Git
* [DVC](https://github.com/iterative/dvc)
* [MLflow](https://github.com/mlflow/mlflow)
* [Label Studio](https://github.com/heartexlabs/label-studio)
* Standard data formats like YAML, JSON, CSV

Therefore, you can work with DagsHub regardless of your chosen programming language or frameworks.

# DagsHub Client API & CLI

__This client library is meant to help you get started quickly with DagsHub__. It is made up of Experiment tracking and
Direct Data Access (DDA), a component to let you stream and upload your data.

For more details on the different functions of the client, check out the docs segments:
1. [Installation & Setup](docs/index.md#installation-and-setup)
2. [Data Streaming](docs/index.md#data-streaming)
3. [Data Upload](docs/index.md#data-upload)
4. [Experiment Tracking](docs/index.md#experiment-tracking-logger)
    1. [Autologging](docs/index.md#autologging-integrations-with-ml-frameworks)

Some functionality is supported only in Python.

To read about some of the awesome use cases for Direct Data Access, check out
the [relevant doc page](https://dagshub.com/docs/feature_guide/direct_data_access/#use-cases).

## Installation
```bash
pip install dagshub
```

Direct Data Access (DDA) functionality requires authentication, which you can easily do by running the following command
in your terminal:
```bash
dagshub login
```

## Quickstart for Data Streaming
The easiest way to start using DagsHub is via the Python Hooks method. To do this:
1. Your DagsHub project,
2. Copy the following 2 lines of code into your Python code which accesses your data:
    ```python
    from dagshub.streaming import install_hooks
    install_hooks()
    ```
3. That’s it! You now have streaming access to all your project files.

**🤩 Check out this colab to see an example of this Data Streaming work end to end:**

[![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/drive/1CtBmcDtZnxZKVIhNvPagX-8UFWHZ5HAg?usp=sharing)

## Next Steps
You can dive into the expanded [documentation](docs/index.md), to learn more about data streaming, data upload and
experiment tracking with DagsHub

---

Made with 🐶 by [DagsHub](https://dagshub.com/).
