# coding=utf-8
# *** WARNING: this file was generated by pulumi-gen-eks. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._enums import *
from .vpc_cni_addon import VpcCniAddon
import pulumi_aws
import pulumi_kubernetes

__all__ = [
    'AccessEntry',
    'AccessPolicyAssociation',
    'ClusterNodeGroupOptions',
    'CoreData',
    'NodeGroupData',
    'NodeadmOptions',
    'Taint',
]

@pulumi.output_type
class AccessEntry(dict):
    """
    Access entries allow an IAM principal to access your cluster.

    You have the following options for authorizing an IAM principal to access Kubernetes objects on your cluster: Kubernetes role-based access control (RBAC), Amazon EKS, or both.
    Kubernetes RBAC authorization requires you to create and manage Kubernetes Role , ClusterRole , RoleBinding , and ClusterRoleBinding objects, in addition to managing access entries. If you use Amazon EKS authorization exclusively, you don't need to create and manage Kubernetes Role , ClusterRole , RoleBinding , and ClusterRoleBinding objects.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalArn":
            suggest = "principal_arn"
        elif key == "accessPolicies":
            suggest = "access_policies"
        elif key == "kubernetesGroups":
            suggest = "kubernetes_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessEntry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessEntry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessEntry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_arn: builtins.str,
                 access_policies: Optional[Mapping[str, 'outputs.AccessPolicyAssociation']] = None,
                 kubernetes_groups: Optional[Sequence[builtins.str]] = None,
                 tags: Optional[Mapping[str, builtins.str]] = None,
                 type: Optional['AccessEntryType'] = None,
                 username: Optional[builtins.str] = None):
        """
        Access entries allow an IAM principal to access your cluster.

        You have the following options for authorizing an IAM principal to access Kubernetes objects on your cluster: Kubernetes role-based access control (RBAC), Amazon EKS, or both.
        Kubernetes RBAC authorization requires you to create and manage Kubernetes Role , ClusterRole , RoleBinding , and ClusterRoleBinding objects, in addition to managing access entries. If you use Amazon EKS authorization exclusively, you don't need to create and manage Kubernetes Role , ClusterRole , RoleBinding , and ClusterRoleBinding objects.
        :param builtins.str principal_arn: The IAM Principal ARN which requires Authentication access to the EKS cluster.
        :param Mapping[str, 'AccessPolicyAssociation'] access_policies: The access policies to associate to the access entry.
        :param Sequence[builtins.str] kubernetes_groups: A list of groups within Kubernetes to which the IAM principal is mapped to.
        :param Mapping[str, builtins.str] tags: The tags to apply to the AccessEntry.
        :param 'AccessEntryType' type: The type of the new access entry. Valid values are STANDARD, FARGATE_LINUX, EC2_LINUX, and EC2_WINDOWS.
               Defaults to STANDARD which provides the standard workflow. EC2_LINUX, EC2_WINDOWS, FARGATE_LINUX types disallow users to input a username or kubernetesGroup, and prevent associating access policies.
        :param builtins.str username: Defaults to the principalArn if the principal is a user, else defaults to assume-role/session-name.
        """
        pulumi.set(__self__, "principal_arn", principal_arn)
        if access_policies is not None:
            pulumi.set(__self__, "access_policies", access_policies)
        if kubernetes_groups is not None:
            pulumi.set(__self__, "kubernetes_groups", kubernetes_groups)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="principalArn")
    def principal_arn(self) -> builtins.str:
        """
        The IAM Principal ARN which requires Authentication access to the EKS cluster.
        """
        return pulumi.get(self, "principal_arn")

    @property
    @pulumi.getter(name="accessPolicies")
    def access_policies(self) -> Optional[Mapping[str, 'outputs.AccessPolicyAssociation']]:
        """
        The access policies to associate to the access entry.
        """
        return pulumi.get(self, "access_policies")

    @property
    @pulumi.getter(name="kubernetesGroups")
    def kubernetes_groups(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of groups within Kubernetes to which the IAM principal is mapped to.
        """
        return pulumi.get(self, "kubernetes_groups")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The tags to apply to the AccessEntry.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> Optional['AccessEntryType']:
        """
        The type of the new access entry. Valid values are STANDARD, FARGATE_LINUX, EC2_LINUX, and EC2_WINDOWS.
        Defaults to STANDARD which provides the standard workflow. EC2_LINUX, EC2_WINDOWS, FARGATE_LINUX types disallow users to input a username or kubernetesGroup, and prevent associating access policies.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        Defaults to the principalArn if the principal is a user, else defaults to assume-role/session-name.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class AccessPolicyAssociation(dict):
    """
    Associates an access policy and its scope to an IAM principal.

    See for more details:
    https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessScope":
            suggest = "access_scope"
        elif key == "policyArn":
            suggest = "policy_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessPolicyAssociation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessPolicyAssociation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessPolicyAssociation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_scope: 'pulumi_aws.eks.outputs.AccessPolicyAssociationAccessScope',
                 policy_arn: builtins.str):
        """
        Associates an access policy and its scope to an IAM principal.

        See for more details:
        https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html
        :param 'pulumi_aws.eks.AccessPolicyAssociationAccessScopeArgs' access_scope: The scope of the access policy association. This controls whether the access policy is scoped to the cluster or to a particular namespace.
        :param builtins.str policy_arn: The ARN of the access policy to associate with the principal
        """
        pulumi.set(__self__, "access_scope", access_scope)
        pulumi.set(__self__, "policy_arn", policy_arn)

    @property
    @pulumi.getter(name="accessScope")
    def access_scope(self) -> 'pulumi_aws.eks.outputs.AccessPolicyAssociationAccessScope':
        """
        The scope of the access policy association. This controls whether the access policy is scoped to the cluster or to a particular namespace.
        """
        return pulumi.get(self, "access_scope")

    @property
    @pulumi.getter(name="policyArn")
    def policy_arn(self) -> builtins.str:
        """
        The ARN of the access policy to associate with the principal
        """
        return pulumi.get(self, "policy_arn")


@pulumi.output_type
class ClusterNodeGroupOptions(dict):
    """
    Describes the configuration options accepted by a cluster to create its own node groups.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "amiId":
            suggest = "ami_id"
        elif key == "amiType":
            suggest = "ami_type"
        elif key == "autoScalingGroupTags":
            suggest = "auto_scaling_group_tags"
        elif key == "bootstrapExtraArgs":
            suggest = "bootstrap_extra_args"
        elif key == "bottlerocketSettings":
            suggest = "bottlerocket_settings"
        elif key == "cloudFormationTags":
            suggest = "cloud_formation_tags"
        elif key == "clusterIngressRule":
            suggest = "cluster_ingress_rule"
        elif key == "clusterIngressRuleId":
            suggest = "cluster_ingress_rule_id"
        elif key == "desiredCapacity":
            suggest = "desired_capacity"
        elif key == "enableDetailedMonitoring":
            suggest = "enable_detailed_monitoring"
        elif key == "encryptRootBlockDevice":
            suggest = "encrypt_root_block_device"
        elif key == "extraNodeSecurityGroups":
            suggest = "extra_node_security_groups"
        elif key == "ignoreScalingChanges":
            suggest = "ignore_scaling_changes"
        elif key == "instanceProfile":
            suggest = "instance_profile"
        elif key == "instanceProfileName":
            suggest = "instance_profile_name"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "keyName":
            suggest = "key_name"
        elif key == "kubeletExtraArgs":
            suggest = "kubelet_extra_args"
        elif key == "launchTemplateTagSpecifications":
            suggest = "launch_template_tag_specifications"
        elif key == "maxSize":
            suggest = "max_size"
        elif key == "minRefreshPercentage":
            suggest = "min_refresh_percentage"
        elif key == "minSize":
            suggest = "min_size"
        elif key == "nodeAssociatePublicIpAddress":
            suggest = "node_associate_public_ip_address"
        elif key == "nodePublicKey":
            suggest = "node_public_key"
        elif key == "nodeRootVolumeDeleteOnTermination":
            suggest = "node_root_volume_delete_on_termination"
        elif key == "nodeRootVolumeEncrypted":
            suggest = "node_root_volume_encrypted"
        elif key == "nodeRootVolumeIops":
            suggest = "node_root_volume_iops"
        elif key == "nodeRootVolumeSize":
            suggest = "node_root_volume_size"
        elif key == "nodeRootVolumeThroughput":
            suggest = "node_root_volume_throughput"
        elif key == "nodeRootVolumeType":
            suggest = "node_root_volume_type"
        elif key == "nodeSecurityGroup":
            suggest = "node_security_group"
        elif key == "nodeSecurityGroupId":
            suggest = "node_security_group_id"
        elif key == "nodeSubnetIds":
            suggest = "node_subnet_ids"
        elif key == "nodeUserData":
            suggest = "node_user_data"
        elif key == "nodeUserDataOverride":
            suggest = "node_user_data_override"
        elif key == "nodeadmExtraOptions":
            suggest = "nodeadm_extra_options"
        elif key == "operatingSystem":
            suggest = "operating_system"
        elif key == "spotPrice":
            suggest = "spot_price"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeGroupOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeGroupOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeGroupOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ami_id: Optional[builtins.str] = None,
                 ami_type: Optional[builtins.str] = None,
                 auto_scaling_group_tags: Optional[Mapping[str, builtins.str]] = None,
                 bootstrap_extra_args: Optional[builtins.str] = None,
                 bottlerocket_settings: Optional[Mapping[str, Any]] = None,
                 cloud_formation_tags: Optional[Mapping[str, builtins.str]] = None,
                 cluster_ingress_rule: Optional['pulumi_aws.ec2.SecurityGroupRule'] = None,
                 cluster_ingress_rule_id: Optional[builtins.str] = None,
                 desired_capacity: Optional[builtins.int] = None,
                 enable_detailed_monitoring: Optional[builtins.bool] = None,
                 encrypt_root_block_device: Optional[builtins.bool] = None,
                 extra_node_security_groups: Optional[Sequence['pulumi_aws.ec2.SecurityGroup']] = None,
                 gpu: Optional[builtins.bool] = None,
                 ignore_scaling_changes: Optional[builtins.bool] = None,
                 instance_profile: Optional['pulumi_aws.iam.InstanceProfile'] = None,
                 instance_profile_name: Optional[builtins.str] = None,
                 instance_type: Optional[builtins.str] = None,
                 key_name: Optional[builtins.str] = None,
                 kubelet_extra_args: Optional[builtins.str] = None,
                 labels: Optional[Mapping[str, builtins.str]] = None,
                 launch_template_tag_specifications: Optional[Sequence['pulumi_aws.ec2.outputs.LaunchTemplateTagSpecification']] = None,
                 max_size: Optional[builtins.int] = None,
                 min_refresh_percentage: Optional[builtins.int] = None,
                 min_size: Optional[builtins.int] = None,
                 node_associate_public_ip_address: Optional[builtins.bool] = None,
                 node_public_key: Optional[builtins.str] = None,
                 node_root_volume_delete_on_termination: Optional[builtins.bool] = None,
                 node_root_volume_encrypted: Optional[builtins.bool] = None,
                 node_root_volume_iops: Optional[builtins.int] = None,
                 node_root_volume_size: Optional[builtins.int] = None,
                 node_root_volume_throughput: Optional[builtins.int] = None,
                 node_root_volume_type: Optional[builtins.str] = None,
                 node_security_group: Optional['pulumi_aws.ec2.SecurityGroup'] = None,
                 node_security_group_id: Optional[builtins.str] = None,
                 node_subnet_ids: Optional[Sequence[builtins.str]] = None,
                 node_user_data: Optional[builtins.str] = None,
                 node_user_data_override: Optional[builtins.str] = None,
                 nodeadm_extra_options: Optional[Sequence['outputs.NodeadmOptions']] = None,
                 operating_system: Optional['OperatingSystem'] = None,
                 spot_price: Optional[builtins.str] = None,
                 taints: Optional[Mapping[str, 'outputs.Taint']] = None,
                 version: Optional[builtins.str] = None):
        """
        Describes the configuration options accepted by a cluster to create its own node groups.
        :param builtins.str ami_id: The AMI ID to use for the worker nodes.
               
               Defaults to the latest recommended EKS Optimized Linux AMI from the AWS Systems Manager Parameter Store.
               
               Note: `amiId` and `gpu` are mutually exclusive.
               
               See for more details:
               - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html.
        :param builtins.str ami_type: The AMI Type to use for the worker nodes. 
               
               Only applicable when setting an AMI ID that is of type `arm64`. 
               
               Note: `amiType` and `gpu` are mutually exclusive.
        :param Mapping[str, builtins.str] auto_scaling_group_tags: The tags to apply to the NodeGroup's AutoScalingGroup in the CloudFormation Stack.
               
               Per AWS, all stack-level tags, including automatically created tags, and the `cloudFormationTags` option are propagated to resources that AWS CloudFormation supports, including the AutoScalingGroup. See https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html
               
               Note: Given the inheritance of auto-generated CF tags and `cloudFormationTags`, you should either supply the tag in `autoScalingGroupTags` or `cloudFormationTags`, but not both.
        :param builtins.str bootstrap_extra_args: Additional args to pass directly to `/etc/eks/bootstrap.sh`. For details on available options, see: https://github.com/awslabs/amazon-eks-ami/blob/master/files/bootstrap.sh. Note that the `--apiserver-endpoint`, `--b64-cluster-ca` and `--kubelet-extra-args` flags are included automatically based on other configuration parameters.
        :param Mapping[str, Any] bottlerocket_settings: The configuration settings for Bottlerocket OS.
               The settings will get merged with the base settings the provider uses to configure Bottlerocket.
               
               This includes:
                 - settings.kubernetes.api-server
                 - settings.kubernetes.cluster-certificate
                 - settings.kubernetes.cluster-name
                 - settings.kubernetes.cluster-dns-ip
               
               For an overview of the available settings, see https://bottlerocket.dev/en/os/1.20.x/api/settings/.
        :param Mapping[str, builtins.str] cloud_formation_tags: The tags to apply to the CloudFormation Stack of the Worker NodeGroup.
               
               Note: Given the inheritance of auto-generated CF tags and `cloudFormationTags`, you should either supply the tag in `autoScalingGroupTags` or `cloudFormationTags`, but not both.
        :param 'pulumi_aws.ec2.SecurityGroupRule' cluster_ingress_rule: The ingress rule that gives node group access.
        :param builtins.str cluster_ingress_rule_id: The ID of the ingress rule that gives node group access.
        :param builtins.int desired_capacity: The number of worker nodes that should be running in the cluster. Defaults to 2.
        :param builtins.bool enable_detailed_monitoring: Enables/disables detailed monitoring of the EC2 instances.
               
               With detailed monitoring, all metrics, including status check metrics, are available in 1-minute intervals.
               When enabled, you can also get aggregated data across groups of similar instances.
               
               Note: You are charged per metric that is sent to CloudWatch. You are not charged for data storage.
               For more information, see "Paid tier" and "Example 1 - EC2 Detailed Monitoring" here https://aws.amazon.com/cloudwatch/pricing/.
        :param builtins.bool encrypt_root_block_device: Encrypt the root block device of the nodes in the node group.
        :param Sequence['pulumi_aws.ec2.SecurityGroup'] extra_node_security_groups: Extra security groups to attach on all nodes in this worker node group.
               
               This additional set of security groups captures any user application rules that will be needed for the nodes.
        :param builtins.bool gpu: Use the latest recommended EKS Optimized Linux AMI with GPU support for the worker nodes from the AWS Systems Manager Parameter Store.
               
               Defaults to false.
               
               Note: `gpu` and `amiId` are mutually exclusive.
               
               See for more details:
               - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html
               - https://docs.aws.amazon.com/eks/latest/userguide/retrieve-ami-id.html
        :param builtins.bool ignore_scaling_changes: Whether to ignore changes to the desired size of the Auto Scaling Group. This is useful when using Cluster Autoscaler.
               
               See [EKS best practices](https://aws.github.io/aws-eks-best-practices/cluster-autoscaling/) for more details.
        :param 'pulumi_aws.iam.InstanceProfile' instance_profile: The IAM InstanceProfile to use on the NodeGroup. Properties instanceProfile and instanceProfileName are mutually exclusive.
        :param builtins.str instance_profile_name: The name of the IAM InstanceProfile to use on the NodeGroup. Properties instanceProfile and instanceProfileName are mutually exclusive.
        :param builtins.str instance_type: The instance type to use for the cluster's nodes. Defaults to "t3.medium".
        :param builtins.str key_name: Name of the key pair to use for SSH access to worker nodes.
        :param builtins.str kubelet_extra_args: Extra args to pass to the Kubelet. Corresponds to the options passed in the `--kubeletExtraArgs` flag to `/etc/eks/bootstrap.sh`. For example, '--port=10251 --address=0.0.0.0'. Note that the `labels` and `taints` properties will be applied to this list (using `--node-labels` and `--register-with-taints` respectively) after to the explicit `kubeletExtraArgs`.
        :param Mapping[str, builtins.str] labels: Custom k8s node labels to be attached to each worker node. Adds the given key/value pairs to the `--node-labels` kubelet argument.
        :param Sequence['pulumi_aws.ec2.LaunchTemplateTagSpecificationArgs'] launch_template_tag_specifications: The tag specifications to apply to the launch template.
        :param builtins.int max_size: The maximum number of worker nodes running in the cluster. Defaults to 2.
        :param builtins.int min_refresh_percentage: The minimum amount of instances that should remain available during an instance refresh, expressed as a percentage. Defaults to 50.
        :param builtins.int min_size: The minimum number of worker nodes running in the cluster. Defaults to 1.
        :param builtins.bool node_associate_public_ip_address: Whether or not to auto-assign public IP addresses on the EKS worker nodes. If this toggle is set to true, the EKS workers will be auto-assigned public IPs. If false, they will not be auto-assigned public IPs.
        :param builtins.str node_public_key: Public key material for SSH access to worker nodes. See allowed formats at:
               https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
               If not provided, no SSH access is enabled on VMs.
        :param builtins.bool node_root_volume_delete_on_termination: Whether the root block device should be deleted on termination of the instance. Defaults to true.
        :param builtins.bool node_root_volume_encrypted: Whether to encrypt a cluster node's root volume. Defaults to false.
        :param builtins.int node_root_volume_iops: The amount of provisioned IOPS. This is only valid with a volumeType of 'io1'.
        :param builtins.int node_root_volume_size: The size in GiB of a cluster node's root volume. Defaults to 20.
        :param builtins.int node_root_volume_throughput: Provisioned throughput performance in integer MiB/s for a cluster node's root volume. This is only valid with a volumeType of 'gp3'.
        :param builtins.str node_root_volume_type: Configured EBS type for a cluster node's root volume. Default is 'gp2'. Supported values are 'standard', 'gp2', 'gp3', 'st1', 'sc1', 'io1'.
        :param 'pulumi_aws.ec2.SecurityGroup' node_security_group: The security group for the worker node group to communicate with the cluster.
               
               This security group requires specific inbound and outbound rules.
               
               See for more details:
               https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html
               
               Note: The `nodeSecurityGroup` option and the cluster option`nodeSecurityGroupTags` are mutually exclusive.
        :param builtins.str node_security_group_id: The ID of the security group for the worker node group to communicate with the cluster.
               
               This security group requires specific inbound and outbound rules.
               
               See for more details:
               https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html
               
               Note: The `nodeSecurityGroupId` option and the cluster option `nodeSecurityGroupTags` are mutually exclusive.
        :param Sequence[builtins.str] node_subnet_ids: The set of subnets to override and use for the worker node group.
               
               Setting this option overrides which subnets to use for the worker node group, regardless if the cluster's `subnetIds` is set, or if `publicSubnetIds` and/or `privateSubnetIds` were set.
        :param builtins.str node_user_data: Extra code to run on node startup. This code will run after the AWS EKS bootstrapping code and before the node signals its readiness to the managing CloudFormation stack. This code must be a typical user data script: critically it must begin with an interpreter directive (i.e. a `#!`).
        :param builtins.str node_user_data_override: User specified code to run on node startup. This code is expected to handle the full AWS EKS bootstrapping code and signal node readiness to the managing CloudFormation stack. This code must be a complete and executable user data script in bash (Linux) or powershell (Windows).
               
               See for more details: https://docs.aws.amazon.com/eks/latest/userguide/worker.html
        :param Sequence['NodeadmOptions'] nodeadm_extra_options: Extra nodeadm configuration sections to be added to the nodeadm user data. This can be shell scripts, nodeadm NodeConfig or any other user data compatible script. When configuring additional nodeadm NodeConfig sections, they'll be merged with the base settings the provider sets. You can overwrite base settings or provide additional settings this way.
               The base settings the provider sets are:
                 - cluster.name
                 - cluster.apiServerEndpoint
                 - cluster.certificateAuthority
                 - cluster.cidr
               
               Note: This is only applicable when using AL2023.
               See for more details:
                 - https://awslabs.github.io/amazon-eks-ami/nodeadm/
                 - https://awslabs.github.io/amazon-eks-ami/nodeadm/doc/api/
        :param 'OperatingSystem' operating_system: The type of OS to use for the node group. Will be used to determine the right EKS optimized AMI to use based on the instance types and gpu configuration.
               Valid values are `RECOMMENDED`, `AL2`, `AL2023` and `Bottlerocket`.
               
               Defaults to the current recommended OS.
        :param builtins.str spot_price: Bidding price for spot instance. If set, only spot instances will be added as worker node.
        :param Mapping[str, 'Taint'] taints: Custom k8s node taints to be attached to each worker node. Adds the given taints to the `--register-with-taints` kubelet argument
        :param builtins.str version: Desired Kubernetes master / control plane version. If you do not specify a value, the latest available version is used.
        """
        if ami_id is not None:
            pulumi.set(__self__, "ami_id", ami_id)
        if ami_type is not None:
            pulumi.set(__self__, "ami_type", ami_type)
        if auto_scaling_group_tags is not None:
            pulumi.set(__self__, "auto_scaling_group_tags", auto_scaling_group_tags)
        if bootstrap_extra_args is not None:
            pulumi.set(__self__, "bootstrap_extra_args", bootstrap_extra_args)
        if bottlerocket_settings is not None:
            pulumi.set(__self__, "bottlerocket_settings", bottlerocket_settings)
        if cloud_formation_tags is not None:
            pulumi.set(__self__, "cloud_formation_tags", cloud_formation_tags)
        if cluster_ingress_rule is not None:
            pulumi.set(__self__, "cluster_ingress_rule", cluster_ingress_rule)
        if cluster_ingress_rule_id is not None:
            pulumi.set(__self__, "cluster_ingress_rule_id", cluster_ingress_rule_id)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if enable_detailed_monitoring is not None:
            pulumi.set(__self__, "enable_detailed_monitoring", enable_detailed_monitoring)
        if encrypt_root_block_device is not None:
            pulumi.set(__self__, "encrypt_root_block_device", encrypt_root_block_device)
        if extra_node_security_groups is not None:
            pulumi.set(__self__, "extra_node_security_groups", extra_node_security_groups)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if ignore_scaling_changes is not None:
            pulumi.set(__self__, "ignore_scaling_changes", ignore_scaling_changes)
        if instance_profile is not None:
            pulumi.set(__self__, "instance_profile", instance_profile)
        if instance_profile_name is not None:
            pulumi.set(__self__, "instance_profile_name", instance_profile_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if kubelet_extra_args is not None:
            pulumi.set(__self__, "kubelet_extra_args", kubelet_extra_args)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if launch_template_tag_specifications is not None:
            pulumi.set(__self__, "launch_template_tag_specifications", launch_template_tag_specifications)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_refresh_percentage is not None:
            pulumi.set(__self__, "min_refresh_percentage", min_refresh_percentage)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if node_associate_public_ip_address is not None:
            pulumi.set(__self__, "node_associate_public_ip_address", node_associate_public_ip_address)
        if node_public_key is not None:
            pulumi.set(__self__, "node_public_key", node_public_key)
        if node_root_volume_delete_on_termination is not None:
            pulumi.set(__self__, "node_root_volume_delete_on_termination", node_root_volume_delete_on_termination)
        if node_root_volume_encrypted is not None:
            pulumi.set(__self__, "node_root_volume_encrypted", node_root_volume_encrypted)
        if node_root_volume_iops is not None:
            pulumi.set(__self__, "node_root_volume_iops", node_root_volume_iops)
        if node_root_volume_size is not None:
            pulumi.set(__self__, "node_root_volume_size", node_root_volume_size)
        if node_root_volume_throughput is not None:
            pulumi.set(__self__, "node_root_volume_throughput", node_root_volume_throughput)
        if node_root_volume_type is not None:
            pulumi.set(__self__, "node_root_volume_type", node_root_volume_type)
        if node_security_group is not None:
            pulumi.set(__self__, "node_security_group", node_security_group)
        if node_security_group_id is not None:
            pulumi.set(__self__, "node_security_group_id", node_security_group_id)
        if node_subnet_ids is not None:
            pulumi.set(__self__, "node_subnet_ids", node_subnet_ids)
        if node_user_data is not None:
            pulumi.set(__self__, "node_user_data", node_user_data)
        if node_user_data_override is not None:
            pulumi.set(__self__, "node_user_data_override", node_user_data_override)
        if nodeadm_extra_options is not None:
            pulumi.set(__self__, "nodeadm_extra_options", nodeadm_extra_options)
        if operating_system is not None:
            pulumi.set(__self__, "operating_system", operating_system)
        if spot_price is not None:
            pulumi.set(__self__, "spot_price", spot_price)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="amiId")
    def ami_id(self) -> Optional[builtins.str]:
        """
        The AMI ID to use for the worker nodes.

        Defaults to the latest recommended EKS Optimized Linux AMI from the AWS Systems Manager Parameter Store.

        Note: `amiId` and `gpu` are mutually exclusive.

        See for more details:
        - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html.
        """
        return pulumi.get(self, "ami_id")

    @property
    @pulumi.getter(name="amiType")
    def ami_type(self) -> Optional[builtins.str]:
        """
        The AMI Type to use for the worker nodes. 

        Only applicable when setting an AMI ID that is of type `arm64`. 

        Note: `amiType` and `gpu` are mutually exclusive.
        """
        return pulumi.get(self, "ami_type")

    @property
    @pulumi.getter(name="autoScalingGroupTags")
    def auto_scaling_group_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The tags to apply to the NodeGroup's AutoScalingGroup in the CloudFormation Stack.

        Per AWS, all stack-level tags, including automatically created tags, and the `cloudFormationTags` option are propagated to resources that AWS CloudFormation supports, including the AutoScalingGroup. See https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html

        Note: Given the inheritance of auto-generated CF tags and `cloudFormationTags`, you should either supply the tag in `autoScalingGroupTags` or `cloudFormationTags`, but not both.
        """
        return pulumi.get(self, "auto_scaling_group_tags")

    @property
    @pulumi.getter(name="bootstrapExtraArgs")
    def bootstrap_extra_args(self) -> Optional[builtins.str]:
        """
        Additional args to pass directly to `/etc/eks/bootstrap.sh`. For details on available options, see: https://github.com/awslabs/amazon-eks-ami/blob/master/files/bootstrap.sh. Note that the `--apiserver-endpoint`, `--b64-cluster-ca` and `--kubelet-extra-args` flags are included automatically based on other configuration parameters.
        """
        return pulumi.get(self, "bootstrap_extra_args")

    @property
    @pulumi.getter(name="bottlerocketSettings")
    def bottlerocket_settings(self) -> Optional[Mapping[str, Any]]:
        """
        The configuration settings for Bottlerocket OS.
        The settings will get merged with the base settings the provider uses to configure Bottlerocket.

        This includes:
          - settings.kubernetes.api-server
          - settings.kubernetes.cluster-certificate
          - settings.kubernetes.cluster-name
          - settings.kubernetes.cluster-dns-ip

        For an overview of the available settings, see https://bottlerocket.dev/en/os/1.20.x/api/settings/.
        """
        return pulumi.get(self, "bottlerocket_settings")

    @property
    @pulumi.getter(name="cloudFormationTags")
    def cloud_formation_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The tags to apply to the CloudFormation Stack of the Worker NodeGroup.

        Note: Given the inheritance of auto-generated CF tags and `cloudFormationTags`, you should either supply the tag in `autoScalingGroupTags` or `cloudFormationTags`, but not both.
        """
        return pulumi.get(self, "cloud_formation_tags")

    @property
    @pulumi.getter(name="clusterIngressRule")
    def cluster_ingress_rule(self) -> Optional['pulumi_aws.ec2.SecurityGroupRule']:
        """
        The ingress rule that gives node group access.
        """
        return pulumi.get(self, "cluster_ingress_rule")

    @property
    @pulumi.getter(name="clusterIngressRuleId")
    def cluster_ingress_rule_id(self) -> Optional[builtins.str]:
        """
        The ID of the ingress rule that gives node group access.
        """
        return pulumi.get(self, "cluster_ingress_rule_id")

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[builtins.int]:
        """
        The number of worker nodes that should be running in the cluster. Defaults to 2.
        """
        return pulumi.get(self, "desired_capacity")

    @property
    @pulumi.getter(name="enableDetailedMonitoring")
    def enable_detailed_monitoring(self) -> Optional[builtins.bool]:
        """
        Enables/disables detailed monitoring of the EC2 instances.

        With detailed monitoring, all metrics, including status check metrics, are available in 1-minute intervals.
        When enabled, you can also get aggregated data across groups of similar instances.

        Note: You are charged per metric that is sent to CloudWatch. You are not charged for data storage.
        For more information, see "Paid tier" and "Example 1 - EC2 Detailed Monitoring" here https://aws.amazon.com/cloudwatch/pricing/.
        """
        return pulumi.get(self, "enable_detailed_monitoring")

    @property
    @pulumi.getter(name="encryptRootBlockDevice")
    def encrypt_root_block_device(self) -> Optional[builtins.bool]:
        """
        Encrypt the root block device of the nodes in the node group.
        """
        return pulumi.get(self, "encrypt_root_block_device")

    @property
    @pulumi.getter(name="extraNodeSecurityGroups")
    def extra_node_security_groups(self) -> Optional[Sequence['pulumi_aws.ec2.SecurityGroup']]:
        """
        Extra security groups to attach on all nodes in this worker node group.

        This additional set of security groups captures any user application rules that will be needed for the nodes.
        """
        return pulumi.get(self, "extra_node_security_groups")

    @property
    @pulumi.getter
    def gpu(self) -> Optional[builtins.bool]:
        """
        Use the latest recommended EKS Optimized Linux AMI with GPU support for the worker nodes from the AWS Systems Manager Parameter Store.

        Defaults to false.

        Note: `gpu` and `amiId` are mutually exclusive.

        See for more details:
        - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html
        - https://docs.aws.amazon.com/eks/latest/userguide/retrieve-ami-id.html
        """
        return pulumi.get(self, "gpu")

    @property
    @pulumi.getter(name="ignoreScalingChanges")
    def ignore_scaling_changes(self) -> Optional[builtins.bool]:
        """
        Whether to ignore changes to the desired size of the Auto Scaling Group. This is useful when using Cluster Autoscaler.

        See [EKS best practices](https://aws.github.io/aws-eks-best-practices/cluster-autoscaling/) for more details.
        """
        return pulumi.get(self, "ignore_scaling_changes")

    @property
    @pulumi.getter(name="instanceProfile")
    def instance_profile(self) -> Optional['pulumi_aws.iam.InstanceProfile']:
        """
        The IAM InstanceProfile to use on the NodeGroup. Properties instanceProfile and instanceProfileName are mutually exclusive.
        """
        return pulumi.get(self, "instance_profile")

    @property
    @pulumi.getter(name="instanceProfileName")
    def instance_profile_name(self) -> Optional[builtins.str]:
        """
        The name of the IAM InstanceProfile to use on the NodeGroup. Properties instanceProfile and instanceProfileName are mutually exclusive.
        """
        return pulumi.get(self, "instance_profile_name")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[builtins.str]:
        """
        The instance type to use for the cluster's nodes. Defaults to "t3.medium".
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[builtins.str]:
        """
        Name of the key pair to use for SSH access to worker nodes.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="kubeletExtraArgs")
    def kubelet_extra_args(self) -> Optional[builtins.str]:
        """
        Extra args to pass to the Kubelet. Corresponds to the options passed in the `--kubeletExtraArgs` flag to `/etc/eks/bootstrap.sh`. For example, '--port=10251 --address=0.0.0.0'. Note that the `labels` and `taints` properties will be applied to this list (using `--node-labels` and `--register-with-taints` respectively) after to the explicit `kubeletExtraArgs`.
        """
        return pulumi.get(self, "kubelet_extra_args")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Custom k8s node labels to be attached to each worker node. Adds the given key/value pairs to the `--node-labels` kubelet argument.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="launchTemplateTagSpecifications")
    def launch_template_tag_specifications(self) -> Optional[Sequence['pulumi_aws.ec2.outputs.LaunchTemplateTagSpecification']]:
        """
        The tag specifications to apply to the launch template.
        """
        return pulumi.get(self, "launch_template_tag_specifications")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[builtins.int]:
        """
        The maximum number of worker nodes running in the cluster. Defaults to 2.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minRefreshPercentage")
    def min_refresh_percentage(self) -> Optional[builtins.int]:
        """
        The minimum amount of instances that should remain available during an instance refresh, expressed as a percentage. Defaults to 50.
        """
        return pulumi.get(self, "min_refresh_percentage")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[builtins.int]:
        """
        The minimum number of worker nodes running in the cluster. Defaults to 1.
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="nodeAssociatePublicIpAddress")
    def node_associate_public_ip_address(self) -> Optional[builtins.bool]:
        """
        Whether or not to auto-assign public IP addresses on the EKS worker nodes. If this toggle is set to true, the EKS workers will be auto-assigned public IPs. If false, they will not be auto-assigned public IPs.
        """
        return pulumi.get(self, "node_associate_public_ip_address")

    @property
    @pulumi.getter(name="nodePublicKey")
    def node_public_key(self) -> Optional[builtins.str]:
        """
        Public key material for SSH access to worker nodes. See allowed formats at:
        https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
        If not provided, no SSH access is enabled on VMs.
        """
        return pulumi.get(self, "node_public_key")

    @property
    @pulumi.getter(name="nodeRootVolumeDeleteOnTermination")
    def node_root_volume_delete_on_termination(self) -> Optional[builtins.bool]:
        """
        Whether the root block device should be deleted on termination of the instance. Defaults to true.
        """
        return pulumi.get(self, "node_root_volume_delete_on_termination")

    @property
    @pulumi.getter(name="nodeRootVolumeEncrypted")
    def node_root_volume_encrypted(self) -> Optional[builtins.bool]:
        """
        Whether to encrypt a cluster node's root volume. Defaults to false.
        """
        return pulumi.get(self, "node_root_volume_encrypted")

    @property
    @pulumi.getter(name="nodeRootVolumeIops")
    def node_root_volume_iops(self) -> Optional[builtins.int]:
        """
        The amount of provisioned IOPS. This is only valid with a volumeType of 'io1'.
        """
        return pulumi.get(self, "node_root_volume_iops")

    @property
    @pulumi.getter(name="nodeRootVolumeSize")
    def node_root_volume_size(self) -> Optional[builtins.int]:
        """
        The size in GiB of a cluster node's root volume. Defaults to 20.
        """
        return pulumi.get(self, "node_root_volume_size")

    @property
    @pulumi.getter(name="nodeRootVolumeThroughput")
    def node_root_volume_throughput(self) -> Optional[builtins.int]:
        """
        Provisioned throughput performance in integer MiB/s for a cluster node's root volume. This is only valid with a volumeType of 'gp3'.
        """
        return pulumi.get(self, "node_root_volume_throughput")

    @property
    @pulumi.getter(name="nodeRootVolumeType")
    def node_root_volume_type(self) -> Optional[builtins.str]:
        """
        Configured EBS type for a cluster node's root volume. Default is 'gp2'. Supported values are 'standard', 'gp2', 'gp3', 'st1', 'sc1', 'io1'.
        """
        return pulumi.get(self, "node_root_volume_type")

    @property
    @pulumi.getter(name="nodeSecurityGroup")
    def node_security_group(self) -> Optional['pulumi_aws.ec2.SecurityGroup']:
        """
        The security group for the worker node group to communicate with the cluster.

        This security group requires specific inbound and outbound rules.

        See for more details:
        https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html

        Note: The `nodeSecurityGroup` option and the cluster option`nodeSecurityGroupTags` are mutually exclusive.
        """
        return pulumi.get(self, "node_security_group")

    @property
    @pulumi.getter(name="nodeSecurityGroupId")
    def node_security_group_id(self) -> Optional[builtins.str]:
        """
        The ID of the security group for the worker node group to communicate with the cluster.

        This security group requires specific inbound and outbound rules.

        See for more details:
        https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html

        Note: The `nodeSecurityGroupId` option and the cluster option `nodeSecurityGroupTags` are mutually exclusive.
        """
        return pulumi.get(self, "node_security_group_id")

    @property
    @pulumi.getter(name="nodeSubnetIds")
    def node_subnet_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The set of subnets to override and use for the worker node group.

        Setting this option overrides which subnets to use for the worker node group, regardless if the cluster's `subnetIds` is set, or if `publicSubnetIds` and/or `privateSubnetIds` were set.
        """
        return pulumi.get(self, "node_subnet_ids")

    @property
    @pulumi.getter(name="nodeUserData")
    def node_user_data(self) -> Optional[builtins.str]:
        """
        Extra code to run on node startup. This code will run after the AWS EKS bootstrapping code and before the node signals its readiness to the managing CloudFormation stack. This code must be a typical user data script: critically it must begin with an interpreter directive (i.e. a `#!`).
        """
        return pulumi.get(self, "node_user_data")

    @property
    @pulumi.getter(name="nodeUserDataOverride")
    def node_user_data_override(self) -> Optional[builtins.str]:
        """
        User specified code to run on node startup. This code is expected to handle the full AWS EKS bootstrapping code and signal node readiness to the managing CloudFormation stack. This code must be a complete and executable user data script in bash (Linux) or powershell (Windows).

        See for more details: https://docs.aws.amazon.com/eks/latest/userguide/worker.html
        """
        return pulumi.get(self, "node_user_data_override")

    @property
    @pulumi.getter(name="nodeadmExtraOptions")
    def nodeadm_extra_options(self) -> Optional[Sequence['outputs.NodeadmOptions']]:
        """
        Extra nodeadm configuration sections to be added to the nodeadm user data. This can be shell scripts, nodeadm NodeConfig or any other user data compatible script. When configuring additional nodeadm NodeConfig sections, they'll be merged with the base settings the provider sets. You can overwrite base settings or provide additional settings this way.
        The base settings the provider sets are:
          - cluster.name
          - cluster.apiServerEndpoint
          - cluster.certificateAuthority
          - cluster.cidr

        Note: This is only applicable when using AL2023.
        See for more details:
          - https://awslabs.github.io/amazon-eks-ami/nodeadm/
          - https://awslabs.github.io/amazon-eks-ami/nodeadm/doc/api/
        """
        return pulumi.get(self, "nodeadm_extra_options")

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> Optional['OperatingSystem']:
        """
        The type of OS to use for the node group. Will be used to determine the right EKS optimized AMI to use based on the instance types and gpu configuration.
        Valid values are `RECOMMENDED`, `AL2`, `AL2023` and `Bottlerocket`.

        Defaults to the current recommended OS.
        """
        return pulumi.get(self, "operating_system")

    @property
    @pulumi.getter(name="spotPrice")
    def spot_price(self) -> Optional[builtins.str]:
        """
        Bidding price for spot instance. If set, only spot instances will be added as worker node.
        """
        return pulumi.get(self, "spot_price")

    @property
    @pulumi.getter
    def taints(self) -> Optional[Mapping[str, 'outputs.Taint']]:
        """
        Custom k8s node taints to be attached to each worker node. Adds the given taints to the `--register-with-taints` kubelet argument
        """
        return pulumi.get(self, "taints")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        Desired Kubernetes master / control plane version. If you do not specify a value, the latest available version is used.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class CoreData(dict):
    """
    Defines the core set of data associated with an EKS cluster, including the network in which it runs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterIamRole":
            suggest = "cluster_iam_role"
        elif key == "instanceRoles":
            suggest = "instance_roles"
        elif key == "nodeGroupOptions":
            suggest = "node_group_options"
        elif key == "subnetIds":
            suggest = "subnet_ids"
        elif key == "vpcId":
            suggest = "vpc_id"
        elif key == "accessEntries":
            suggest = "access_entries"
        elif key == "awsProvider":
            suggest = "aws_provider"
        elif key == "clusterSecurityGroup":
            suggest = "cluster_security_group"
        elif key == "eksNodeAccess":
            suggest = "eks_node_access"
        elif key == "encryptionConfig":
            suggest = "encryption_config"
        elif key == "fargateProfile":
            suggest = "fargate_profile"
        elif key == "nodeSecurityGroupTags":
            suggest = "node_security_group_tags"
        elif key == "oidcProvider":
            suggest = "oidc_provider"
        elif key == "privateSubnetIds":
            suggest = "private_subnet_ids"
        elif key == "publicSubnetIds":
            suggest = "public_subnet_ids"
        elif key == "storageClasses":
            suggest = "storage_classes"
        elif key == "vpcCni":
            suggest = "vpc_cni"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CoreData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CoreData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CoreData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster: 'pulumi_aws.eks.Cluster',
                 cluster_iam_role: 'pulumi_aws.iam.Role',
                 endpoint: builtins.str,
                 instance_roles: Sequence['pulumi_aws.iam.Role'],
                 node_group_options: 'outputs.ClusterNodeGroupOptions',
                 provider: 'pulumi_kubernetes.Provider',
                 subnet_ids: Sequence[builtins.str],
                 vpc_id: builtins.str,
                 access_entries: Optional[Sequence['outputs.AccessEntry']] = None,
                 aws_provider: Optional['pulumi_aws.Provider'] = None,
                 cluster_security_group: Optional['pulumi_aws.ec2.SecurityGroup'] = None,
                 eks_node_access: Optional['pulumi_kubernetes.core.v1.ConfigMap'] = None,
                 encryption_config: Optional['pulumi_aws.eks.outputs.ClusterEncryptionConfig'] = None,
                 fargate_profile: Optional['pulumi_aws.eks.FargateProfile'] = None,
                 kubeconfig: Optional[Any] = None,
                 node_security_group_tags: Optional[Mapping[str, builtins.str]] = None,
                 oidc_provider: Optional['pulumi_aws.iam.OpenIdConnectProvider'] = None,
                 private_subnet_ids: Optional[Sequence[builtins.str]] = None,
                 public_subnet_ids: Optional[Sequence[builtins.str]] = None,
                 storage_classes: Optional[Mapping[str, 'pulumi_kubernetes.storage.v1.StorageClass']] = None,
                 tags: Optional[Mapping[str, builtins.str]] = None,
                 vpc_cni: Optional['VpcCniAddon'] = None):
        """
        Defines the core set of data associated with an EKS cluster, including the network in which it runs.
        :param 'pulumi_aws.iam.Role' cluster_iam_role: The IAM Role attached to the EKS Cluster
        :param builtins.str endpoint: The EKS cluster's Kubernetes API server endpoint.
        :param Sequence['pulumi_aws.iam.Role'] instance_roles: The IAM instance roles for the cluster's nodes.
        :param 'ClusterNodeGroupOptions' node_group_options: The cluster's node group options.
        :param Sequence[builtins.str] subnet_ids: List of subnet IDs for the EKS cluster.
        :param builtins.str vpc_id: ID of the cluster's VPC.
        :param Sequence['AccessEntry'] access_entries: The access entries added to the cluster.
        :param 'pulumi_aws.eks.FargateProfile' fargate_profile: The Fargate profile used to manage which pods run on Fargate.
        :param Any kubeconfig: The kubeconfig file for the cluster.
        :param Mapping[str, builtins.str] node_security_group_tags: Tags attached to the security groups associated with the cluster's worker nodes.
        :param Sequence[builtins.str] private_subnet_ids: List of subnet IDs for the private subnets.
        :param Sequence[builtins.str] public_subnet_ids: List of subnet IDs for the public subnets.
        :param Mapping[str, 'pulumi_kubernetes.storage.v1.StorageClass'] storage_classes: The storage class used for persistent storage by the cluster.
        :param Mapping[str, builtins.str] tags: A map of tags assigned to the EKS cluster.
        :param 'VpcCniAddon' vpc_cni: The VPC CNI for the cluster.
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "cluster_iam_role", cluster_iam_role)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "instance_roles", instance_roles)
        pulumi.set(__self__, "node_group_options", node_group_options)
        pulumi.set(__self__, "provider", provider)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if access_entries is not None:
            pulumi.set(__self__, "access_entries", access_entries)
        if aws_provider is not None:
            pulumi.set(__self__, "aws_provider", aws_provider)
        if cluster_security_group is not None:
            pulumi.set(__self__, "cluster_security_group", cluster_security_group)
        if eks_node_access is not None:
            pulumi.set(__self__, "eks_node_access", eks_node_access)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if fargate_profile is not None:
            pulumi.set(__self__, "fargate_profile", fargate_profile)
        if kubeconfig is not None:
            pulumi.set(__self__, "kubeconfig", kubeconfig)
        if node_security_group_tags is not None:
            pulumi.set(__self__, "node_security_group_tags", node_security_group_tags)
        if oidc_provider is not None:
            pulumi.set(__self__, "oidc_provider", oidc_provider)
        if private_subnet_ids is not None:
            pulumi.set(__self__, "private_subnet_ids", private_subnet_ids)
        if public_subnet_ids is not None:
            pulumi.set(__self__, "public_subnet_ids", public_subnet_ids)
        if storage_classes is not None:
            pulumi.set(__self__, "storage_classes", storage_classes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_cni is not None:
            pulumi.set(__self__, "vpc_cni", vpc_cni)

    @property
    @pulumi.getter
    def cluster(self) -> 'pulumi_aws.eks.Cluster':
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter(name="clusterIamRole")
    def cluster_iam_role(self) -> 'pulumi_aws.iam.Role':
        """
        The IAM Role attached to the EKS Cluster
        """
        return pulumi.get(self, "cluster_iam_role")

    @property
    @pulumi.getter
    def endpoint(self) -> builtins.str:
        """
        The EKS cluster's Kubernetes API server endpoint.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="instanceRoles")
    def instance_roles(self) -> Sequence['pulumi_aws.iam.Role']:
        """
        The IAM instance roles for the cluster's nodes.
        """
        return pulumi.get(self, "instance_roles")

    @property
    @pulumi.getter(name="nodeGroupOptions")
    def node_group_options(self) -> 'outputs.ClusterNodeGroupOptions':
        """
        The cluster's node group options.
        """
        return pulumi.get(self, "node_group_options")

    @property
    @pulumi.getter
    def provider(self) -> 'pulumi_kubernetes.Provider':
        return pulumi.get(self, "provider")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[builtins.str]:
        """
        List of subnet IDs for the EKS cluster.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> builtins.str:
        """
        ID of the cluster's VPC.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="accessEntries")
    def access_entries(self) -> Optional[Sequence['outputs.AccessEntry']]:
        """
        The access entries added to the cluster.
        """
        return pulumi.get(self, "access_entries")

    @property
    @pulumi.getter(name="awsProvider")
    def aws_provider(self) -> Optional['pulumi_aws.Provider']:
        return pulumi.get(self, "aws_provider")

    @property
    @pulumi.getter(name="clusterSecurityGroup")
    def cluster_security_group(self) -> Optional['pulumi_aws.ec2.SecurityGroup']:
        return pulumi.get(self, "cluster_security_group")

    @property
    @pulumi.getter(name="eksNodeAccess")
    def eks_node_access(self) -> Optional['pulumi_kubernetes.core.v1.ConfigMap']:
        return pulumi.get(self, "eks_node_access")

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional['pulumi_aws.eks.outputs.ClusterEncryptionConfig']:
        return pulumi.get(self, "encryption_config")

    @property
    @pulumi.getter(name="fargateProfile")
    def fargate_profile(self) -> Optional['pulumi_aws.eks.FargateProfile']:
        """
        The Fargate profile used to manage which pods run on Fargate.
        """
        return pulumi.get(self, "fargate_profile")

    @property
    @pulumi.getter
    def kubeconfig(self) -> Optional[Any]:
        """
        The kubeconfig file for the cluster.
        """
        return pulumi.get(self, "kubeconfig")

    @property
    @pulumi.getter(name="nodeSecurityGroupTags")
    def node_security_group_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Tags attached to the security groups associated with the cluster's worker nodes.
        """
        return pulumi.get(self, "node_security_group_tags")

    @property
    @pulumi.getter(name="oidcProvider")
    def oidc_provider(self) -> Optional['pulumi_aws.iam.OpenIdConnectProvider']:
        return pulumi.get(self, "oidc_provider")

    @property
    @pulumi.getter(name="privateSubnetIds")
    def private_subnet_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        List of subnet IDs for the private subnets.
        """
        return pulumi.get(self, "private_subnet_ids")

    @property
    @pulumi.getter(name="publicSubnetIds")
    def public_subnet_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        List of subnet IDs for the public subnets.
        """
        return pulumi.get(self, "public_subnet_ids")

    @property
    @pulumi.getter(name="storageClasses")
    def storage_classes(self) -> Optional[Mapping[str, 'pulumi_kubernetes.storage.v1.StorageClass']]:
        """
        The storage class used for persistent storage by the cluster.
        """
        return pulumi.get(self, "storage_classes")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the EKS cluster.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcCni")
    def vpc_cni(self) -> Optional['VpcCniAddon']:
        """
        The VPC CNI for the cluster.
        """
        return pulumi.get(self, "vpc_cni")


@pulumi.output_type
class NodeGroupData(dict):
    """
    NodeGroupData describes the resources created for the given NodeGroup.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoScalingGroup":
            suggest = "auto_scaling_group"
        elif key == "extraNodeSecurityGroups":
            suggest = "extra_node_security_groups"
        elif key == "nodeSecurityGroup":
            suggest = "node_security_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeGroupData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeGroupData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeGroupData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_scaling_group: 'pulumi_aws.autoscaling.Group',
                 extra_node_security_groups: Sequence['pulumi_aws.ec2.SecurityGroup'],
                 node_security_group: 'pulumi_aws.ec2.SecurityGroup'):
        """
        NodeGroupData describes the resources created for the given NodeGroup.
        :param 'pulumi_aws.autoscaling.Group' auto_scaling_group: The AutoScalingGroup for the node group.
        :param Sequence['pulumi_aws.ec2.SecurityGroup'] extra_node_security_groups: The additional security groups for the node group that captures user-specific rules.
        :param 'pulumi_aws.ec2.SecurityGroup' node_security_group: The security group for the node group to communicate with the cluster.
        """
        pulumi.set(__self__, "auto_scaling_group", auto_scaling_group)
        pulumi.set(__self__, "extra_node_security_groups", extra_node_security_groups)
        pulumi.set(__self__, "node_security_group", node_security_group)

    @property
    @pulumi.getter(name="autoScalingGroup")
    def auto_scaling_group(self) -> 'pulumi_aws.autoscaling.Group':
        """
        The AutoScalingGroup for the node group.
        """
        return pulumi.get(self, "auto_scaling_group")

    @property
    @pulumi.getter(name="extraNodeSecurityGroups")
    def extra_node_security_groups(self) -> Sequence['pulumi_aws.ec2.SecurityGroup']:
        """
        The additional security groups for the node group that captures user-specific rules.
        """
        return pulumi.get(self, "extra_node_security_groups")

    @property
    @pulumi.getter(name="nodeSecurityGroup")
    def node_security_group(self) -> 'pulumi_aws.ec2.SecurityGroup':
        """
        The security group for the node group to communicate with the cluster.
        """
        return pulumi.get(self, "node_security_group")


@pulumi.output_type
class NodeadmOptions(dict):
    """
    MIME document parts for nodeadm configuration. This can be shell scripts, nodeadm configuration or any other user data compatible script.

    See for more details: https://awslabs.github.io/amazon-eks-ami/nodeadm/.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeadmOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeadmOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeadmOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: builtins.str,
                 content_type: builtins.str):
        """
        MIME document parts for nodeadm configuration. This can be shell scripts, nodeadm configuration or any other user data compatible script.

        See for more details: https://awslabs.github.io/amazon-eks-ami/nodeadm/.
        :param builtins.str content: The actual content of the MIME document part, such as shell script code or nodeadm configuration. Must be compatible with the specified contentType.
        :param builtins.str content_type: The MIME type of the content. Examples are `text/x-shellscript; charset="us-ascii"` for shell scripts, and `application/node.eks.aws` nodeadm configuration.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "content_type", content_type)

    @property
    @pulumi.getter
    def content(self) -> builtins.str:
        """
        The actual content of the MIME document part, such as shell script code or nodeadm configuration. Must be compatible with the specified contentType.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> builtins.str:
        """
        The MIME type of the content. Examples are `text/x-shellscript; charset="us-ascii"` for shell scripts, and `application/node.eks.aws` nodeadm configuration.
        """
        return pulumi.get(self, "content_type")


@pulumi.output_type
class Taint(dict):
    """
    Represents a Kubernetes `taint` to apply to all Nodes in a NodeGroup. See https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/.
    """
    def __init__(__self__, *,
                 effect: builtins.str,
                 value: builtins.str):
        """
        Represents a Kubernetes `taint` to apply to all Nodes in a NodeGroup. See https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/.
        :param builtins.str effect: The effect of the taint.
        :param builtins.str value: The value of the taint.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> builtins.str:
        """
        The effect of the taint.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the taint.
        """
        return pulumi.get(self, "value")


