# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectIssueBoardArgs', 'ProjectIssueBoard']

@pulumi.input_type
class ProjectIssueBoardArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[str],
                 assignee_id: Optional[pulumi.Input[int]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 lists: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectIssueBoardListArgs']]]] = None,
                 milestone_id: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 weight: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a ProjectIssueBoard resource.
        :param pulumi.Input[str] project: The ID or full path of the project maintained by the authenticated user.
        :param pulumi.Input[int] assignee_id: The assignee the board should be scoped to. Requires a GitLab EE license.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] labels: The list of label names which the board should be scoped to. Requires a GitLab EE license.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectIssueBoardListArgs']]] lists: The list of issue board lists
        :param pulumi.Input[int] milestone_id: The milestone the board should be scoped to. Requires a GitLab EE license.
        :param pulumi.Input[str] name: The name of the board.
        :param pulumi.Input[int] weight: The weight range from 0 to 9, to which the board should be scoped to. Requires a GitLab EE license.
        """
        pulumi.set(__self__, "project", project)
        if assignee_id is not None:
            pulumi.set(__self__, "assignee_id", assignee_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if lists is not None:
            pulumi.set(__self__, "lists", lists)
        if milestone_id is not None:
            pulumi.set(__self__, "milestone_id", milestone_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        The ID or full path of the project maintained by the authenticated user.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="assigneeId")
    def assignee_id(self) -> Optional[pulumi.Input[int]]:
        """
        The assignee the board should be scoped to. Requires a GitLab EE license.
        """
        return pulumi.get(self, "assignee_id")

    @assignee_id.setter
    def assignee_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "assignee_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of label names which the board should be scoped to. Requires a GitLab EE license.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectIssueBoardListArgs']]]]:
        """
        The list of issue board lists
        """
        return pulumi.get(self, "lists")

    @lists.setter
    def lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectIssueBoardListArgs']]]]):
        pulumi.set(self, "lists", value)

    @property
    @pulumi.getter(name="milestoneId")
    def milestone_id(self) -> Optional[pulumi.Input[int]]:
        """
        The milestone the board should be scoped to. Requires a GitLab EE license.
        """
        return pulumi.get(self, "milestone_id")

    @milestone_id.setter
    def milestone_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "milestone_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the board.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        The weight range from 0 to 9, to which the board should be scoped to. Requires a GitLab EE license.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class _ProjectIssueBoardState:
    def __init__(__self__, *,
                 assignee_id: Optional[pulumi.Input[int]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 lists: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectIssueBoardListArgs']]]] = None,
                 milestone_id: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 weight: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering ProjectIssueBoard resources.
        :param pulumi.Input[int] assignee_id: The assignee the board should be scoped to. Requires a GitLab EE license.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] labels: The list of label names which the board should be scoped to. Requires a GitLab EE license.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectIssueBoardListArgs']]] lists: The list of issue board lists
        :param pulumi.Input[int] milestone_id: The milestone the board should be scoped to. Requires a GitLab EE license.
        :param pulumi.Input[str] name: The name of the board.
        :param pulumi.Input[str] project: The ID or full path of the project maintained by the authenticated user.
        :param pulumi.Input[int] weight: The weight range from 0 to 9, to which the board should be scoped to. Requires a GitLab EE license.
        """
        if assignee_id is not None:
            pulumi.set(__self__, "assignee_id", assignee_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if lists is not None:
            pulumi.set(__self__, "lists", lists)
        if milestone_id is not None:
            pulumi.set(__self__, "milestone_id", milestone_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="assigneeId")
    def assignee_id(self) -> Optional[pulumi.Input[int]]:
        """
        The assignee the board should be scoped to. Requires a GitLab EE license.
        """
        return pulumi.get(self, "assignee_id")

    @assignee_id.setter
    def assignee_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "assignee_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of label names which the board should be scoped to. Requires a GitLab EE license.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectIssueBoardListArgs']]]]:
        """
        The list of issue board lists
        """
        return pulumi.get(self, "lists")

    @lists.setter
    def lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectIssueBoardListArgs']]]]):
        pulumi.set(self, "lists", value)

    @property
    @pulumi.getter(name="milestoneId")
    def milestone_id(self) -> Optional[pulumi.Input[int]]:
        """
        The milestone the board should be scoped to. Requires a GitLab EE license.
        """
        return pulumi.get(self, "milestone_id")

    @milestone_id.setter
    def milestone_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "milestone_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the board.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID or full path of the project maintained by the authenticated user.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        The weight range from 0 to 9, to which the board should be scoped to. Requires a GitLab EE license.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


class ProjectIssueBoard(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assignee_id: Optional[pulumi.Input[int]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectIssueBoardListArgs']]]]] = None,
                 milestone_id: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 weight: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        The `ProjectIssueBoard` resource allows to manage the lifecycle of a Project Issue Board.

        > **NOTE:** If the board lists are changed all lists will be recreated.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/boards.html)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        example_project = gitlab.Project("exampleProject",
            description="Lorem Ipsum",
            visibility_level="public")
        example_user = gitlab.User("exampleUser",
            username="example",
            email="example@example.com",
            password="example1$$$")
        example_project_membership = gitlab.ProjectMembership("exampleProjectMembership",
            project_id=example_project.id,
            user_id=example_user.id,
            access_level="developer")
        example_project_milestone = gitlab.ProjectMilestone("exampleProjectMilestone",
            project=example_project.id,
            title="m1")
        this = gitlab.ProjectIssueBoard("this",
            project=example_project.id,
            lists=[
                gitlab.ProjectIssueBoardListArgs(
                    assignee_id=example_user.id,
                ),
                gitlab.ProjectIssueBoardListArgs(
                    milestone_id=example_project_milestone.milestone_id,
                ),
            ],
            opts=pulumi.ResourceOptions(depends_on=[example_project_membership]))
        list_syntax = gitlab.ProjectIssueBoard("listSyntax",
            project=example_project.id,
            lists=[
                gitlab.ProjectIssueBoardListArgs(
                    assignee_id=example_user.id,
                ),
                gitlab.ProjectIssueBoardListArgs(
                    milestone_id=example_project_milestone.milestone_id,
                ),
            ],
            opts=pulumi.ResourceOptions(depends_on=[example_project_membership]))
        ```

        ## Import

        You can import this resource with an id made up of `{project-id}:{issue-board-id}`, e.g.

        ```sh
         $ pulumi import gitlab:index/projectIssueBoard:ProjectIssueBoard kanban 42:1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] assignee_id: The assignee the board should be scoped to. Requires a GitLab EE license.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] labels: The list of label names which the board should be scoped to. Requires a GitLab EE license.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectIssueBoardListArgs']]]] lists: The list of issue board lists
        :param pulumi.Input[int] milestone_id: The milestone the board should be scoped to. Requires a GitLab EE license.
        :param pulumi.Input[str] name: The name of the board.
        :param pulumi.Input[str] project: The ID or full path of the project maintained by the authenticated user.
        :param pulumi.Input[int] weight: The weight range from 0 to 9, to which the board should be scoped to. Requires a GitLab EE license.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectIssueBoardArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `ProjectIssueBoard` resource allows to manage the lifecycle of a Project Issue Board.

        > **NOTE:** If the board lists are changed all lists will be recreated.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/boards.html)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        example_project = gitlab.Project("exampleProject",
            description="Lorem Ipsum",
            visibility_level="public")
        example_user = gitlab.User("exampleUser",
            username="example",
            email="example@example.com",
            password="example1$$$")
        example_project_membership = gitlab.ProjectMembership("exampleProjectMembership",
            project_id=example_project.id,
            user_id=example_user.id,
            access_level="developer")
        example_project_milestone = gitlab.ProjectMilestone("exampleProjectMilestone",
            project=example_project.id,
            title="m1")
        this = gitlab.ProjectIssueBoard("this",
            project=example_project.id,
            lists=[
                gitlab.ProjectIssueBoardListArgs(
                    assignee_id=example_user.id,
                ),
                gitlab.ProjectIssueBoardListArgs(
                    milestone_id=example_project_milestone.milestone_id,
                ),
            ],
            opts=pulumi.ResourceOptions(depends_on=[example_project_membership]))
        list_syntax = gitlab.ProjectIssueBoard("listSyntax",
            project=example_project.id,
            lists=[
                gitlab.ProjectIssueBoardListArgs(
                    assignee_id=example_user.id,
                ),
                gitlab.ProjectIssueBoardListArgs(
                    milestone_id=example_project_milestone.milestone_id,
                ),
            ],
            opts=pulumi.ResourceOptions(depends_on=[example_project_membership]))
        ```

        ## Import

        You can import this resource with an id made up of `{project-id}:{issue-board-id}`, e.g.

        ```sh
         $ pulumi import gitlab:index/projectIssueBoard:ProjectIssueBoard kanban 42:1
        ```

        :param str resource_name: The name of the resource.
        :param ProjectIssueBoardArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectIssueBoardArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assignee_id: Optional[pulumi.Input[int]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectIssueBoardListArgs']]]]] = None,
                 milestone_id: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 weight: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectIssueBoardArgs.__new__(ProjectIssueBoardArgs)

            __props__.__dict__["assignee_id"] = assignee_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["lists"] = lists
            __props__.__dict__["milestone_id"] = milestone_id
            __props__.__dict__["name"] = name
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["weight"] = weight
        super(ProjectIssueBoard, __self__).__init__(
            'gitlab:index/projectIssueBoard:ProjectIssueBoard',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assignee_id: Optional[pulumi.Input[int]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectIssueBoardListArgs']]]]] = None,
            milestone_id: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            weight: Optional[pulumi.Input[int]] = None) -> 'ProjectIssueBoard':
        """
        Get an existing ProjectIssueBoard resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] assignee_id: The assignee the board should be scoped to. Requires a GitLab EE license.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] labels: The list of label names which the board should be scoped to. Requires a GitLab EE license.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectIssueBoardListArgs']]]] lists: The list of issue board lists
        :param pulumi.Input[int] milestone_id: The milestone the board should be scoped to. Requires a GitLab EE license.
        :param pulumi.Input[str] name: The name of the board.
        :param pulumi.Input[str] project: The ID or full path of the project maintained by the authenticated user.
        :param pulumi.Input[int] weight: The weight range from 0 to 9, to which the board should be scoped to. Requires a GitLab EE license.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectIssueBoardState.__new__(_ProjectIssueBoardState)

        __props__.__dict__["assignee_id"] = assignee_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["lists"] = lists
        __props__.__dict__["milestone_id"] = milestone_id
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["weight"] = weight
        return ProjectIssueBoard(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="assigneeId")
    def assignee_id(self) -> pulumi.Output[Optional[int]]:
        """
        The assignee the board should be scoped to. Requires a GitLab EE license.
        """
        return pulumi.get(self, "assignee_id")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of label names which the board should be scoped to. Requires a GitLab EE license.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def lists(self) -> pulumi.Output[Optional[Sequence['outputs.ProjectIssueBoardList']]]:
        """
        The list of issue board lists
        """
        return pulumi.get(self, "lists")

    @property
    @pulumi.getter(name="milestoneId")
    def milestone_id(self) -> pulumi.Output[Optional[int]]:
        """
        The milestone the board should be scoped to. Requires a GitLab EE license.
        """
        return pulumi.get(self, "milestone_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the board.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID or full path of the project maintained by the authenticated user.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def weight(self) -> pulumi.Output[Optional[int]]:
        """
        The weight range from 0 to 9, to which the board should be scoped to. Requires a GitLab EE license.
        """
        return pulumi.get(self, "weight")

