# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pelican', 'pelican.plugins.math_svg']

package_data = \
{'': ['*']}

install_requires = \
['lxml>=4.6.3,<5.0.0', 'pelican>=4.5,<5.0', 'setuptools>=57.1.0,<58.0.0']

extras_require = \
{'markdown': ['markdown>=3.2.2,<4.0.0']}

entry_points = \
{'console_scripts': ['pelican-math-svg = pelican.plugins.math_svg.main:main']}

setup_kwargs = {
    'name': 'pelican-math-svg',
    'version': '0.7.0',
    'description': 'Render math expressions to svg and embed them.',
    'long_description': '# math-svg: A Plugin for Pelican\n\n[![Build Status](https://img.shields.io/github/workflow/status/f-koehler/pelican-math-svg/build)](https://github.com/f-koehler/pelican-math-svg/actions)\n[![PyPI Version](https://img.shields.io/pypi/v/pelican-math-svg)](https://pypi.org/project/pelican-math-svg/)\n![License](https://img.shields.io/pypi/l/pelican-math-svg?color=blue)\n\nRender math expressions to svg and embed them.\n\n## Installation\n\nThis plugin can be installed via:\n\n```shell\npython -m pip install pelican-math-svg\n```\n\n## Requirements\n\n-   required LaTeX tools (all included in TeX Live and possibly other LaTeX distributions):\n    -   `lualatex` (or another LaTeX compiler if changed in the settings, [see below](#configuration))\n    -   `pdfcrop`\n    -   `dvisvgm`\n-   `scour` (optional)\n-   `svgo` (optional)\n\n## Usage\n\nIn Markdown you can use `$x$` for inline math and\n\n```\n$$\n  \\int x^2\n$$\n```\n\nfor display math.\n\nIt is required to set the stroke color using the `strokeonly` class (this class name can be changed, see [configuration options below](#configuration)), otherwise lines would be rendered white:\n\n```css\nsvg path.strokeonly {\n    color: #000;\n}\n```\n\nTo change the fill color for equations as well, thus essential changing the default color for math, specify the following additionally:\n\n```css\nspan.math svg path,\ndiv.math svg path {\n    fill: #000;\n}\n```\n\n## Configuration\n\nIn your `pelicanconf.py` you can use the following options to tweak the behavior of the plugin:\n\n| Setting                         | Description                                                                                                                 | Default Value                                                                                                                                       |\n| ------------------------------- | --------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------- |\n| `MATH_SVG["titles"]             | Whether to generate `<title>` tags containing the raw LaTeX code (recommended for accessibility).                           | `True`                                                                                                                                              |\n| `MATH_SVG["scale_inline"]`      | scaling factor for inline math                                                                                              | `1.0`                                                                                                                                               |\n| `MATH_SVG["scale_display"]`     | scaling factor for display math                                                                                             | `1.0`                                                                                                                                               |\n| `MATH_SVG["strokeonly_class]`   | CSS class for SVG paths that have no filling and a black stroke color, useful when changing the color of rendered equations | `strokeonly`                                                                                                                                        |\n| `MATH_SVG["latex"]["args"]`     | CLI arguments of the invoked LaTeX compiler                                                                                 | `"--interaction=errorstopmode", "--halt-on-error"`                                                                                                  |\n| `MATH_SVG["latex"]["preamble"]` | preamble of the generated LaTeX document                                                                                    | `[r"\\documentclass[crop,border={2pt 0pt}]{standalone}",r"\\usepackage{amsmath}",r"\\usepackage{amssymb}",]`                                           |\n| `MATH_SVG["latex"]["program"]`  | LaTeX compiler to use                                                                                                       | `lualatex`                                                                                                                                          |\n| `MATH_SVG["pdfcrop"]["args"]`   | CLI arguments for `pdfcrop`                                                                                                 | `--hires`                                                                                                                                           |\n| `MATH_SVG["dvisvgm"]["args"]`   | CLI arguments for `dvisvgm`                                                                                                 | `["--pdf", "--optimize=all", "--no-fonts", "--exact-bbox"]`                                                                                         |\n| `MATH_SVG["scour"]["args"]`     | CLI arguments for `scour`                                                                                                   | `["--strip-xml-prolog", "--remove-descriptions", "--remove-metadata", "--enable-comment-stripping", "--strip-xml-space", "--enable-id-stripping",]` |\n| `MATH_SVG["scour"]["enabled"]`  | whether to use `scour` to optimize SVG output                                                                               | `True` if `scour` is in `$PATH`, `False` otherwise                                                                                                  |\n| `MATH_SVG["svgo"]["args"]`      | CLI arguments for `svgo`                                                                                                    | `["--multipass", "--precision", "5"]`                                                                                                               |\n| `MATH_SVG["svgo"]["enabled"]`   | whether to use `svgo` to optimize SVG output                                                                                | `True` if `svgo` is in `$PATH`, `False` otherwise                                                                                                   |\n\n## Contributing\n\nContributions are welcome and much appreciated. Every little bit helps. You can contribute by improving the documentation, adding missing features, and fixing bugs. You can also help out by reviewing and commenting on [existing issues][].\n\nTo start contributing to this plugin, review the [Contributing to Pelican][] documentation, beginning with the **Contributing Code** section.\n\n[existing issues]: https://github.com/f-koehler/pelican-math-svg/issues\n[contributing to pelican]: https://docs.getpelican.com/en/latest/contribute.html\n\n## License\n\nThis project is licensed under the GPLv3 license.\n',
    'author': 'Fabian Köhler',
    'author_email': 'fabian.koehler@protonmail.ch',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/f-koehler/pelican-math-svg',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
