"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BastionAccessPolicy = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const constants_1 = require("./constants");
class BastionAccessPolicy extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const securityTag = (props === null || props === void 0 ? void 0 : props.securityTag) ? props.securityTag
            : constants_1.Constants.securityTag;
        this.policy = new aws_cdk_lib_1.aws_iam.PolicyDocument({
            statements: [
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    actions: [
                        'cloudwatch:DescribeAlarms',
                        'ec2:DescribeInstances',
                        'ec2:DescribeInstanceStatus',
                        'ec2:DescribeSecurityGroup*',
                        'identitystore:DescribeUser',
                        'ssm-guiconnect:CancelConnection',
                        'ssm-guiconnect:GetConnection',
                        'ssm-guiconnect:StartConnection',
                        'ssm:DescribeInstance*',
                        'ssm:GetCommandInvocation',
                        'ssm:GetInventorySchema',
                        'sso:ListDirectoryAssociations*',
                        'rds:Describe*',
                        'secretsmanager:ListSecrets',
                        'kms:ListAliases',
                    ],
                    resources: ['*'],
                }),
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    actions: [
                        'ec2:GetPasswordData',
                        'ec2:StartInstances',
                        'ssm:GetConnectionStatus',
                        'ssm:SendCommand',
                        'ssm:StartSession',
                    ],
                    resources: ['arn:aws:ec2:*:*:instance/*'],
                    conditions: {
                        StringEquals: JSON.parse(`{"aws:ResourceTag/${securityTag.key}": "${securityTag.value}"}`),
                    },
                }),
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    actions: [
                        'secretsmanager:DescribeSecret',
                        'secretsmanager:GetSecretValue',
                    ],
                    resources: ['*'],
                    conditions: {
                        StringEquals: JSON.parse(`{"aws:ResourceTag/${securityTag.key}": "${securityTag.value}"}`),
                    },
                }),
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    actions: ['ssm:TerminateSession'],
                    resources: ['*'],
                    conditions: {
                        StringLike: {
                            'ssm:resourceTag/aws:ssmmessages:session-id': '${aws:userName}',
                        },
                    },
                }),
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    actions: ['ssm:GetDocument'],
                    resources: [
                        'arn:aws:ssm:*:*:document/AWS-StartPortForwardingSession',
                        'arn:aws:ssm:*:*:document/SSM-SessionManagerRunShell',
                    ],
                }),
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    actions: ['ssm:SendCommand', 'ssm:StartSession'],
                    resources: [
                        'arn:aws:ssm:*:*:document/AWS-StartPortForwardingSession',
                        'arn:aws:ssm:*:*:document/AWSSSO-CreateSSOUser',
                        'arn:aws:ssm:*:*:managed-instance/*',
                    ],
                    conditions: {
                        BoolIfExists: {
                            'ssm:SessionDocumentAccessCheck': 'true',
                        },
                    },
                }),
            ],
        });
    }
}
exports.BastionAccessPolicy = BastionAccessPolicy;
//# sourceMappingURL=data:application/json;base64,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