import { Tag } from 'aws-cdk-lib';
import { Construct } from 'constructs';
export interface IBastionPermissionSetProps {
    ssoInstanceArn: string;
    permissionSetName: string;
    sessionDuration?: string;
    securityTag?: Tag;
}
export declare class BastionPermissionSet extends Construct {
    private policy;
    private permissionSet;
    private ssoInstanceArn;
    securityTag: Tag;
    constructor(scope: Construct, id: string, props: IBastionPermissionSetProps);
    assign(accountId: string, principalId: string, principalType: string): void;
}
