"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BastionPermissionSet = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const access_policy_1 = require("./access-policy");
const constants_1 = require("./constants");
class BastionPermissionSet extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.securityTag = props.securityTag
            ? props.securityTag
            : constants_1.Constants.securityTag;
        this.ssoInstanceArn = props.ssoInstanceArn;
        const accessPolicy = new access_policy_1.BastionAccessPolicy(this, 'BastionAccessPolicy', {
            securityTag: this.securityTag,
        });
        this.policy = accessPolicy.policy;
        this.permissionSet = new aws_cdk_lib_1.aws_sso.CfnPermissionSet(this, 'BastionAccessPermissionSet', {
            instanceArn: props.ssoInstanceArn,
            inlinePolicy: this.policy,
            name: props.permissionSetName
                ? props.permissionSetName
                : 'BastionAccess',
            sessionDuration: props.sessionDuration ? props.sessionDuration : 'PT8H',
            relayStateType: 'https://console.aws.amazon.com/systems-manager/managed-instances/rdp-connect',
        });
    }
    assign(accountId, principalId, principalType) {
        new aws_cdk_lib_1.aws_sso.CfnAssignment(this, `Account${accountId}${principalType}${principalId}`, {
            permissionSetArn: this.permissionSet
                .getAtt('PermissionSetArn')
                .toString(),
            principalType,
            principalId,
            instanceArn: this.ssoInstanceArn,
            targetType: 'AWS_ACCOUNT',
            targetId: accountId,
        });
    }
}
exports.BastionPermissionSet = BastionPermissionSet;
_a = JSII_RTTI_SYMBOL_1;
BastionPermissionSet[_a] = { fqn: "pwed-cdk.pwed_bastion.BastionPermissionSet", version: "0.0.33" };
//# sourceMappingURL=data:application/json;base64,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