"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WindowsBastion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cdk_ec2_key_pair_1 = require("cdk-ec2-key-pair");
const constructs_1 = require("constructs");
const constants_1 = require("./constants");
class WindowsBastion extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const securityTag = (props === null || props === void 0 ? void 0 : props.securityTag) ? props.securityTag
            : constants_1.Constants.securityTag;
        const key = (props === null || props === void 0 ? void 0 : props.createKeyPair) ? new cdk_ec2_key_pair_1.KeyPair(this, 'KeyPair', {
            name: `${aws_cdk_lib_1.Aws.STACK_NAME}-${id}-windows-bastion-key`,
            storePublicKey: false,
        })
            : undefined;
        if (key)
            aws_cdk_lib_1.Tags.of(key).add(securityTag.key, securityTag.value);
        this.securityGroup = new aws_cdk_lib_1.aws_ec2.SecurityGroup(this, 'BastionSecurityGroup', {
            vpc: props.vpc,
            allowAllOutbound: true,
        });
        const bastionInstance = new aws_cdk_lib_1.aws_ec2.Instance(this, 'BastionInstance', {
            instanceType: aws_cdk_lib_1.aws_ec2.InstanceType.of(aws_cdk_lib_1.aws_ec2.InstanceClass.C5A, aws_cdk_lib_1.aws_ec2.InstanceSize.XLARGE),
            machineImage: aws_cdk_lib_1.aws_ec2.MachineImage.latestWindows(aws_cdk_lib_1.aws_ec2.WindowsVersion.WINDOWS_SERVER_2022_ENGLISH_FULL_BASE),
            vpc: props.vpc,
            vpcSubnets: props.vpcSubnets,
            blockDevices: [
                {
                    deviceName: '/dev/sda1',
                    volume: aws_cdk_lib_1.aws_ec2.BlockDeviceVolume.ebs(40, {
                        volumeType: aws_cdk_lib_1.aws_ec2.EbsDeviceVolumeType.GP3,
                        encrypted: true,
                    }),
                },
            ],
            propagateTagsToVolumeOnCreation: true,
            keyName: key === null || key === void 0 ? void 0 : key.keyPairName,
            securityGroup: this.securityGroup,
            userDataCausesReplacement: true,
        });
        const windowsPackages = props.windowsPackages ? props.windowsPackages : [];
        const userData = [
            'for($i=1; $i -le 10; $i++) {',
            '  reg query HKLMSOFTWAREMicrosoftWindowsCurrentVersionInstallerInProgress',
            '  if ($LASTEXITCODE -ne 0 ) {',
            '    Write-Output "No installer is running, continuing"',
            '    break',
            '  }',
            '  Write-Output "Another installer is running, waiting ($i / 10)"',
            '  Start-Sleep -Seconds 15',
            '}',
            // Unfortunately Windows Server 2022 doesn't support WinGet yet ...
            // https://github.com/microsoft/winget-cli/issues/1929
            'iwr -UseBasicParsing https://github.com/jedieaston/winget-build/raw/main/Install.ps1 | iex',
            ...windowsPackages.map((p) => {
                return `wingetdev install --silent --accept-source-agreements --accept-package-agreements ${p}`;
            }),
            'wingetdev upgrade --all --silent --accept-source-agreements --accept-package-agreements',
        ].join('\n');
        bastionInstance.addUserData(userData);
        aws_cdk_lib_1.Tags.of(bastionInstance.instance).add(securityTag.key, securityTag.value);
        bastionInstance.role.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
    }
}
exports.WindowsBastion = WindowsBastion;
_a = JSII_RTTI_SYMBOL_1;
WindowsBastion[_a] = { fqn: "pwed-cdk.pwed_bastion.WindowsBastion", version: "0.0.33" };
//# sourceMappingURL=data:application/json;base64,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