"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StaticSite = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const child_process = require("child_process");
const crypto = require("crypto");
const fs = require("fs");
const path = require("path");
const process = require("process");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const glob_1 = require("glob");
class StaticSite extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const bucket = new aws_cdk_lib_1.aws_s3.Bucket(this, 'Bucket', {
            encryption: aws_cdk_lib_1.aws_s3.BucketEncryption.S3_MANAGED,
            lifecycleRules: [
                {
                    transitions: [
                        {
                            storageClass: aws_cdk_lib_1.aws_s3.StorageClass.INTELLIGENT_TIERING,
                            transitionAfter: aws_cdk_lib_1.Duration.days(7),
                        },
                    ],
                },
            ],
        });
        const hostedZone = props.hostedZone
            ? props.hostedZone
            : aws_cdk_lib_1.aws_route53.HostedZone.fromLookup(this, 'HostedZone', {
                domainName: props.domain,
            });
        const certificate = new aws_cdk_lib_1.aws_certificatemanager.Certificate(this, 'Certificate', {
            domainName: props.domain,
            validation: aws_cdk_lib_1.aws_certificatemanager.CertificateValidation.fromDns(hostedZone),
        });
        const originAccessIdentity = new aws_cdk_lib_1.aws_cloudfront.OriginAccessIdentity(this, 'OriginAccessIdentity');
        bucket.grantRead(originAccessIdentity);
        const distribution = new aws_cdk_lib_1.aws_cloudfront.Distribution(this, 'Distribution', {
            defaultBehavior: {
                origin: new aws_cdk_lib_1.aws_cloudfront_origins.S3Origin(bucket, {
                    originAccessIdentity,
                }),
                allowedMethods: aws_cdk_lib_1.aws_cloudfront.AllowedMethods.ALLOW_GET_HEAD_OPTIONS,
                viewerProtocolPolicy: aws_cdk_lib_1.aws_cloudfront.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
            },
            domainNames: [props.domain],
            certificate,
            errorResponses: [
                {
                    httpStatus: 404,
                    responseHttpStatus: 404,
                    responsePagePath: '/404.html',
                },
            ],
            defaultRootObject: 'index.html',
        });
        new aws_cdk_lib_1.aws_route53.ARecord(this, 'AAliasRecord', {
            recordName: props.domain,
            zone: hostedZone,
            target: aws_cdk_lib_1.aws_route53.RecordTarget.fromAlias(new aws_cdk_lib_1.aws_route53_targets.CloudFrontTarget(distribution)),
        });
        new aws_cdk_lib_1.aws_route53.AaaaRecord(this, 'AaaaAliasRecord', {
            recordName: props.domain,
            zone: hostedZone,
            target: aws_cdk_lib_1.aws_route53.RecordTarget.fromAlias(new aws_cdk_lib_1.aws_route53_targets.CloudFrontTarget(distribution)),
        });
        const hashFile = '/.hashfile';
        let invalidations = [hashFile];
        invalidations.push(...compareRemoteToLocal(props.domain, hashFile, props.path));
        console.log('Invalidations:\n', invalidations);
        new aws_cdk_lib_1.aws_s3_deployment.BucketDeployment(this, 'StaticDeployment', {
            sources: [aws_cdk_lib_1.aws_s3_deployment.Source.asset(props.path)],
            destinationBucket: bucket,
            distribution: distribution,
            distributionPaths: invalidations,
        });
    }
}
exports.StaticSite = StaticSite;
_a = JSII_RTTI_SYMBOL_1;
StaticSite[_a] = { fqn: "pwed-cdk.pwed_static_site.StaticSite", version: "0.0.33" };
function getHashes(globPattern, dir) {
    let fh = new Map();
    const gs = glob_1.sync(globPattern, { cwd: dir, nodir: true });
    const pwd = process.cwd();
    process.chdir(dir);
    gs.forEach(function (file) {
        const fileBuffer = fs.readFileSync(file, {});
        const hashSum = crypto.createHash('sha256');
        hashSum.update(fileBuffer);
        const hex = hashSum.digest('hex');
        fh.set(file, hex);
    });
    process.chdir(pwd);
    return fh;
}
function getInvalidations(oldHashes, newHashes) {
    let invalidations = [];
    oldHashes.forEach(function (v, k) {
        if (newHashes.get(k) !== v) {
            invalidations.push(`/${k}`);
        }
    });
    return invalidations;
}
function compareRemoteToLocal(domain, hashFile, localFolder) {
    let oldHashesJSON;
    const newHashes = getHashes('**', localFolder);
    fs.writeFileSync(path.join(localFolder, hashFile), JSON.stringify(Object.fromEntries(newHashes)));
    try {
        oldHashesJSON = child_process
            .execSync(`curl https://${domain}/${hashFile}`)
            .toString();
    }
    catch (e) {
        console.log('error getting file from web', e);
        return ['/*'];
    }
    let oldHashes;
    try {
        oldHashes = new Map(Object.entries(JSON.parse(oldHashesJSON)));
    }
    catch (e) {
        return ['/*'];
    }
    return getInvalidations(oldHashes, newHashes);
}
//# sourceMappingURL=data:application/json;base64,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