import datetime

from src.mb_cruise_migration.db.cruise_connection import CruiseConnection
from src.mb_cruise_migration.logging.migration_log import MigrationLog
from src.mb_cruise_migration.logging.migration_report import MigrationReport
from src.mb_cruise_migration.migration_properties import MigrationProperties


class Cleaner(object):
    def __init__(self, config_file):
        MigrationProperties(config_file)
        MigrationLog()
        MigrationReport()
        self.cruise = CruiseConnection()

    def delete_multibeam_data_from_cruise(self):
        MigrationReport.start = datetime.datetime.now()

        self.__delete_file_shapes()
        self.__delete_file_access_paths()
        self.__delete_file_parameters()
        self.__delete_files()
        self.__delete_dataset_shapes()
        self.__delete_dataset_surveys()
        self.__delete_dataset_projects()
        self.__delete_dataset_sources()
        self.__delete_dataset_scientists()
        self.__delete_dataset_platforms()
        self.__delete_dataset_instruments()
        self.__delete_dataset_parameters()
        self.__delete_datasets()
        self.__delete_unreferenced_shapes()
        self.__delete_unreferenced_access_paths()

        MigrationReport.end = datetime.datetime.now()
        MigrationReport.clean_final_report()

    def __delete_file_shapes(self):
        MigrationLog.logger.info("START -- DELETING FILE SHAPES")
        command = "DELETE FROM CRUISE.FILE_SHAPES WHERE FILE_ID IN (SELECT FILE_ID FROM CRUISE.FILES all_files WHERE all_files.DATASET_ID IN (SELECT DATASET_ID FROM CRUISE.DATASETS WHERE DATASET_TYPE_ID IN (SELECT TYPE_ID FROM CRUISE.DATASET_TYPES WHERE TYPE_NAME = 'MB RAW' OR TYPE_NAME = 'MB PROCESSED' OR TYPE_NAME = 'MB PRODUCT' OR TYPE_NAME = 'MB RAW NONPUBLIC' OR TYPE_NAME = 'MB PROCESSED NONPUBLIC' OR TYPE_NAME = 'MB PRODUCT NONPUBLIC' OR TYPE_NAME = 'ANCILLARY' OR TYPE_NAME = 'DOCUMENT' OR TYPE_NAME = 'METADATA' OR TYPE_NAME = 'ANCILLARY NONPUBLIC' OR TYPE_NAME = 'DOCUMENT NONPUBLIC' OR TYPE_NAME = 'METADATA NONPUBLIC')))"
        self.cruise.execute(command)
        MigrationLog.logger.info("END -- DELETING FILE SHAPES")

    def __delete_file_access_paths(self):
        MigrationLog.logger.info("START -- DELETING FILE ACCESS PATHS")
        command = "DELETE FROM CRUISE.FILE_ACCESS_PATHS WHERE FILE_ID IN (SELECT FILE_ID FROM CRUISE.FILES all_files WHERE all_files.DATASET_ID IN (SELECT DATASET_ID FROM CRUISE.DATASETS WHERE DATASET_TYPE_ID IN (SELECT TYPE_ID FROM CRUISE.DATASET_TYPES WHERE TYPE_NAME = 'MB RAW' OR TYPE_NAME = 'MB PROCESSED' OR TYPE_NAME = 'MB PRODUCT' OR TYPE_NAME = 'MB RAW NONPUBLIC' OR TYPE_NAME = 'MB PROCESSED NONPUBLIC' OR TYPE_NAME = 'MB PRODUCT NONPUBLIC' OR TYPE_NAME = 'ANCILLARY' OR TYPE_NAME = 'DOCUMENT' OR TYPE_NAME = 'METADATA' OR TYPE_NAME = 'ANCILLARY NONPUBLIC' OR TYPE_NAME = 'DOCUMENT NONPUBLIC' OR TYPE_NAME = 'METADATA NONPUBLIC')))"
        self.cruise.execute(command)
        MigrationLog.logger.info("END -- DELETING FILE ACCESS PATHS")

    def __delete_file_parameters(self):
        MigrationLog.logger.info("START -- DELETING FILE PARAMETERS")
        count_query = "SELECT COUNT(*) FROM CRUISE.FILE_PARAMETERS WHERE FILE_ID IN (SELECT FILE_ID FROM CRUISE.FILES all_files WHERE all_files.DATASET_ID IN (SELECT DATASET_ID FROM CRUISE.DATASETS WHERE DATASET_TYPE_ID IN (SELECT TYPE_ID FROM CRUISE.DATASET_TYPES WHERE TYPE_NAME = 'MB RAW' OR TYPE_NAME = 'MB PROCESSED' OR TYPE_NAME = 'MB PRODUCT' OR TYPE_NAME = 'MB RAW NONPUBLIC' OR TYPE_NAME = 'MB PROCESSED NONPUBLIC' OR TYPE_NAME = 'MB PRODUCT NONPUBLIC' OR TYPE_NAME = 'ANCILLARY' OR TYPE_NAME = 'DOCUMENT' OR TYPE_NAME = 'METADATA' OR TYPE_NAME = 'ANCILLARY NONPUBLIC' OR TYPE_NAME = 'DOCUMENT NONPUBLIC' OR TYPE_NAME = 'METADATA NONPUBLIC')))"
        fp_count = list(self.cruise.query(count_query))[0]
        while fp_count > 0:
            MigrationLog.logger.info("...deleting block")
            delete_command = "DELETE FROM CRUISE.FILE_PARAMETERS WHERE FILE_PARAMETER_ID IN (SELECT FILE_PARAMETER_ID FROM CRUISE.FILE_PARAMETERS WHERE FILE_ID IN (SELECT FILE_ID FROM CRUISE.FILES all_files WHERE all_files.DATASET_ID IN (SELECT DATASET_ID FROM CRUISE.DATASETS WHERE DATASET_TYPE_ID IN (SELECT TYPE_ID FROM CRUISE.DATASET_TYPES WHERE TYPE_NAME = 'MB RAW' OR TYPE_NAME = 'MB PROCESSED' OR TYPE_NAME = 'MB PRODUCT' OR TYPE_NAME = 'MB RAW NONPUBLIC' OR TYPE_NAME = 'MB PROCESSED NONPUBLIC' OR TYPE_NAME = 'MB PRODUCT NONPUBLIC' OR TYPE_NAME = 'ANCILLARY' OR TYPE_NAME = 'DOCUMENT' OR TYPE_NAME = 'METADATA' OR TYPE_NAME = 'ANCILLARY NONPUBLIC' OR TYPE_NAME = 'DOCUMENT NONPUBLIC' OR TYPE_NAME = 'METADATA NONPUBLIC'))) FETCH FIRST 1000000 ROWS ONLY)"
            self.cruise.execute(delete_command)
            fp_count = list(self.cruise.query(count_query))[0]
        MigrationLog.logger.info("END -- DELETING FILE PARAMETERS")

    def __delete_files(self):
        MigrationLog.logger.info("START -- DELETING FILES")
        command = "DELETE FROM CRUISE.FILES all_files WHERE all_files.DATASET_ID IN (SELECT DATASET_ID FROM CRUISE.DATASETS WHERE DATASET_TYPE_ID IN (SELECT TYPE_ID FROM CRUISE.DATASET_TYPES WHERE TYPE_NAME = 'MB RAW' OR TYPE_NAME = 'MB PROCESSED' OR TYPE_NAME = 'MB PRODUCT' OR TYPE_NAME = 'MB RAW NONPUBLIC' OR TYPE_NAME = 'MB PROCESSED NONPUBLIC' OR TYPE_NAME = 'MB PRODUCT NONPUBLIC' OR TYPE_NAME = 'ANCILLARY' OR TYPE_NAME = 'DOCUMENT' OR TYPE_NAME = 'METADATA' OR TYPE_NAME = 'ANCILLARY NONPUBLIC' OR TYPE_NAME = 'DOCUMENT NONPUBLIC' OR TYPE_NAME = 'METADATA NONPUBLIC'))"
        self.cruise.execute(command)
        MigrationLog.logger.info("END -- DELETING FILES")

    def __delete_dataset_shapes(self):
        MigrationLog.logger.info("START -- DELETING DATASET SHAPES")
        command = "DELETE FROM CRUISE.DATASET_SHAPES WHERE DATASET_ID IN (SELECT DATASET_ID FROM CRUISE.DATASETS WHERE DATASET_TYPE_ID IN (SELECT TYPE_ID FROM CRUISE.DATASET_TYPES WHERE TYPE_NAME = 'MB RAW' OR TYPE_NAME = 'MB PROCESSED' OR TYPE_NAME = 'MB PRODUCT' OR TYPE_NAME = 'MB RAW NONPUBLIC' OR TYPE_NAME = 'MB PROCESSED NONPUBLIC' OR TYPE_NAME = 'MB PRODUCT NONPUBLIC' OR TYPE_NAME = 'ANCILLARY' OR TYPE_NAME = 'DOCUMENT' OR TYPE_NAME = 'METADATA' OR TYPE_NAME = 'ANCILLARY NONPUBLIC' OR TYPE_NAME = 'DOCUMENT NONPUBLIC' OR TYPE_NAME = 'METADATA NONPUBLIC'))"
        self.cruise.execute(command)
        MigrationLog.logger.info("END -- DELETING DATASET SHAPES")

    def __delete_dataset_surveys(self):
        MigrationLog.logger.info("START -- DELETING DATASET SURVEYS")
        command = "DELETE FROM CRUISE.DATASET_SURVEYS WHERE DATASET_ID IN (SELECT DATASET_ID FROM CRUISE.DATASETS WHERE DATASET_TYPE_ID IN (SELECT TYPE_ID FROM CRUISE.DATASET_TYPES WHERE TYPE_NAME = 'MB RAW' OR TYPE_NAME = 'MB PROCESSED' OR TYPE_NAME = 'MB PRODUCT' OR TYPE_NAME = 'MB RAW NONPUBLIC' OR TYPE_NAME = 'MB PROCESSED NONPUBLIC' OR TYPE_NAME = 'MB PRODUCT NONPUBLIC' OR TYPE_NAME = 'ANCILLARY' OR TYPE_NAME = 'DOCUMENT' OR TYPE_NAME = 'METADATA' OR TYPE_NAME = 'ANCILLARY NONPUBLIC' OR TYPE_NAME = 'DOCUMENT NONPUBLIC' OR TYPE_NAME = 'METADATA NONPUBLIC'))"
        self.cruise.execute(command)
        MigrationLog.logger.info("END -- DELETING DATASET SURVEYS")

    def __delete_dataset_projects(self):
        MigrationLog.logger.info("START -- DELETING DATASET PROJECTS")
        command = "DELETE FROM CRUISE.DATASET_PROJECTS WHERE DATASET_ID IN (SELECT DATASET_ID FROM CRUISE.DATASETS WHERE DATASET_TYPE_ID IN (SELECT TYPE_ID FROM CRUISE.DATASET_TYPES WHERE TYPE_NAME = 'MB RAW' OR TYPE_NAME = 'MB PROCESSED' OR TYPE_NAME = 'MB PRODUCT' OR TYPE_NAME = 'MB RAW NONPUBLIC' OR TYPE_NAME = 'MB PROCESSED NONPUBLIC' OR TYPE_NAME = 'MB PRODUCT NONPUBLIC' OR TYPE_NAME = 'ANCILLARY' OR TYPE_NAME = 'DOCUMENT' OR TYPE_NAME = 'METADATA' OR TYPE_NAME = 'ANCILLARY NONPUBLIC' OR TYPE_NAME = 'DOCUMENT NONPUBLIC' OR TYPE_NAME = 'METADATA NONPUBLIC'))"
        self.cruise.execute(command)
        MigrationLog.logger.info("END -- DELETING DATASET PROJECTS")

    def __delete_dataset_sources(self):
        MigrationLog.logger.info("START -- DELETING DATASET SOURCES")
        command = "DELETE FROM CRUISE.SOURCES WHERE DATASET_ID IN (SELECT DATASET_ID FROM CRUISE.DATASETS WHERE DATASET_TYPE_ID IN (SELECT TYPE_ID FROM CRUISE.DATASET_TYPES WHERE TYPE_NAME = 'MB RAW' OR TYPE_NAME = 'MB PROCESSED' OR TYPE_NAME = 'MB PRODUCT' OR TYPE_NAME = 'MB RAW NONPUBLIC' OR TYPE_NAME = 'MB PROCESSED NONPUBLIC' OR TYPE_NAME = 'MB PRODUCT NONPUBLIC' OR TYPE_NAME = 'ANCILLARY' OR TYPE_NAME = 'DOCUMENT' OR TYPE_NAME = 'METADATA' OR TYPE_NAME = 'ANCILLARY NONPUBLIC' OR TYPE_NAME = 'DOCUMENT NONPUBLIC' OR TYPE_NAME = 'METADATA NONPUBLIC'))"
        self.cruise.execute(command)
        MigrationLog.logger.info("END -- DELETING DATASET SOURCES")

    def __delete_dataset_scientists(self):
        MigrationLog.logger.info("START -- DELETING DATASET SCIENTISTS")
        command = "DELETE FROM CRUISE.SCIENTISTS WHERE DATASET_ID IN (SELECT DATASET_ID FROM CRUISE.DATASETS WHERE DATASET_TYPE_ID IN (SELECT TYPE_ID FROM CRUISE.DATASET_TYPES WHERE TYPE_NAME = 'MB RAW' OR TYPE_NAME = 'MB PROCESSED' OR TYPE_NAME = 'MB PRODUCT' OR TYPE_NAME = 'MB RAW NONPUBLIC' OR TYPE_NAME = 'MB PROCESSED NONPUBLIC' OR TYPE_NAME = 'MB PRODUCT NONPUBLIC' OR TYPE_NAME = 'ANCILLARY' OR TYPE_NAME = 'DOCUMENT' OR TYPE_NAME = 'METADATA' OR TYPE_NAME = 'ANCILLARY NONPUBLIC' OR TYPE_NAME = 'DOCUMENT NONPUBLIC' OR TYPE_NAME = 'METADATA NONPUBLIC'))"
        self.cruise.execute(command)
        MigrationLog.logger.info("END -- DELETING DATASET SCIENTISTS")

    def __delete_dataset_platforms(self):
        MigrationLog.logger.info("START -- DELETING DATASET PLATFORMS")
        command = "DELETE FROM CRUISE.DATASET_PLATFORMS WHERE DATASET_ID IN (SELECT DATASET_ID FROM CRUISE.DATASETS WHERE DATASET_TYPE_ID IN (SELECT TYPE_ID FROM CRUISE.DATASET_TYPES WHERE TYPE_NAME = 'MB RAW' OR TYPE_NAME = 'MB PROCESSED' OR TYPE_NAME = 'MB PRODUCT' OR TYPE_NAME = 'MB RAW NONPUBLIC' OR TYPE_NAME = 'MB PROCESSED NONPUBLIC' OR TYPE_NAME = 'MB PRODUCT NONPUBLIC' OR TYPE_NAME = 'ANCILLARY' OR TYPE_NAME = 'DOCUMENT' OR TYPE_NAME = 'METADATA' OR TYPE_NAME = 'ANCILLARY NONPUBLIC' OR TYPE_NAME = 'DOCUMENT NONPUBLIC' OR TYPE_NAME = 'METADATA NONPUBLIC'))"
        self.cruise.execute(command)
        MigrationLog.logger.info("END -- DELETING DATASET PLATFORMS")

    def __delete_dataset_instruments(self):
        MigrationLog.logger.info("START -- DELETING DATASET INSTRUMENTS")
        command = "DELETE FROM CRUISE.DATASET_INSTRUMENTS WHERE DATASET_ID IN (SELECT DATASET_ID FROM CRUISE.DATASETS WHERE DATASET_TYPE_ID IN (SELECT TYPE_ID FROM CRUISE.DATASET_TYPES WHERE TYPE_NAME = 'MB RAW' OR TYPE_NAME = 'MB PROCESSED' OR TYPE_NAME = 'MB PRODUCT' OR TYPE_NAME = 'MB RAW NONPUBLIC' OR TYPE_NAME = 'MB PROCESSED NONPUBLIC' OR TYPE_NAME = 'MB PRODUCT NONPUBLIC' OR TYPE_NAME = 'ANCILLARY' OR TYPE_NAME = 'DOCUMENT' OR TYPE_NAME = 'METADATA' OR TYPE_NAME = 'ANCILLARY NONPUBLIC' OR TYPE_NAME = 'DOCUMENT NONPUBLIC' OR TYPE_NAME = 'METADATA NONPUBLIC'))"
        self.cruise.execute(command)
        MigrationLog.logger.info("END -- DELETING DATASET INSTRUMENTS")

    def __delete_dataset_parameters(self):
        MigrationLog.logger.info("START -- DELETING DATASET PARAMETERS")
        command = "DELETE FROM CRUISE.DATASET_PARAMETERS WHERE DATASET_ID IN (SELECT DATASET_ID FROM CRUISE.DATASETS WHERE DATASET_TYPE_ID IN (SELECT TYPE_ID FROM CRUISE.DATASET_TYPES WHERE TYPE_NAME = 'MB RAW' OR TYPE_NAME = 'MB PROCESSED' OR TYPE_NAME = 'MB PRODUCT' OR TYPE_NAME = 'MB RAW NONPUBLIC' OR TYPE_NAME = 'MB PROCESSED NONPUBLIC' OR TYPE_NAME = 'MB PRODUCT NONPUBLIC' OR TYPE_NAME = 'ANCILLARY' OR TYPE_NAME = 'DOCUMENT' OR TYPE_NAME = 'METADATA' OR TYPE_NAME = 'ANCILLARY NONPUBLIC' OR TYPE_NAME = 'DOCUMENT NONPUBLIC' OR TYPE_NAME = 'METADATA NONPUBLIC'))"
        self.cruise.execute(command)
        MigrationLog.logger.info("END -- DELETING DATASET PARAMETERS")

    def __delete_datasets(self):
        MigrationLog.logger.info("START -- DELETING DATASETS")
        command = "DELETE FROM CRUISE.DATASETS WHERE DATASET_TYPE_ID IN (SELECT TYPE_ID FROM CRUISE.DATASET_TYPES WHERE TYPE_NAME = 'MB RAW' OR TYPE_NAME = 'MB PROCESSED' OR TYPE_NAME = 'MB PRODUCT' OR TYPE_NAME = 'MB RAW NONPUBLIC' OR TYPE_NAME = 'MB PROCESSED NONPUBLIC' OR TYPE_NAME = 'MB PRODUCT NONPUBLIC' OR TYPE_NAME = 'ANCILLARY' OR TYPE_NAME = 'DOCUMENT' OR TYPE_NAME = 'METADATA' OR TYPE_NAME = 'ANCILLARY NONPUBLIC' OR TYPE_NAME = 'DOCUMENT NONPUBLIC' OR TYPE_NAME = 'METADATA NONPUBLIC')"
        self.cruise.execute(command)
        MigrationLog.logger.info("END -- DELETING DATASETS")

    def __delete_unreferenced_shapes(self):
        MigrationLog.logger.info("START -- DELETING UNREFERENCED SHAPES")
        command = "DELETE FROM (SELECT * FROM CRUISE.SHAPES WHERE SHAPE_ID NOT IN (SELECT DISTINCT SHAPE_ID FROM CRUISE.FILE_SHAPES) AND SHAPE_ID NOT IN (SELECT DISTINCT SHAPE_ID FROM CRUISE.DATASET_SHAPES) AND SHAPE_ID NOT IN (SELECT DISTINCT SHAPE_ID FROM CRUISE.SURVEY_SHAPES))"
        self.cruise.execute(command)
        MigrationLog.logger.info("END -- DELETING UNREFERENCED SHAPES")

    def __delete_unreferenced_access_paths(self):
        MigrationLog.logger.info("START -- DELETING UNREFERENCED ACCESS PATHS")
        command = "DELETE FROM (SELECT * FROM CRUISE.ACCESS_PATHS WHERE PATH_ID NOT IN (SELECT DISTINCT PATH_ID FROM CRUISE.FILE_ACCESS_PATHS))"
        self.cruise.execute(command)
        MigrationLog.logger.info("END -- DELETING UNREFERENCED ACCESS PATHS")
