-- noinspection SqlNoDataSourceInspectionForFile

------------------------------------------------
-- SEQUENCES
------------------------------------------------

CREATE SEQUENCE MB.MBINFO_FILE_TSQL_OBJID_SEQ INCREMENT BY 1 MAXVALUE 999999999999999999999999999 MINVALUE 1 NOCACHE
/

CREATE SEQUENCE MB.OBJECTID_SEQ INCREMENT BY 1 MAXVALUE 999999999999999999999999999 MINVALUE 1 NOCACHE
/

CREATE SEQUENCE MB.SURVEY_SEQ INCREMENT BY 1 MAXVALUE 999999999999999999999999999 MINVALUE 1 NOCACHE
/

------------------------------------------------
-- TABLES
------------------------------------------------

------------------------- MB.CONTACT -----------------------
-- CREATE TABLE MB.CONTACT
-- (
--     ORGANIZATION VARCHAR2(50 BYTE) NOT NULL
--     , PERSON VARCHAR2(50 BYTE)
--     , ADDRESS_TYPE VARCHAR2(20 BYTE)
--     , ADDRESS VARCHAR2(80 BYTE)
--     , ADDRESS_CITY VARCHAR2(30 BYTE)
--     , ADDRESS_STATE VARCHAR2(30 BYTE)
--     , ADDRESS_POSTAL_CODE VARCHAR2(20 BYTE)
--     , ADDRESS_COUNTRY VARCHAR2(80 BYTE)
--     , PHONE VARCHAR2(20 BYTE)
--     , FAX VARCHAR2(20 BYTE)
--     , EMAIL VARCHAR2(30 BYTE)
--     , HOURS_OF_SERVICE VARCHAR2(30 BYTE)
--     , CONTACT_INSTRUCTIONS VARCHAR2(200 BYTE)
--     , URL VARCHAR2(200 BYTE)
--     , ID NUMBER NOT NULL
--     , PUBLISH VARCHAR2(3 BYTE)
--     , PREVIOUS_STATE VARCHAR2(3 BYTE)
-- )
--     LOGGING
--     PCTFREE 10
--     INITRANS 1
--     STORAGE
-- (
--     INITIAL 81920
--     NEXT 1048576
--     MINEXTENTS 1
--     MAXEXTENTS UNLIMITED
--     BUFFER_POOL DEFAULT
-- )
--
-- /
--
-- CREATE UNIQUE INDEX MB.SYS_C0024776 ON MB.CONTACT (ORGANIZATION ASC, PERSON ASC)
--     NOLOGGING
--     PCTFREE 10
--     INITRANS 2
--     STORAGE
--     (
--     INITIAL 49152
--     NEXT 1048576
--     MINEXTENTS 1
--     MAXEXTENTS UNLIMITED
--     BUFFER_POOL DEFAULT
--     )
--
-- /
--
-- CREATE UNIQUE INDEX MB.SYS_C0024778 ON MB.CONTACT (ID ASC)
--     NOLOGGING
--     PCTFREE 10
--     INITRANS 2
--     STORAGE
--     (
--     INITIAL 65536
--     NEXT 1048576
--     MINEXTENTS 1
--     MAXEXTENTS UNLIMITED
--     BUFFER_POOL DEFAULT
--     )
--
-- /
--
-- ALTER TABLE MB.CONTACT
--     ADD CONSTRAINT SYS_C0024776 UNIQUE
--         (
--          ORGANIZATION
--             , PERSON
--             )
--         USING INDEX MB.SYS_C0024776
--         ENABLE
--
-- /
--
-- ALTER TABLE MB.CONTACT
--     ADD CONSTRAINT SYS_C0024778 PRIMARY KEY
--         (
--          ID
--             )
--         USING INDEX MB.SYS_C0024778
--         ENABLE
--
-- /
--
-- ALTER TABLE MB.CONTACT
--     ADD CONSTRAINT CONTACT_CK_1 CHECK
--         (upper(address_type) in ('PHYSICAL', 'MAILING','PHYSICAL AND MAILING'))
--         ENABLE
--
-- /

------------------------- MB.MBINFO_FILE_TSQL -----------------------
CREATE TABLE MB.MBINFO_FILE_TSQL
(
    DATA_FILE VARCHAR2(256 BYTE) NOT NULL
    , NGDC_ID VARCHAR2(8 BYTE) NOT NULL
    , MBIO_FORMAT_ID NUMBER(6, 0) NOT NULL
    , RECORD_COUNT NUMBER(8, 0) NOT NULL
    , BATHY_BEAMS NUMBER(10, 0) NOT NULL
    , BB_GOOD NUMBER(10, 0) NOT NULL
    , BB_ZERO NUMBER(10, 0) NOT NULL
    , BB_FLAGGED NUMBER(10, 0) NOT NULL
    , AMP_BEAMS NUMBER(10, 0) NOT NULL
    , AB_GOOD NUMBER(10, 0) NOT NULL
    , AB_ZERO NUMBER(10, 0) NOT NULL
    , AB_FLAGGED NUMBER(10, 0) NOT NULL
    , SIDESCANS NUMBER(10, 0) NOT NULL
    , SS_GOOD NUMBER(10, 0) NOT NULL
    , SS_ZERO NUMBER(10, 0) NOT NULL
    , SS_FLAGGED NUMBER(10, 0) NOT NULL
    , TOTAL_TIME NUMBER(9, 4) NOT NULL
    , TRACK_LENGTH NUMBER(10, 4) NOT NULL
    , AVG_SPEED NUMBER(9, 4) NOT NULL
    , START_TIME DATE NOT NULL
    , START_LON NUMBER(13, 9) NOT NULL
    , START_LAT NUMBER(12, 9) NOT NULL
    , START_DEPTH NUMBER(9, 4) NOT NULL
    , START_SPEED NUMBER(7, 4) NOT NULL
    , START_HEADING NUMBER(7, 4) NOT NULL
    , START_SONAR_DEPTH NUMBER(9, 4)
    , START_SONAR_ALT NUMBER(9, 4)
    , END_TIME DATE NOT NULL
    , END_LON NUMBER(13, 9) NOT NULL
    , END_LAT NUMBER(12, 9) NOT NULL
    , END_DEPTH NUMBER(9, 4) NOT NULL
    , END_SPEED NUMBER(7, 4) NOT NULL
    , END_HEADING NUMBER(7, 4) NOT NULL
    , END_SONAR_DEPTH NUMBER(9, 4)
    , END_SONAR_ALT NUMBER(9, 4)
    , MIN_LON NUMBER(13, 9) NOT NULL
    , MAX_LON NUMBER(13, 9) NOT NULL
    , MIN_LAT NUMBER(12, 9) NOT NULL
    , MAX_LAT NUMBER(12, 9) NOT NULL
    , MIN_SONAR_DEPTH NUMBER(9, 4)
    , MAX_SONAR_DEPTH NUMBER(9, 4)
    , MIN_SONAR_ALT NUMBER(9, 4)
    , MAX_SONAR_ALT NUMBER(9, 4)
    , MIN_DEPTH NUMBER(9, 4)
    , MAX_DEPTH NUMBER(9, 4)
    , MIN_AMP NUMBER(8, 4)
    , MAX_AMP NUMBER(10, 4)
    , MIN_SIDESCAN NUMBER(12, 4)
    , MAX_SIDESCAN NUMBER(15, 4)
    , OBJECTID NUMBER(38, 0) NOT NULL
    , SHAPE MDSYS.SDO_GEOMETRY
    , PUBLISH VARCHAR2(3 BYTE)
    , PREVIOUS_STATE VARCHAR2(3 BYTE)
    , SHAPE_GEN MDSYS.SDO_GEOMETRY
)
    LOGGING
    PCTFREE 10
    INITRANS 1
    STORAGE
(
    INITIAL 58982400
    NEXT 1048576
    MINEXTENTS 1
    MAXEXTENTS UNLIMITED
    BUFFER_POOL DEFAULT
)

/

CREATE INDEX MB.MBINFO_FILE_NGDC_ID_IDX ON MB.MBINFO_FILE_TSQL (NGDC_ID ASC)
    NOLOGGING
    PCTFREE 10
    INITRANS 2
    STORAGE
    (
    INITIAL 65536
    NEXT 1048576
    MINEXTENTS 1
    MAXEXTENTS UNLIMITED
    BUFFER_POOL DEFAULT
    )

/

INSERT INTO USER_SDO_GEOM_METADATA (TABLE_NAME, COLUMN_NAME, DIMINFO, SRID)
VALUES (
        'MBINFO_FILE_TSQL',
        'SHAPE_GEN',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('Longitude', -180, 180, 0.05),
            MDSYS.SDO_DIM_ELEMENT('Latitude', -90, 90, 0.05)
            ),
        8307)
/

CREATE INDEX MB.MBINFO_FILE_TSQL_SHAPE_GEN_SPX ON MB.MBINFO_FILE_TSQL (SHAPE_GEN) INDEXTYPE IS MDSYS.SPATIAL_INDEX

/

INSERT INTO USER_SDO_GEOM_METADATA (TABLE_NAME, COLUMN_NAME, DIMINFO, SRID)
VALUES (
        'MBINFO_FILE_TSQL',
        'SHAPE',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('Longitude', -180, 180, 0.05),
            MDSYS.SDO_DIM_ELEMENT('Latitude', -90, 90, 0.05)
            ),
        8307)

/

CREATE INDEX MB.MBINFO_FILE_TSQL_SPX ON MB.MBINFO_FILE_TSQL (SHAPE) INDEXTYPE IS MDSYS.SPATIAL_INDEX

/

CREATE UNIQUE INDEX MB.SYS_C0024788 ON MB.MBINFO_FILE_TSQL (DATA_FILE ASC, NGDC_ID ASC)
    NOLOGGING
    PCTFREE 10
    INITRANS 2
    STORAGE
    (
    INITIAL 65536
    NEXT 1048576
    MINEXTENTS 1
    MAXEXTENTS UNLIMITED
    BUFFER_POOL DEFAULT
    )

/

CREATE UNIQUE INDEX MB.SYS_C0024789 ON MB.MBINFO_FILE_TSQL (OBJECTID ASC)
    NOLOGGING
    PCTFREE 10
    INITRANS 2
    STORAGE
    (
    INITIAL 65536
    NEXT 1048576
    MINEXTENTS 1
    MAXEXTENTS UNLIMITED
    BUFFER_POOL DEFAULT
    )

/

ALTER TABLE MB.MBINFO_FILE_TSQL
    ADD CONSTRAINT SYS_C0024788 PRIMARY KEY
        (
         DATA_FILE
            , NGDC_ID
            )
        USING INDEX MB.SYS_C0024788
        ENABLE

/

ALTER TABLE MB.MBINFO_FILE_TSQL
    ADD CONSTRAINT SYS_C0024789 UNIQUE
        (
         OBJECTID
            )
        USING INDEX MB.SYS_C0024789
        ENABLE

/

------------------------- MB.MBINFO_FORMATS -----------------------
CREATE TABLE MB.MBINFO_FORMATS
(
    ID NUMBER(6, 0) NOT NULL
    , FORMAT_NAME VARCHAR2(20 BYTE) NOT NULL
    , INFORMAL_DESC VARCHAR2(80 BYTE)
    , ATTRIBUTES VARCHAR2(2000 BYTE)
    , PUBLISH VARCHAR2(3 BYTE)
    , PREVIOUS_STATE VARCHAR2(3 BYTE)
    , FORMAT_TYPE VARCHAR2(30 BYTE)
    , PROTOCOL VARCHAR2(20 BYTE)
)
    LOGGING
    PCTFREE 10
    INITRANS 1
    STORAGE
(
    INITIAL 1048576
    NEXT 1048576
    MINEXTENTS 1
    MAXEXTENTS UNLIMITED
    BUFFER_POOL DEFAULT
)

/

CREATE UNIQUE INDEX MB.MBINFO_FORMATS_PK ON MB.MBINFO_FORMATS (ID ASC)
    NOLOGGING
    PCTFREE 10
    INITRANS 2
    STORAGE
    (
    INITIAL 65536
    NEXT 1048576
    MINEXTENTS 1
    MAXEXTENTS UNLIMITED
    BUFFER_POOL DEFAULT
    )

/

ALTER TABLE MB.MBINFO_FORMATS
    ADD CONSTRAINT MBINFO_FORMATS_PK PRIMARY KEY
        (
         ID
            )
        USING INDEX MB.MBINFO_FORMATS_PK
        ENABLE

/

------------------------- MB.MBINFO_SURVEY_3857_TSQL -----------------------
-- CREATE TABLE MB.MBINFO_SURVEY_3857_TSQL
-- (
--     NGDC_ID VARCHAR2(8 BYTE) NOT NULL
--     , OBJECTID NUMBER(38, 0) NOT NULL
--     , SHAPE MDSYS.SDO_GEOMETRY
--     , SHAPE_GEN MDSYS.SDO_GEOMETRY
--     , PUBLISH VARCHAR2(3 BYTE)
--     , PREVIOUS_STATE VARCHAR2(3 BYTE)
-- )
--     LOGGING
--     PCTFREE 10
--     INITRANS 1
--     STORAGE
-- (
--     INITIAL 1048576
--     NEXT 1048576
--     MINEXTENTS 1
--     MAXEXTENTS UNLIMITED
--     BUFFER_POOL DEFAULT
-- )
--
-- /
--
-- INSERT INTO USER_SDO_GEOM_METADATA (TABLE_NAME, COLUMN_NAME, DIMINFO, SRID)
-- VALUES (
--         'MBINFO_SURVEY_3857_TSQL',
--         'SHAPE_GEN',
--         MDSYS.SDO_DIM_ARRAY(
--             MDSYS.SDO_DIM_ELEMENT('Longitude', -180, 180, 0.05),
--             MDSYS.SDO_DIM_ELEMENT('Latitude', -90, 90, 0.05)
--             ),
--         8307)
--
-- /
--
-- CREATE INDEX MB.MBINFO_SRVY_3857_SPATIAL_IDX ON MB.MBINFO_SURVEY_3857_TSQL (SHAPE_GEN) INDEXTYPE IS MDSYS.SPATIAL_INDEX
--
-- /

------------------------- MB.MBINFO_SURVEY_TSQL -----------------------
CREATE TABLE MB.MBINFO_SURVEY_TSQL
(
    NGDC_ID VARCHAR2(8 BYTE) NOT NULL
    , OBJECTID NUMBER(38, 0) NOT NULL
    , SHAPE MDSYS.SDO_GEOMETRY
    , SHAPE_GEN MDSYS.SDO_GEOMETRY
    , PUBLISH VARCHAR2(3 BYTE)
    , PREVIOUS_STATE VARCHAR2(3 BYTE)
)
    LOGGING
    PCTFREE 10
    INITRANS 1
    STORAGE
(
    INITIAL 1605632
    NEXT 1048576
    MINEXTENTS 1
    MAXEXTENTS UNLIMITED
    BUFFER_POOL DEFAULT
)

/

INSERT INTO USER_SDO_GEOM_METADATA (TABLE_NAME, COLUMN_NAME, DIMINFO, SRID)
VALUES (
        'MBINFO_SURVEY_TSQL',
        'SHAPE_GEN',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('Longitude', -180, 180, 0.05),
            MDSYS.SDO_DIM_ELEMENT('Latitude', -90, 90, 0.05)
            ),
        8307)

/

CREATE INDEX MB.MBINFO_SURVEY_GEN_TSQL_SPX ON MB.MBINFO_SURVEY_TSQL (SHAPE_GEN) INDEXTYPE IS MDSYS.SPATIAL_INDEX

/

CREATE UNIQUE INDEX MB.MBINFO_SURVEY_TSQL_NGDCID_IDX ON MB.MBINFO_SURVEY_TSQL (NGDC_ID ASC)
    NOLOGGING
    PCTFREE 10
    INITRANS 2
    STORAGE
    (
    INITIAL 65536
    NEXT 1048576
    MINEXTENTS 1
    MAXEXTENTS UNLIMITED
    BUFFER_POOL DEFAULT
    )

/

CREATE UNIQUE INDEX MB.MBINFO_SURVEY_TSQL_OBJID_IDX ON MB.MBINFO_SURVEY_TSQL (OBJECTID ASC)
    NOLOGGING
    PCTFREE 10
    INITRANS 2
    STORAGE
    (
    INITIAL 65536
    NEXT 1048576
    MINEXTENTS 1
    MAXEXTENTS UNLIMITED
    BUFFER_POOL DEFAULT
    )

/

INSERT INTO USER_SDO_GEOM_METADATA (TABLE_NAME, COLUMN_NAME, DIMINFO, SRID)
VALUES (
        'MBINFO_SURVEY_TSQL',
        'SHAPE',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('Longitude', -180, 180, 0.05),
            MDSYS.SDO_DIM_ELEMENT('Latitude', -90, 90, 0.05)
            ),
        8307)

/

CREATE INDEX MB.MBINFO_SURVEY_TSQL_SPX ON MB.MBINFO_SURVEY_TSQL (SHAPE) INDEXTYPE IS MDSYS.SPATIAL_INDEX

/

------------------------- MB.NGDCID_AND_FILE -----------------------
CREATE TABLE MB.NGDCID_AND_FILE
(
    NGDC_ID VARCHAR2(8 BYTE) NOT NULL
    , DATA_FILE VARCHAR2(256 BYTE) NOT NULL
    , FORMAT_ID NUMBER(6, 0) NOT NULL
    , ENTRY_DATE DATE
    , PROCESS_DATE DATE
    , STATUS VARCHAR2(4000 BYTE)
    , VERSION NUMBER(11, 0)
    , MOSTCURRENT NUMBER(1, 0) DEFAULT 1 NOT NULL
    , VERSION_ID NUMBER(11, 0)
    , PROCESS_NOTES VARCHAR2(2000 BYTE)
    , FILESIZE NUMBER
    , FILESIZE_GZIP NUMBER
    , FILENOTFOUND VARCHAR2(3 BYTE)
    , PUBLISH VARCHAR2(3 BYTE)
    , PREVIOUS_STATE VARCHAR2(3 BYTE)
    , ARCHIVE_PATH VARCHAR2(255 BYTE)
)
    LOGGING
    PCTFREE 10
    INITRANS 1
    STORAGE
(
    INITIAL 39370752
    NEXT 1048576
    MINEXTENTS 1
    MAXEXTENTS UNLIMITED
    BUFFER_POOL DEFAULT
)

/

CREATE INDEX MB.NGDCID_AND_FILE_ARCH_PATH_IDX ON MB.NGDCID_AND_FILE (ARCHIVE_PATH ASC)
    NOLOGGING
    PCTFREE 10
    INITRANS 2
    STORAGE
    (
    INITIAL 1048576
    NEXT 1048576
    MINEXTENTS 1
    MAXEXTENTS UNLIMITED
    BUFFER_POOL DEFAULT
    )

/

CREATE INDEX MB.NGDCID_DF_FORMAT_ID_IDX ON MB.NGDCID_AND_FILE (DATA_FILE ASC, FORMAT_ID ASC)
    NOLOGGING
    PCTFREE 10
    INITRANS 2
    STORAGE
    (
    INITIAL 1048576
    NEXT 1048576
    MINEXTENTS 1
    MAXEXTENTS UNLIMITED
    BUFFER_POOL DEFAULT
    )

/

CREATE INDEX MB.NGDCID_LOWERDF_IDX ON MB.NGDCID_AND_FILE (LOWER("DATA_FILE") ASC)
    NOLOGGING
    PCTFREE 10
    INITRANS 2
    STORAGE
    (
    INITIAL 1048576
    NEXT 1048576
    MINEXTENTS 1
    MAXEXTENTS UNLIMITED
    BUFFER_POOL DEFAULT
    )

/

CREATE UNIQUE INDEX MB.NGDCID_FILE_NGDCID_DF_VER_IDX ON MB.NGDCID_AND_FILE (NGDC_ID ASC, DATA_FILE ASC, VERSION ASC)
    NOLOGGING
    PCTFREE 10
    INITRANS 2
    STORAGE
    (
    INITIAL 65536
    NEXT 1048576
    MINEXTENTS 1
    MAXEXTENTS UNLIMITED
    BUFFER_POOL DEFAULT
    )

/

ALTER TABLE MB.NGDCID_AND_FILE
    ADD CONSTRAINT NGDCID_AND_FILE_PK PRIMARY KEY
        (
         NGDC_ID
            , DATA_FILE
            , VERSION
            )
        USING INDEX MB.NGDCID_FILE_NGDCID_DF_VER_IDX
        ENABLE

/

------------------------- MB.SURVEY -----------------------
CREATE TABLE MB.SURVEY
(
    NGDC_ID VARCHAR2(8 BYTE) NOT NULL
    , CHIEF_SCIENTIST VARCHAR2(200 BYTE)
    , DEPARTURE_PORT VARCHAR2(100 BYTE)
    , ARRIVAL_PORT VARCHAR2(100 BYTE)
    , START_TIME DATE
    , END_TIME DATE
    , SURVEY_NAME VARCHAR2(100 BYTE)
    , SHIP_NAME VARCHAR2(100 BYTE)
    , SOURCE VARCHAR2(200 BYTE) NOT NULL
    , NAV1 VARCHAR2(100 BYTE)
    , NAV2 VARCHAR2(100 BYTE)
    , INSTRUMENT VARCHAR2(100 BYTE)
    , HORIZONTAL_DATUM VARCHAR2(35 BYTE)
    , VERTICAL_DATUM VARCHAR2(25 BYTE)
    , TIDE_CORRECTION VARCHAR2(7 BYTE)
    , SOUND_VELOCITY VARCHAR2(7 BYTE)
    , SHIP_OWNER VARCHAR2(50 BYTE)
    , PROJECT_NAME VARCHAR2(250 BYTE)
    , CONTACT_ID NUMBER
    , CHIEF_SCI_ORGANIZATION VARCHAR2(200 BYTE)
    , PUBLISH VARCHAR2(12 BYTE) DEFAULT 'no'
    , COMMENTS VARCHAR2(2000 BYTE)
    , PROPRIETARY VARCHAR2(3 BYTE)
    , ENTERED_DATE DATE
    , PREVIOUS_STATE VARCHAR2(3 BYTE)
    , FILE_COUNT NUMBER
    , TRACK_LENGTH NUMBER
    , TOTAL_TIME NUMBER
    , BATHY_BEAMS NUMBER
    , AMP_BEAMS NUMBER
    , SIDESCANS NUMBER
    , SURVEY_SIZE NUMBER(10, 0)
    , MODIFY_DATE_DATA DATE
    , MODIFY_DATE_METADATA DATE
    , EXTRACT_METADATA VARCHAR2(3 BYTE) DEFAULT 'yes'
)
    LOGGING
    PCTFREE 10
    INITRANS 1
    STORAGE
(
    INITIAL 163840
    NEXT 1048576
    MINEXTENTS 1
    MAXEXTENTS UNLIMITED
    BUFFER_POOL DEFAULT
)

/

CREATE INDEX MB.SURVEY_IDX$$_2F6A0009 ON MB.SURVEY (SHIP_NAME ASC, SUBSTR(TO_CHAR("START_TIME",'YYYY'),1,3) ASC)
    NOLOGGING
    PCTFREE 10
    INITRANS 2
    STORAGE
    (
    INITIAL 1048576
    NEXT 1048576
    MINEXTENTS 1
    MAXEXTENTS UNLIMITED
    BUFFER_POOL DEFAULT
    )

/

CREATE UNIQUE INDEX MB.SURVEY_PK ON MB.SURVEY (NGDC_ID ASC)
    NOLOGGING
    PCTFREE 10
    INITRANS 2
    STORAGE
    (
    INITIAL 65536
    NEXT 1048576
    MINEXTENTS 1
    MAXEXTENTS UNLIMITED
    BUFFER_POOL DEFAULT
    )

/

CREATE INDEX MB.SURVEY_SURVEY_NAME_IDX ON MB.SURVEY (SURVEY_NAME ASC)
    NOLOGGING
    PCTFREE 10
    INITRANS 2
    STORAGE
    (
    INITIAL 1048576
    NEXT 1048576
    MINEXTENTS 1
    MAXEXTENTS UNLIMITED
    BUFFER_POOL DEFAULT
    )

/

ALTER TABLE MB.SURVEY
    ADD CONSTRAINT SURVEY_PK PRIMARY KEY
        (
         NGDC_ID
            )
        USING INDEX MB.SURVEY_PK
        ENABLE

/

ALTER TABLE MB.SURVEY
    ADD CONSTRAINT SURVEY_CK_1 CHECK
        (upper(tide_correction) in ('YES','NO','UNKNOWN'))
        ENABLE

/

ALTER TABLE MB.SURVEY
    ADD CONSTRAINT SURVEY_CK_2 CHECK
        (upper (sound_velocity) in ('YES','NO','UNKNOWN'))
        ENABLE

/

------------------------- MB.SURVEY_DATA_TYPE_CODES -----------------------
-- CREATE TABLE MB.SURVEY_DATA_TYPE_CODES
-- (
--     ID NUMBER(*, 0) NOT NULL
--     , DATA_TYPE VARCHAR2(40 BYTE)
--     , PUBLISH VARCHAR2(3 BYTE)
--     , PREVIOUS_STATE VARCHAR2(3 BYTE)
--     , CONSTRAINT SURVEY_DATA_TYPE_CODES_PK PRIMARY KEY
--     (
--      ID
--         )
--     DISABLE
-- )
--     LOGGING
--     PCTFREE 10
--     INITRANS 1
--     STORAGE
-- (
--     INITIAL 81920
--     NEXT 1048576
--     MINEXTENTS 1
--     MAXEXTENTS UNLIMITED
--     BUFFER_POOL DEFAULT
-- )
--
-- /
--
------------------------- MB.SURVEY_AND_DATA_TYPE -----------------------
-- CREATE TABLE MB.SURVEY_AND_DATA_TYPE
-- (
--     NGDC_ID VARCHAR2(8 BYTE) NOT NULL
--     , DATA_TYPE_ID NUMBER(*, 0) NOT NULL
--     , PUBLISH VARCHAR2(3 BYTE)
--     , PREVIOUS_STATE VARCHAR2(3 BYTE)
-- )
--     LOGGING
--     PCTFREE 10
--     INITRANS 1
--     STORAGE
-- (
--     INITIAL 81920
--     NEXT 1048576
--     MINEXTENTS 1
--     MAXEXTENTS UNLIMITED
--     BUFFER_POOL DEFAULT
-- )
--
-- /
--
-- CREATE UNIQUE INDEX MB.SYS_C0024787 ON MB.SURVEY_AND_DATA_TYPE (NGDC_ID ASC, DATA_TYPE_ID ASC)
--     NOLOGGING
--     PCTFREE 10
--     INITRANS 2
--     STORAGE
--     (
--     INITIAL 81920
--     NEXT 1048576
--     MINEXTENTS 1
--     MAXEXTENTS UNLIMITED
--     BUFFER_POOL DEFAULT
--     )
--
-- /
--
-- ALTER TABLE MB.SURVEY_AND_DATA_TYPE
--     ADD CONSTRAINT SYS_C0024802 FOREIGN KEY
--         (
--          DATA_TYPE_ID
--             )
--         REFERENCES MB.SURVEY_DATA_TYPE_CODES
--             (
--              ID
--                 )
--             DISABLE
--
-- /
--
-- ALTER TABLE MB.SURVEY_AND_DATA_TYPE
--     ADD CONSTRAINT SYS_C0024787 PRIMARY KEY
--         (
--          NGDC_ID
--             , DATA_TYPE_ID
--             )
--         USING INDEX MB.SYS_C0024787
--         ENABLE
--
-- /

------------------------- MB.SURVEY_REFERENCE -----------------------
CREATE TABLE MB.SURVEY_REFERENCE
(
    NGDC_ID VARCHAR2(8 BYTE) NOT NULL
    , DOI VARCHAR2(50 BYTE)
    , ABSTRACT VARCHAR2(4000 BYTE)
    , PURPOSE VARCHAR2(4000 BYTE)
    , PROJECT_URL VARCHAR2(4000 BYTE)
    , CREATE_DATE DATE
    , CREATED_BY VARCHAR2(50 BYTE)
    , LAST_UPDATE_DATE DATE
    , LAST_UPDATED_BY VARCHAR2(50 BYTE)
    , DOWNLOAD_URL VARCHAR2(4000 BYTE)
)
    LOGGING
    PCTFREE 10
    INITRANS 1
    STORAGE
(
    INITIAL 1048576
    NEXT 1048576
    MINEXTENTS 1
    MAXEXTENTS UNLIMITED
    BUFFER_POOL DEFAULT
)
    NOCOMPRESS
    NO INMEMORY
    NOPARALLEL

/

CREATE UNIQUE INDEX MB.SURVEY_REFERENCE_PK ON MB.SURVEY_REFERENCE (NGDC_ID ASC)
    NOLOGGING
    PCTFREE 10
    INITRANS 2
    STORAGE
    (
    INITIAL 65536
    NEXT 1048576
    MINEXTENTS 1
    MAXEXTENTS UNLIMITED
    BUFFER_POOL DEFAULT
    )
    NOPARALLEL

/

ALTER TABLE MB.SURVEY_REFERENCE
    ADD CONSTRAINT SURVEY_REFERENCE_PK PRIMARY KEY
        (
         NGDC_ID
            )
        USING INDEX MB.SURVEY_REFERENCE_PK

/


-- ALTER PLUGGABLE DATABASE PDB1 open;
ALTER PLUGGABLE DATABASE ALL OPEN;
ALTER PLUGGABLE DATABASE ALL SAVE STATE;



REM INSERTING into MBINFO_FORMATS
SELECT * FROM MB.MBINFO_FORMATS;
SET DEFINE OFF;
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (4000,'ANC_SVP','Sound Speed Profiles (SSP or SVP)','ASCII sound speed measurements applied to multibeam soundings','yes',null,'Supporting','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (3002,'METADATA_INF','Informal metadata text','ASCII','yes',null,'Metadata','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (2007,'IMAGE_BMP','Bitmap image product','Bitmap image product','yes',null,'Images','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (4005,'ANC_SUPPORT','Supporting data','Additional ancillary support data','yes',null,'Supporting','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (2008,'IVS_SD','Fledermaus surface','Fledermaus gridded surface','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (2010,'GRID_BAG','Bathymetric Attributed Grid','Open Navigation Surface Bathymetric Attributed Grid file','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (3001,'DATAFILE_XML','XML metadata file','XML format metadata','yes',null,'Metadata','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (1000,'NETCDF','netCDF grid file','binary','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (4006,'ANC_NAV','Navigation data','Navigation data from ship''s positioning equipment','yes',null,'Supporting','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (2009,'ESRI_ASC','ESRI Arc ASCII ','ESRI Arc ASCII ','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (2011,'PDF','PDF product','PDF products, reports, images','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (11,'MBF_SBSIOMRG','SIO merge Sea Beam','Sea Beam, bathymetry, 16 beams, binary, uncentered, SIO','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (12,'MBF_SBSIOCEN','SIO centered Sea Beam','Sea Beam, bathymetry, 19 beams, binary, centered, SIO','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (13,'MBF_SBSIOLSI','SIO LSI Sea Beam','Sea Beam, bathymetry, 19 beams, binary, centered, obsolete, SIO','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (14,'MBF_SBURICEN','URI Sea Beam','Sea Beam, bathymetry, 19 beams, binary, centered, URI','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (15,'MBF_SBURIVAX','URI Sea Beam from VAX','Sea Beam, bathymetry, 19 beams, binary, centered, VAX byte order, URI','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (16,'MBF_SBSIOSWB','SIO Swath-bathy SeaBeam','Sea Beam, bathymetry, 19 beams, binary, centered, SIO','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (17,'MBF_SBIFREMR','IFREMER Archive SeaBeam','Sea Beam, bathymetry, 19 beams, ascii, centered, IFREMER','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (21,'MBF_HSATLRAW','Raw Hydrosweep','Hydrosweep DS, bathymetry and amplitude, 59 beams, ascii, Atlas Electronik','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (22,'MBF_HSLDEDMB','EDMB Hydrosweep','Hydrosweep DS, bathymetry, 59 beams, binary, NRL','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (23,'MBF_HSURICEN','URI Hydrosweep','Hydrosweep DS, 59 beams, bathymetry, binary, URI','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (24,'MBF_HSLDEOIH','L-DEO in-house binary Hydrosweep','Hydrosweep DS, 59 beams, bathymetry and amplitude, binary, centered, L-DEO','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (25,'MBF_HSURIVAX','URI Hydrosweep from VAX','Hydrosweep DS, 59 beams, bathymetry, binary, VAX byte order, URI','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (32,'MBF_SB2000SB','SIO Swath-bathy SeaBeam 2000 format','SeaBeam 2000, bathymetry, 121 beams, binary, SIO','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (33,'MBF_SB2000SS','SIO Swath-bathy SeaBeam 2000 format','SeaBeam 2000, sidescan, 1000 pixels for 4-bit sidescan, 2000 pixels for 12+-bit sidescan, binary, SIO','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (41,'MBF_SB2100RW','SeaBeam 2100 series vender format','SeaBeam 2100, bathymetry, amplitude and sidescan, 151 beams and 2000 pixels, ascii with binary sidescan, SeaBeam Instruments','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (42,'MBF_SB2100B1','SeaBeam 2100 series vender format','SeaBeam 2100, bathymetry, amplitude and sidescan, 151 beams bathymetry, 2000 pixels sidescan, binary, SeaBeam Instruments and L-DEO','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (43,'MBF_SB2100B2','SeaBeam 2100 series vender format','SeaBeam 2100, bathymetry and amplitude, 151 beams bathymetry, binary, SeaBeam Instruments and L-DEO','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (51,'MBF_EMOLDRAW','Old Simrad vendor multibeam format','Simrad EM1000, EM12S, EM12D, and EM121 multibeam sonars, bathymetry, amplitude, and sidescan, 60 beams for EM1000, 81 beams for EM12S/D, 121 beams for EM121, variable pixels, ascii + binary, Simrad','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (53,'MBF_EM12IFRM','IFREMER TRISMUS format for Simrad EM12','Simrad EM12S and EM12D, bathymetry, amplitude, and sidescan 81 beams, variable pixels, binary, IFREMER','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (54,'MBF_EM12DARW','Simrad EM12S RRS Darwin processed format','Simrad EM12S, bathymetry and amplitude, 81 beams, binary, Oxford University','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (56,'MBF_EM300RAW','Simrad multibeam vendor format','Simrad EM120, EM300, EM1002, EM3000, bathymetry, amplitude, and sidescan, up to 254 beams, variable pixels, ascii + binary, Simrad','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (57,'MBF_EM300MBA','Simrad multibeam processing format','Old and new Simrad multibeams, EM12S, EM12D, EM121, EM120, EM300, EM100, EM1000, EM950, EM1002, EM3000, bathymetry, amplitude, and sidescan, up to 254 beams, variable pixels, ascii + binary, MBARI','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (61,'MBF_MR1PRHIG','SOEST MR1 post processed format','SOEST MR1, bathymetry and sidescan, variable beams and pixels, xdr binary, SOEST, University of Hawaii','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (62,'MBF_MR1ALDEO','L-DEO MR1 post processed format with travel times','L-DEO MR1, bathymetry and sidescan, variable beams and pixels, xdr binary, L-DEO','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (63,'MBF_MR1BLDEO','L-DEO small MR1 post processed format with travel times','L-DEO MR1, bathymetry and sidescan, variable beams and pixels, xdr binary, L-DEO','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (71,'MBF_MBLDEOIH','L-DEO in-house generic multibeam','Data from all sonar systems, bathymetry, amplitude and sidescan, variable beams and pixels, binary, centered, L-DEO','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (81,'MBF_CBAT9001','Reson SeaBat 9001 shallow water multibeam','60 beam bathymetry and amplitude, binary, University of New Brunswick','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (82,'MBF_CBAT8101','Reson SeaBat 8101 shallow water multibeam','101 beam bathymetry and amplitude, binary, SeaBeam Instruments','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (83,'MBF_HYPC8101','Reson SeaBat 8101 shallow water multibeam','101 beam bathymetry, ASCII, read-only, Coastal Oceanographics','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (84,'MBF_XTFR8101','XTF format Reson SeaBat 81XX','240 beam bathymetry and amplitude, 1024 pixel sidescan binary, read-only, Triton-Elics','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (91,'MBF_BCHRTUNB','Elac BottomChart shallow water multibeam','56 beam bathymetry and amplitude, binary, University of New Brunswick','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (92,'MBF_ELMK2UNB','Elac BottomChart MkII shallow water multibeam','126 beam bathymetry and amplitude, binary, University of New Brunswick','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (93,'MBF_BCHRXUNB','Elac BottomChart shallow water multibeam','56 beam bathymetry and amplitude, binary, University of New Brunswick','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (94,'MBF_L3XSERAW','ELAC/SeaBeam XSE vendor format','Bottomchart MkII 50 kHz and 180 kHz multibeam, SeaBeam 2120 20 KHz multibeam, bathymetry, amplitude and sidescan, variable beams and pixels, binary, L3 Communications (Elac Nautik and SeaBeam Instruments)','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (101,'MBF_HSMDARAW','Atlas HSMD medium depth multibeam raw format','40 beam bathymetry, 160 pixel sidescan, XDR (binary), STN Atlas Elektronik','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (102,'MBF_HSMDLDIH','Atlas HSMD medium depth multibeam processed format','40 beam bathymetry, 160 pixel sidescan, XDR (binary), L-DEO','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (111,'MBF_DSL120SF','WHOI DSL AMS-120 processed format','2048 beam bathymetry, 8192 pixel sidescan, binary, single files, WHOI DSL','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (112,'MBF_DSL120PF','WHOI DSL AMS-120 processed format','2048 beam bathymetry, 8192 pixel sidescan, binary, parallel bathymetry and amplitude files, WHOI DSL','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (121,'MBF_GSFGENMB','SAIC Generic Sensor Format (GSF)','variable beams, bathymetry and amplitude, binary, single files, SAIC','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (131,'MBF_MSTIFFSS','MSTIFF sidescan format','variable pixels, sidescan, binary TIFF variant, single files, Sea Scan','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (141,'MBF_OICGEODA','OIC swath sonar format','variable beam bathymetry and amplitude, variable pixel sidescan, binary, Oceanic Imaging Consultants','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (142,'MBF_OICMBARI','OIC-style extended swath sonar format','variable beam bathymetry and amplitude, variable pixel sidescan, binary, MBARI','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (151,'MBF_OMGHDCSJ','UNB OMG HDCS format (the John Hughes Clarke format)','variable beam bathymetry and amplitude, variable pixel sidescan, binary, UNB','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (161,'MBF_MGD77DAT','NGDC MGD77 underway geophysics format','single beam bathymetry, nav, magnetics, gravity, ascii, NOAA NGDC','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (165,'MBF_MBARIROV','MBARI ROV navigation format','ROV navigation, MBARI','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (166,'MBF_MBPRONAV','MB-System simple navigation format','navigation, MBARI','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (171,'MBF_HS10JAMS','Furuno HS-10 multibeam format','45 beams bathymetry and amplitude, ascii, JAMSTEC','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (182,'MBF_HSDS2RAW','STN Atlas raw multibeam format','STN Atlas multibeam sonars, Hydrosweep DS2, Hydrosweep MD, Fansweep 10, Fansweep 20, bathymetry, amplitude, and sidescan, up to 1440 beams and 4096 pixels, XDR binary, STN Atlas','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (183,'MBF_HSDS2LAM','L-DEO HSDS2 processing format','STN Atlas multibeam sonars, Hydrosweep DS2, Hydrosweep MD, Fansweep 10, Fansweep 20, bathymetry, amplitude, and sidescan, up to 1440 beams and 4096 pixels, XDR binary, L-DEO','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (2000,'IMAGE_GEOTIFF','GeoTIFF survey image','Data over the entire survey area is represented in full color.','yes',null,'Images','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (2001,'IMAGE_TFW','TIFF survey world file','The world file geospatially registers the corresponding TIFF image.','yes',null,'Images','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (2002,'IMAGE_JPEG','JPEG survey image','Data over the entire survey area is represented in full color.','yes',null,'Images','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (3003,'SIO_MIF','Metadata I?? File for each individual data file','ASCII','yes',null,'Metadata','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (58,'MBF_EM710RAW','Kongsberg multibeam vendor format','Kongsberg EM122, EM302, EM710, bathymetry, amplitude, and sidescan, up to 400 beams, variable pixels, binary, Kongsberg','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (8,'MBF_HSLDEOIH','same as 24','see 24','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (1005,'XYZ_SOURCE','xyz grid file provided by the originator',null,'yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (2003,'IMAGE_JPW','JPEG world reference file',null,'yes',null,'Images','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (2004,'IMAGE_RRD','image pyramid file',null,'yes',null,'Images','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (2005,'IMAGE_AUX','image auxiliary file',null,'yes',null,'Images','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (1006,'YXZ_SOURCE','yxz file provided by the originator',null,'yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (3000,'NOSEEZ','NOS EEZ metadata file','ASCII','yes',null,'Metadata','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (2006,'IMAGE_PS','Postscript',null,'yes',null,'Images','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (997,'DMC','ASCII Format','ascii','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (1007,'ASCII_MOSAIC','ASCII backscatter data','ASCII backscatter data from multibeam sonars','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (1008,'ASCII_TEXT','ASCII text product','ASCII text product','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (996,'MBF_ASCIIXYZ','Generic XYZ sounding format','XYZ (lon lat depth) ASCII soundings, generic','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (999,'Unsupported','Not supported by MB-System',null,'yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (5,'MBF_HSATLRAW',null,null,'yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (3006,'META_FILE_LEVEL','File level metadata','Metadata files describing each multibeam data file','yes',null,'Metadata','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (64,'MBF_MR1PRVR2','SOEST MR1 post processed format','SOEST MR1, bathymetry and sidescan, variable beams and pixels, xdr binary, SOEST, University of Hawaii','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (3004,'META_PDF','PDF metadata file','Metadata files in PDF format, reports, summaries, cruise instructions','yes',null,'Metadata','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (4001,'ANC_XBT','Expendable Bathythermograph (XBT) data','Measurements collected with expendable bathythermograph probes','yes',null,'Supporting','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (4002,'ANC_CTD','Conductivity, Temperature, Depth (CTD) data','Files associated with Conductivity, Temperature, and Depth package data','yes',null,'Supporting','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (3005,'META_RTF','Metadata files in Rich Text Format','Metadata files in RTF format, documents, summaries','yes',null,'Metadata','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (5001,'WCD','Water column sonar data available','Water Column Sonar Data collected for cruise','yes',null,'Water column',null);
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (59,'MBF_EM710MBA','Kongsberg multibeam vendor format','Kongsberg EM122, EM302, EM710, bathymetry, amplitude, and sidescan, up to 400 beams, variable pixels, binary, Simrad','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (4004,'ANC_TIDE','Tidal data','Tidal data for application of tidal offsets to multibeam data','yes',null,'Supporting','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (3008,'MS Word 2000','Data report or metadata in Word document format','Data Report or Metadata in DOCX format','yes',null,'Metadata','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (2012,'GOOGLE_KMZ','Compressed Keyhole Markup Language file','Compressed Keyhole Markup Language file for display in Google Earth or other geospatial software','yes',null,'Geometry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (88,'MBF_RESON7KR','Reson S7K multibeam vendor format','Reson 7K series multibeam sonars, bathymetry, amplitude, three channels sidescan, and subbottom up to 254 beams, variable pixels, binary, Reson','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (4007,'do_not_process files','Data Not Processed','Data Not Processed','yes',null,'Supporting','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (4008,'BagIt info files','BagIt File (includes checksum manifest)','BagIt Information File','yes',null,'Supporting','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (3007,'MS Word','Data report or metadata in Word document format','Data Report or Metadata in DOC format','yes',null,'Metadata','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (168,'MBF_ASCIIXYT','Generic XYT sounding format','XYT (lon lat topography) ASCII soundings, generic','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (162,'MBF_ASCIIXYZ','Generic XYZ sounding format','XYZ (lon, lat, depth) ASCII soundings, generic','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (163,'MBF_ASCIIYXZ','Generic YXZ sounding format','YXZ (lat, lon, depth) ASCII soundings, generic','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (3027,'MS_XLS','Provider supplied metadata','Provider supplied metadata in Microsoft Excel 97/2000/XP/2003 format','yes',null,'Metadata','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (3028,'MS_XLSX','Provider supplied metadata','Provider supplied metadata in Microsoft Excel 2007/2010 format','yes',null,'Metadata','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (2020,'GZ_BAG','Compressed Bathymetric Attributed Grid file','Compressed BAG file','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (3017,'META_REPORT','Reports and Logs from cruise','Archive of cruise reports, logs, project instructions','yes',null,'Metadata','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (998,'MB_TAR','Tar archive of unsupported MB data','Tar archive of sonar data files in a format not supported by MB-System','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (1015,'GZ_XYZ_SOURCE','GZIP XYZ grid file provided by the originator','Compressed XYZ file','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (222,'.sxp','Processed Interferometric Sonar file .sxp ',null,'yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (901,'.sxr','raw interferometric sonar file',null,'yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (2022,'GOOGLE_KML','Keyhole Markup Language file','Keyhole Markup Language file for display in Google Earth or other geospatial software','yes',null,'Geometry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (4010,'ANC_SHP','Shapefile data','ESRI Shapefile format providing geospatial vector data for GIS software','yes',null,'Supporting','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (3010,'META_HTML','HTML metadata file','Metadata records in HTML or HTM format','yes',null,'Metadata','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (2039,'ESRI_ARCGRID','ESRI Arc/INFO grid','ESRI Arc grid files','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (2018,'GZ_SD','Compressed Fledermaus surface','Compressed Fledermaus surface','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (2019,'GZ_ASC','Compressed ESRI Arc ASCII','Compressed ESRI Arc ASCII','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (2099,'PRODUCT_XML','Product Specific Metadata','Product Specific Metadata','yes',null,'Metadata','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (962,'ASCII_XYB','Generic XYB backscatter format','XYB (lon, lat, backscatter) ASCII data, generic','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (5003,'Singlebeam','Singlebeam data available by request','Singlebeam Sonar Data collected for cruise','yes',null,'Water column',null);
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (5004,'Sidescan','Sidescan or Backscatter data available by request','Sidescan or Backscatter Sonar Data collected for cruise','yes',null,'Sidescan',null);
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (900,'MBF_CARIS','Caris project data files','Caris project files','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (3009,'INFO_TAR','Additional cruise information','Archive of additional cruise information, xml, txt, htm, reports, summaries','yes',null,'Metadata','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (990,'7K','Reson snippet data','Reson snippet (footprint amplitude time series) data in Hypack acquired .7K file format','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (2032,'PROD_TRKLNE','Trackline files','Trackline data represented in a geospatial format','yes',null,'Geometry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (164,'MBF_HYDROB93','NGDC binary hydrographic sounding format','XYZ (lon lat depth) binary soundings','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (2031,'IVS_SCENE','Fledermaus Scene file','Fledermaus Scene File','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (2058,'ADD_PROD','Additional Products','Bundle of additional products not associated with usual product formats','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (902,'.pds','native PDS2000','native format for PDS2000','yes',null,null,null);
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (4012,'Ancillary_Data','Ancillary Data Files','Ancillary data for Cruise','yes',null,'Supporting','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (4011,'BISTs','BISTs data files','BISTs data files','yes',null,'Supporting','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (3011,'XML','NCEI created ISO metadata','ISO standard XML metadata generated during data ingest','yes',null,'Metadata','HTTP');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (1018,'gzip text product','GZIP Text Product','text product','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (2013,'IMAGE_TIFF_TFW','Compressed TIFF and TFW','TIFF image and support files','yes',null,'Images','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (201,'MBF_HYSWEEP1','HYSWEEP multibeam data format','Many multibeam sonars, bathymetry, amplitude variable beams, ascii, HYPACK','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (4009,'PLATFORM_CONFIG','Platform Configuration files','Platform Configuration Files','yes',null,'Supporting','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (909,'XTF','XTF formatted bathymetry','Bathymetry files acquired in XTF format (through programs such as Triton ISIS or QPS QINSy). Not supported by MB-System.','yes',null,'Bathymetry','ARCHIVE');
Insert into MBINFO_FORMATS (ID,FORMAT_NAME,INFORMAL_DESC,ATTRIBUTES,PUBLISH,PREVIOUS_STATE,FORMAT_TYPE,PROTOCOL) values (991,'s7k','Backscatter Support Data','Backscatter Support Data','yes',null,'Bathymetry','ARCHIVE');
