import { Resource } from '@aws-cdk/core';
import { AuthorizationType } from './method';
/**
 * Base class for all custom authorizers
 */
export declare abstract class Authorizer extends Resource implements IAuthorizer {
    abstract readonly authorizerId: string;
    readonly authorizationType?: AuthorizationType;
}
/**
 * Represents an API Gateway authorizer.
 */
export interface IAuthorizer {
    /**
     * The authorizer ID.
     * @attribute
     */
    readonly authorizerId: string;
    /**
     * The authorization type of this authorizer.
     */
    readonly authorizationType?: AuthorizationType;
}
