# Generated by Django 3.2.8 on 2021-12-21 17:50

import django.core.validators
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("eveuniverse", "0005_type_materials_and_sections"),
        ("auth", "0012_alter_user_first_name_max_length"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("eveonline", "0015_factions"),
        ("authentication", "0019_merge_20211026_0919"),
    ]

    operations = [
        migrations.CreateModel(
            name="General",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "permissions": (
                    ("basic_access", "Can access this app and see own statics."),
                    (
                        "manage_programs",
                        "Can manage own buyback programs and see own program statics.",
                    ),
                    ("see_all_statics", "Can see all program statics."),
                ),
                "managed": False,
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="Contract",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("assignee_id", models.IntegerField()),
                ("availability", models.CharField(max_length=20)),
                ("contract_id", models.IntegerField()),
                ("date_completed", models.DateTimeField(null=True)),
                ("date_expired", models.DateTimeField(null=True)),
                ("date_issued", models.DateTimeField()),
                ("for_corporation", models.BooleanField()),
                ("issuer_corporation_id", models.IntegerField()),
                ("issuer_id", models.IntegerField()),
                ("price", models.BigIntegerField()),
                ("status", models.CharField(max_length=30)),
                ("title", models.CharField(max_length=128)),
                ("volume", models.BigIntegerField()),
            ],
        ),
        migrations.CreateModel(
            name="Location",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Structure name where the contracts are accepted at",
                        max_length=32,
                    ),
                ),
                (
                    "eve_solar_system",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        help_text="System where the buyback structure is located",
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="+",
                        to="eveuniverse.evesolarsystem",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Owner",
            fields=[
                (
                    "corporation",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        related_name="+",
                        serialize=False,
                        to="eveonline.evecorporationinfo",
                    ),
                ),
                (
                    "character",
                    models.ForeignKey(
                        help_text="Character used for retrieving info",
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="authentication.characterownership",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        help_text="User that manages the program",
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="Program",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "is_corporation",
                    models.BooleanField(
                        default=False,
                        help_text="Tick if contracts should be made to corporation instead of player.",
                    ),
                ),
                (
                    "tax",
                    models.IntegerField(
                        default=0,
                        help_text="Default tax is applied on all items unless an item spesific tax is assigned",
                        validators=[
                            django.core.validators.MaxValueValidator(100),
                            django.core.validators.MinValueValidator(0),
                        ],
                    ),
                ),
                (
                    "hauling_fuel_cost",
                    models.IntegerField(
                        default=0,
                        help_text="ISK per m³ that will be removed from the buy price ie. to cover jump freighet fuel costs. <b>Should not be used with price dencity modifier</b>",
                    ),
                ),
                (
                    "price_dencity_modifier",
                    models.BooleanField(
                        default=False,
                        help_text="Should we modify buy prices for items with high volume and low value ie. T1 industrial hulls. <b>Should not be used with hauling fuel cost</b>",
                    ),
                ),
                (
                    "price_dencity_treshold",
                    models.IntegerField(
                        default=0,
                        help_text="At what ISK/m3 do we start to apply the low isk dencity tax. Tritanium is 500 ISK/m³ @ 5 ISK per unit price. PLEX is 14,5Trillion ISK/m³ @2.9M per unit price.",
                        null=True,
                    ),
                ),
                (
                    "price_dencity_tax",
                    models.IntegerField(
                        default=0,
                        help_text="How much tax do we apply on the low isk dencity items.",
                        null=True,
                        validators=[
                            django.core.validators.MaxValueValidator(100),
                            django.core.validators.MinValueValidator(0),
                        ],
                    ),
                ),
                (
                    "allow_all_items",
                    models.BooleanField(
                        default=True,
                        help_text="If true all items are accepted to the buyback program. You can set extra taxes or disallow individual items from the program item section. If set to false you need to add each accepted item into the program item section. Blueprints are not included in all items.",
                    ),
                ),
                (
                    "use_refined_value",
                    models.BooleanField(
                        default=False,
                        help_text="Take refined value into account when calculating prices for ore, ice and moon goo",
                    ),
                ),
                (
                    "use_compressed_value",
                    models.BooleanField(
                        default=False,
                        help_text="Take compressed value into account when calculating prices for ore, ice and moon goo",
                    ),
                ),
                (
                    "use_raw_ore_value",
                    models.BooleanField(
                        default=True,
                        help_text="Take raw ore value into account when calculating prices for ore, ice and moon goo",
                    ),
                ),
                (
                    "allow_unpacked_items",
                    models.BooleanField(
                        default=False,
                        help_text="Do you want to allow unpacked items in this program such as assembled ship hulls?",
                    ),
                ),
                (
                    "refining_rate",
                    models.IntegerField(
                        default=0,
                        help_text="Refining rate to be used if refined value is active",
                        null=True,
                        validators=[
                            django.core.validators.MaxValueValidator(100),
                            django.core.validators.MinValueValidator(0),
                        ],
                    ),
                ),
                (
                    "location",
                    models.ForeignKey(
                        help_text="Solarystem and station name for contracts.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="buybackprogram.location",
                    ),
                ),
                (
                    "owner",
                    models.ForeignKey(
                        help_text="Player that the contracts will be created for",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="buybackprogram.owner",
                    ),
                ),
                (
                    "restricted_to_group",
                    models.ManyToManyField(
                        blank=True,
                        help_text="The group(s) that will be able to see this buyback program. If none is selected program is open for all.",
                        related_name="buybackprogram_require_groups",
                        to="auth.Group",
                    ),
                ),
                (
                    "restricted_to_state",
                    models.ManyToManyField(
                        blank=True,
                        help_text="The state(s) that will be able to see this buyback program. If none is selected program is open for all.",
                        related_name="buybackprogram_require_states",
                        to="authentication.State",
                    ),
                ),
            ],
            options={
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="Tracking",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("value", models.BigIntegerField()),
                ("taxes", models.BigIntegerField()),
                ("hauling_cost", models.BigIntegerField()),
                ("donation", models.BigIntegerField(blank=True, null=True)),
                ("net_price", models.BigIntegerField()),
                ("tracking_number", models.CharField(max_length=20)),
                (
                    "issuer_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "program",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="buybackprogram.program",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="TrackingItem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("buy_value", models.BigIntegerField()),
                ("quantity", models.IntegerField()),
                (
                    "eve_type",
                    models.ForeignKey(
                        help_text="Item type information",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="eveuniverse.evetype",
                    ),
                ),
                (
                    "tracking",
                    models.ForeignKey(
                        help_text="What tracking do these items belong to",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="buybackprogram.tracking",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ItemPrices",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("buy", models.BigIntegerField()),
                ("sell", models.BigIntegerField()),
                ("updated", models.DateTimeField()),
                (
                    "eve_type",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="eveuniverse.evetype",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ContractItem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("quantity", models.IntegerField()),
                (
                    "contract",
                    models.ForeignKey(
                        help_text="What contract do these items belong to",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="buybackprogram.contract",
                    ),
                ),
                (
                    "eve_type",
                    models.ForeignKey(
                        help_text="Item type information",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="eveuniverse.evetype",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ProgramItem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "item_tax",
                    models.IntegerField(
                        default=0,
                        help_text="How much tax do we add on top of the base tax for this item. Can also be negative.",
                        null=True,
                        validators=[
                            django.core.validators.MaxValueValidator(100),
                            django.core.validators.MinValueValidator(0),
                        ],
                    ),
                ),
                (
                    "disallow_item",
                    models.BooleanField(
                        default=False,
                        help_text="You can disallow an item from a buyback location. It will return 0 price if disallowed.",
                    ),
                ),
                (
                    "item_type",
                    models.ForeignKey(
                        help_text="Select item for special tax",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="eveuniverse.evetype",
                    ),
                ),
                (
                    "program",
                    models.ForeignKey(
                        help_text="What program do these items belong to",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="buybackprogram.program",
                    ),
                ),
            ],
            options={
                "default_permissions": (),
                "unique_together": {("program", "item_type")},
            },
        ),
    ]
