/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.ImpreciseDateTimeField;

class BasicMonthOfYearDateTimeField
extends ImpreciseDateTimeField {
    private static final long serialVersionUID = -8258715387168736L;
    private static final int MIN = 1;
    private final BasicChronology iChronology;
    private final int iMax;
    private final int iLeapMonth;

    BasicMonthOfYearDateTimeField(BasicChronology basicChronology, int n2) {
        super(DateTimeFieldType.monthOfYear(), basicChronology.getAverageMillisPerMonth());
        this.iChronology = basicChronology;
        this.iMax = this.iChronology.getMaxMonth();
        this.iLeapMonth = n2;
    }

    public boolean isLenient() {
        return false;
    }

    public int get(long l2) {
        return this.iChronology.getMonthOfYear(l2);
    }

    public long add(long l2, int n2) {
        int n3;
        if (n2 == 0) {
            return l2;
        }
        long l3 = this.iChronology.getMillisOfDay(l2);
        int n4 = this.iChronology.getYear(l2);
        int n5 = this.iChronology.getMonthOfYear(l2, n4);
        int n6 = n4;
        int n7 = n5 - 1 + n2;
        if (n5 > 0 && n7 < 0) {
            if (Math.signum(n2 + this.iMax) == Math.signum(n2)) {
                --n6;
                n2 += this.iMax;
            } else {
                ++n6;
                n2 -= this.iMax;
            }
            n7 = n5 - 1 + n2;
        }
        if (n7 >= 0) {
            n6 += n7 / this.iMax;
            n7 = n7 % this.iMax + 1;
        } else {
            n6 = n6 + n7 / this.iMax - 1;
            n3 = (n7 = Math.abs(n7)) % this.iMax;
            if (n3 == 0) {
                n3 = this.iMax;
            }
            if ((n7 = this.iMax - n3 + 1) == 1) {
                ++n6;
            }
        }
        n3 = this.iChronology.getDayOfMonth(l2, n4, n5);
        int n8 = this.iChronology.getDaysInYearMonth(n6, n7);
        if (n3 > n8) {
            n3 = n8;
        }
        long l4 = this.iChronology.getYearMonthDayMillis(n6, n7, n3);
        return l4 + l3;
    }

    public long add(long l2, long l3) {
        int n2;
        int n3;
        long l4;
        int n4 = (int)l3;
        if ((long)n4 == l3) {
            return this.add(l2, n4);
        }
        long l5 = this.iChronology.getMillisOfDay(l2);
        int n5 = this.iChronology.getYear(l2);
        int n6 = this.iChronology.getMonthOfYear(l2, n5);
        long l6 = (long)(n6 - 1) + l3;
        if (l6 >= 0L) {
            l4 = (long)n5 + l6 / (long)this.iMax;
            l6 = l6 % (long)this.iMax + 1L;
        } else {
            l4 = (long)n5 + l6 / (long)this.iMax - 1L;
            n3 = (int)((l6 = Math.abs(l6)) % (long)this.iMax);
            if (n3 == 0) {
                n3 = this.iMax;
            }
            if ((l6 = (long)(this.iMax - n3 + 1)) == 1L) {
                ++l4;
            }
        }
        if (l4 < (long)this.iChronology.getMinYear() || l4 > (long)this.iChronology.getMaxYear()) {
            throw new IllegalArgumentException("Magnitude of add amount is too large: " + l3);
        }
        n3 = (int)l4;
        int n7 = (int)l6;
        int n8 = this.iChronology.getDayOfMonth(l2, n5, n6);
        if (n8 > (n2 = this.iChronology.getDaysInYearMonth(n3, n7))) {
            n8 = n2;
        }
        long l7 = this.iChronology.getYearMonthDayMillis(n3, n7, n8);
        return l7 + l5;
    }

    public int[] add(ReadablePartial readablePartial, int n2, int[] nArray, int n3) {
        if (n3 == 0) {
            return nArray;
        }
        if (readablePartial.size() > 0 && readablePartial.getFieldType(0).equals(DateTimeFieldType.monthOfYear()) && n2 == 0) {
            int n4 = nArray[0] - 1;
            int n5 = (n4 + n3 % 12 + 12) % 12 + 1;
            return this.set(readablePartial, 0, nArray, n5);
        }
        if (DateTimeUtils.isContiguous(readablePartial)) {
            long l2 = 0L;
            int n6 = readablePartial.size();
            for (int i2 = 0; i2 < n6; ++i2) {
                l2 = readablePartial.getFieldType(i2).getField(this.iChronology).set(l2, nArray[i2]);
            }
            l2 = this.add(l2, n3);
            return this.iChronology.get(readablePartial, l2);
        }
        return super.add(readablePartial, n2, nArray, n3);
    }

    public long addWrapField(long l2, int n2) {
        return this.set(l2, FieldUtils.getWrappedValue(this.get(l2), n2, 1, this.iMax));
    }

    public long getDifferenceAsLong(long l2, long l3) {
        long l4;
        long l5;
        int n2;
        if (l2 < l3) {
            return -this.getDifference(l3, l2);
        }
        int n3 = this.iChronology.getYear(l2);
        int n4 = this.iChronology.getMonthOfYear(l2, n3);
        int n5 = this.iChronology.getYear(l3);
        int n6 = this.iChronology.getMonthOfYear(l3, n5);
        long l6 = (long)(n3 - n5) * (long)this.iMax + (long)n4 - (long)n6;
        int n7 = this.iChronology.getDayOfMonth(l2, n3, n4);
        if (n7 == this.iChronology.getDaysInYearMonth(n3, n4) && (n2 = this.iChronology.getDayOfMonth(l3, n5, n6)) > n7) {
            l3 = this.iChronology.dayOfMonth().set(l3, n7);
        }
        if ((l5 = l2 - this.iChronology.getYearMonthMillis(n3, n4)) < (l4 = l3 - this.iChronology.getYearMonthMillis(n5, n6))) {
            --l6;
        }
        return l6;
    }

    public long set(long l2, int n2) {
        FieldUtils.verifyValueBounds(this, n2, 1, this.iMax);
        int n3 = this.iChronology.getYear(l2);
        int n4 = this.iChronology.getDayOfMonth(l2, n3);
        int n5 = this.iChronology.getDaysInYearMonth(n3, n2);
        if (n4 > n5) {
            n4 = n5;
        }
        return this.iChronology.getYearMonthDayMillis(n3, n2, n4) + (long)this.iChronology.getMillisOfDay(l2);
    }

    public DurationField getRangeDurationField() {
        return this.iChronology.years();
    }

    public boolean isLeap(long l2) {
        int n2 = this.iChronology.getYear(l2);
        if (this.iChronology.isLeapYear(n2)) {
            return this.iChronology.getMonthOfYear(l2, n2) == this.iLeapMonth;
        }
        return false;
    }

    public int getLeapAmount(long l2) {
        return this.isLeap(l2) ? 1 : 0;
    }

    public DurationField getLeapDurationField() {
        return this.iChronology.days();
    }

    public int getMinimumValue() {
        return 1;
    }

    public int getMaximumValue() {
        return this.iMax;
    }

    public long roundFloor(long l2) {
        int n2 = this.iChronology.getYear(l2);
        int n3 = this.iChronology.getMonthOfYear(l2, n2);
        return this.iChronology.getYearMonthMillis(n2, n3);
    }

    public long remainder(long l2) {
        return l2 - this.roundFloor(l2);
    }

    private Object readResolve() {
        return this.iChronology.monthOfYear();
    }
}

