# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['IntegrationMetric']


class IntegrationMetric(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key_id: Optional[pulumi.Input[str]] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 client_email: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[int]] = None,
                 license_key: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 queue_allowlist: Optional[pulumi.Input[str]] = None,
                 queue_whitelist: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secret_access_key: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[str]] = None,
                 vhost_allowlist: Optional[pulumi.Input[str]] = None,
                 vhost_whitelist: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a IntegrationMetric resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_key_id: AWS access key identifier. (Cloudwatch)
        :param pulumi.Input[str] api_key: The API key for the integration service. (Librato)
        :param pulumi.Input[str] client_email: The client email. (Stackdriver)
        :param pulumi.Input[str] email: The email address registred for the integration service. (Librato)
        :param pulumi.Input[int] instance_id: Instance identifier
        :param pulumi.Input[str] license_key: The license key registred for the integration service. (New Relic)
        :param pulumi.Input[str] name: The name of metrics integration
        :param pulumi.Input[str] private_key: The private key. (Stackdriver)
        :param pulumi.Input[str] project_id: Project ID. (Stackdriver)
        :param pulumi.Input[str] queue_allowlist: (optional) allowlist using regular expression
        :param pulumi.Input[str] queue_whitelist: **Deprecated**
        :param pulumi.Input[str] region: AWS region for Cloudwatch and [US/EU] for Data dog/New relic. (Cloudwatch, Data Dog, New Relic)
        :param pulumi.Input[str] secret_access_key: AWS secret key. (Cloudwatch)
        :param pulumi.Input[str] tags: (optional) tags. E.g. env=prod,region=europe
        :param pulumi.Input[str] vhost_allowlist: (optional) allowlist using regular expression
        :param pulumi.Input[str] vhost_whitelist: **Deprecated**
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['access_key_id'] = access_key_id
            __props__['api_key'] = api_key
            __props__['client_email'] = client_email
            __props__['email'] = email
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__['instance_id'] = instance_id
            __props__['license_key'] = license_key
            __props__['name'] = name
            __props__['private_key'] = private_key
            __props__['project_id'] = project_id
            __props__['queue_allowlist'] = queue_allowlist
            if queue_whitelist is not None and not opts.urn:
                warnings.warn("""use queue_allowlist instead""", DeprecationWarning)
                pulumi.log.warn("queue_whitelist is deprecated: use queue_allowlist instead")
            __props__['queue_whitelist'] = queue_whitelist
            __props__['region'] = region
            __props__['secret_access_key'] = secret_access_key
            __props__['tags'] = tags
            __props__['vhost_allowlist'] = vhost_allowlist
            if vhost_whitelist is not None and not opts.urn:
                warnings.warn("""use vhost_allowlist instead""", DeprecationWarning)
                pulumi.log.warn("vhost_whitelist is deprecated: use vhost_allowlist instead")
            __props__['vhost_whitelist'] = vhost_whitelist
        super(IntegrationMetric, __self__).__init__(
            'cloudamqp:index/integrationMetric:IntegrationMetric',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key_id: Optional[pulumi.Input[str]] = None,
            api_key: Optional[pulumi.Input[str]] = None,
            client_email: Optional[pulumi.Input[str]] = None,
            email: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[int]] = None,
            license_key: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            private_key: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            queue_allowlist: Optional[pulumi.Input[str]] = None,
            queue_whitelist: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            secret_access_key: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[str]] = None,
            vhost_allowlist: Optional[pulumi.Input[str]] = None,
            vhost_whitelist: Optional[pulumi.Input[str]] = None) -> 'IntegrationMetric':
        """
        Get an existing IntegrationMetric resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_key_id: AWS access key identifier. (Cloudwatch)
        :param pulumi.Input[str] api_key: The API key for the integration service. (Librato)
        :param pulumi.Input[str] client_email: The client email. (Stackdriver)
        :param pulumi.Input[str] email: The email address registred for the integration service. (Librato)
        :param pulumi.Input[int] instance_id: Instance identifier
        :param pulumi.Input[str] license_key: The license key registred for the integration service. (New Relic)
        :param pulumi.Input[str] name: The name of metrics integration
        :param pulumi.Input[str] private_key: The private key. (Stackdriver)
        :param pulumi.Input[str] project_id: Project ID. (Stackdriver)
        :param pulumi.Input[str] queue_allowlist: (optional) allowlist using regular expression
        :param pulumi.Input[str] queue_whitelist: **Deprecated**
        :param pulumi.Input[str] region: AWS region for Cloudwatch and [US/EU] for Data dog/New relic. (Cloudwatch, Data Dog, New Relic)
        :param pulumi.Input[str] secret_access_key: AWS secret key. (Cloudwatch)
        :param pulumi.Input[str] tags: (optional) tags. E.g. env=prod,region=europe
        :param pulumi.Input[str] vhost_allowlist: (optional) allowlist using regular expression
        :param pulumi.Input[str] vhost_whitelist: **Deprecated**
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["access_key_id"] = access_key_id
        __props__["api_key"] = api_key
        __props__["client_email"] = client_email
        __props__["email"] = email
        __props__["instance_id"] = instance_id
        __props__["license_key"] = license_key
        __props__["name"] = name
        __props__["private_key"] = private_key
        __props__["project_id"] = project_id
        __props__["queue_allowlist"] = queue_allowlist
        __props__["queue_whitelist"] = queue_whitelist
        __props__["region"] = region
        __props__["secret_access_key"] = secret_access_key
        __props__["tags"] = tags
        __props__["vhost_allowlist"] = vhost_allowlist
        __props__["vhost_whitelist"] = vhost_whitelist
        return IntegrationMetric(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        AWS access key identifier. (Cloudwatch)
        """
        return pulumi.get(self, "access_key_id")

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[Optional[str]]:
        """
        The API key for the integration service. (Librato)
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> pulumi.Output[Optional[str]]:
        """
        The client email. (Stackdriver)
        """
        return pulumi.get(self, "client_email")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[Optional[str]]:
        """
        The email address registred for the integration service. (Librato)
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[int]:
        """
        Instance identifier
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="licenseKey")
    def license_key(self) -> pulumi.Output[Optional[str]]:
        """
        The license key registred for the integration service. (New Relic)
        """
        return pulumi.get(self, "license_key")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of metrics integration
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[Optional[str]]:
        """
        The private key. (Stackdriver)
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[str]]:
        """
        Project ID. (Stackdriver)
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="queueAllowlist")
    def queue_allowlist(self) -> pulumi.Output[Optional[str]]:
        """
        (optional) allowlist using regular expression
        """
        return pulumi.get(self, "queue_allowlist")

    @property
    @pulumi.getter(name="queueWhitelist")
    def queue_whitelist(self) -> pulumi.Output[Optional[str]]:
        """
        **Deprecated**
        """
        return pulumi.get(self, "queue_whitelist")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        """
        AWS region for Cloudwatch and [US/EU] for Data dog/New relic. (Cloudwatch, Data Dog, New Relic)
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> pulumi.Output[Optional[str]]:
        """
        AWS secret key. (Cloudwatch)
        """
        return pulumi.get(self, "secret_access_key")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[str]]:
        """
        (optional) tags. E.g. env=prod,region=europe
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vhostAllowlist")
    def vhost_allowlist(self) -> pulumi.Output[Optional[str]]:
        """
        (optional) allowlist using regular expression
        """
        return pulumi.get(self, "vhost_allowlist")

    @property
    @pulumi.getter(name="vhostWhitelist")
    def vhost_whitelist(self) -> pulumi.Output[Optional[str]]:
        """
        **Deprecated**
        """
        return pulumi.get(self, "vhost_whitelist")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

