# coding: utf-8

"""
    Yagna Activity API

     The Activity API can be perceived as controls which a Requestor-side application has to steer the execution of an Activity as specified in an Agreement which has been negotiated via the Market API/Protocol. This defines possible interactions between the Requestor application (via Activity API) and the generic components running on the Provider node, which host the Provider-side application code. The possible interactions imply a logical “execution environment” component, which is the host/container for the “payload” code. The “execution environment” is specified as an ExeUnit, with a generic interface via which a Provider node’s Activity Controller can operate the hosted code. It conforms with capability level 1 of the [Activity API specification] (https://docs.google.com/document/d/1BXaN32ediXdBHljEApmznSfbuudTU8TmvOmHKl0gmQM).   # noqa: E501

    The version of the OpenAPI document: 1.6.1
    Generated by: https://openapi-generator.tech
"""

import re  # noqa: F401


from ya_activity.api_client import ApiClient
from ya_activity.exceptions import ApiTypeError, ApiValueError  # noqa: F401


class RequestorControlApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def call_encrypted(self, activity_id, body, **kwargs):  # noqa: E501
        """Sends encrypted command to secure exe-unit.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.call_encrypted(activity_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str activity_id: (required)
        :param file body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.call_encrypted_with_http_info(activity_id, body, **kwargs)  # noqa: E501

    def call_encrypted_with_http_info(self, activity_id, body, **kwargs):  # noqa: E501
        """Sends encrypted command to secure exe-unit.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.call_encrypted_with_http_info(activity_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str activity_id: (required)
        :param file body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'activity_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method call_encrypted" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'activity_id' is set
        if self.api_client.client_side_validation and ('activity_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['activity_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `activity_id` when calling `call_encrypted`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `call_encrypted`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'activity_id' in local_var_params:
            path_params['activityId'] = local_var_params['activity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream', 'application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/activity/{activityId}/encrypted', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def call_exec(self, activity_id, script, **kwargs):  # noqa: E501
        """Executes an ExeScript batch within a given Activity.  # noqa: E501

        **Note:** This call shall get routed directly to ExeUnit.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.call_exec(activity_id, script, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str activity_id: (required)
        :param ExeScriptRequest script: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.call_exec_with_http_info(
            activity_id, script, **kwargs
        )  # noqa: E501

    def call_exec_with_http_info(self, activity_id, script, **kwargs):  # noqa: E501
        """Executes an ExeScript batch within a given Activity.  # noqa: E501

        **Note:** This call shall get routed directly to ExeUnit.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.call_exec_with_http_info(activity_id, script, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str activity_id: (required)
        :param ExeScriptRequest script: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["activity_id", "script"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in local_var_params["kwargs"].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method call_exec" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'activity_id' is set
        if self.api_client.client_side_validation and (
            "activity_id" not in local_var_params
            or local_var_params["activity_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `activity_id` when calling `call_exec`"
            )  # noqa: E501
        # verify the required parameter 'script' is set
        if self.api_client.client_side_validation and (
            "script" not in local_var_params
            or local_var_params["script"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `script` when calling `call_exec`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "activity_id" in local_var_params:
            path_params["activityId"] = local_var_params["activity_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "script" in local_var_params:
            body_params = local_var_params["script"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["app_key"]  # noqa: E501

        return self.api_client.call_api(
            "/activity/{activityId}/exec",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="str",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_activity(self, agreement_id, **kwargs):  # noqa: E501
        """Creates new Activity based on given Agreement.  # noqa: E501

        **Note:** This call shall get routed as a provider event (see ProviderEvent structure).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_activity(agreement_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param UNKNOWN_BASE_TYPE agreement_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: oneOf[CreateActivityResult, str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.create_activity_with_http_info(agreement_id, **kwargs)  # noqa: E501

    def create_activity_with_http_info(self, agreement_id, **kwargs):  # noqa: E501
        """Creates new Activity based on given Agreement.  # noqa: E501

        **Note:** This call shall get routed as a provider event (see ProviderEvent structure).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_activity_with_http_info(agreement_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param UNKNOWN_BASE_TYPE agreement_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(oneOf[CreateActivityResult, str], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["agreement_id"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in local_var_params["kwargs"].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_activity" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'agreement_id' is set
        if self.api_client.client_side_validation and (
            "agreement_id" not in local_var_params
            or local_var_params["agreement_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `agreement_id` when calling `create_activity`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'agreement_id' in local_var_params:
            body_params = local_var_params['agreement_id']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/activity', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='oneOf[CreateActivityResult, str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def destroy_activity(self, activity_id, **kwargs):  # noqa: E501
        """Destroys given Activity.  # noqa: E501

        **Note:** This call shall get routed as a provider event (see ProviderEvent structure).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_activity(activity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str activity_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.destroy_activity_with_http_info(activity_id, **kwargs)  # noqa: E501

    def destroy_activity_with_http_info(self, activity_id, **kwargs):  # noqa: E501
        """Destroys given Activity.  # noqa: E501

        **Note:** This call shall get routed as a provider event (see ProviderEvent structure).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_activity_with_http_info(activity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str activity_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["activity_id"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in local_var_params["kwargs"].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method destroy_activity" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'activity_id' is set
        if self.api_client.client_side_validation and (
            "activity_id" not in local_var_params
            or local_var_params["activity_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `activity_id` when calling `destroy_activity`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "activity_id" in local_var_params:
            path_params["activityId"] = local_var_params["activity_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["app_key"]  # noqa: E501

        return self.api_client.call_api(
            "/activity/{activityId}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_exec_batch_results(self, activity_id, batch_id, **kwargs):  # noqa: E501
        """Queries for ExeScript batch results.  # noqa: E501

        'This call shall collect ExeScriptCommand result objects received directly from ExeUnit (via the long polling pattern). **Note:** two formats of response are specified (as indicated by the Accept header):   - application/json - standard JSON response, specified below, as code generators handle it properly.   - text/event-stream - an EventSource implementation (as per https://www.w3.org/TR/eventsource/).     This isn't explicitly specified as code generators generally are unable to handle this.     The streaming events adhere to following format:        event: runtime       data: <RuntimeEvent structure>      This streaming endpoint requires dedicated implementation. '   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_exec_batch_results(activity_id, batch_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str activity_id: (required)
        :param str batch_id: (required)
        :param float command_index: Wait until command with the specified index finishes. Must be accompanied by a valid \"pollTimeout\" query parameter. 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ExeScriptCommandResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_exec_batch_results_with_http_info(
            activity_id, batch_id, **kwargs
        )  # noqa: E501

    def get_exec_batch_results_with_http_info(
        self, activity_id, batch_id, **kwargs
    ):  # noqa: E501
        """Queries for ExeScript batch results.  # noqa: E501

        'This call shall collect ExeScriptCommand result objects received directly from ExeUnit (via the long polling pattern). **Note:** two formats of response are specified (as indicated by the Accept header):   - application/json - standard JSON response, specified below, as code generators handle it properly.   - text/event-stream - an EventSource implementation (as per https://www.w3.org/TR/eventsource/).     This isn't explicitly specified as code generators generally are unable to handle this.     The streaming events adhere to following format:        event: runtime       data: <RuntimeEvent structure>      This streaming endpoint requires dedicated implementation. '   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_exec_batch_results_with_http_info(activity_id, batch_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str activity_id: (required)
        :param str batch_id: (required)
        :param float command_index: Wait until command with the specified index finishes. Must be accompanied by a valid \"pollTimeout\" query parameter. 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[ExeScriptCommandResult], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'activity_id',
            'batch_id',
            'command_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_exec_batch_results" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'activity_id' is set
        if self.api_client.client_side_validation and ('activity_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['activity_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `activity_id` when calling `get_exec_batch_results`")  # noqa: E501
        # verify the required parameter 'batch_id' is set
        if self.api_client.client_side_validation and ('batch_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['batch_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `batch_id` when calling `get_exec_batch_results`")  # noqa: E501

        if self.api_client.client_side_validation and 'command_index' in local_var_params and local_var_params['command_index'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `command_index` when calling `get_exec_batch_results`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'activity_id' in local_var_params:
            path_params['activityId'] = local_var_params['activity_id']  # noqa: E501
        if 'batch_id' in local_var_params:
            path_params['batchId'] = local_var_params['batch_id']  # noqa: E501

        query_params = []
        if 'command_index' in local_var_params and local_var_params['command_index'] is not None:  # noqa: E501
            query_params.append(('commandIndex', local_var_params['command_index']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["app_key"]  # noqa: E501

        return self.api_client.call_api(
            "/activity/{activityId}/exec/{batchId}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[ExeScriptCommandResult]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
