"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateWeight = void 0;
const core_1 = require("@aws-cdk/core");
function validateWeight(x) {
    if (x !== undefined && !core_1.Token.isUnresolved(x) && (x < 0 || x > 255)) {
        throw new Error(`'weight' must be between 0 and 255, got: ${x}`);
    }
}
exports.validateWeight = validateWeight;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiX3V0aWwuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJfdXRpbC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSx3Q0FBc0M7QUFFdEMsU0FBZ0IsY0FBYyxDQUFDLENBQVU7SUFDdkMsSUFBSSxDQUFDLEtBQUssU0FBUyxJQUFJLENBQUMsWUFBSyxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxHQUFHLEdBQUcsQ0FBQyxFQUFFO1FBQ25FLE1BQU0sSUFBSSxLQUFLLENBQUMsNENBQTRDLENBQUMsRUFBRSxDQUFDLENBQUM7S0FDbEU7QUFDSCxDQUFDO0FBSkQsd0NBSUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBUb2tlbiB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG5leHBvcnQgZnVuY3Rpb24gdmFsaWRhdGVXZWlnaHQoeD86IG51bWJlcikge1xuICBpZiAoeCAhPT0gdW5kZWZpbmVkICYmICFUb2tlbi5pc1VucmVzb2x2ZWQoeCkgJiYgKHggPCAwIHx8IHggPiAyNTUpKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKGAnd2VpZ2h0JyBtdXN0IGJlIGJldHdlZW4gMCBhbmQgMjU1LCBnb3Q6ICR7eH1gKTtcbiAgfVxufSJdfQ==