"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JwtAuthBackend = exports.JwtAuthBackendTuneList = exports.JwtAuthBackendTuneOutputReference = exports.jwtAuthBackendTuneToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function jwtAuthBackendTuneToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_response_headers: struct.allowedResponseHeaders === undefined ? null : cdktf.listMapper(cdktf.stringToTerraform)(struct.allowedResponseHeaders),
        audit_non_hmac_request_keys: struct.auditNonHmacRequestKeys === undefined ? null : cdktf.listMapper(cdktf.stringToTerraform)(struct.auditNonHmacRequestKeys),
        audit_non_hmac_response_keys: struct.auditNonHmacResponseKeys === undefined ? null : cdktf.listMapper(cdktf.stringToTerraform)(struct.auditNonHmacResponseKeys),
        default_lease_ttl: struct.defaultLeaseTtl === undefined ? null : cdktf.stringToTerraform(struct.defaultLeaseTtl),
        listing_visibility: struct.listingVisibility === undefined ? null : cdktf.stringToTerraform(struct.listingVisibility),
        max_lease_ttl: struct.maxLeaseTtl === undefined ? null : cdktf.stringToTerraform(struct.maxLeaseTtl),
        passthrough_request_headers: struct.passthroughRequestHeaders === undefined ? null : cdktf.listMapper(cdktf.stringToTerraform)(struct.passthroughRequestHeaders),
        token_type: struct.tokenType === undefined ? null : cdktf.stringToTerraform(struct.tokenType),
    };
}
exports.jwtAuthBackendTuneToTerraform = jwtAuthBackendTuneToTerraform;
class JwtAuthBackendTuneOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._allowedResponseHeaders !== undefined) {
            hasAnyValues = true;
            internalValueResult.allowedResponseHeaders = this._allowedResponseHeaders;
        }
        if (this._auditNonHmacRequestKeys !== undefined) {
            hasAnyValues = true;
            internalValueResult.auditNonHmacRequestKeys = this._auditNonHmacRequestKeys;
        }
        if (this._auditNonHmacResponseKeys !== undefined) {
            hasAnyValues = true;
            internalValueResult.auditNonHmacResponseKeys = this._auditNonHmacResponseKeys;
        }
        if (this._defaultLeaseTtl !== undefined) {
            hasAnyValues = true;
            internalValueResult.defaultLeaseTtl = this._defaultLeaseTtl;
        }
        if (this._listingVisibility !== undefined) {
            hasAnyValues = true;
            internalValueResult.listingVisibility = this._listingVisibility;
        }
        if (this._maxLeaseTtl !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxLeaseTtl = this._maxLeaseTtl;
        }
        if (this._passthroughRequestHeaders !== undefined) {
            hasAnyValues = true;
            internalValueResult.passthroughRequestHeaders = this._passthroughRequestHeaders;
        }
        if (this._tokenType !== undefined) {
            hasAnyValues = true;
            internalValueResult.tokenType = this._tokenType;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._allowedResponseHeaders = undefined;
            this._auditNonHmacRequestKeys = undefined;
            this._auditNonHmacResponseKeys = undefined;
            this._defaultLeaseTtl = undefined;
            this._listingVisibility = undefined;
            this._maxLeaseTtl = undefined;
            this._passthroughRequestHeaders = undefined;
            this._tokenType = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._allowedResponseHeaders = value.allowedResponseHeaders;
            this._auditNonHmacRequestKeys = value.auditNonHmacRequestKeys;
            this._auditNonHmacResponseKeys = value.auditNonHmacResponseKeys;
            this._defaultLeaseTtl = value.defaultLeaseTtl;
            this._listingVisibility = value.listingVisibility;
            this._maxLeaseTtl = value.maxLeaseTtl;
            this._passthroughRequestHeaders = value.passthroughRequestHeaders;
            this._tokenType = value.tokenType;
        }
    }
    get allowedResponseHeaders() {
        return this.getListAttribute('allowed_response_headers');
    }
    set allowedResponseHeaders(value) {
        this._allowedResponseHeaders = value;
    }
    resetAllowedResponseHeaders() {
        this._allowedResponseHeaders = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowedResponseHeadersInput() {
        return this._allowedResponseHeaders;
    }
    get auditNonHmacRequestKeys() {
        return this.getListAttribute('audit_non_hmac_request_keys');
    }
    set auditNonHmacRequestKeys(value) {
        this._auditNonHmacRequestKeys = value;
    }
    resetAuditNonHmacRequestKeys() {
        this._auditNonHmacRequestKeys = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get auditNonHmacRequestKeysInput() {
        return this._auditNonHmacRequestKeys;
    }
    get auditNonHmacResponseKeys() {
        return this.getListAttribute('audit_non_hmac_response_keys');
    }
    set auditNonHmacResponseKeys(value) {
        this._auditNonHmacResponseKeys = value;
    }
    resetAuditNonHmacResponseKeys() {
        this._auditNonHmacResponseKeys = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get auditNonHmacResponseKeysInput() {
        return this._auditNonHmacResponseKeys;
    }
    get defaultLeaseTtl() {
        return this.getStringAttribute('default_lease_ttl');
    }
    set defaultLeaseTtl(value) {
        this._defaultLeaseTtl = value;
    }
    resetDefaultLeaseTtl() {
        this._defaultLeaseTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultLeaseTtlInput() {
        return this._defaultLeaseTtl;
    }
    get listingVisibility() {
        return this.getStringAttribute('listing_visibility');
    }
    set listingVisibility(value) {
        this._listingVisibility = value;
    }
    resetListingVisibility() {
        this._listingVisibility = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get listingVisibilityInput() {
        return this._listingVisibility;
    }
    get maxLeaseTtl() {
        return this.getStringAttribute('max_lease_ttl');
    }
    set maxLeaseTtl(value) {
        this._maxLeaseTtl = value;
    }
    resetMaxLeaseTtl() {
        this._maxLeaseTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxLeaseTtlInput() {
        return this._maxLeaseTtl;
    }
    get passthroughRequestHeaders() {
        return this.getListAttribute('passthrough_request_headers');
    }
    set passthroughRequestHeaders(value) {
        this._passthroughRequestHeaders = value;
    }
    resetPassthroughRequestHeaders() {
        this._passthroughRequestHeaders = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passthroughRequestHeadersInput() {
        return this._passthroughRequestHeaders;
    }
    get tokenType() {
        return this.getStringAttribute('token_type');
    }
    set tokenType(value) {
        this._tokenType = value;
    }
    resetTokenType() {
        this._tokenType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenTypeInput() {
        return this._tokenType;
    }
}
exports.JwtAuthBackendTuneOutputReference = JwtAuthBackendTuneOutputReference;
_a = JSII_RTTI_SYMBOL_1;
JwtAuthBackendTuneOutputReference[_a] = { fqn: "@cdktf/provider-vault.JwtAuthBackendTuneOutputReference", version: "0.0.9" };
class JwtAuthBackendTuneList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new JwtAuthBackendTuneOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.JwtAuthBackendTuneList = JwtAuthBackendTuneList;
_b = JSII_RTTI_SYMBOL_1;
JwtAuthBackendTuneList[_b] = { fqn: "@cdktf/provider-vault.JwtAuthBackendTuneList", version: "0.0.9" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend vault_jwt_auth_backend}
*/
class JwtAuthBackend extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend vault_jwt_auth_backend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options JwtAuthBackendConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'vault_jwt_auth_backend',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.7.0',
                providerVersionConstraint: '~> 3.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // tune - computed: true, optional: true, required: false
        this._tune = new JwtAuthBackendTuneList(this, "tune", true);
        this._boundIssuer = config.boundIssuer;
        this._defaultRole = config.defaultRole;
        this._description = config.description;
        this._id = config.id;
        this._jwksCaPem = config.jwksCaPem;
        this._jwksUrl = config.jwksUrl;
        this._jwtSupportedAlgs = config.jwtSupportedAlgs;
        this._jwtValidationPubkeys = config.jwtValidationPubkeys;
        this._local = config.local;
        this._namespace = config.namespace;
        this._namespaceInState = config.namespaceInState;
        this._oidcClientId = config.oidcClientId;
        this._oidcClientSecret = config.oidcClientSecret;
        this._oidcDiscoveryCaPem = config.oidcDiscoveryCaPem;
        this._oidcDiscoveryUrl = config.oidcDiscoveryUrl;
        this._oidcResponseMode = config.oidcResponseMode;
        this._oidcResponseTypes = config.oidcResponseTypes;
        this._path = config.path;
        this._providerConfig = config.providerConfig;
        this._tune.internalValue = config.tune;
        this._type = config.type;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // accessor - computed: true, optional: false, required: false
    get accessor() {
        return this.getStringAttribute('accessor');
    }
    get boundIssuer() {
        return this.getStringAttribute('bound_issuer');
    }
    set boundIssuer(value) {
        this._boundIssuer = value;
    }
    resetBoundIssuer() {
        this._boundIssuer = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get boundIssuerInput() {
        return this._boundIssuer;
    }
    get defaultRole() {
        return this.getStringAttribute('default_role');
    }
    set defaultRole(value) {
        this._defaultRole = value;
    }
    resetDefaultRole() {
        this._defaultRole = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultRoleInput() {
        return this._defaultRole;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get jwksCaPem() {
        return this.getStringAttribute('jwks_ca_pem');
    }
    set jwksCaPem(value) {
        this._jwksCaPem = value;
    }
    resetJwksCaPem() {
        this._jwksCaPem = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get jwksCaPemInput() {
        return this._jwksCaPem;
    }
    get jwksUrl() {
        return this.getStringAttribute('jwks_url');
    }
    set jwksUrl(value) {
        this._jwksUrl = value;
    }
    resetJwksUrl() {
        this._jwksUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get jwksUrlInput() {
        return this._jwksUrl;
    }
    get jwtSupportedAlgs() {
        return this.getListAttribute('jwt_supported_algs');
    }
    set jwtSupportedAlgs(value) {
        this._jwtSupportedAlgs = value;
    }
    resetJwtSupportedAlgs() {
        this._jwtSupportedAlgs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get jwtSupportedAlgsInput() {
        return this._jwtSupportedAlgs;
    }
    get jwtValidationPubkeys() {
        return this.getListAttribute('jwt_validation_pubkeys');
    }
    set jwtValidationPubkeys(value) {
        this._jwtValidationPubkeys = value;
    }
    resetJwtValidationPubkeys() {
        this._jwtValidationPubkeys = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get jwtValidationPubkeysInput() {
        return this._jwtValidationPubkeys;
    }
    get local() {
        return this.getBooleanAttribute('local');
    }
    set local(value) {
        this._local = value;
    }
    resetLocal() {
        this._local = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get localInput() {
        return this._local;
    }
    get namespace() {
        return this.getStringAttribute('namespace');
    }
    set namespace(value) {
        this._namespace = value;
    }
    resetNamespace() {
        this._namespace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInput() {
        return this._namespace;
    }
    get namespaceInState() {
        return this.getBooleanAttribute('namespace_in_state');
    }
    set namespaceInState(value) {
        this._namespaceInState = value;
    }
    resetNamespaceInState() {
        this._namespaceInState = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInStateInput() {
        return this._namespaceInState;
    }
    get oidcClientId() {
        return this.getStringAttribute('oidc_client_id');
    }
    set oidcClientId(value) {
        this._oidcClientId = value;
    }
    resetOidcClientId() {
        this._oidcClientId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcClientIdInput() {
        return this._oidcClientId;
    }
    get oidcClientSecret() {
        return this.getStringAttribute('oidc_client_secret');
    }
    set oidcClientSecret(value) {
        this._oidcClientSecret = value;
    }
    resetOidcClientSecret() {
        this._oidcClientSecret = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcClientSecretInput() {
        return this._oidcClientSecret;
    }
    get oidcDiscoveryCaPem() {
        return this.getStringAttribute('oidc_discovery_ca_pem');
    }
    set oidcDiscoveryCaPem(value) {
        this._oidcDiscoveryCaPem = value;
    }
    resetOidcDiscoveryCaPem() {
        this._oidcDiscoveryCaPem = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcDiscoveryCaPemInput() {
        return this._oidcDiscoveryCaPem;
    }
    get oidcDiscoveryUrl() {
        return this.getStringAttribute('oidc_discovery_url');
    }
    set oidcDiscoveryUrl(value) {
        this._oidcDiscoveryUrl = value;
    }
    resetOidcDiscoveryUrl() {
        this._oidcDiscoveryUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcDiscoveryUrlInput() {
        return this._oidcDiscoveryUrl;
    }
    get oidcResponseMode() {
        return this.getStringAttribute('oidc_response_mode');
    }
    set oidcResponseMode(value) {
        this._oidcResponseMode = value;
    }
    resetOidcResponseMode() {
        this._oidcResponseMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcResponseModeInput() {
        return this._oidcResponseMode;
    }
    get oidcResponseTypes() {
        return this.getListAttribute('oidc_response_types');
    }
    set oidcResponseTypes(value) {
        this._oidcResponseTypes = value;
    }
    resetOidcResponseTypes() {
        this._oidcResponseTypes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcResponseTypesInput() {
        return this._oidcResponseTypes;
    }
    get path() {
        return this.getStringAttribute('path');
    }
    set path(value) {
        this._path = value;
    }
    resetPath() {
        this._path = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pathInput() {
        return this._path;
    }
    get providerConfig() {
        return this.getStringMapAttribute('provider_config');
    }
    set providerConfig(value) {
        this._providerConfig = value;
    }
    resetProviderConfig() {
        this._providerConfig = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get providerConfigInput() {
        return this._providerConfig;
    }
    get tune() {
        return this._tune;
    }
    putTune(value) {
        this._tune.internalValue = value;
    }
    resetTune() {
        this._tune.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tuneInput() {
        return this._tune.internalValue;
    }
    get type() {
        return this.getStringAttribute('type');
    }
    set type(value) {
        this._type = value;
    }
    resetType() {
        this._type = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get typeInput() {
        return this._type;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            bound_issuer: cdktf.stringToTerraform(this._boundIssuer),
            default_role: cdktf.stringToTerraform(this._defaultRole),
            description: cdktf.stringToTerraform(this._description),
            id: cdktf.stringToTerraform(this._id),
            jwks_ca_pem: cdktf.stringToTerraform(this._jwksCaPem),
            jwks_url: cdktf.stringToTerraform(this._jwksUrl),
            jwt_supported_algs: cdktf.listMapper(cdktf.stringToTerraform)(this._jwtSupportedAlgs),
            jwt_validation_pubkeys: cdktf.listMapper(cdktf.stringToTerraform)(this._jwtValidationPubkeys),
            local: cdktf.booleanToTerraform(this._local),
            namespace: cdktf.stringToTerraform(this._namespace),
            namespace_in_state: cdktf.booleanToTerraform(this._namespaceInState),
            oidc_client_id: cdktf.stringToTerraform(this._oidcClientId),
            oidc_client_secret: cdktf.stringToTerraform(this._oidcClientSecret),
            oidc_discovery_ca_pem: cdktf.stringToTerraform(this._oidcDiscoveryCaPem),
            oidc_discovery_url: cdktf.stringToTerraform(this._oidcDiscoveryUrl),
            oidc_response_mode: cdktf.stringToTerraform(this._oidcResponseMode),
            oidc_response_types: cdktf.listMapper(cdktf.stringToTerraform)(this._oidcResponseTypes),
            path: cdktf.stringToTerraform(this._path),
            provider_config: cdktf.hashMapper(cdktf.stringToTerraform)(this._providerConfig),
            tune: cdktf.listMapper(jwtAuthBackendTuneToTerraform)(this._tune.internalValue),
            type: cdktf.stringToTerraform(this._type),
        };
    }
}
exports.JwtAuthBackend = JwtAuthBackend;
_c = JSII_RTTI_SYMBOL_1;
JwtAuthBackend[_c] = { fqn: "@cdktf/provider-vault.JwtAuthBackend", version: "0.0.9" };
// =================
// STATIC PROPERTIES
// =================
JwtAuthBackend.tfResourceType = "vault_jwt_auth_backend";
//# sourceMappingURL=data:application/json;base64,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