import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KmipSecretScopeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Force deletion even if there are managed objects in the scope
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_scope#force KmipSecretScope#force}
    */
    readonly force?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_scope#id KmipSecretScope#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_scope#namespace KmipSecretScope#namespace}
    */
    readonly namespace?: string;
    /**
    * Path where KMIP backend is mounted
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_scope#path KmipSecretScope#path}
    */
    readonly path: string;
    /**
    * Name of the scope
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_scope#scope KmipSecretScope#scope}
    */
    readonly scope: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_scope vault_kmip_secret_scope}
*/
export declare class KmipSecretScope extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_kmip_secret_scope";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_scope vault_kmip_secret_scope} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KmipSecretScopeConfig
    */
    constructor(scope: Construct, id: string, config: KmipSecretScopeConfig);
    private _force?;
    get force(): boolean | cdktf.IResolvable;
    set force(value: boolean | cdktf.IResolvable);
    resetForce(): void;
    get forceInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    get scopeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
