"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesAuthBackendRole = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_auth_backend_role vault_kubernetes_auth_backend_role}
*/
class KubernetesAuthBackendRole extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_auth_backend_role vault_kubernetes_auth_backend_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KubernetesAuthBackendRoleConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault_kubernetes_auth_backend_role',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.7.0',
                providerVersionConstraint: '~> 3.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._aliasNameSource = config.aliasNameSource;
        this._audience = config.audience;
        this._backend = config.backend;
        this._boundServiceAccountNames = config.boundServiceAccountNames;
        this._boundServiceAccountNamespaces = config.boundServiceAccountNamespaces;
        this._id = config.id;
        this._namespace = config.namespace;
        this._roleName = config.roleName;
        this._tokenBoundCidrs = config.tokenBoundCidrs;
        this._tokenExplicitMaxTtl = config.tokenExplicitMaxTtl;
        this._tokenMaxTtl = config.tokenMaxTtl;
        this._tokenNoDefaultPolicy = config.tokenNoDefaultPolicy;
        this._tokenNumUses = config.tokenNumUses;
        this._tokenPeriod = config.tokenPeriod;
        this._tokenPolicies = config.tokenPolicies;
        this._tokenTtl = config.tokenTtl;
        this._tokenType = config.tokenType;
    }
    get aliasNameSource() {
        return this.getStringAttribute('alias_name_source');
    }
    set aliasNameSource(value) {
        this._aliasNameSource = value;
    }
    resetAliasNameSource() {
        this._aliasNameSource = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasNameSourceInput() {
        return this._aliasNameSource;
    }
    get audience() {
        return this.getStringAttribute('audience');
    }
    set audience(value) {
        this._audience = value;
    }
    resetAudience() {
        this._audience = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get audienceInput() {
        return this._audience;
    }
    get backend() {
        return this.getStringAttribute('backend');
    }
    set backend(value) {
        this._backend = value;
    }
    resetBackend() {
        this._backend = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backendInput() {
        return this._backend;
    }
    get boundServiceAccountNames() {
        return cdktf.Fn.tolist(this.getListAttribute('bound_service_account_names'));
    }
    set boundServiceAccountNames(value) {
        this._boundServiceAccountNames = value;
    }
    // Temporarily expose input value. Use with caution.
    get boundServiceAccountNamesInput() {
        return this._boundServiceAccountNames;
    }
    get boundServiceAccountNamespaces() {
        return cdktf.Fn.tolist(this.getListAttribute('bound_service_account_namespaces'));
    }
    set boundServiceAccountNamespaces(value) {
        this._boundServiceAccountNamespaces = value;
    }
    // Temporarily expose input value. Use with caution.
    get boundServiceAccountNamespacesInput() {
        return this._boundServiceAccountNamespaces;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get namespace() {
        return this.getStringAttribute('namespace');
    }
    set namespace(value) {
        this._namespace = value;
    }
    resetNamespace() {
        this._namespace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInput() {
        return this._namespace;
    }
    get roleName() {
        return this.getStringAttribute('role_name');
    }
    set roleName(value) {
        this._roleName = value;
    }
    // Temporarily expose input value. Use with caution.
    get roleNameInput() {
        return this._roleName;
    }
    get tokenBoundCidrs() {
        return cdktf.Fn.tolist(this.getListAttribute('token_bound_cidrs'));
    }
    set tokenBoundCidrs(value) {
        this._tokenBoundCidrs = value;
    }
    resetTokenBoundCidrs() {
        this._tokenBoundCidrs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenBoundCidrsInput() {
        return this._tokenBoundCidrs;
    }
    get tokenExplicitMaxTtl() {
        return this.getNumberAttribute('token_explicit_max_ttl');
    }
    set tokenExplicitMaxTtl(value) {
        this._tokenExplicitMaxTtl = value;
    }
    resetTokenExplicitMaxTtl() {
        this._tokenExplicitMaxTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenExplicitMaxTtlInput() {
        return this._tokenExplicitMaxTtl;
    }
    get tokenMaxTtl() {
        return this.getNumberAttribute('token_max_ttl');
    }
    set tokenMaxTtl(value) {
        this._tokenMaxTtl = value;
    }
    resetTokenMaxTtl() {
        this._tokenMaxTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenMaxTtlInput() {
        return this._tokenMaxTtl;
    }
    get tokenNoDefaultPolicy() {
        return this.getBooleanAttribute('token_no_default_policy');
    }
    set tokenNoDefaultPolicy(value) {
        this._tokenNoDefaultPolicy = value;
    }
    resetTokenNoDefaultPolicy() {
        this._tokenNoDefaultPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenNoDefaultPolicyInput() {
        return this._tokenNoDefaultPolicy;
    }
    get tokenNumUses() {
        return this.getNumberAttribute('token_num_uses');
    }
    set tokenNumUses(value) {
        this._tokenNumUses = value;
    }
    resetTokenNumUses() {
        this._tokenNumUses = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenNumUsesInput() {
        return this._tokenNumUses;
    }
    get tokenPeriod() {
        return this.getNumberAttribute('token_period');
    }
    set tokenPeriod(value) {
        this._tokenPeriod = value;
    }
    resetTokenPeriod() {
        this._tokenPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenPeriodInput() {
        return this._tokenPeriod;
    }
    get tokenPolicies() {
        return cdktf.Fn.tolist(this.getListAttribute('token_policies'));
    }
    set tokenPolicies(value) {
        this._tokenPolicies = value;
    }
    resetTokenPolicies() {
        this._tokenPolicies = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenPoliciesInput() {
        return this._tokenPolicies;
    }
    get tokenTtl() {
        return this.getNumberAttribute('token_ttl');
    }
    set tokenTtl(value) {
        this._tokenTtl = value;
    }
    resetTokenTtl() {
        this._tokenTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenTtlInput() {
        return this._tokenTtl;
    }
    get tokenType() {
        return this.getStringAttribute('token_type');
    }
    set tokenType(value) {
        this._tokenType = value;
    }
    resetTokenType() {
        this._tokenType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenTypeInput() {
        return this._tokenType;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            alias_name_source: cdktf.stringToTerraform(this._aliasNameSource),
            audience: cdktf.stringToTerraform(this._audience),
            backend: cdktf.stringToTerraform(this._backend),
            bound_service_account_names: cdktf.listMapper(cdktf.stringToTerraform)(this._boundServiceAccountNames),
            bound_service_account_namespaces: cdktf.listMapper(cdktf.stringToTerraform)(this._boundServiceAccountNamespaces),
            id: cdktf.stringToTerraform(this._id),
            namespace: cdktf.stringToTerraform(this._namespace),
            role_name: cdktf.stringToTerraform(this._roleName),
            token_bound_cidrs: cdktf.listMapper(cdktf.stringToTerraform)(this._tokenBoundCidrs),
            token_explicit_max_ttl: cdktf.numberToTerraform(this._tokenExplicitMaxTtl),
            token_max_ttl: cdktf.numberToTerraform(this._tokenMaxTtl),
            token_no_default_policy: cdktf.booleanToTerraform(this._tokenNoDefaultPolicy),
            token_num_uses: cdktf.numberToTerraform(this._tokenNumUses),
            token_period: cdktf.numberToTerraform(this._tokenPeriod),
            token_policies: cdktf.listMapper(cdktf.stringToTerraform)(this._tokenPolicies),
            token_ttl: cdktf.numberToTerraform(this._tokenTtl),
            token_type: cdktf.stringToTerraform(this._tokenType),
        };
    }
}
exports.KubernetesAuthBackendRole = KubernetesAuthBackendRole;
_a = JSII_RTTI_SYMBOL_1;
KubernetesAuthBackendRole[_a] = { fqn: "@cdktf/provider-vault.KubernetesAuthBackendRole", version: "0.0.9" };
// =================
// STATIC PROPERTIES
// =================
KubernetesAuthBackendRole.tfResourceType = "vault_kubernetes_auth_backend_role";
//# sourceMappingURL=data:application/json;base64,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