"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PkiSecretBackendRole = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role vault_pki_secret_backend_role}
*/
class PkiSecretBackendRole extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role vault_pki_secret_backend_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PkiSecretBackendRoleConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault_pki_secret_backend_role',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.7.0',
                providerVersionConstraint: '~> 3.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._allowAnyName = config.allowAnyName;
        this._allowBareDomains = config.allowBareDomains;
        this._allowGlobDomains = config.allowGlobDomains;
        this._allowIpSans = config.allowIpSans;
        this._allowLocalhost = config.allowLocalhost;
        this._allowSubdomains = config.allowSubdomains;
        this._allowedDomains = config.allowedDomains;
        this._allowedDomainsTemplate = config.allowedDomainsTemplate;
        this._allowedOtherSans = config.allowedOtherSans;
        this._allowedSerialNumbers = config.allowedSerialNumbers;
        this._allowedUriSans = config.allowedUriSans;
        this._backend = config.backend;
        this._basicConstraintsValidForNonCa = config.basicConstraintsValidForNonCa;
        this._clientFlag = config.clientFlag;
        this._codeSigningFlag = config.codeSigningFlag;
        this._country = config.country;
        this._emailProtectionFlag = config.emailProtectionFlag;
        this._enforceHostnames = config.enforceHostnames;
        this._extKeyUsage = config.extKeyUsage;
        this._generateLease = config.generateLease;
        this._id = config.id;
        this._keyBits = config.keyBits;
        this._keyType = config.keyType;
        this._keyUsage = config.keyUsage;
        this._locality = config.locality;
        this._maxTtl = config.maxTtl;
        this._name = config.name;
        this._namespace = config.namespace;
        this._noStore = config.noStore;
        this._notBeforeDuration = config.notBeforeDuration;
        this._organization = config.organization;
        this._ou = config.ou;
        this._policyIdentifiers = config.policyIdentifiers;
        this._postalCode = config.postalCode;
        this._province = config.province;
        this._requireCn = config.requireCn;
        this._serverFlag = config.serverFlag;
        this._streetAddress = config.streetAddress;
        this._ttl = config.ttl;
        this._useCsrCommonName = config.useCsrCommonName;
        this._useCsrSans = config.useCsrSans;
    }
    get allowAnyName() {
        return this.getBooleanAttribute('allow_any_name');
    }
    set allowAnyName(value) {
        this._allowAnyName = value;
    }
    resetAllowAnyName() {
        this._allowAnyName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowAnyNameInput() {
        return this._allowAnyName;
    }
    get allowBareDomains() {
        return this.getBooleanAttribute('allow_bare_domains');
    }
    set allowBareDomains(value) {
        this._allowBareDomains = value;
    }
    resetAllowBareDomains() {
        this._allowBareDomains = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowBareDomainsInput() {
        return this._allowBareDomains;
    }
    get allowGlobDomains() {
        return this.getBooleanAttribute('allow_glob_domains');
    }
    set allowGlobDomains(value) {
        this._allowGlobDomains = value;
    }
    resetAllowGlobDomains() {
        this._allowGlobDomains = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowGlobDomainsInput() {
        return this._allowGlobDomains;
    }
    get allowIpSans() {
        return this.getBooleanAttribute('allow_ip_sans');
    }
    set allowIpSans(value) {
        this._allowIpSans = value;
    }
    resetAllowIpSans() {
        this._allowIpSans = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowIpSansInput() {
        return this._allowIpSans;
    }
    get allowLocalhost() {
        return this.getBooleanAttribute('allow_localhost');
    }
    set allowLocalhost(value) {
        this._allowLocalhost = value;
    }
    resetAllowLocalhost() {
        this._allowLocalhost = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowLocalhostInput() {
        return this._allowLocalhost;
    }
    get allowSubdomains() {
        return this.getBooleanAttribute('allow_subdomains');
    }
    set allowSubdomains(value) {
        this._allowSubdomains = value;
    }
    resetAllowSubdomains() {
        this._allowSubdomains = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowSubdomainsInput() {
        return this._allowSubdomains;
    }
    get allowedDomains() {
        return this.getListAttribute('allowed_domains');
    }
    set allowedDomains(value) {
        this._allowedDomains = value;
    }
    resetAllowedDomains() {
        this._allowedDomains = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowedDomainsInput() {
        return this._allowedDomains;
    }
    get allowedDomainsTemplate() {
        return this.getBooleanAttribute('allowed_domains_template');
    }
    set allowedDomainsTemplate(value) {
        this._allowedDomainsTemplate = value;
    }
    resetAllowedDomainsTemplate() {
        this._allowedDomainsTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowedDomainsTemplateInput() {
        return this._allowedDomainsTemplate;
    }
    get allowedOtherSans() {
        return this.getListAttribute('allowed_other_sans');
    }
    set allowedOtherSans(value) {
        this._allowedOtherSans = value;
    }
    resetAllowedOtherSans() {
        this._allowedOtherSans = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowedOtherSansInput() {
        return this._allowedOtherSans;
    }
    get allowedSerialNumbers() {
        return this.getListAttribute('allowed_serial_numbers');
    }
    set allowedSerialNumbers(value) {
        this._allowedSerialNumbers = value;
    }
    resetAllowedSerialNumbers() {
        this._allowedSerialNumbers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowedSerialNumbersInput() {
        return this._allowedSerialNumbers;
    }
    get allowedUriSans() {
        return this.getListAttribute('allowed_uri_sans');
    }
    set allowedUriSans(value) {
        this._allowedUriSans = value;
    }
    resetAllowedUriSans() {
        this._allowedUriSans = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowedUriSansInput() {
        return this._allowedUriSans;
    }
    get backend() {
        return this.getStringAttribute('backend');
    }
    set backend(value) {
        this._backend = value;
    }
    // Temporarily expose input value. Use with caution.
    get backendInput() {
        return this._backend;
    }
    get basicConstraintsValidForNonCa() {
        return this.getBooleanAttribute('basic_constraints_valid_for_non_ca');
    }
    set basicConstraintsValidForNonCa(value) {
        this._basicConstraintsValidForNonCa = value;
    }
    resetBasicConstraintsValidForNonCa() {
        this._basicConstraintsValidForNonCa = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get basicConstraintsValidForNonCaInput() {
        return this._basicConstraintsValidForNonCa;
    }
    get clientFlag() {
        return this.getBooleanAttribute('client_flag');
    }
    set clientFlag(value) {
        this._clientFlag = value;
    }
    resetClientFlag() {
        this._clientFlag = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientFlagInput() {
        return this._clientFlag;
    }
    get codeSigningFlag() {
        return this.getBooleanAttribute('code_signing_flag');
    }
    set codeSigningFlag(value) {
        this._codeSigningFlag = value;
    }
    resetCodeSigningFlag() {
        this._codeSigningFlag = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get codeSigningFlagInput() {
        return this._codeSigningFlag;
    }
    get country() {
        return this.getListAttribute('country');
    }
    set country(value) {
        this._country = value;
    }
    resetCountry() {
        this._country = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get countryInput() {
        return this._country;
    }
    get emailProtectionFlag() {
        return this.getBooleanAttribute('email_protection_flag');
    }
    set emailProtectionFlag(value) {
        this._emailProtectionFlag = value;
    }
    resetEmailProtectionFlag() {
        this._emailProtectionFlag = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emailProtectionFlagInput() {
        return this._emailProtectionFlag;
    }
    get enforceHostnames() {
        return this.getBooleanAttribute('enforce_hostnames');
    }
    set enforceHostnames(value) {
        this._enforceHostnames = value;
    }
    resetEnforceHostnames() {
        this._enforceHostnames = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enforceHostnamesInput() {
        return this._enforceHostnames;
    }
    get extKeyUsage() {
        return this.getListAttribute('ext_key_usage');
    }
    set extKeyUsage(value) {
        this._extKeyUsage = value;
    }
    resetExtKeyUsage() {
        this._extKeyUsage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get extKeyUsageInput() {
        return this._extKeyUsage;
    }
    get generateLease() {
        return this.getBooleanAttribute('generate_lease');
    }
    set generateLease(value) {
        this._generateLease = value;
    }
    resetGenerateLease() {
        this._generateLease = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get generateLeaseInput() {
        return this._generateLease;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get keyBits() {
        return this.getNumberAttribute('key_bits');
    }
    set keyBits(value) {
        this._keyBits = value;
    }
    resetKeyBits() {
        this._keyBits = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keyBitsInput() {
        return this._keyBits;
    }
    get keyType() {
        return this.getStringAttribute('key_type');
    }
    set keyType(value) {
        this._keyType = value;
    }
    resetKeyType() {
        this._keyType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keyTypeInput() {
        return this._keyType;
    }
    get keyUsage() {
        return this.getListAttribute('key_usage');
    }
    set keyUsage(value) {
        this._keyUsage = value;
    }
    resetKeyUsage() {
        this._keyUsage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keyUsageInput() {
        return this._keyUsage;
    }
    get locality() {
        return this.getListAttribute('locality');
    }
    set locality(value) {
        this._locality = value;
    }
    resetLocality() {
        this._locality = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get localityInput() {
        return this._locality;
    }
    get maxTtl() {
        return this.getStringAttribute('max_ttl');
    }
    set maxTtl(value) {
        this._maxTtl = value;
    }
    resetMaxTtl() {
        this._maxTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxTtlInput() {
        return this._maxTtl;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get namespace() {
        return this.getStringAttribute('namespace');
    }
    set namespace(value) {
        this._namespace = value;
    }
    resetNamespace() {
        this._namespace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInput() {
        return this._namespace;
    }
    get noStore() {
        return this.getBooleanAttribute('no_store');
    }
    set noStore(value) {
        this._noStore = value;
    }
    resetNoStore() {
        this._noStore = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get noStoreInput() {
        return this._noStore;
    }
    get notBeforeDuration() {
        return this.getStringAttribute('not_before_duration');
    }
    set notBeforeDuration(value) {
        this._notBeforeDuration = value;
    }
    resetNotBeforeDuration() {
        this._notBeforeDuration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notBeforeDurationInput() {
        return this._notBeforeDuration;
    }
    get organization() {
        return this.getListAttribute('organization');
    }
    set organization(value) {
        this._organization = value;
    }
    resetOrganization() {
        this._organization = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get organizationInput() {
        return this._organization;
    }
    get ou() {
        return this.getListAttribute('ou');
    }
    set ou(value) {
        this._ou = value;
    }
    resetOu() {
        this._ou = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ouInput() {
        return this._ou;
    }
    get policyIdentifiers() {
        return this.getListAttribute('policy_identifiers');
    }
    set policyIdentifiers(value) {
        this._policyIdentifiers = value;
    }
    resetPolicyIdentifiers() {
        this._policyIdentifiers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get policyIdentifiersInput() {
        return this._policyIdentifiers;
    }
    get postalCode() {
        return this.getListAttribute('postal_code');
    }
    set postalCode(value) {
        this._postalCode = value;
    }
    resetPostalCode() {
        this._postalCode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get postalCodeInput() {
        return this._postalCode;
    }
    get province() {
        return this.getListAttribute('province');
    }
    set province(value) {
        this._province = value;
    }
    resetProvince() {
        this._province = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get provinceInput() {
        return this._province;
    }
    get requireCn() {
        return this.getBooleanAttribute('require_cn');
    }
    set requireCn(value) {
        this._requireCn = value;
    }
    resetRequireCn() {
        this._requireCn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requireCnInput() {
        return this._requireCn;
    }
    get serverFlag() {
        return this.getBooleanAttribute('server_flag');
    }
    set serverFlag(value) {
        this._serverFlag = value;
    }
    resetServerFlag() {
        this._serverFlag = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serverFlagInput() {
        return this._serverFlag;
    }
    get streetAddress() {
        return this.getListAttribute('street_address');
    }
    set streetAddress(value) {
        this._streetAddress = value;
    }
    resetStreetAddress() {
        this._streetAddress = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get streetAddressInput() {
        return this._streetAddress;
    }
    get ttl() {
        return this.getStringAttribute('ttl');
    }
    set ttl(value) {
        this._ttl = value;
    }
    resetTtl() {
        this._ttl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ttlInput() {
        return this._ttl;
    }
    get useCsrCommonName() {
        return this.getBooleanAttribute('use_csr_common_name');
    }
    set useCsrCommonName(value) {
        this._useCsrCommonName = value;
    }
    resetUseCsrCommonName() {
        this._useCsrCommonName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useCsrCommonNameInput() {
        return this._useCsrCommonName;
    }
    get useCsrSans() {
        return this.getBooleanAttribute('use_csr_sans');
    }
    set useCsrSans(value) {
        this._useCsrSans = value;
    }
    resetUseCsrSans() {
        this._useCsrSans = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useCsrSansInput() {
        return this._useCsrSans;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allow_any_name: cdktf.booleanToTerraform(this._allowAnyName),
            allow_bare_domains: cdktf.booleanToTerraform(this._allowBareDomains),
            allow_glob_domains: cdktf.booleanToTerraform(this._allowGlobDomains),
            allow_ip_sans: cdktf.booleanToTerraform(this._allowIpSans),
            allow_localhost: cdktf.booleanToTerraform(this._allowLocalhost),
            allow_subdomains: cdktf.booleanToTerraform(this._allowSubdomains),
            allowed_domains: cdktf.listMapper(cdktf.stringToTerraform)(this._allowedDomains),
            allowed_domains_template: cdktf.booleanToTerraform(this._allowedDomainsTemplate),
            allowed_other_sans: cdktf.listMapper(cdktf.stringToTerraform)(this._allowedOtherSans),
            allowed_serial_numbers: cdktf.listMapper(cdktf.stringToTerraform)(this._allowedSerialNumbers),
            allowed_uri_sans: cdktf.listMapper(cdktf.stringToTerraform)(this._allowedUriSans),
            backend: cdktf.stringToTerraform(this._backend),
            basic_constraints_valid_for_non_ca: cdktf.booleanToTerraform(this._basicConstraintsValidForNonCa),
            client_flag: cdktf.booleanToTerraform(this._clientFlag),
            code_signing_flag: cdktf.booleanToTerraform(this._codeSigningFlag),
            country: cdktf.listMapper(cdktf.stringToTerraform)(this._country),
            email_protection_flag: cdktf.booleanToTerraform(this._emailProtectionFlag),
            enforce_hostnames: cdktf.booleanToTerraform(this._enforceHostnames),
            ext_key_usage: cdktf.listMapper(cdktf.stringToTerraform)(this._extKeyUsage),
            generate_lease: cdktf.booleanToTerraform(this._generateLease),
            id: cdktf.stringToTerraform(this._id),
            key_bits: cdktf.numberToTerraform(this._keyBits),
            key_type: cdktf.stringToTerraform(this._keyType),
            key_usage: cdktf.listMapper(cdktf.stringToTerraform)(this._keyUsage),
            locality: cdktf.listMapper(cdktf.stringToTerraform)(this._locality),
            max_ttl: cdktf.stringToTerraform(this._maxTtl),
            name: cdktf.stringToTerraform(this._name),
            namespace: cdktf.stringToTerraform(this._namespace),
            no_store: cdktf.booleanToTerraform(this._noStore),
            not_before_duration: cdktf.stringToTerraform(this._notBeforeDuration),
            organization: cdktf.listMapper(cdktf.stringToTerraform)(this._organization),
            ou: cdktf.listMapper(cdktf.stringToTerraform)(this._ou),
            policy_identifiers: cdktf.listMapper(cdktf.stringToTerraform)(this._policyIdentifiers),
            postal_code: cdktf.listMapper(cdktf.stringToTerraform)(this._postalCode),
            province: cdktf.listMapper(cdktf.stringToTerraform)(this._province),
            require_cn: cdktf.booleanToTerraform(this._requireCn),
            server_flag: cdktf.booleanToTerraform(this._serverFlag),
            street_address: cdktf.listMapper(cdktf.stringToTerraform)(this._streetAddress),
            ttl: cdktf.stringToTerraform(this._ttl),
            use_csr_common_name: cdktf.booleanToTerraform(this._useCsrCommonName),
            use_csr_sans: cdktf.booleanToTerraform(this._useCsrSans),
        };
    }
}
exports.PkiSecretBackendRole = PkiSecretBackendRole;
_a = JSII_RTTI_SYMBOL_1;
PkiSecretBackendRole[_a] = { fqn: "@cdktf/provider-vault.PkiSecretBackendRole", version: "0.0.9" };
// =================
// STATIC PROPERTIES
// =================
PkiSecretBackendRole.tfResourceType = "vault_pki_secret_backend_role";
//# sourceMappingURL=data:application/json;base64,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