# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['lolacli']

package_data = \
{'': ['*'], 'lolacli': ['scripts/*']}

install_requires = \
['click>=8.0.1,<9.0.0']

entry_points = \
{'console_scripts': ['lola = lolacli.lolacli:main']}

setup_kwargs = {
    'name': 'lolacli',
    'version': '0.2.1',
    'description': 'A simple cli tool to help beginners install apps in Linux',
    'long_description': "# Lola\n### `lola` : A simple CLI for installing packages on Linux easily \n\n**lola is made for linux users who want to download software fast and easy!**\n\nNow many will ask, Why use lola when we have those software managers?\n\nWell, lola is a Command Line Interface and is used inside the terminal. And as we know, terminal downloads are way more faster than the software managers. While many softwares can be downloaded with a single `sudo apt install`, most common ones need some more commands.\n\nSo `lola` is here to make your life way more easier while installing software! This project targets both advanced and beginner users, because who doesn't like speedy and quicky stuff?\n\n#### Dependencies\n+ `click`\n\n### Built with\n+ `Python 3.8.5`\n\n\n## Installation\n\n#### Method 1 (Recommended):\n\nIf you dont have python3 and pip installed on your system, or are not that much of PYTHON CODER, use this method\n\n- In your terminal-\n\n```bash\ncurl https://raw.githubusercontent.com/arghyagod-coder/lola/master/lolacli/install.sh | sudo bash -\n```\n\n- Now `lola` is ready to work!\n\n#### Method 2\n\nIf you have python and pip installed in your computer, execute the following\n\n```bash\npip3 install lolacli\n```\n\n## Supported Platforms:\n\n+ Operating System = Linux64\n    - Ubuntu 20.04 and Derivatives\n    - Mint 19.3\n    - Mint 20.1\n    - Debian 10 \n\n## Screenshots\n\n![](assets/help.png)\n\n![](assets/check-apps.png)\n\n![](assets/audacity-dl.png)\n\n### Guide\n\nEnter `sudo` mode first in the kernel\n\n```bash\nsudo su\n```\nIt will ask for your system password, enter your password and you will enter sudo mode\n\n- The help command\n\n```bash\n>lola --help\n\n\n  I am Lola! Your assistant who can help you setup your Linux in an easy way!\n  You can know more about me in https://github.com/arghyagod-coder/lola.\n\n  I can help you install apps through terminal, and you need to know almost\n  nothing about the terminal to do so! Just simple prompts will be enough\n\nOptions:\n  --version  Show the version and exit.\n  --help     Show this message and exit.\n\nCommands:\n  check-apps  Check the list of supported apps!\n  install     Install an app\n\n```\n\n- Check all supported apps in lola by using the `lola check-apps` command.\n\n```bash\n> lola check-apps\n\n\ngimp\nda-vinci-resolve\nwine\nlibreoffice-full\nkrita\nbrave-browser\nbrave-beta\nbrave-nightly\nedge-beta\nfirefox\nchrome\nlutris\ng-drive\nblender\npython3\nminiconda\nanaconda\npip3\njava-development-kit-11\njava-development-kit-14-oracle\nvscode\natom-editor\n...\n```\n\n- Install an app through lola with the `lola install <appname>` command\n\n```bash\n> lola install cheese\n\n\n--2021-05-25 13:16:45--  https://raw.githubusercontent.com/arghyagod-coder/lola/master/lolacli/scripts/cheese.sh\nResolving raw.githubusercontent.com (raw.githubusercontent.com)... 185.199.108.133, 185.199.111.133, 185.199.110.133, ...\nConnecting to raw.githubusercontent.com (raw.githubusercontent.com)|185.199.108.133|:443... connected.\nHTTP request sent, awaiting response... 200 OK\nLength: 53 [text/plain]\nSaving to: ‘cheese.sh’\n\ncheese.sh           100%[===================>]      53  --.-KB/s    in 0s      \n\n2021-05-25 13:16:48 (2.20 MB/s) - ‘cheese.sh’ saved [53/53]\n         \nHit:1 https://brave-browser-apt-release.s3.brave.com stable InRelease\nHit:2 http://packages.microsoft.com/repos/code stable InRelease                \nHit:3 http://security.ubuntu.com/ubuntu focal-security InRelease               \nHit:4 http://archive.canonical.com/ubuntu focal InRelease                      \nIgn:5 http://packages.linuxmint.com ulyssa InRelease                           \nHit:6 http://archive.ubuntu.com/ubuntu focal InRelease\nHit:7 http://archive.ubuntu.com/ubuntu focal-updates InRelease\nHit:8 http://packages.linuxmint.com ulyssa Release\nHit:10 http://archive.ubuntu.com/ubuntu focal-backports InRelease\nReading package lists... Done\nReading package lists... Done\nBuilding dependency tree       \nReading state information... Done\nThe following additional packages will be installed:\n  cheese-common gnome-video-effects libcheese-gtk25 libcheese8\nSuggested packages:\n  gnome-video-effects-frei0r gnome-video-effects-extra\nThe following NEW packages will be installed:\n  cheese cheese-common gnome-video-effects libcheese-gtk25 libcheese8\n0 upgraded, 5 newly installed, 0 to remove and 6 not upgraded.\nNeed to get 628 kB of archives.\nAfter this operation, 1,707 kB of additional disk space will be used.\nGet:1 http://archive.ubuntu.com/ubuntu focal-updates/main amd64 cheese-common all 3.34.0-1ubuntu1 [390 kB]\nGet:2 http://archive.ubuntu.com/ubuntu focal-updates/main amd64 libcheese8 amd64 3.34.0-1ubuntu1 [33.3 kB]\nGet:3 http://archive.ubuntu.com/ubuntu focal-updates/main amd64 libcheese-gtk25 amd64 3.34.0-1ubuntu1 [27.0 kB]\nGet:4 http://archive.ubuntu.com/ubuntu focal/main amd64 gnome-video-effects all 0.5.0-1ubuntu1 [38.8 kB]\nGet:5 http://archive.ubuntu.com/ubuntu focal-updates/main amd64 cheese amd64 3.34.0-1ubuntu1 [139 kB]\nFetched 628 kB in 16s (39.2 kB/s)                                              \nSelecting previously unselected package cheese-common.\n(Reading database ... 328427 files and directories currently installed.)\nPreparing to unpack .../cheese-common_3.34.0-1ubuntu1_all.deb ...\nUnpacking cheese-common (3.34.0-1ubuntu1) ...\nSelecting previously unselected package libcheese8:amd64.\nPreparing to unpack .../libcheese8_3.34.0-1ubuntu1_amd64.deb ...\nUnpacking libcheese8:amd64 (3.34.0-1ubuntu1) ...\nSelecting previously unselected package libcheese-gtk25:amd64.\nPreparing to unpack .../libcheese-gtk25_3.34.0-1ubuntu1_amd64.deb ...\nUnpacking libcheese-gtk25:amd64 (3.34.0-1ubuntu1) ...\nSelecting previously unselected package gnome-video-effects.\nPreparing to unpack .../gnome-video-effects_0.5.0-1ubuntu1_all.deb ...\nUnpacking gnome-video-effects (0.5.0-1ubuntu1) ...\nSelecting previously unselected package cheese.\nPreparing to unpack .../cheese_3.34.0-1ubuntu1_amd64.deb ...\nUnpacking cheese (3.34.0-1ubuntu1) ...\nSetting up gnome-video-effects (0.5.0-1ubuntu1) ...\nSetting up cheese-common (3.34.0-1ubuntu1) ...\nProcessing triggers for bamfdaemon (0.5.3+18.04.20180207.2-0ubuntu2) ...\nRebuilding /usr/share/applications/bamf-2.index...\nProcessing triggers for desktop-file-utils (0.24+linuxmint1) ...\nProcessing triggers for mime-support (3.64ubuntu1) ...\nProcessing triggers for hicolor-icon-theme (0.17-2) ...\nProcessing triggers for gnome-menus (3.36.0-1ubuntu1) ...\nProcessing triggers for libglib2.0-0:amd64 (2.64.6-1~ubuntu20.04.3) ...\nProcessing triggers for libc-bin (2.31-0ubuntu9.2) ...\nProcessing triggers for man-db (2.9.1-1) ...\nSetting up libcheese8:amd64 (3.34.0-1ubuntu1) ...\nSetting up libcheese-gtk25:amd64 (3.34.0-1ubuntu1) ...\nSetting up cheese (3.34.0-1ubuntu1) ...\nProcessing triggers for libc-bin (2.31-0ubuntu9.2) ...\n\n```\n\n## Developer Tools\n\n- [Python 3.8.5](https://www.python.org/ftp/python/3.8.5/Python-3.8.5.tar.xz)\n- [Sublime Text 3](https://www.sublimetext.com/3)\n- [Visual Studio Code](https://code.visualstudio.com)\n- [Git](https://git-scm.com/) \n- [Python Poetry](https://python-poetry.org/) for package management and publishing\n\n## Release Notes\n\n- **Current Release- 0.2.1**\n\n### What's new?\n\n- Larger app support\n- Improved README\n- Fixed Installation Script\n- Fixed the 'File not Found' error\n\n#### Developers\n- \n\n## License\n\nLicense © 2021-Present Arghya Sarkar\n\nThis repository is licensed under the MIT license. See [LICENSE](https://github.com/arghyagod-coder/lola/master/LICENSE) for details.\n\n## Special Notes\n\n- Contribution is appreciated! Visit the contribution guide in \n- If you don't find an app in the supported app list, file an issue in [the issue page](https://github.com/arghyagod-coder/lola/issues). Issues aren't ignored by the developers\n- Thanks for seeing my project!",
    'author': 'Arghya Sarkar',
    'author_email': 'arghyasarkar.joker@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/arghyagod-coder/lola',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
