from .fun import ispump

import IPython,os,time,copy
import pandas as pd
import numpy as np
import warnings; warnings.filterwarnings("ignore")
from matplotlib import pyplot as plt

class plot(object):

    def demo():
        demostr = '''
import clubear as cb
#clubear.csv is generated by cb.manager.demo()
pm=cb.pump('clubear.csv')
pm.qlist=['height','logsales','price','weight']
pt=cb.plot(pm)
pt.hist('logsales')
pt.size('region')
pt.mu(y='logsales',x='region')
pt.sd(y='logsales',x='gender')
'''
        print(demostr)

    def __init__(self, pm):
        self.pm = pm
        
        '''check whether the input is a pump first'''
        pump_check=ispump(self.pm)
        if pump_check != 'YES': print(pump_check); return
        self.Hist=[];self.Mu=[];self.Std=[];self.Size=[]
        
    def hist(self,x='',niter=10,xrange=[99,-99]):
        '''check whether the input is a pump first'''
        df=self.pm.go();heads=list(df.columns) 
        if not isinstance(niter,int): print('plot.hist: The niter must be an int.'); return
        if niter<1: print('plot.hist: The niter should be no less than 1.'); return
        if not isinstance(x,str): print('plot.hist: The input x should be str.'); return
        x=x.strip()
        if len(x)==0: print('plot.hist: The input x cannot be empty.'); return
        if x not in heads: print('plot.hist: The input x was not found in pump df.'); return
        if df.dtypes[x]=='object': print('plot.hist: The input x is found to be non-numeric.'); return
        xval=list(df[x]);
        if not isinstance(xrange,list): print('plot.hist: The xrange must be a list.'); return
        if len(xrange)!=2: print('plot.hist: The lenth of xrange must be TWO.'); return
        xmin=xrange[0];xmax=xrange[1]
        if not isinstance(xmin,float)|isinstance(xmin,int): print('plot.hist: The xmin must be numeric.'); return
        if not isinstance(xmax,float)|isinstance(xmax,int): print('plot.hist: The xmax must be numeric.'); return
        if xmin>xmax: xmin=np.nanmin(xval);xmax=np.nanmax(xval);
        width=xmax-xmin
        if width<=0: print('plot.hist: An valid (xmin,xmax) range cannot be produced.'); return

        nc=30;nr=20;
        freq=np.zeros(nc+2)
        MyMin=np.zeros(niter)
        MyMax=np.zeros(niter)
        start_time=time.time()
        for n in range(niter):
            xval=self.pm.go()[x]
            MyMin[n]=np.nanmin(xval)
            MyMax[n]=np.nanmax(xval)
            xval=(xval-xmin)/width
            xval=list(np.round(xval*nc))
            xval=[each+1 for each in xval]
            xval=[np.max([0,each]) for each in xval]
            xval=[np.min([nc+1,each]) for each in xval]
            myfreq=[xval.count(each) for each in range(nc+2)]
            freq=freq+myfreq
            percent=freq/np.sum(freq)

            '''compute the dynamic range'''
            Min=np.nanmin(MyMin[:(n+1)])
            Max=np.nanmax(MyMax[:(n+1)])

            '''output to screen for interactive analysis'''
            end_time=time.time();elapse_time=end_time-start_time            
            IPython.display.clear_output(wait=True)            
            pd.set_option('display.float_format', lambda x: '%.2f' % x)
            fig,ax = plt.subplots()
            fig.set_figwidth(15)
            fig.set_figheight(7.5)
            
            yval=percent;xval=list(range(len(yval)))
            xticks=[int((len(xval)-1)*each/5) for each in list(range(6))]
            xlabs=[each/(nc+1)*(xmax-xmin)+xmin for each in xticks]
            xlabs=[np.round(each,2) for each in xlabs]
            ax.set_xticklabels(xlabs);ax.set_xticks(xticks)
            mytitle=x+':    '+'(xmin,xmax)='+str((xmin,xmax))+';    (Min,Max)='+str((Min,Max))
            ax.set_title(mytitle)
            
            progress = np.round((n+1)/niter*100, 2)
            titlestr='Task accomplished ='+str(n+1)+'/'+str(niter)+';    '
            titlestr=titlestr+'Time elapsed ='+str(np.round(elapse_time,3))+'seconds.'
            ax.set_xlabel(titlestr)
            ax.bar(xval, yval) 
            plt.show()    
            
        self.Hist=freq
        
    def mu(self,y='',x='',niter=10):
        '''check whether the input is a pump first'''
        df=self.pm.go();heads=list(df.columns) 
        if not isinstance(x,str): print('plot.mu: The input x should be str.'); return
        if not isinstance(y,str): print('plot.mu: The input y should be str.'); return
        x=x.strip();y=y.strip()
        if len(x)==0: print('plot.mu: The input x cannot be empty.'); return
        if len(y)==0: print('plot.mu: The input y cannot be empty.'); return
        if x not in heads: print('plot.mu: The input x was not found in pump df.'); return
        if y not in heads: print('plot.mu: The input y was not found in pump df.'); return
        if df.dtypes[y]=='object': print('plot.mu: The input y is found not numeric.'); return
        if not isinstance(niter,int): print('plot.mu: The niter must be an int.'); return
        if niter<1: print('plot.mu: The niter should be no less than 1.'); return
        xval=df[x];levels=list(set(xval));nlevels=len(levels);dtype=str(df.dtypes[x])
        if nlevels>50: print('plot.mu: Too many levels in x please double check.'); return
        
        start_time=time.time()
        SUM=pd.Series(np.zeros(nlevels),levels)        
        SIZE=pd.Series(np.zeros(nlevels),levels)        
        for n in range(niter):
            df=self.pm.go()[[x,y]]
            
            flag=list(np.abs(df[y])>0)
            df=df.iloc[flag]
            df=df.groupby(x)
            
            mysum=df.sum(); mysum=pd.Series(mysum[y],mysum.index)            
            newindex=sorted(list(set(SUM.index)|set(mysum.index)))
            S1=pd.Series(np.zeros(len(newindex)),newindex)
            S2=pd.Series(np.zeros(len(newindex)),newindex)
            S1[SUM.index]=SUM;S2[mysum.index]=mysum;SUM=S1+S2
           
            mysize=df.size(); #a Series already
            newindex=sorted(list(set(SIZE.index)|set(mysize.index)))
            S1=pd.Series(np.zeros(len(newindex)),newindex)
            S2=pd.Series(np.zeros(len(newindex)),newindex)
            S1[SIZE.index]=SIZE;S2[mysize.index]=mysize;SIZE=S1+S2
            
            MU=SUM/SIZE

            '''ready for dynamic outputs'''
            end_time=time.time();elapse_time=end_time-start_time            
            IPython.display.clear_output(wait=True)            
            pd.set_option('display.float_format', lambda x: '%.1f' % x)
            fig,ax = plt.subplots(); fig.set_figwidth(15); fig.set_figheight(7.5)
            
            yval=list(MU);xval=list(range(len(yval)))
            xlabs=MU.index;xlabs=[str(each) for each in xlabs]
            ax.set_xticklabels(xlabs);ax.set_xticks(xval)
            
            progress = np.round((n+1)/niter*100, 2)
            titlestr='Task accomplished ='+str(n+1)+'/'+str(niter)+';    '
            titlestr=titlestr+'Time elapsed ='+str(np.round(elapse_time,3))+'seconds.'
            ax.set_title(titlestr)
            ax.set_xlabel(x+' <'+dtype+'>')
            ax.set_ylabel('mu: '+y)
            ax.bar(xval, yval) 
            plt.show() 
            
        self.Mu=MU

    def std(self,y='',x='',niter=10):
        '''check whether the input is a pump first'''
        df=self.pm.go();heads=list(df.columns) 
        if not isinstance(x,str): print('plot.std: The input x should be str.'); return
        if not isinstance(y,str): print('plot.std: The input y should be str.'); return
        x=x.strip();y=y.strip()
        if len(x)==0: print('plot.std: The input x cannot be empty.'); return
        if len(y)==0: print('plot.std: The input y cannot be empty.'); return
        if x not in heads: print('plot.std: The input x was not found in pump df.'); return
        if y not in heads: print('plot.std: The input y was not found in pump df.'); return
        if df.dtypes[y]=='object': print('plot.std: The input y is found not numeric.'); return
        if not isinstance(niter,int): print('plot.std: The niter must be an int.'); return
        if niter<1: print('plot.std: The niter should be no less than 1.'); return
        xval=df[x];levels=list(set(xval));nlevels=len(levels);dtype=str(df.dtypes[x])
        if nlevels>50: print('plot.std: Too many levels in x please double check.'); return
        
        start_time=time.time()
        SUM=pd.Series(np.zeros(nlevels),levels)        
        SUM2=pd.Series(np.zeros(nlevels),levels)        
        SIZE=pd.Series(np.zeros(nlevels),levels)       
        for n in range(niter):
            df=self.pm.go()[[x,y]];
            
            df2=copy.deepcopy(df);df2[y]=df2[y]**2
            flag=list((np.abs(df[y])>0)*(np.abs(df2[y])>0))
            df=df.iloc[flag];df2=df2.iloc[flag]
            df=df.groupby(x);df2=df2.groupby(x)
            
            mysum=df.sum(); mysum=pd.Series(mysum[y],mysum.index)            
            newindex=sorted(list(set(SUM.index)|set(mysum.index)))
            S1=pd.Series(np.zeros(len(newindex)),newindex)
            S2=pd.Series(np.zeros(len(newindex)),newindex)
            S1[SUM.index]=SUM;S2[mysum.index]=mysum;SUM=S1+S2
           
            mysum=df2.sum(); mysum=pd.Series(mysum[y],mysum.index)            
            newindex=sorted(list(set(SUM.index)|set(mysum.index)))
            S1=pd.Series(np.zeros(len(newindex)),newindex)
            S2=pd.Series(np.zeros(len(newindex)),newindex)
            S1[SUM2.index]=SUM2;S2[mysum.index]=mysum;SUM2=S1+S2
            
            mysize=df.size(); #a Series already
            newindex=sorted(list(set(SIZE.index)|set(mysize.index)))
            S1=pd.Series(np.zeros(len(newindex)),newindex)
            S2=pd.Series(np.zeros(len(newindex)),newindex)
            S1[SIZE.index]=SIZE;S2[mysize.index]=mysize;SIZE=S1+S2
            
            MU=SUM/SIZE; MU2=SUM2/SIZE; SD=np.sqrt(MU2-MU**2)

            '''ready for dynamic outputs'''
            end_time=time.time();elapse_time=end_time-start_time            
            IPython.display.clear_output(wait=True)            
            pd.set_option('display.float_format', lambda x: '%.1f' % x)
            fig,ax = plt.subplots(); fig.set_figwidth(15); fig.set_figheight(7.5)
            
            yval=list(SD);xval=list(range(len(yval)))
            xlabs=MU.index;xlabs=[str(each) for each in xlabs]
            ax.set_xticklabels(xlabs);ax.set_xticks(xval)
            
            progress = np.round((n+1)/niter*100, 2)
            titlestr='Task accomplished ='+str(n+1)+'/'+str(niter)+';    '
            titlestr=titlestr+'Time elapsed ='+str(np.round(elapse_time,3))+'seconds.'
            ax.set_title(titlestr)
            ax.set_xlabel(x+' <'+dtype+'>')
            ax.set_ylabel('sd: '+y)
            ax.bar(xval, yval) 
            plt.show() 
            
        self.Std=SD

    def size(self,x='',niter=10):
        '''check whether the input is a pump first'''
        df=self.pm.go();heads=list(df.columns)
        if not isinstance(x,str): print('plot.size: The input x should be str.'); return
        x=x.strip();
        if len(x)==0: print('plot.size: The input x cannot be empty.'); return
        if x not in heads: print('plot.size: The input x was not found in pump df.'); return
        if not isinstance(niter,int): print('plot.size: The niter must be an int.'); return
        if niter<1: print('plot.size: The niter should be no less than 1.'); return
        xval=list(df[x]);levels=sorted(list(set(xval)));nlevels=len(levels);dtype=str(df.dtypes[x])
        if nlevels>50: print('plot.size: Too many levels in x please double check.'); return
                
        start_time=time.time()
        SIZE=pd.Series(np.zeros(nlevels),levels)        
        for n in range(niter):
            df=self.pm.go()[[x]];
            df=df.groupby(x);
            
            mysize=df.size(); #a Series already
            newindex=sorted(list(set(SIZE.index)|set(mysize.index)))
            S1=pd.Series(np.zeros(len(newindex)),newindex)
            S2=pd.Series(np.zeros(len(newindex)),newindex)
            S1[SIZE.index]=SIZE;S2[mysize.index]=mysize;SIZE=S1+S2

            end_time=time.time();elapse_time=end_time-start_time            
            IPython.display.clear_output(wait=True)            
            pd.set_option('display.float_format', lambda x: '%.1f' % x)
            fig,ax = plt.subplots()
            fig.set_figwidth(15)
            fig.set_figheight(7.5)
            
            percent=SIZE/np.sum(SIZE)
            yval=list(percent)
            xval=list(range(len(yval)))
            xlabs=SIZE.index;xlabs=[str(each) for each in xlabs]
            ax.set_xticklabels(xlabs)
            ax.set_xticks(xval)
            
            progress = np.round((n+1)/niter*100, 2)
            titlestr='Task accomplished ='+str(n+1)+'/'+str(niter)+';    '
            titlestr=titlestr+'Time elapsed ='+str(np.round(elapse_time,3))+'seconds.'
            ax.set_title(titlestr)
            ax.set_xlabel(x+' <'+dtype+'>')
            ax.set_ylabel('Relative Size')
            ax.bar(xval, yval) 
            plt.show() 
            
        self.Size=percent
