# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['abilian',
 'abilian.cli',
 'abilian.core',
 'abilian.core.extensions',
 'abilian.core.models',
 'abilian.core.models.tests',
 'abilian.core.tests',
 'abilian.services',
 'abilian.services.activity',
 'abilian.services.antivirus',
 'abilian.services.audit',
 'abilian.services.auth',
 'abilian.services.conversion',
 'abilian.services.image',
 'abilian.services.image.tests',
 'abilian.services.indexing',
 'abilian.services.indexing.tests',
 'abilian.services.preferences',
 'abilian.services.repository',
 'abilian.services.sandbox',
 'abilian.services.security',
 'abilian.services.settings',
 'abilian.services.tagging',
 'abilian.services.viewtracker',
 'abilian.services.vocabularies',
 'abilian.testing',
 'abilian.web',
 'abilian.web.admin',
 'abilian.web.admin.panels',
 'abilian.web.admin.panels.groups',
 'abilian.web.admin.panels.users',
 'abilian.web.assets',
 'abilian.web.attachments',
 'abilian.web.comments',
 'abilian.web.coreviews',
 'abilian.web.forms',
 'abilian.web.preferences',
 'abilian.web.preferences.tests',
 'abilian.web.search',
 'abilian.web.setupwizard',
 'abilian.web.tags',
 'abilian.web.tests',
 'abilian.web.tools',
 'abilian.web.uploads',
 'abilian.web.views',
 'abilian.web.views.tests']

package_data = \
{'': ['*'],
 'abilian': ['translations/*',
             'translations/de_DE/LC_MESSAGES/messages.po',
             'translations/en/LC_MESSAGES/messages.po',
             'translations/es/LC_MESSAGES/messages.po',
             'translations/es_ES/LC_MESSAGES/messages.po',
             'translations/fr/LC_MESSAGES/messages.po',
             'translations/fr_FR/LC_MESSAGES/messages.po',
             'translations/id_ID/LC_MESSAGES/messages.po',
             'translations/it_IT/LC_MESSAGES/messages.po',
             'translations/nl/LC_MESSAGES/messages.po',
             'translations/nl_NL/LC_MESSAGES/messages.po',
             'translations/pt_BR/LC_MESSAGES/messages.po',
             'translations/pt_PT/LC_MESSAGES/messages.po',
             'translations/tr_TR/LC_MESSAGES/messages.po',
             'translations/zh_CN/LC_MESSAGES/messages.po',
             'translations/zh_TW/LC_MESSAGES/messages.po'],
 'abilian.services.auth': ['templates/login/*', 'templates/login/email/*'],
 'abilian.services.conversion': ['dummy_files/*'],
 'abilian.services.vocabularies': ['templates/admin/*',
                                   'templates/admin/macros/*'],
 'abilian.web': ['resources/bootbox/*',
                 'resources/bootstrap-datepicker/css/*',
                 'resources/bootstrap-datepicker/js/*',
                 'resources/bootstrap-datepicker/js/locales/*',
                 'resources/bootstrap-datepicker/less/*',
                 'resources/bootstrap-switch/*',
                 'resources/bootstrap-switch/less/bootstrap3/*',
                 'resources/bootstrap-timepicker/css/*',
                 'resources/bootstrap-timepicker/js/*',
                 'resources/bootstrap-timepicker/less/*',
                 'resources/bootstrap/fonts/*',
                 'resources/bootstrap/js/*',
                 'resources/bootstrap/less/*',
                 'resources/bootstrap/less/mixins/*',
                 'resources/ckeditor/*',
                 'resources/ckeditor/adapters/*',
                 'resources/ckeditor/lang/*',
                 'resources/ckeditor/plugins/*',
                 'resources/ckeditor/plugins/a11yhelp/dialogs/*',
                 'resources/ckeditor/plugins/a11yhelp/dialogs/lang/*',
                 'resources/ckeditor/plugins/about/dialogs/*',
                 'resources/ckeditor/plugins/about/dialogs/hidpi/*',
                 'resources/ckeditor/plugins/autolink/*',
                 'resources/ckeditor/plugins/bootstrapVisibility/*',
                 'resources/ckeditor/plugins/bootstrapVisibility/lang/*',
                 'resources/ckeditor/plugins/clipboard/dialogs/*',
                 'resources/ckeditor/plugins/colordialog/dialogs/*',
                 'resources/ckeditor/plugins/dialog/*',
                 'resources/ckeditor/plugins/div/dialogs/*',
                 'resources/ckeditor/plugins/find/dialogs/*',
                 'resources/ckeditor/plugins/flash/dialogs/*',
                 'resources/ckeditor/plugins/flash/images/*',
                 'resources/ckeditor/plugins/forms/dialogs/*',
                 'resources/ckeditor/plugins/forms/images/*',
                 'resources/ckeditor/plugins/iframe/dialogs/*',
                 'resources/ckeditor/plugins/iframe/images/*',
                 'resources/ckeditor/plugins/image/dialogs/*',
                 'resources/ckeditor/plugins/image/images/*',
                 'resources/ckeditor/plugins/link/dialogs/*',
                 'resources/ckeditor/plugins/link/images/*',
                 'resources/ckeditor/plugins/link/images/hidpi/*',
                 'resources/ckeditor/plugins/liststyle/dialogs/*',
                 'resources/ckeditor/plugins/magicline/images/*',
                 'resources/ckeditor/plugins/magicline/images/hidpi/*',
                 'resources/ckeditor/plugins/pagebreak/images/*',
                 'resources/ckeditor/plugins/pastefromword/filter/*',
                 'resources/ckeditor/plugins/preview/*',
                 'resources/ckeditor/plugins/scayt/*',
                 'resources/ckeditor/plugins/scayt/dialogs/*',
                 'resources/ckeditor/plugins/showblocks/images/*',
                 'resources/ckeditor/plugins/smiley/dialogs/*',
                 'resources/ckeditor/plugins/smiley/images/*',
                 'resources/ckeditor/plugins/specialchar/dialogs/*',
                 'resources/ckeditor/plugins/specialchar/dialogs/lang/*',
                 'resources/ckeditor/plugins/table/dialogs/*',
                 'resources/ckeditor/plugins/tabletools/dialogs/*',
                 'resources/ckeditor/plugins/templates/dialogs/*',
                 'resources/ckeditor/plugins/templates/templates/*',
                 'resources/ckeditor/plugins/templates/templates/images/*',
                 'resources/ckeditor/plugins/wsc/*',
                 'resources/ckeditor/plugins/wsc/dialogs/*',
                 'resources/ckeditor/samples/*',
                 'resources/ckeditor/samples/css/*',
                 'resources/ckeditor/samples/img/*',
                 'resources/ckeditor/samples/js/*',
                 'resources/ckeditor/samples/old/*',
                 'resources/ckeditor/samples/old/assets/*',
                 'resources/ckeditor/samples/old/assets/inlineall/*',
                 'resources/ckeditor/samples/old/assets/outputxhtml/*',
                 'resources/ckeditor/samples/old/assets/uilanguages/*',
                 'resources/ckeditor/samples/old/dialog/*',
                 'resources/ckeditor/samples/old/dialog/assets/*',
                 'resources/ckeditor/samples/old/enterkey/*',
                 'resources/ckeditor/samples/old/htmlwriter/*',
                 'resources/ckeditor/samples/old/htmlwriter/assets/outputforflash/*',
                 'resources/ckeditor/samples/old/magicline/*',
                 'resources/ckeditor/samples/old/toolbar/*',
                 'resources/ckeditor/samples/old/wysiwygarea/*',
                 'resources/ckeditor/samples/toolbarconfigurator/*',
                 'resources/ckeditor/samples/toolbarconfigurator/css/*',
                 'resources/ckeditor/samples/toolbarconfigurator/font/*',
                 'resources/ckeditor/samples/toolbarconfigurator/js/*',
                 'resources/ckeditor/samples/toolbarconfigurator/lib/codemirror/*',
                 'resources/ckeditor/skins/moono/*',
                 'resources/ckeditor/skins/moono/images/*',
                 'resources/ckeditor/skins/moono/images/hidpi/*',
                 'resources/datatables/css/*',
                 'resources/datatables/images/*',
                 'resources/datatables/js/*',
                 'resources/fileapi/*',
                 'resources/fileapi/plugins/*',
                 'resources/font-awesome/css/*',
                 'resources/font-awesome/fonts/*',
                 'resources/font-awesome/less/*',
                 'resources/font-awesome/scss/*',
                 'resources/highlightjs/*',
                 'resources/img/abilian.png',
                 'resources/img/abilian.png',
                 'resources/img/abilian.png',
                 'resources/img/abilian.png',
                 'resources/img/avatar-default.png',
                 'resources/img/avatar-default.png',
                 'resources/img/avatar-default.png',
                 'resources/img/avatar-default.png',
                 'resources/img/logo-abilian-32x32.png',
                 'resources/img/logo-abilian-32x32.png',
                 'resources/img/logo-abilian-32x32.png',
                 'resources/img/logo-abilian-32x32.png',
                 'resources/img/logo-abilian.png',
                 'resources/img/logo-abilian.png',
                 'resources/img/logo-abilian.png',
                 'resources/img/logo-abilian.png',
                 'resources/jquery/js/*',
                 'resources/js/*',
                 'resources/js/widgets/*',
                 'resources/less/*',
                 'resources/nvd3/*',
                 'resources/requirejs/*',
                 'resources/select2/*',
                 'resources/typeahead/*',
                 'templates/*',
                 'templates/debug_panels/*',
                 'templates/default/*',
                 'templates/macros/*',
                 'templates/preferences/*',
                 'templates/widgets/*'],
 'abilian.web.admin': ['templates/admin/*'],
 'abilian.web.search': ['templates/search/*'],
 'abilian.web.setupwizard': ['templates/setupwizard/*'],
 'abilian.web.tags': ['templates/admin/*']}

install_requires = \
['Flask-Assets>=0.12',
 'Flask-Babel>=0.11',
 'Flask-Login>=0.4',
 'Flask-Mail>=0.9.1',
 'Flask-Migrate>=2.0',
 'Flask-Talisman>=0.6',
 'Flask-WTF>=0.12,<0.13',
 'Flask>=1.0,<2.0',
 'MarkupSafe>=0.21',
 'PyYAML',
 'SQLAlchemy>=1.1,<2.0',
 'WTForms-Alchemy>=0.12',
 'Whoosh>=2.5,<3.0',
 'alembic>=0.9',
 'bcrypt',
 'bleach>=2',
 'celery>=4,<5',
 'clamd',
 'closure',
 'cssmin',
 'deprecated',
 'devtools>=0.5.1,<0.6.0',
 'flask-sqlalchemy<=2.1',
 'hyperlink',
 'jsmin',
 'lxml',
 'pandas>=0.17',
 'pathlib',
 'pillow',
 'pygeoip',
 'python-dateutil>=2.4.0,<3.0.0',
 'python-magic',
 'redis>=3,<4',
 'sentry-sdk[flask]',
 'sqlparse',
 'tqdm',
 'webassets<2',
 'werkzeug<1',
 'wtforms-sqlalchemy']

setup_kwargs = {
    'name': 'abilian-core',
    'version': '0.11.10',
    'description': 'A framework for enterprise applications (CRM, ERP, collaboration...), based on Flask and SQLAlchemy',
    'long_description': 'About\n=====\n\n.. image:: https://api.travis-ci.org/abilian/abilian-core.png\n   :target: https://travis-ci.org/abilian/abilian-core\n\n.. image:: https://coveralls.io/repos/abilian/abilian-core/badge.png?branch=master\n   :target: https://coveralls.io/r/abilian/abilian-core?branch=master\n\n.. image:: https://static.pepy.tech/badge/abilian-core\n   :target: https://pepy.tech/project/abilian-core\n\n\nAbilian Core is an enterprise application development platform based on the `Flask micro-framework <http://flask.pocoo.org/>`_, the `SQLAlchemy ORM <http://www.sqlalchemy.org/>`_, good intentions and best practices (for some value of "best").\n\nThe full documentation is available on http://docs.abilian.com/.\n\n\nGoals & principles\n------------------\n\n- Development must be easy and fun (some some definition of "easy" and "fun", of course)\n\n- The less code (and configuration) we write, the better\n\n- Leverage existing reputable open source libraries and frameworks, such as SQLAlchemy and Flask\n\n- It must lower errors, bugs, project\'s time to deliver. It\'s intended to be a rapid application development tool\n\n- It must promote best practices in software development, specially Test-Driven Development (as advocated by the `GOOS book <http://www.amazon.com/gp/product/0321503627/>`_)\n\n\nFeatures\n--------\n\nHere\'s a short list of features that you may find appealing in Abilian:\n\nInfrastructure\n^^^^^^^^^^^^^^\n\n-  Plugin framework\n\n-  Asynchronous tasks (using `Celery <http://www.celeryproject.org/>`_)\n\n-  Security model and service\n\nDomain model and services\n^^^^^^^^^^^^^^^^^^^^^^^^^\n\n-  Persistent domain object model, based on SQLAlchemy\n\n-  Audit\n\nContent management and services\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\n-  Simple file-based content repository\n\n-  Indexing service\n\n-  Document preview and transformation\n\nSocial\n^^^^^^\n\n-  Users, groups and social graph (followers)\n\n-  Activity streams\n\nUser Interface and API\n^^^^^^^^^^^^^^^^^^^^^^\n\n-  Forms (based on `WTForms <http://wtforms.simplecodes.com/>`_)\n\n-  CRUD (Create, Retrieve, Edit/Update, Remove) interface from domain\n   models\n\n-  Labels and descriptions for each field\n\n-  Various web utilities: view decorators, class-based views, Jinja2\n   filters, etc.\n\n-  A default UI based on `Bootstrap 3 <http://getbootstrap.com/>`_ and\n   several carefully selected jQuery plugins such as\n   `Select2 <http://ivaynberg.github.io/select2/>`_\n\n-  REST and AJAX API helpers\n\n-  i18n: support for multi-language via Babel, with multiple translation\n   dictionaries\n\nManagement and admin\n^^^^^^^^^^^^^^^^^^^^\n\n-  Initial settings wizard\n\n-  Admin and user settings framework\n\n-  System monitoring (using `Sentry <https://getsentry.com/welcome/>`_)\n\nCurrent status\n--------------\n\nAbilian Core is currently alpha software, in terms of API stability.\n\nIt is currently used in several applications that have been developped\nby `Abilian <http://www.abilian.com/>`_ over the last two years:\n\n-  `Abilian SBE (Social Business Engine)\n   <https://github.com/abilian/abilian-sbe/>`_ - an enterprise 2.0\n   (social collaboration) platform\n\n-  Abilian EMS (Event Management System)\n\n-  Abilian CRM (Customer / Contact / Community Relationship Management\n   System)\n\n-  Abilian Le MOOC - a MOOC prototype\n\n-  Abilian CMS - a Web CMS\n\nIn other words, Abilian Core is the foundation for a small, but growing,\nfamily of business-critical applications that our customers intend us to\nsupport in the coming years.\n\nSo while Abilian Core APIs, object model and even architecture, may (and\nmost probably will) change due to various refactorings that are expected\nas we can\'t be expected to ship perfect software on the firt release, we\nalso intend to treat it as a valuable business asset and keep\nmaintaining and improving it in the foreseeable future.\n\nRoadmap & getting involved\n--------------------------\n\nIf you need help or for general discussions about the Abilian Platform, we\nrecommend joing the `Abilian Users\n<https://groups.google.com/forum/#!forum/abilian-users>`_ forum on Google\nGroups.\n\nWe have a `roadmap on Pivotal\nTracker <https://www.pivotaltracker.com/s/projects/878951>`_ that we use\ninternally to manage our iterative delivery process.\n\nFor features and bug requests (or is it the other way around?), we\nrecommend that you use the `GitHub issue\ntracker <https://github.com/abilian/abilian-core/issues>`_.\n\n\nInstall\n=======\n\nIf you are a Python web developer (which is the primary target for this\nproject), you probably already know about:\n\n-  Python 2.7\n-  Virtualenv\n-  Poetry (https://poetry.eustace.io/)\n\nSo, after you have created and activated a virtualenv for the project,\njust run::\n\n    poetry\n\nTo use some features of the library, namely document and images\ntransformation, you will need to install the additional native packages,\nusing our operating system\'s package management tools (``dpkg``,\n``yum``, ``brew``...):\n\n-  A few image manipulation libraries (``libpng``, ``libjpeg``)\n-  The ``poppler-utils``, ``unoconv``, ``LibreOffice``, ``ImageMagick``\n   utilities\n\nLook at the ``fabfile.py`` for the exact list.\n\n\nTesting\n=======\n\nAbilian Core come with a full unit and integration testing suite. You\ncan run it with ``make test`` (once your virtualenv has been activated and\nall required dependencies have been installed, see above).\n\nAlternatively, you can use ``tox`` to run the full test suite in an\nisolated environment.\n\n\nLicence\n=======\n\nAbilian Core is licensed under the LGPL.\n\n\nCredits\n=======\n\nAbilian Core has been created by the development team at Abilian\n(currently: Stefane and Bertrand), with financial support from our\nwonderful customers, and R&D fundings from the French Government, the\nParis Region and the European Union.\n\nWe are also specially grateful to:\n\n-  `Armin Ronacher <http://lucumr.pocoo.org/>`_ for his work on Flask.\n-  `Michael Bayer <http://techspot.zzzeek.org/>`_ for his work on\n   SQLAlchemy.\n-  Everyone who has been involved with and produced open source software\n   for the Flask ecosystem (Kiran Jonnalagadda and the\n   `HasGeek <https://hasgeek.com/>`_ team, Max Countryman, Matt Wright,\n   Matt Good, Thomas Johansson, James Crasta, and probably many others).\n-  The creators of Django, Pylons, TurboGears, Pyramid and Zope, for\n   even more inspiration.\n-  The whole Python community.\n\nLinks\n=====\n\n- `Discussion list (Google Groups) <https://groups.google.com/forum/#!forum/abilian-users>`_\n- `Documentation <http://docs.abilian.com/>`_\n- `GitHub repository <https://github.com/abilian/abilian-core>`_\n- `Corporate support <http://www.abilian.com>`_\n',
    'author': 'Abilian SAS',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/abilian/abilian-core',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
