# coding: utf-8

"""
    Veeroute.LSS Lastmile

    Veeroute.LSS Lastmile API  # noqa: E501

    The version of the OpenAPI document: 3.8.168680
    Contact: support@veeroute.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import unittest
import datetime

import vrt_lss_lastmile
from vrt_lss_lastmile.models.analytics_task import AnalyticsTask  # noqa: E501
from vrt_lss_lastmile.rest import ApiException

class TestAnalyticsTask(unittest.TestCase):
    """AnalyticsTask unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional):
        """Test AnalyticsTask
            include_option is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        # model = vrt_lss_lastmile.models.analytics_task.AnalyticsTask()  # noqa: E501
        if include_optional :
            return AnalyticsTask(
                plan_task = vrt_lss_lastmile.models.plan_task.PlanTask(
                    locations = [
                        vrt_lss_lastmile.models.advanced_location.AdvancedLocation(
                            key = 'location01', 
                            location = vrt_lss_lastmile.models.location.Location(
                                latitude = 55.692789, 
                                longitude = 37.554554, 
                                arrival_duration = 15, 
                                departure_duration = 5, ), 
                            transport_restrictions = ["2T"], 
                            load_windows = [
                                vrt_lss_lastmile.models.load_window.LoadWindow(
                                    time_window = vrt_lss_lastmile.models.time_window.TimeWindow(
                                        from = '2021-02-21T09:30+03:00', 
                                        to = '2021-02-21T19:45Z', ), 
                                    gates_count = 1, )
                                ], 
                            attributes = ["Name:X51"], )
                        ], 
                    orders = [
                        vrt_lss_lastmile.models.order.Order(
                            key = 'order01', 
                            order_features = ["Special"], 
                            order_restrictions = ["Special"], 
                            performer_restrictions = ["Special"], 
                            performer_blacklist = ["A0"], 
                            cargos = [
                                vrt_lss_lastmile.models.cargo.Cargo(
                                    key = 'cargo01', 
                                    capacity = vrt_lss_lastmile.models.capacity.Capacity(
                                        mass = 10, 
                                        volume = 2, 
                                        capacity_x = 1, 
                                        capacity_y = 2, 
                                        capacity_z = 3, ), 
                                    rotation = ["ALL"], 
                                    width = 1, 
                                    height = 0.3, 
                                    length = 2.2, 
                                    max_storage_time = 60, 
                                    restrictions = ["Freezer"], 
                                    cargo_features = ["Clean"], 
                                    cargo_restrictions = ["Warm"], )
                                ], 
                            demands = [
                                vrt_lss_lastmile.models.demand.Demand(
                                    key = 'demand_1', 
                                    demand_type = 'WORK', 
                                    target_cargos = ["cargo01"], 
                                    precedence_in_trip = 1, 
                                    precedence_in_order = 1, 
                                    possible_events = [
                                        vrt_lss_lastmile.models.possible_event.PossibleEvent(
                                            key = 'event_1', 
                                            location_key = 'location01', 
                                            duration = 10, 
                                            reward = 199.9, 
                                            time_window = vrt_lss_lastmile.models.time_window.TimeWindow(
                                                from = '2021-02-21T09:30+03:00', 
                                                to = '2021-02-21T19:45Z', ), 
                                            soft_time_window = vrt_lss_lastmile.models.time_window.TimeWindow(
                                                from = '2021-02-21T09:30+03:00', 
                                                to = '2021-02-21T19:45Z', ), )
                                        ], 
                                    attributes = ["Name:X51"], )
                                ], 
                            attributes = ["Name:X51"], )
                        ], 
                    performers = [
                        vrt_lss_lastmile.models.performer.Performer(
                            key = 'performer0001', 
                            max_work_shifts = 3, 
                            performer_features = ["B1","Special"], 
                            transport_restrictions = ["B1"], 
                            own_transport_type = 'CAR', 
                            attributes = ["Name:X51"], )
                        ], 
                    transports = [
                        vrt_lss_lastmile.models.transport.Transport(
                            key = 'transport0001', 
                            transport_type = 'CAR', 
                            transport_features = ["20T"], 
                            performer_restrictions = ["Special"], 
                            boxes = [
                                vrt_lss_lastmile.models.box.Box(
                                    key = 'box01', 
                                    max_size = vrt_lss_lastmile.models.capacity.Capacity(
                                        mass = 10, 
                                        volume = 2, 
                                        capacity_x = 1, 
                                        capacity_y = 2, 
                                        capacity_z = 3, ), 
                                    width = 1, 
                                    height = 3.1, 
                                    length = 2.1, 
                                    features = ["Freezer"], )
                                ], 
                            attributes = ["Name:X51"], )
                        ], 
                    shifts = [
                        vrt_lss_lastmile.models.shift.Shift(
                            key = 'shift01', 
                            shift_type = 'PERFORMER', 
                            resource_key = 'performer01', 
                            availability_time = vrt_lss_lastmile.models.time_window.TimeWindow(
                                from = '2021-02-21T09:30+03:00', 
                                to = '2021-02-21T19:45Z', ), 
                            working_time = vrt_lss_lastmile.models.time_window.TimeWindow(
                                from = '2021-02-21T09:30+03:00', 
                                to = '2021-02-21T19:45Z', ), 
                            start_location_key = 'location01', 
                            finish_location_key = 'location01', 
                            max_locations = 15, 
                            tariff = vrt_lss_lastmile.models.universal_tariff.UniversalTariff(
                                cost_per_shift = 2000, 
                                constraints = [
                                    vrt_lss_lastmile.models.tariff_constraint.TariffConstraint(
                                        stage_length = 200000, 
                                        cost_per_unit = 1.5, )
                                    ], ), 
                            attributes = ["Name:X51"], )
                        ], 
                    hardlinks = [
                        vrt_lss_lastmile.models.hardlink.Hardlink(
                            key = 'group01', 
                            links = [
                                vrt_lss_lastmile.models.hardlink_element.HardlinkElement(
                                    type = 'ORDER', 
                                    entity_key = 'ord0001', )
                                ], )
                        ], 
                    trips = [
                        vrt_lss_lastmile.models.trip.Trip(
                            key = 'TRIP0001', 
                            assigned_shifts = [
                                vrt_lss_lastmile.models.assigned_shift.AssignedShift(
                                    shift_key = 'performer01', 
                                    shift_time = vrt_lss_lastmile.models.time_window.TimeWindow(
                                        from = '2021-02-21T09:30+03:00', 
                                        to = '2021-02-21T19:45Z', ), )
                                ], 
                            actions = [
                                vrt_lss_lastmile.models.trip_action.TripAction(
                                    order_key = 'order01', 
                                    demand_key = 'demand01.1', 
                                    event_key = 'location01', 
                                    location_key = 'location01', 
                                    todolist = [
                                        vrt_lss_lastmile.models.trip_job.TripJob(
                                            job_type = 'START_WORK', 
                                            job_time = '2021-05-21T09:30+03:00', )
                                        ], 
                                    cargo_placements = [
                                        vrt_lss_lastmile.models.cargo_placement.CargoPlacement(
                                            box_key = 'box01', 
                                            cargo_key = 'cargo01', )
                                        ], 
                                    attributes = ["Name:X51"], )
                                ], 
                            waitlist = ["order02"], 
                            start_location_key = 'location01', 
                            finish_location_key = 'location01', 
                            attributes = ["Name:X51"], )
                        ], 
                    settings = vrt_lss_lastmile.models.plan_settings.PlanSettings(
                        configuration = 'default', 
                        planning_time = 30, 
                        result_ttl = 10, 
                        result_timezone = 3, 
                        predict_slots = 2, 
                        transport_factor = [
                            vrt_lss_lastmile.models.transport_factor.TransportFactor(
                                transport_type = 'CAR', 
                                speed = 2.5, )
                            ], 
                        capacity_factor = [
                            vrt_lss_lastmile.models.capacity_factor.CapacityFactor(
                                transport_type = 'CAR', 
                                capacity = vrt_lss_lastmile.models.capacity.Capacity(
                                    mass = 10, 
                                    volume = 2, 
                                    capacity_x = 1, 
                                    capacity_y = 2, 
                                    capacity_z = 3, ), )
                            ], 
                        routing = [
                            vrt_lss_lastmile.models.routing.Routing(
                                transport_type = 'CAR', 
                                matrix = {"waypoints":[{"latitude":59.9345,"longitude":30.1504},{"latitude":59.942383,"longitude":30.258951},{"latitude":59.9545,"longitude":30.2004},{"latitude":59.89527,"longitude":30.261747},{"latitude":59.9745,"longitude":30.5004}],"distances":[[0,5822,1820,14130,23304],[5936,0,4931,8365,17731],[1819,4853,0,13161,22335],[14859,9056,13854,0,21440],[21777,16306,20772,19290,0]],"durations":[[0,13,7,24,36],[13,0,9,13,25],[7,9,0,21,32],[26,14,22,0,30],[34,23,30,28,0]]}, 
                                traffic_jams = [
                                    vrt_lss_lastmile.models.traffic_factor.TrafficFactor(
                                        time_window = vrt_lss_lastmile.models.time_window.TimeWindow(
                                            from = '2021-02-21T09:30+03:00', 
                                            to = '2021-02-21T19:45Z', ), 
                                        length_multiplier = 2, 
                                        length_additive = 20, 
                                        time_multiplier = 2, 
                                        time_additive = 30, )
                                    ], )
                            ], 
                        assumptions = vrt_lss_lastmile.models.plan_assumptions.PlanAssumptions(
                            toll_roads = False, 
                            ferry_crossing = False, 
                            flight_distance = True, 
                            disable_compatibility = True, 
                            disable_capacity = True, 
                            same_order_time_window = True, 
                            expand_shift_time_window = True, ), 
                        precision = 3, ), 
                    tracedata = vrt_lss_lastmile.models.trace_data.TraceData(
                        code = 'client_server_service_time_uuid', 
                        client = 'client_name', 
                        server = 'server_name', 
                        service = 'LASTMILE', 
                        method = 'PLAN', 
                        time = '2021-02-21T09:30+03:00', ), ), 
                plan_result = {"tracedata":{"code":"example_LssTestingPreview_LastmileServicePlanner_2021-05-25-13-43_c83f103d-e59c-4d87-add9-635162bec755"},"trips":[{"key":"trip_shift_1","assigned_shifts":[{"shift_key":"shift_1","shift_time":{"from":"2021-05-13T10:20:00Z","to":"2021-05-13T12:10:00Z"}},{"shift_key":"shift_3","shift_time":{"from":"2021-05-13T10:30:00Z","to":"2021-05-13T12:01:00Z"}}],"actions":[{"order_key":"order_2","demand_key":"demand_3","location_key":"whs","todolist":[{"job_type":"LOCATION_ARRIVAL","job_time":"2021-05-13T10:30:00Z"},{"job_type":"READY_TO_WORK","job_time":"2021-05-13T10:30:00Z"},{"job_type":"START_WORK","job_time":"2021-05-13T10:30:00Z"},{"job_type":"FINISH_WORK","job_time":"2021-05-13T10:40:00Z"}],"cargo_placements":[{"box_key":"box01","cargo_key":"cargo_2"}]},{"order_key":"order_1","demand_key":"demand_1","location_key":"whs","todolist":[{"job_type":"READY_TO_WORK","job_time":"2021-05-13T10:40:00Z"},{"job_type":"START_WORK","job_time":"2021-05-13T10:40:00Z"},{"job_type":"FINISH_WORK","job_time":"2021-05-13T10:50:00Z"},{"job_type":"LOCATION_DEPARTURE","job_time":"2021-05-13T10:50:00Z"}],"cargo_placements":[{"box_key":"box01","cargo_key":"cargo_1"}]},{"order_key":"order_3","demand_key":"demand_5","location_key":"loc_3","todolist":[{"job_type":"LOCATION_ARRIVAL","job_time":"2021-05-13T11:00:00Z"},{"job_type":"READY_TO_WORK","job_time":"2021-05-13T11:00:00Z"},{"job_type":"START_WORK","job_time":"2021-05-13T11:00:00Z"},{"job_type":"FINISH_WORK","job_time":"2021-05-13T11:10:00Z"},{"job_type":"LOCATION_DEPARTURE","job_time":"2021-05-13T11:10:00Z"}],"cargo_placements":[]},{"order_key":"order_1","demand_key":"demand_2","location_key":"loc_1","todolist":[{"job_type":"LOCATION_ARRIVAL","job_time":"2021-05-13T11:18:00Z"},{"job_type":"READY_TO_WORK","job_time":"2021-05-13T11:18:00Z"},{"job_type":"START_WORK","job_time":"2021-05-13T11:18:00Z"},{"job_type":"FINISH_WORK","job_time":"2021-05-13T11:28:00Z"},{"job_type":"LOCATION_DEPARTURE","job_time":"2021-05-13T11:28:00Z"}],"cargo_placements":[{"box_key":"box01","cargo_key":"cargo_1"}]},{"order_key":"order_2","demand_key":"demand_4","location_key":"loc_2","todolist":[{"job_type":"LOCATION_ARRIVAL","job_time":"2021-05-13T11:41:00Z"},{"job_type":"READY_TO_WORK","job_time":"2021-05-13T11:41:00Z"},{"job_type":"START_WORK","job_time":"2021-05-13T11:41:00Z"},{"job_type":"FINISH_WORK","job_time":"2021-05-13T11:51:00Z"},{"job_type":"LOCATION_DEPARTURE","job_time":"2021-05-13T11:51:00Z"}],"cargo_placements":[{"box_key":"box01","cargo_key":"cargo_2"}]}],"waitlist":[],"start_location_key":"loc_1","finish_location_key":"loc_1"}],"statistics":{"total_statistics":{"cost":15785.5,"reward":5000,"measurements":{"driving_time":52,"waiting_time":0,"working_time":50,"arriving_time":6,"departure_time":6,"total_time":114,"distance":7743,"time_window":{"from":"2021-05-13T10:20:00Z","to":"2021-05-13T12:10:00Z"}},"orders_count":3,"plan_orders_count":3,"waitlist_orders_count":0,"performers_count":1,"capacity_utilization":{"mass":0.02,"volume":0.02,"capacity_x":0.2,"capacity_y":0.2,"capacity_z":0.2},"quality":{"soft_time_window_violations":{"before":{"keys":[],"count":0},"after":{"keys":[],"count":0}},"hard_time_window_violations":{"before":{"keys":[],"count":0},"after":{"keys":[],"count":0}}}},"trips_statistics":[{"trip_key":"trip_shift_1","statistics":{"cost":15785.5,"reward":5000,"measurements":{"driving_time":52,"waiting_time":0,"working_time":50,"arriving_time":6,"departure_time":6,"total_time":114,"distance":7743,"time_window":{"from":"2021-05-13T10:20:00Z","to":"2021-05-13T12:10:00Z"}},"orders_count":3,"plan_orders_count":3,"waitlist_orders_count":0,"performers_count":1,"capacity_utilization":{"mass":0.02,"volume":0.02,"capacity_x":0.2,"capacity_y":0.2,"capacity_z":0.2},"capacity_max":{"mass":0.02,"volume":0.02,"capacity_x":0.2,"capacity_y":0.2,"capacity_z":0.2},"quality":{"soft_time_window_violations":{"before":{"keys":[],"count":0},"after":{"keys":[],"count":0}},"hard_time_window_violations":{"before":{"keys":[],"count":0},"after":{"keys":[],"count":0}}}},"stop_statistics":[{"location":{"latitude":55.83079795705435,"longitude":37.62993934276462,"arrival_duration":1,"departure_duration":1},"location_key":"loc_1","demand_ids":[],"measurements":{"driving_time":0,"waiting_time":0,"working_time":0,"arriving_time":0,"departure_time":1,"total_time":1,"distance":1125,"time_window":{"from":"2021-05-13T10:20:00Z","to":"2021-05-13T10:21:00Z"}},"upload":{"count":0,"capacity":{"mass":0,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}},"download":{"count":0,"capacity":{"mass":0,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}},"current_load":{"count":0,"capacity":{"mass":0,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}}},{"location":{"latitude":55.83730739,"longitude":37.62006685,"arrival_duration":1,"departure_duration":1},"location_key":"whs","demand_ids":["order_2#demand_3","order_1#demand_1"],"measurements":{"driving_time":10,"waiting_time":0,"working_time":20,"arriving_time":1,"departure_time":1,"total_time":32,"distance":0,"time_window":{"from":"2021-05-13T10:29:00Z","to":"2021-05-13T10:51:00Z"}},"upload":{"count":2,"capacity":{"mass":20,"volume":4,"capacity_x":2,"capacity_y":4,"capacity_z":6}},"download":{"count":0,"capacity":{"mass":0,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}},"current_load":{"count":2,"capacity":{"mass":20,"volume":4,"capacity_x":2,"capacity_y":4,"capacity_z":6}}},{"location":{"latitude":55.83022,"longitude":37.623083,"arrival_duration":1,"departure_duration":1},"location_key":"loc_3","demand_ids":["order_3#demand_5"],"measurements":{"driving_time":8,"waiting_time":0,"working_time":10,"arriving_time":1,"departure_time":1,"total_time":20,"distance":1594,"time_window":{"from":"2021-05-13T10:59:00Z","to":"2021-05-13T11:11:00Z"}},"current_load":{"count":2,"capacity":{"mass":20,"volume":4,"capacity_x":2,"capacity_y":4,"capacity_z":6}}},{"location":{"latitude":55.83079795705435,"longitude":37.62993934276462,"arrival_duration":1,"departure_duration":1},"location_key":"loc_1","demand_ids":["order_1#demand_2"],"measurements":{"driving_time":6,"waiting_time":0,"working_time":10,"arriving_time":1,"departure_time":1,"total_time":18,"distance":764,"time_window":{"from":"2021-05-13T11:17:00Z","to":"2021-05-13T11:29:00Z"}},"download":{"count":1,"capacity":{"mass":10,"volume":2,"capacity_x":1,"capacity_y":2,"capacity_z":3}},"current_load":{"count":1,"capacity":{"mass":10,"volume":2,"capacity_x":1,"capacity_y":2,"capacity_z":3}}},{"location":{"latitude":55.839876,"longitude":37.629588,"arrival_duration":1,"departure_duration":1},"location_key":"loc_2","demand_ids":["order_2#demand_4"],"measurements":{"driving_time":11,"waiting_time":0,"working_time":10,"arriving_time":1,"departure_time":1,"total_time":23,"distance":1905,"time_window":{"from":"2021-05-13T11:40:00Z","to":"2021-05-13T11:52:00Z"}},"download":{"count":1,"capacity":{"mass":10,"volume":2,"capacity_x":1,"capacity_y":2,"capacity_z":3}},"current_load":{"count":0,"capacity":{"mass":0,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}}},{"location":{"latitude":55.83730739,"longitude":37.62006685,"arrival_duration":1,"departure_duration":1},"location_key":"whs","demand_ids":[],"measurements":{"driving_time":9,"waiting_time":0,"working_time":0,"arriving_time":1,"departure_time":1,"total_time":11,"distance":1230,"time_window":{"from":"2021-05-13T12:00:00Z","to":"2021-05-13T12:02:00Z"}},"upload":{"count":0,"capacity":{"mass":0,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}},"download":{"count":0,"capacity":{"mass":0,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}},"current_load":{"count":0,"capacity":{"mass":0,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}}},{"location":{"latitude":55.83079795705435,"longitude":37.62993934276462,"arrival_duration":1,"departure_duration":1},"location_key":"loc_1","demand_ids":[],"measurements":{"driving_time":8,"waiting_time":0,"working_time":0,"arriving_time":1,"departure_time":0,"total_time":9,"distance":1125,"time_window":{"from":"2021-05-13T12:09:00Z","to":"2021-05-13T12:10:00Z"}},"upload":{"count":0,"capacity":{"mass":0,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}},"download":{"count":0,"capacity":{"mass":0,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}},"current_load":{"count":0,"capacity":{"mass":0,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}}}],"total_load":{"count":2,"capacity":{"mass":20,"volume":4,"capacity_x":2,"capacity_y":4,"capacity_z":6}},"max_load":{"count":2,"capacity":{"mass":20,"volume":4,"capacity_x":2,"capacity_y":4,"capacity_z":6}}}]},"validations":[],"unplanned_orders":[],"progress":100,"info":{"status":"FINISHED_IN_TIME","result_version":0,"planning_time":0,"waiting_time":0}}
            )
        else :
            return AnalyticsTask(
                plan_task = vrt_lss_lastmile.models.plan_task.PlanTask(
                    locations = [
                        vrt_lss_lastmile.models.advanced_location.AdvancedLocation(
                            key = 'location01', 
                            location = vrt_lss_lastmile.models.location.Location(
                                latitude = 55.692789, 
                                longitude = 37.554554, 
                                arrival_duration = 15, 
                                departure_duration = 5, ), 
                            transport_restrictions = ["2T"], 
                            load_windows = [
                                vrt_lss_lastmile.models.load_window.LoadWindow(
                                    time_window = vrt_lss_lastmile.models.time_window.TimeWindow(
                                        from = '2021-02-21T09:30+03:00', 
                                        to = '2021-02-21T19:45Z', ), 
                                    gates_count = 1, )
                                ], 
                            attributes = ["Name:X51"], )
                        ], 
                    orders = [
                        vrt_lss_lastmile.models.order.Order(
                            key = 'order01', 
                            order_features = ["Special"], 
                            order_restrictions = ["Special"], 
                            performer_restrictions = ["Special"], 
                            performer_blacklist = ["A0"], 
                            cargos = [
                                vrt_lss_lastmile.models.cargo.Cargo(
                                    key = 'cargo01', 
                                    capacity = vrt_lss_lastmile.models.capacity.Capacity(
                                        mass = 10, 
                                        volume = 2, 
                                        capacity_x = 1, 
                                        capacity_y = 2, 
                                        capacity_z = 3, ), 
                                    rotation = ["ALL"], 
                                    width = 1, 
                                    height = 0.3, 
                                    length = 2.2, 
                                    max_storage_time = 60, 
                                    restrictions = ["Freezer"], 
                                    cargo_features = ["Clean"], 
                                    cargo_restrictions = ["Warm"], )
                                ], 
                            demands = [
                                vrt_lss_lastmile.models.demand.Demand(
                                    key = 'demand_1', 
                                    demand_type = 'WORK', 
                                    target_cargos = ["cargo01"], 
                                    precedence_in_trip = 1, 
                                    precedence_in_order = 1, 
                                    possible_events = [
                                        vrt_lss_lastmile.models.possible_event.PossibleEvent(
                                            key = 'event_1', 
                                            location_key = 'location01', 
                                            duration = 10, 
                                            reward = 199.9, 
                                            time_window = vrt_lss_lastmile.models.time_window.TimeWindow(
                                                from = '2021-02-21T09:30+03:00', 
                                                to = '2021-02-21T19:45Z', ), 
                                            soft_time_window = vrt_lss_lastmile.models.time_window.TimeWindow(
                                                from = '2021-02-21T09:30+03:00', 
                                                to = '2021-02-21T19:45Z', ), )
                                        ], 
                                    attributes = ["Name:X51"], )
                                ], 
                            attributes = ["Name:X51"], )
                        ], 
                    performers = [
                        vrt_lss_lastmile.models.performer.Performer(
                            key = 'performer0001', 
                            max_work_shifts = 3, 
                            performer_features = ["B1","Special"], 
                            transport_restrictions = ["B1"], 
                            own_transport_type = 'CAR', 
                            attributes = ["Name:X51"], )
                        ], 
                    transports = [
                        vrt_lss_lastmile.models.transport.Transport(
                            key = 'transport0001', 
                            transport_type = 'CAR', 
                            transport_features = ["20T"], 
                            performer_restrictions = ["Special"], 
                            boxes = [
                                vrt_lss_lastmile.models.box.Box(
                                    key = 'box01', 
                                    max_size = vrt_lss_lastmile.models.capacity.Capacity(
                                        mass = 10, 
                                        volume = 2, 
                                        capacity_x = 1, 
                                        capacity_y = 2, 
                                        capacity_z = 3, ), 
                                    width = 1, 
                                    height = 3.1, 
                                    length = 2.1, 
                                    features = ["Freezer"], )
                                ], 
                            attributes = ["Name:X51"], )
                        ], 
                    shifts = [
                        vrt_lss_lastmile.models.shift.Shift(
                            key = 'shift01', 
                            shift_type = 'PERFORMER', 
                            resource_key = 'performer01', 
                            availability_time = vrt_lss_lastmile.models.time_window.TimeWindow(
                                from = '2021-02-21T09:30+03:00', 
                                to = '2021-02-21T19:45Z', ), 
                            working_time = vrt_lss_lastmile.models.time_window.TimeWindow(
                                from = '2021-02-21T09:30+03:00', 
                                to = '2021-02-21T19:45Z', ), 
                            start_location_key = 'location01', 
                            finish_location_key = 'location01', 
                            max_locations = 15, 
                            tariff = vrt_lss_lastmile.models.universal_tariff.UniversalTariff(
                                cost_per_shift = 2000, 
                                constraints = [
                                    vrt_lss_lastmile.models.tariff_constraint.TariffConstraint(
                                        stage_length = 200000, 
                                        cost_per_unit = 1.5, )
                                    ], ), 
                            attributes = ["Name:X51"], )
                        ], 
                    hardlinks = [
                        vrt_lss_lastmile.models.hardlink.Hardlink(
                            key = 'group01', 
                            links = [
                                vrt_lss_lastmile.models.hardlink_element.HardlinkElement(
                                    type = 'ORDER', 
                                    entity_key = 'ord0001', )
                                ], )
                        ], 
                    trips = [
                        vrt_lss_lastmile.models.trip.Trip(
                            key = 'TRIP0001', 
                            assigned_shifts = [
                                vrt_lss_lastmile.models.assigned_shift.AssignedShift(
                                    shift_key = 'performer01', 
                                    shift_time = vrt_lss_lastmile.models.time_window.TimeWindow(
                                        from = '2021-02-21T09:30+03:00', 
                                        to = '2021-02-21T19:45Z', ), )
                                ], 
                            actions = [
                                vrt_lss_lastmile.models.trip_action.TripAction(
                                    order_key = 'order01', 
                                    demand_key = 'demand01.1', 
                                    event_key = 'location01', 
                                    location_key = 'location01', 
                                    todolist = [
                                        vrt_lss_lastmile.models.trip_job.TripJob(
                                            job_type = 'START_WORK', 
                                            job_time = '2021-05-21T09:30+03:00', )
                                        ], 
                                    cargo_placements = [
                                        vrt_lss_lastmile.models.cargo_placement.CargoPlacement(
                                            box_key = 'box01', 
                                            cargo_key = 'cargo01', )
                                        ], 
                                    attributes = ["Name:X51"], )
                                ], 
                            waitlist = ["order02"], 
                            start_location_key = 'location01', 
                            finish_location_key = 'location01', 
                            attributes = ["Name:X51"], )
                        ], 
                    settings = vrt_lss_lastmile.models.plan_settings.PlanSettings(
                        configuration = 'default', 
                        planning_time = 30, 
                        result_ttl = 10, 
                        result_timezone = 3, 
                        predict_slots = 2, 
                        transport_factor = [
                            vrt_lss_lastmile.models.transport_factor.TransportFactor(
                                transport_type = 'CAR', 
                                speed = 2.5, )
                            ], 
                        capacity_factor = [
                            vrt_lss_lastmile.models.capacity_factor.CapacityFactor(
                                transport_type = 'CAR', 
                                capacity = vrt_lss_lastmile.models.capacity.Capacity(
                                    mass = 10, 
                                    volume = 2, 
                                    capacity_x = 1, 
                                    capacity_y = 2, 
                                    capacity_z = 3, ), )
                            ], 
                        routing = [
                            vrt_lss_lastmile.models.routing.Routing(
                                transport_type = 'CAR', 
                                matrix = {"waypoints":[{"latitude":59.9345,"longitude":30.1504},{"latitude":59.942383,"longitude":30.258951},{"latitude":59.9545,"longitude":30.2004},{"latitude":59.89527,"longitude":30.261747},{"latitude":59.9745,"longitude":30.5004}],"distances":[[0,5822,1820,14130,23304],[5936,0,4931,8365,17731],[1819,4853,0,13161,22335],[14859,9056,13854,0,21440],[21777,16306,20772,19290,0]],"durations":[[0,13,7,24,36],[13,0,9,13,25],[7,9,0,21,32],[26,14,22,0,30],[34,23,30,28,0]]}, 
                                traffic_jams = [
                                    vrt_lss_lastmile.models.traffic_factor.TrafficFactor(
                                        time_window = vrt_lss_lastmile.models.time_window.TimeWindow(
                                            from = '2021-02-21T09:30+03:00', 
                                            to = '2021-02-21T19:45Z', ), 
                                        length_multiplier = 2, 
                                        length_additive = 20, 
                                        time_multiplier = 2, 
                                        time_additive = 30, )
                                    ], )
                            ], 
                        assumptions = vrt_lss_lastmile.models.plan_assumptions.PlanAssumptions(
                            toll_roads = False, 
                            ferry_crossing = False, 
                            flight_distance = True, 
                            disable_compatibility = True, 
                            disable_capacity = True, 
                            same_order_time_window = True, 
                            expand_shift_time_window = True, ), 
                        precision = 3, ), 
                    tracedata = vrt_lss_lastmile.models.trace_data.TraceData(
                        code = 'client_server_service_time_uuid', 
                        client = 'client_name', 
                        server = 'server_name', 
                        service = 'LASTMILE', 
                        method = 'PLAN', 
                        time = '2021-02-21T09:30+03:00', ), ),
                plan_result = {"tracedata":{"code":"example_LssTestingPreview_LastmileServicePlanner_2021-05-25-13-43_c83f103d-e59c-4d87-add9-635162bec755"},"trips":[{"key":"trip_shift_1","assigned_shifts":[{"shift_key":"shift_1","shift_time":{"from":"2021-05-13T10:20:00Z","to":"2021-05-13T12:10:00Z"}},{"shift_key":"shift_3","shift_time":{"from":"2021-05-13T10:30:00Z","to":"2021-05-13T12:01:00Z"}}],"actions":[{"order_key":"order_2","demand_key":"demand_3","location_key":"whs","todolist":[{"job_type":"LOCATION_ARRIVAL","job_time":"2021-05-13T10:30:00Z"},{"job_type":"READY_TO_WORK","job_time":"2021-05-13T10:30:00Z"},{"job_type":"START_WORK","job_time":"2021-05-13T10:30:00Z"},{"job_type":"FINISH_WORK","job_time":"2021-05-13T10:40:00Z"}],"cargo_placements":[{"box_key":"box01","cargo_key":"cargo_2"}]},{"order_key":"order_1","demand_key":"demand_1","location_key":"whs","todolist":[{"job_type":"READY_TO_WORK","job_time":"2021-05-13T10:40:00Z"},{"job_type":"START_WORK","job_time":"2021-05-13T10:40:00Z"},{"job_type":"FINISH_WORK","job_time":"2021-05-13T10:50:00Z"},{"job_type":"LOCATION_DEPARTURE","job_time":"2021-05-13T10:50:00Z"}],"cargo_placements":[{"box_key":"box01","cargo_key":"cargo_1"}]},{"order_key":"order_3","demand_key":"demand_5","location_key":"loc_3","todolist":[{"job_type":"LOCATION_ARRIVAL","job_time":"2021-05-13T11:00:00Z"},{"job_type":"READY_TO_WORK","job_time":"2021-05-13T11:00:00Z"},{"job_type":"START_WORK","job_time":"2021-05-13T11:00:00Z"},{"job_type":"FINISH_WORK","job_time":"2021-05-13T11:10:00Z"},{"job_type":"LOCATION_DEPARTURE","job_time":"2021-05-13T11:10:00Z"}],"cargo_placements":[]},{"order_key":"order_1","demand_key":"demand_2","location_key":"loc_1","todolist":[{"job_type":"LOCATION_ARRIVAL","job_time":"2021-05-13T11:18:00Z"},{"job_type":"READY_TO_WORK","job_time":"2021-05-13T11:18:00Z"},{"job_type":"START_WORK","job_time":"2021-05-13T11:18:00Z"},{"job_type":"FINISH_WORK","job_time":"2021-05-13T11:28:00Z"},{"job_type":"LOCATION_DEPARTURE","job_time":"2021-05-13T11:28:00Z"}],"cargo_placements":[{"box_key":"box01","cargo_key":"cargo_1"}]},{"order_key":"order_2","demand_key":"demand_4","location_key":"loc_2","todolist":[{"job_type":"LOCATION_ARRIVAL","job_time":"2021-05-13T11:41:00Z"},{"job_type":"READY_TO_WORK","job_time":"2021-05-13T11:41:00Z"},{"job_type":"START_WORK","job_time":"2021-05-13T11:41:00Z"},{"job_type":"FINISH_WORK","job_time":"2021-05-13T11:51:00Z"},{"job_type":"LOCATION_DEPARTURE","job_time":"2021-05-13T11:51:00Z"}],"cargo_placements":[{"box_key":"box01","cargo_key":"cargo_2"}]}],"waitlist":[],"start_location_key":"loc_1","finish_location_key":"loc_1"}],"statistics":{"total_statistics":{"cost":15785.5,"reward":5000,"measurements":{"driving_time":52,"waiting_time":0,"working_time":50,"arriving_time":6,"departure_time":6,"total_time":114,"distance":7743,"time_window":{"from":"2021-05-13T10:20:00Z","to":"2021-05-13T12:10:00Z"}},"orders_count":3,"plan_orders_count":3,"waitlist_orders_count":0,"performers_count":1,"capacity_utilization":{"mass":0.02,"volume":0.02,"capacity_x":0.2,"capacity_y":0.2,"capacity_z":0.2},"quality":{"soft_time_window_violations":{"before":{"keys":[],"count":0},"after":{"keys":[],"count":0}},"hard_time_window_violations":{"before":{"keys":[],"count":0},"after":{"keys":[],"count":0}}}},"trips_statistics":[{"trip_key":"trip_shift_1","statistics":{"cost":15785.5,"reward":5000,"measurements":{"driving_time":52,"waiting_time":0,"working_time":50,"arriving_time":6,"departure_time":6,"total_time":114,"distance":7743,"time_window":{"from":"2021-05-13T10:20:00Z","to":"2021-05-13T12:10:00Z"}},"orders_count":3,"plan_orders_count":3,"waitlist_orders_count":0,"performers_count":1,"capacity_utilization":{"mass":0.02,"volume":0.02,"capacity_x":0.2,"capacity_y":0.2,"capacity_z":0.2},"capacity_max":{"mass":0.02,"volume":0.02,"capacity_x":0.2,"capacity_y":0.2,"capacity_z":0.2},"quality":{"soft_time_window_violations":{"before":{"keys":[],"count":0},"after":{"keys":[],"count":0}},"hard_time_window_violations":{"before":{"keys":[],"count":0},"after":{"keys":[],"count":0}}}},"stop_statistics":[{"location":{"latitude":55.83079795705435,"longitude":37.62993934276462,"arrival_duration":1,"departure_duration":1},"location_key":"loc_1","demand_ids":[],"measurements":{"driving_time":0,"waiting_time":0,"working_time":0,"arriving_time":0,"departure_time":1,"total_time":1,"distance":1125,"time_window":{"from":"2021-05-13T10:20:00Z","to":"2021-05-13T10:21:00Z"}},"upload":{"count":0,"capacity":{"mass":0,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}},"download":{"count":0,"capacity":{"mass":0,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}},"current_load":{"count":0,"capacity":{"mass":0,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}}},{"location":{"latitude":55.83730739,"longitude":37.62006685,"arrival_duration":1,"departure_duration":1},"location_key":"whs","demand_ids":["order_2#demand_3","order_1#demand_1"],"measurements":{"driving_time":10,"waiting_time":0,"working_time":20,"arriving_time":1,"departure_time":1,"total_time":32,"distance":0,"time_window":{"from":"2021-05-13T10:29:00Z","to":"2021-05-13T10:51:00Z"}},"upload":{"count":2,"capacity":{"mass":20,"volume":4,"capacity_x":2,"capacity_y":4,"capacity_z":6}},"download":{"count":0,"capacity":{"mass":0,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}},"current_load":{"count":2,"capacity":{"mass":20,"volume":4,"capacity_x":2,"capacity_y":4,"capacity_z":6}}},{"location":{"latitude":55.83022,"longitude":37.623083,"arrival_duration":1,"departure_duration":1},"location_key":"loc_3","demand_ids":["order_3#demand_5"],"measurements":{"driving_time":8,"waiting_time":0,"working_time":10,"arriving_time":1,"departure_time":1,"total_time":20,"distance":1594,"time_window":{"from":"2021-05-13T10:59:00Z","to":"2021-05-13T11:11:00Z"}},"current_load":{"count":2,"capacity":{"mass":20,"volume":4,"capacity_x":2,"capacity_y":4,"capacity_z":6}}},{"location":{"latitude":55.83079795705435,"longitude":37.62993934276462,"arrival_duration":1,"departure_duration":1},"location_key":"loc_1","demand_ids":["order_1#demand_2"],"measurements":{"driving_time":6,"waiting_time":0,"working_time":10,"arriving_time":1,"departure_time":1,"total_time":18,"distance":764,"time_window":{"from":"2021-05-13T11:17:00Z","to":"2021-05-13T11:29:00Z"}},"download":{"count":1,"capacity":{"mass":10,"volume":2,"capacity_x":1,"capacity_y":2,"capacity_z":3}},"current_load":{"count":1,"capacity":{"mass":10,"volume":2,"capacity_x":1,"capacity_y":2,"capacity_z":3}}},{"location":{"latitude":55.839876,"longitude":37.629588,"arrival_duration":1,"departure_duration":1},"location_key":"loc_2","demand_ids":["order_2#demand_4"],"measurements":{"driving_time":11,"waiting_time":0,"working_time":10,"arriving_time":1,"departure_time":1,"total_time":23,"distance":1905,"time_window":{"from":"2021-05-13T11:40:00Z","to":"2021-05-13T11:52:00Z"}},"download":{"count":1,"capacity":{"mass":10,"volume":2,"capacity_x":1,"capacity_y":2,"capacity_z":3}},"current_load":{"count":0,"capacity":{"mass":0,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}}},{"location":{"latitude":55.83730739,"longitude":37.62006685,"arrival_duration":1,"departure_duration":1},"location_key":"whs","demand_ids":[],"measurements":{"driving_time":9,"waiting_time":0,"working_time":0,"arriving_time":1,"departure_time":1,"total_time":11,"distance":1230,"time_window":{"from":"2021-05-13T12:00:00Z","to":"2021-05-13T12:02:00Z"}},"upload":{"count":0,"capacity":{"mass":0,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}},"download":{"count":0,"capacity":{"mass":0,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}},"current_load":{"count":0,"capacity":{"mass":0,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}}},{"location":{"latitude":55.83079795705435,"longitude":37.62993934276462,"arrival_duration":1,"departure_duration":1},"location_key":"loc_1","demand_ids":[],"measurements":{"driving_time":8,"waiting_time":0,"working_time":0,"arriving_time":1,"departure_time":0,"total_time":9,"distance":1125,"time_window":{"from":"2021-05-13T12:09:00Z","to":"2021-05-13T12:10:00Z"}},"upload":{"count":0,"capacity":{"mass":0,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}},"download":{"count":0,"capacity":{"mass":0,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}},"current_load":{"count":0,"capacity":{"mass":0,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}}}],"total_load":{"count":2,"capacity":{"mass":20,"volume":4,"capacity_x":2,"capacity_y":4,"capacity_z":6}},"max_load":{"count":2,"capacity":{"mass":20,"volume":4,"capacity_x":2,"capacity_y":4,"capacity_z":6}}}]},"validations":[],"unplanned_orders":[],"progress":100,"info":{"status":"FINISHED_IN_TIME","result_version":0,"planning_time":0,"waiting_time":0}},
        )

    def testAnalyticsTask(self):
        """Test AnalyticsTask"""
        inst_req_only = self.make_instance(include_optional=False)
        inst_req_and_optional = self.make_instance(include_optional=True)

if __name__ == '__main__':
    unittest.main()
