# coding: utf-8

"""
    Veeroute.LSS Lastmile

    Veeroute.LSS Lastmile API  # noqa: E501

    The version of the OpenAPI document: 3.8.168680
    Contact: support@veeroute.com
    Generated by: https://openapi-generator.tech
"""


import inspect
import pprint
import re  # noqa: F401
import six

from vrt_lss_lastmile.configuration import Configuration


class Performer(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'key': 'str',
        'max_work_shifts': 'int',
        'performer_features': 'list[str]',
        'transport_restrictions': 'list[str]',
        'own_transport_type': 'TransportType',
        'attributes': 'list[str]'
    }

    attribute_map = {
        'key': 'key',
        'max_work_shifts': 'max_work_shifts',
        'performer_features': 'performer_features',
        'transport_restrictions': 'transport_restrictions',
        'own_transport_type': 'own_transport_type',
        'attributes': 'attributes'
    }

    def __init__(self, key=None, max_work_shifts=31, performer_features=[], transport_restrictions=None, own_transport_type=None, attributes=[], local_vars_configuration=None):  # noqa: E501
        """Performer - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._key = None
        self._max_work_shifts = None
        self._performer_features = None
        self._transport_restrictions = None
        self._own_transport_type = None
        self._attributes = None
        self.discriminator = None

        self.key = key
        if max_work_shifts is not None:
            self.max_work_shifts = max_work_shifts
        if performer_features is not None:
            self.performer_features = performer_features
        if transport_restrictions is not None:
            self.transport_restrictions = transport_restrictions
        if own_transport_type is not None:
            self.own_transport_type = own_transport_type
        if attributes is not None:
            self.attributes = attributes

    @property
    def key(self):
        """Gets the key of this Performer.  # noqa: E501

        Performer's key, unique ID.  # noqa: E501

        :return: The key of this Performer.  # noqa: E501
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """Sets the key of this Performer.

        Performer's key, unique ID.  # noqa: E501

        :param key: The key of this Performer.  # noqa: E501
        :type key: str
        """
        if self.local_vars_configuration.client_side_validation and key is None:  # noqa: E501
            raise ValueError("Invalid value for `key`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                key is not None and len(key) > 1024):
            raise ValueError("Invalid value for `key`, length must be less than or equal to `1024`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                key is not None and len(key) < 1):
            raise ValueError("Invalid value for `key`, length must be greater than or equal to `1`")  # noqa: E501

        self._key = key

    @property
    def max_work_shifts(self):
        """Gets the max_work_shifts of this Performer.  # noqa: E501

        Limit of the number of performer's shifts in one planning.  # noqa: E501

        :return: The max_work_shifts of this Performer.  # noqa: E501
        :rtype: int
        """
        return self._max_work_shifts

    @max_work_shifts.setter
    def max_work_shifts(self, max_work_shifts):
        """Sets the max_work_shifts of this Performer.

        Limit of the number of performer's shifts in one planning.  # noqa: E501

        :param max_work_shifts: The max_work_shifts of this Performer.  # noqa: E501
        :type max_work_shifts: int
        """
        if (self.local_vars_configuration.client_side_validation and
                max_work_shifts is not None and max_work_shifts > 31):  # noqa: E501
            raise ValueError("Invalid value for `max_work_shifts`, must be a value less than or equal to `31`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                max_work_shifts is not None and max_work_shifts < 1):  # noqa: E501
            raise ValueError("Invalid value for `max_work_shifts`, must be a value greater than or equal to `1`")  # noqa: E501

        self._max_work_shifts = max_work_shifts

    @property
    def performer_features(self):
        """Gets the performer_features of this Performer.  # noqa: E501

        Performer's features list. Used to check whether the performer is compatible with orders.   # noqa: E501

        :return: The performer_features of this Performer.  # noqa: E501
        :rtype: list[str]
        """
        return self._performer_features

    @performer_features.setter
    def performer_features(self, performer_features):
        """Sets the performer_features of this Performer.

        Performer's features list. Used to check whether the performer is compatible with orders.   # noqa: E501

        :param performer_features: The performer_features of this Performer.  # noqa: E501
        :type performer_features: list[str]
        """
        if (self.local_vars_configuration.client_side_validation and
                performer_features is not None and len(performer_features) > 1000):
            raise ValueError("Invalid value for `performer_features`, number of items must be less than or equal to `1000`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                performer_features is not None and len(performer_features) < 0):
            raise ValueError("Invalid value for `performer_features`, number of items must be greater than or equal to `0`")  # noqa: E501

        self._performer_features = performer_features

    @property
    def transport_restrictions(self):
        """Gets the transport_restrictions of this Performer.  # noqa: E501

        List of vehicle requirements. Used to check whether the vehicle is compatible with the order.   # noqa: E501

        :return: The transport_restrictions of this Performer.  # noqa: E501
        :rtype: list[str]
        """
        return self._transport_restrictions

    @transport_restrictions.setter
    def transport_restrictions(self, transport_restrictions):
        """Sets the transport_restrictions of this Performer.

        List of vehicle requirements. Used to check whether the vehicle is compatible with the order.   # noqa: E501

        :param transport_restrictions: The transport_restrictions of this Performer.  # noqa: E501
        :type transport_restrictions: list[str]
        """
        if (self.local_vars_configuration.client_side_validation and
                transport_restrictions is not None and len(transport_restrictions) > 1000):
            raise ValueError("Invalid value for `transport_restrictions`, number of items must be less than or equal to `1000`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                transport_restrictions is not None and len(transport_restrictions) < 0):
            raise ValueError("Invalid value for `transport_restrictions`, number of items must be greater than or equal to `0`")  # noqa: E501

        self._transport_restrictions = transport_restrictions

    @property
    def own_transport_type(self):
        """Gets the own_transport_type of this Performer.  # noqa: E501


        :return: The own_transport_type of this Performer.  # noqa: E501
        :rtype: TransportType
        """
        return self._own_transport_type

    @own_transport_type.setter
    def own_transport_type(self, own_transport_type):
        """Sets the own_transport_type of this Performer.


        :param own_transport_type: The own_transport_type of this Performer.  # noqa: E501
        :type own_transport_type: TransportType
        """

        self._own_transport_type = own_transport_type

    @property
    def attributes(self):
        """Gets the attributes of this Performer.  # noqa: E501

        Attributes, used to add service information that does not affect planning.  # noqa: E501

        :return: The attributes of this Performer.  # noqa: E501
        :rtype: list[str]
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes):
        """Sets the attributes of this Performer.

        Attributes, used to add service information that does not affect planning.  # noqa: E501

        :param attributes: The attributes of this Performer.  # noqa: E501
        :type attributes: list[str]
        """
        if (self.local_vars_configuration.client_side_validation and
                attributes is not None and len(attributes) > 1000):
            raise ValueError("Invalid value for `attributes`, number of items must be less than or equal to `1000`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                attributes is not None and len(attributes) < 0):
            raise ValueError("Invalid value for `attributes`, number of items must be greater than or equal to `0`")  # noqa: E501

        self._attributes = attributes

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = inspect.getargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Performer):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Performer):
            return True

        return self.to_dict() != other.to_dict()
