# coding: utf-8

"""
    Veeroute.LSS Lastmile

    Veeroute.LSS Lastmile API  # noqa: E501

    The version of the OpenAPI document: 3.8.168680
    Contact: support@veeroute.com
    Generated by: https://openapi-generator.tech
"""


import inspect
import pprint
import re  # noqa: F401
import six

from vrt_lss_lastmile.configuration import Configuration


class Transport(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'key': 'str',
        'transport_type': 'TransportType',
        'transport_features': 'list[str]',
        'performer_restrictions': 'list[str]',
        'boxes': 'list[Box]',
        'attributes': 'list[str]'
    }

    attribute_map = {
        'key': 'key',
        'transport_type': 'transport_type',
        'transport_features': 'transport_features',
        'performer_restrictions': 'performer_restrictions',
        'boxes': 'boxes',
        'attributes': 'attributes'
    }

    def __init__(self, key=None, transport_type=None, transport_features=None, performer_restrictions=[], boxes=None, attributes=[], local_vars_configuration=None):  # noqa: E501
        """Transport - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._key = None
        self._transport_type = None
        self._transport_features = None
        self._performer_restrictions = None
        self._boxes = None
        self._attributes = None
        self.discriminator = None

        self.key = key
        if transport_type is not None:
            self.transport_type = transport_type
        if transport_features is not None:
            self.transport_features = transport_features
        if performer_restrictions is not None:
            self.performer_restrictions = performer_restrictions
        if boxes is not None:
            self.boxes = boxes
        if attributes is not None:
            self.attributes = attributes

    @property
    def key(self):
        """Gets the key of this Transport.  # noqa: E501

        Vehicle key, unique ID.  # noqa: E501

        :return: The key of this Transport.  # noqa: E501
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """Sets the key of this Transport.

        Vehicle key, unique ID.  # noqa: E501

        :param key: The key of this Transport.  # noqa: E501
        :type key: str
        """
        if self.local_vars_configuration.client_side_validation and key is None:  # noqa: E501
            raise ValueError("Invalid value for `key`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                key is not None and len(key) > 1024):
            raise ValueError("Invalid value for `key`, length must be less than or equal to `1024`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                key is not None and len(key) < 1):
            raise ValueError("Invalid value for `key`, length must be greater than or equal to `1`")  # noqa: E501

        self._key = key

    @property
    def transport_type(self):
        """Gets the transport_type of this Transport.  # noqa: E501


        :return: The transport_type of this Transport.  # noqa: E501
        :rtype: TransportType
        """
        return self._transport_type

    @transport_type.setter
    def transport_type(self, transport_type):
        """Sets the transport_type of this Transport.


        :param transport_type: The transport_type of this Transport.  # noqa: E501
        :type transport_type: TransportType
        """

        self._transport_type = transport_type

    @property
    def transport_features(self):
        """Gets the transport_features of this Transport.  # noqa: E501

        Vehicle features list, it is used to check whether the vehicle is compatible with orders, locations, and performers.   # noqa: E501

        :return: The transport_features of this Transport.  # noqa: E501
        :rtype: list[str]
        """
        return self._transport_features

    @transport_features.setter
    def transport_features(self, transport_features):
        """Sets the transport_features of this Transport.

        Vehicle features list, it is used to check whether the vehicle is compatible with orders, locations, and performers.   # noqa: E501

        :param transport_features: The transport_features of this Transport.  # noqa: E501
        :type transport_features: list[str]
        """
        if (self.local_vars_configuration.client_side_validation and
                transport_features is not None and len(transport_features) > 1000):
            raise ValueError("Invalid value for `transport_features`, number of items must be less than or equal to `1000`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                transport_features is not None and len(transport_features) < 0):
            raise ValueError("Invalid value for `transport_features`, number of items must be greater than or equal to `0`")  # noqa: E501

        self._transport_features = transport_features

    @property
    def performer_restrictions(self):
        """Gets the performer_restrictions of this Transport.  # noqa: E501

        Requirements list for the performer. Used for checking the compatibility of the performer and the order (work).   # noqa: E501

        :return: The performer_restrictions of this Transport.  # noqa: E501
        :rtype: list[str]
        """
        return self._performer_restrictions

    @performer_restrictions.setter
    def performer_restrictions(self, performer_restrictions):
        """Sets the performer_restrictions of this Transport.

        Requirements list for the performer. Used for checking the compatibility of the performer and the order (work).   # noqa: E501

        :param performer_restrictions: The performer_restrictions of this Transport.  # noqa: E501
        :type performer_restrictions: list[str]
        """
        if (self.local_vars_configuration.client_side_validation and
                performer_restrictions is not None and len(performer_restrictions) > 1000):
            raise ValueError("Invalid value for `performer_restrictions`, number of items must be less than or equal to `1000`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                performer_restrictions is not None and len(performer_restrictions) < 0):
            raise ValueError("Invalid value for `performer_restrictions`, number of items must be greater than or equal to `0`")  # noqa: E501

        self._performer_restrictions = performer_restrictions

    @property
    def boxes(self):
        """Gets the boxes of this Transport.  # noqa: E501

        A list of vehicle compartments that can accommodate the cargo.  # noqa: E501

        :return: The boxes of this Transport.  # noqa: E501
        :rtype: list[Box]
        """
        return self._boxes

    @boxes.setter
    def boxes(self, boxes):
        """Sets the boxes of this Transport.

        A list of vehicle compartments that can accommodate the cargo.  # noqa: E501

        :param boxes: The boxes of this Transport.  # noqa: E501
        :type boxes: list[Box]
        """
        if (self.local_vars_configuration.client_side_validation and
                boxes is not None and len(boxes) > 100):
            raise ValueError("Invalid value for `boxes`, number of items must be less than or equal to `100`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                boxes is not None and len(boxes) < 1):
            raise ValueError("Invalid value for `boxes`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._boxes = boxes

    @property
    def attributes(self):
        """Gets the attributes of this Transport.  # noqa: E501

        Attributes, used to add service information that does not affect planning.  # noqa: E501

        :return: The attributes of this Transport.  # noqa: E501
        :rtype: list[str]
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes):
        """Sets the attributes of this Transport.

        Attributes, used to add service information that does not affect planning.  # noqa: E501

        :param attributes: The attributes of this Transport.  # noqa: E501
        :type attributes: list[str]
        """
        if (self.local_vars_configuration.client_side_validation and
                attributes is not None and len(attributes) > 1000):
            raise ValueError("Invalid value for `attributes`, number of items must be less than or equal to `1000`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                attributes is not None and len(attributes) < 0):
            raise ValueError("Invalid value for `attributes`, number of items must be greater than or equal to `0`")  # noqa: E501

        self._attributes = attributes

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = inspect.getargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Transport):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Transport):
            return True

        return self.to_dict() != other.to_dict()
