"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultPrivateVpcProps = exports.DefaultIsolatedVpcProps = exports.DefaultPublicPrivateVpcProps = void 0;
const ec2 = require("aws-cdk-lib/aws-ec2");
/**
 * Default VPC with public and private subnets
 */
function DefaultPublicPrivateVpcProps() {
    return {};
}
exports.DefaultPublicPrivateVpcProps = DefaultPublicPrivateVpcProps;
/**
 * Default VPC with isolated subnets
 */
function DefaultIsolatedVpcProps() {
    return {
        natGateways: 0,
        subnetConfiguration: [
            {
                cidrMask: 18,
                name: "isolated",
                subnetType: ec2.SubnetType.PRIVATE_ISOLATED,
            }
        ]
    };
}
exports.DefaultIsolatedVpcProps = DefaultIsolatedVpcProps;
/**
 * Default VPC with private subnets w/NAT
 */
function DefaultPrivateVpcProps() {
    return {
        natGateways: 0,
        subnetConfiguration: [
            {
                cidrMask: 18,
                name: "private",
                subnetType: ec2.SubnetType.PRIVATE_WITH_NAT,
            },
            {
                cidrMask: 24,
                name: "public",
                subnetType: ec2.SubnetType.PUBLIC,
            }
        ]
    };
}
exports.DefaultPrivateVpcProps = DefaultPrivateVpcProps;
//# sourceMappingURL=data:application/json;base64,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