# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['aws_adfs']

package_data = \
{'': ['*']}

install_requires = \
['boto3>=1.20.50,<2.0.0',
 'botocore>=1.12.6',
 'click',
 'configparser',
 'fido2>=0.9.3',
 'lxml',
 'requests']

extras_require = \
{':platform_system != "Windows"': ['requests-kerberos'],
 ':platform_system == "Windows"': ['requests-negotiate-sspi>=0.3.4']}

entry_points = \
{'console_scripts': ['aws-adfs = aws_adfs.commands:cli']}

setup_kwargs = {
    'name': 'aws-adfs',
    'version': '2.0.2',
    'description': 'AWS CLI authenticator via ADFS - small command-line tool to authenticate via ADFS and assume chosen role',
    'long_description': '# aws-adfs\n[![PyPI version](https://badge.fury.io/py/aws-adfs.svg)](https://badge.fury.io/py/aws-adfs)\n[![Travis build](https://api.travis-ci.org/venth/aws-adfs.svg?branch=master)](https://api.travis-ci.org/venth/aws-adfs.svg?branch=master)\n![Build Status](https://github.com/venth/aws-adfs/workflows/Build/badge.svg?branch=master)\n\nThe project provides command line tool - `aws-adfs` to ease aws cli authentication against ADFS (multi factor authentication with active directory) and\n\n## `aws-adfs` command line tool\nThanks to [Brandond](https://github.com/brandond) contribution - "Remove storage of credentials, in favor of storing ADFS session cookies"\naws-adfs:\n\n> allows you to re-login to STS without\n> entering credentials for an extended period of time, without having to store the user\'s actual credentials.\n> It also lets an organization control the period in which a user can re-login to STS without entering credentials,\n> by altering the ADFS session lifetime.\n\nThanks to [Brandond](https://github.com/brandond) contribution - "Add support for legacy aws_security_token key in credentials file"\naws-adfs supports ansible by providing two keys with security token:\n* AWS_SESSION_TOKEN and\n* AWS_SECURITY_TOKEN\n\nThanks to [Brandond](https://github.com/brandond) contribution - "Add support for Kerberos SSO on Windows via requests_negotiate_sspi"\n* on windows os will be used Security Support Provider Interface\n\n### Compatibility\n\nAs of version 0.2.0, this tool acts on the \'default\' profile unless an alternate profile name has been specified on the command line or in your environment. Previous versions acted on the \'adfs\' profile by default.\n\n### MFA integration\n\naws-adfs integrates with:\n* [duo security](https://duo.com) MFA provider with support for FIDO U2F (CTAP1) / FIDO2 (CTAP2) hardware authenticators\n* [Symantec VIP](https://vip.symantec.com/) MFA provider\n* [RSA SecurID](https://www.rsa.com/) MFA provider\n\n# Installation\n\n* user local installation with [pipx](https://github.com/pypa/pipx)\n\n    ```\n    pipx install aws-adfs\n    ```\n\n* user local installation with pip\n\n    ```\n    pip install aws-adfs\n    ```\n\n    Please note, that you need to add $HOME/.local/bin to your PATH\n\n* system wide installation\n\n    ```\n    sudo pip install aws-adfs\n    ```\n\n* virtualenvs\n\n    ```\n    virtualenv aws-adfs\n    source aws-adfs/bin/activate\n    pip install aws-adfs\n    ...\n    ...\n    deactivate\n    ```\n\n* Windows 10\n\n   - Install latest supported Visual C++ downloads from Microsoft for Visual Studio 2015, 2017 and 2019:\n      - https://support.microsoft.com/en-us/help/2977003/the-latest-supported-visual-c-downloads\n      - https://aka.ms/vs/16/release/vc_redist.x64.exe\n    - Install Python 3.7 from Microsoft Store:\n      - https://www.microsoft.com/en-us/p/python-37/9nj46sx7x90p\n    - Start PowerShell as Administrator\n    - Go to `C:\\Program Files`:\n        ```\n        C:\n        cd \'C:\\Program Files\\\'\n        ```\n    - Create virtual env:\n      ```\n      python3 -m venv aws-adfs\n      ```\n    - Install `aws-adfs`:\n      ```\n      & \'C:\\Program Files\\aws-adfs\\Scripts\\pip\' install aws-adfs\n      ```\n    - Run it:\n      ```\n      & \'C:\\Program Files\\aws-adfs\\Scripts\\aws-adfs\' login --adfs-host=your-adfs-hostname\n      ```\n\n# Examples of usage\n\n## `aws-adfs`\n* login to your adfs host with disabled ssl verification on aws cli profile: adfs\n\n    ```\n    aws-adfs login --adfs-host=your-adfs-hostname --no-ssl-verification\n    ```\n\n    and verification\n\n    ```\n    aws --profile=adfs s3 ls\n    ```\n\n* login to your adfs host with disabled ssl verification on specified aws cli profile: specified-profile\n\n    ```\n    aws-adfs login --profile=specified-profile --adfs-host=your-adfs-hostname --no-ssl-verification\n    ```\n\n    and verification\n\n    ```\n    aws --profile=specified-profile s3 ls\n    ```\n\n* login to your adfs host and fetch roles for AWS GovCloud (US)\n\n    ```\n    aws-adfs login --adfs-host=your-adfs-hostname --provider-id urn:amazon:webservices:govcloud --region us-gov-west-1\n    ```\n\n    and verification\n\n    ```\n    aws s3 ls\n    ```\n\n* login to your adfs host within ansible playbook\n\n    ```\n    ---\n    - name: "Auth sts aws"\n      command: "aws-adfs login --adfs-host sts.example.com --env --stdout --role-arn arn:aws:iam::000123456789:role/ADMIN"\n      register: sts_result\n      environment:\n        - username: "{{ ansible_user }}@example.com"\n        - password: "{{ ansible_ssh_pass }}"\n\n    - name: "Set sts facts"\n      set_fact:\n        sts: "{{ sts_result.stdout | from_json }}"\n\n    - name: "List s3 Buckets"\n      aws_s3_bucket_facts:\n        aws_access_key: "{{\xa0sts.AccessKeyId }}"\n        aws_secret_key: "{{\xa0sts.SecretAccessKey }}"\n        security_token: "{{\xa0sts.SessionToken }}"\n        region: "us-east-1"\n      register: buckets\n\n    - name: "Print Buckets"\n      debug:\n        var: buckets\n    ```\n\n* login to your adfs host by passing username and password credentials via a file\n\n    ```\n    aws-adfs login --adfs-host=your-adfs-hostname --authfile=/path/and/file/name\n    ```\n\n    Auth file should be in format of\n\n    ```\n    [profile_name]\n    username = your_username\n    password = your_password\n    ```\n\n* .aws/config profile for automatically refreshing credentials\n    ```\n    [profile example-role-ue1]\n    credential_process=aws-adfs login --region=us-east-1 --role-arn=arn:aws:iam::1234567891234:role/example-role --adfs-host=adfs.example.com --stdout\n    ```\n    Warning: see [AWS documentation](https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-sourcing-external.html) about security considerations to take when sourcing credentials with an external process.\n\n* help, help, help?\n    ```\n    $ aws-adfs --help\n    Usage: aws-adfs [OPTIONS] COMMAND [ARGS]...\n\n    Options:\n      --version  Show current tool version\n      --help  Show this message and exit.\n\n    Commands:\n      list   lists available profiles\n      login  Authenticates an user with active directory...\n      reset  removes stored profile\n    ```\n\n    ```\n    $ aws-adfs list --help\n    Usage: aws-adfs list [OPTIONS]\n\n      lists available profiles\n\n    Options:\n      --version  Show current tool version\n      --help  Show this message and exit.\n    ```\n\n    ```\n    $ aws-adfs login --help\n    Usage: aws-adfs login [OPTIONS]\n\n      Authenticates an user with active directory credentials\n\n    Options:\n      --profile TEXT                  AWS cli profile that will be authenticated.\n                                      After successful authentication just use:\n                                      aws --profile <authenticated profile>\n                                      <service> ...\n      --region TEXT                   The default AWS region that this script will\n                                      connect to for all API calls\n      --ssl-verification / --no-ssl-verification\n                                      SSL certificate verification: Whether or not\n                                      strict certificate verification is done,\n                                      False should only be used for dev/test\n      --adfs-ca-bundle TEXT           Override CA bundle for SSL certificate\n                                      verification for ADFS server only.\n      --adfs-host TEXT                For the first time for a profile it has to\n                                      be provided, next time for the same profile\n                                      it will be loaded from the stored\n                                      configuration\n      --output-format [json|text|table]\n                                      Output format used by aws cli\n      --provider-id TEXT              Provider ID, e.g urn:amazon:webservices\n                                      (optional)\n      --s3-signature-version [s3v4]   s3 signature version: Identifies the version\n                                      of AWS Signature to support for\n                                      authenticated requests. Valid values: s3v4\n      --username-password-command TEXT\n                                      Read username and password from the output\n                                      of a shell command (expected JSON format:\n                                      `{"username": "myusername", "password":\n                                      "mypassword"}`)\n      --env                           Read username, password from environment\n                                      variables (username and password).\n      --stdin                         Read username, password from standard input\n                                      separated by a newline.\n      --authfile TEXT                 Read username, password from a local file\n                                      (optional)\n      --stdout                        Print aws_session_token in json on stdout.\n      --printenv                      Output commands to set AWS_ACCESS_KEY_ID,\n                                      AWS_SECRET_ACCESS_KEY, AWS_SESSION_TOKEN,\n                                      AWS_DEFAULT_REGION environmental variables\n                                      instead of saving them to the aws\n                                      configuration file.\n      --print-console-signin-url      Output a URL that lets users who sign in to\n                                      your organization\'s network securely access\n                                      the AWS Management Console.\n      --console-role-arn TEXT         Role to assume for use in conjunction with\n                                      --print-console-signin-url\n      --console-external-id TEXT      External ID to pass in assume role for use\n                                      in conjunction with --print-console-signin-\n                                      url\n      --role-arn TEXT                 Predefined role arn to selects, e.g. aws-\n                                      adfs login --role-arn arn:aws:iam::123456789\n                                      012:role/YourSpecialRole\n      --session-duration INTEGER      Define the amount of seconds you want to\n                                      establish your STS session, e.g. aws-adfs\n                                      login --session-duration 3600\n      --no-session-cache              Do not use AWS session cache in\n                                      ~/.aws/adfs_cache/ directory.\n      --assertfile TEXT               Use SAML assertion response from a local\n                                      file\n      --sspi / --no-sspi              Whether or not to use Kerberos SSO\n                                      authentication via SSPI (Windows only,\n                                      defaults to True).\n      --help                          Show this message and exit.\n    ```\n    ```\n    $ aws-adfs reset --help                                                                                                                                              13:39\n    Usage: aws-adfs reset [OPTIONS]\n\n      removes stored profile\n\n    Options:\n      --profile TEXT  AWS cli profile that will be removed\n      --help          Show this message and exit.\n    ```\n\n# Known issues\n\n* duo-security\n\n    `Error: Cannot begin authentication process. The error response: {"message": "Unknown authentication method.", "stat": "FAIL"}`\n\n    Please setup preferred auth method in duo-security settings (settings\' -> \'My Settings & Devices\').\n\n* USB FIDO2 does not work in Windows Subsystem for Linux (WSL)\n\n    `OSError: [Errno 2] No such file or directory: \'/sys/class/hidraw\'`\n\n    USB devices are not accessible in WSL, please install and run `aws-adfs` on the Windows 10 host and then access the credentials in WSL from the filesystem. Example:\n\n    ```\n    export AWS_CONFIG_FILE=/mnt/c/Users/username/.aws/config\n    export AWS_SHARED_CREDENTIALS_FILE=/mnt/c/Users/username/.aws/credentials\n    ```\n\n*  FIDO2 devices are not detected on Windows 10 build 1903 or newer\n\n    Running `aws-adfs` as Administrator is required since Windows 10 build 1903 to access FIDO2 devices, cf. https://github.com/Yubico/python-fido2/issues/55)\n\n* in cases of trouble with lxml please install\n\n  ```\n  sudo apt-get install python-dev libxml2-dev libxslt1-dev zlib1g-dev\n  ```\n\n* in cases of trouble with pykerberos please install\n\n  ```\n  sudo apt-get install python-dev libkrb5-dev\n  ```\n\n* in cases of trouble with OSX Sierra (obsolete OpenSSL), upgrade OpenSSL. Example:\n  ```\n  brew upgrade openssl\n  ```\n  AND add explicit directive to .bash_profile:\n  ```\n  export PATH=$(brew --prefix openssl)/bin:$PATH\n  ```\n\n* only python >= 3.6 to <4.0 are supported:\n  - python 2.6 is not supported\n  - python 2.7 is not supported\n  - python 3.2 is not supported\n  - python 3.3 is not supported\n  - python 3.4 is not supported\n  - python 3.5 is not supported\n\n# Development\n\n* bump version:\n```\npoetry version [patch|minor|major|prepatch|preminor|premajor|prerelease]\n```\n\n* update dependencies:\n```\npoetry update\n```\n\n* run unit tests:\n```\npoetry run pytest\n```\n\n# Credits\n* [Brandond](https://github.com/brandond) for: Remove storage of credentials, in favor of storing ADFS session cookies\n* [Brandond](https://github.com/brandond) for: Add support for legacy aws_security_token key in credentials file\n* [Brandond](https://github.com/brandond) for: Store last username in profile config; use it as default for prompt\n* [Brandond](https://github.com/brandond) for: python 3 compatibility\n* [Brandond](https://github.com/brandond) for: Add support for Kerberos SSO on Windows via requests_negotiate_sspi\n* [Brandond](https://github.com/brandond) for: ssl_verification must be a str\n* [Brandond](https://github.com/brandond) for: Move pytest-runner out of setup-requires\n* [Brandond](https://github.com/brandond) for: Improve handling of role selection\n* [Brandond](https://github.com/brandond) for: Improve handling of errors caused by excessive cookie growth\n* [Brandond](https://github.com/brandond) for: Default to \'default\' profile, in line with other AWS tools\n* [kwhitlock](https://github.com/kwhitlock) for: Added extra option "--provider-id"\n* [SydOps](https://github.com/SydOps) for: add additional information in list command\'s output\n* [eric-nord](https://github.com/eric-nord) for: bringing topic of [duo security](https://duo.com) MFA integration\n* [roblugton](https://github.com/roblugton) for: Fix formatting in README.md\n* [cliv](https://github.com/cliv) for: pointing out the issue with missing preferred device for duo-security and providing workaround\n* [AndrewFarley](https://github.com/AndrewFarley) for: Bug in parsing Duo host and signature, backwards compatible\n* [eikenb](https://github.com/eikenb) for: Version 0.3.4 returns no roles - thanks for vigilance of [eikenb](https://github.com/eikenb) spoiled egg was identified\n* [eikenb](https://github.com/eikenb) for: add login argument to accept username/password from stdin\n* [irgeek](https://github.com/irgeek) for: Add Symantec VIP Access support\n* [Brandond](https://github.com/brandond) for: Fix Negotiate auth on non-domain-joined Windows hosts\n* [giafar](https://github.com/giafar) for: Role arn as parameter\n* [zanettibo](https://github.com/zanettibo) for: Add support for Ansible Tower/AWX workflow authentication\n* [anthoneous](https://github.com/anthoneous) and [KyleJamesWalker](https://github.com/KyleJamesWalker) for: add session duration flag\n* [KyleJamesWalker](https://github.com/KyleJamesWalker) for: Allow phone call authentication\n* [KyleJamesWalker](https://github.com/KyleJamesWalker) for: Change default profile to default\n* [kwhitlock](https://github.com/kwhitlock) for: Feature/read username and password from file\n* [avoidik](https://github.com/avoidik) for: Workaround of Symantec VIP obfuscated form\n* [leonardo-test](https://github.com/leonardo-test) for fix: The --env flag is not being called and therefore using the env parameter will not work.\n* [NotMrSteve](https://github.com/NotMrSteve) for: Add RSA SecurID MFA\n* [JLambeth](https://github.com/JLambeth) for: Added flag for disabling Kerberos SSO authentication via SSPI\n* [bghinkle](https://github.com/bghinkle) for: Fix Duo API change - follow result_url and return cookie from result\n* [jan-molak](https://github.com/jan-molak) for: Corrected the XPath expression to work with the latest version of AWS…\n* [NotMrSteve](https://github.com/NotMrSteve) for: Save duo session cookies\n* [pdecat](https://github.com/pdecat) for: Fallback on prompt if env, stdin or auth file do not provide both username and password\n* [0x91](https://github.com/0x91) for: Support for Azure MFA Server\n* [pdecat](https://github.com/pdecat) for: Fix Duo authentication initiation failure messages\n* [tommywo](https://github.com/tommywo) for: save provider_id config\n* [budzejko](https://github.com/budzejko) for: Add support for adfs-ca-bundle option\n* [rinrinne](https://github.com/rinrinne) for: Respect AWS_DEFAULT_PROFILE if defined\n* [mjernsell](https://github.com/mjernsell) for: Add support for AzureMfaAuthentication\n* [kfattig](https://github.com/kfattig) for: Handle sspi like other config options\n* [pdecat](https://github.com/pdecat) for:\n    * lxml 4.4.0 dropped support for python 3.4\n    * Add Duo U2F support\n    * Use MozillaCookieJar as LWPCookieJar has an issue on Windows when cookies have an \'expires\' date too far in the future and they are converted from timestamp to datetime\n    * Fix python 2.7 compatibility\n    * Document Windows 10 and WSL usage/issues\n    * Run tests with python 3.6, 3.7 and 3.8-dev\n    * Add options to trigger or not the default authentication method when U2F is available\n    * Fix AttributeError: \'generator\' object has no attribute \'append\' on python3\n    * Do not print stack trace if no U2F device is available\n    * Pin fido2 dependency to < 0.8.0 as it is a breaking release\n    * U2F: fido2 v0.8.1 compatibility (U2FClient.sign timeout renamed to event)\n* [bodgit](https://github.com/bodgit) for: Kerberos support\n* [pdecat](https://github.com/pdecat) for:\n    * Duo: support U2F with no preferred factor or device configured\n    * Document new libkrb5-dev system dependency for pykerberos\n    * Drop boto3 dependency\n    * Default SSPI to True on Windows only, False otherwise\n* [rheemskerk](https://github.com/rheemskerk) for:\n    * Fix username and password disclosure\n    * Fix authentication with cookies on non-windows system.\n    * Change `AuthMethod` parameter to `FormsAuthentication`\n* [brodie11](https://github.com/brodie11) and [gregorydulin](https://github.com/gregorydulin) for: Add support for non-public AWS regions\n* [johan1252](https://github.com/johan1252) for: Ask for authentication method if there is no default method set in Duo Security settings\n* [pdecat](https://github.com/pdecat) for: Always return the same number of values from _initiate_authentication()\n* [mikereinhold](https://github.com/mikereinhold) for: Feature credential process\n* [pdecat](https://github.com/pdecat) for:\n    * Add --username-password-command command line parameter\n    * Add --print-console-signin-url, --console-role-arn and --console-external-id command line parameters\n    * Update to fido2 v0.9.3\n    * Replace U2F by WebAuthn following Duo move from the former to the latter (compatible with FIDO U2F (CTAP1) by FIDO2 (CTAP2) authenticators)\n    * Remove --u2f-trigger-default/--no-u2f-trigger-default command line parameters\n* [mattmauriello](https://github.com/mattmauriello) for: Allow switching between multiple ADFS hosts without breaking former sessions\n* [fabaff](https://github.com/fabaff) for: Switch to poetry-core\n',
    'author': 'Venth',
    'author_email': 'artur.krysiak.warszawa@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
