# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['ServicePerimeter']


class ServicePerimeter(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 perimeter_type: Optional[pulumi.Input[str]] = None,
                 spec: Optional[pulumi.Input[pulumi.InputType['ServicePerimeterSpecArgs']]] = None,
                 status: Optional[pulumi.Input[pulumi.InputType['ServicePerimeterStatusArgs']]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 use_explicit_dry_run_spec: Optional[pulumi.Input[bool]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ServicePerimeter describes a set of GCP resources which can freely import
        and export data amongst themselves, but not export outside of the
        ServicePerimeter. If a request with a source within this ServicePerimeter
        has a target outside of the ServicePerimeter, the request will be blocked.
        Otherwise the request is allowed. There are two types of Service Perimeter
        - Regular and Bridge. Regular Service Perimeters cannot overlap, a single
          GCP project can only belong to a single regular Service Perimeter. Service
          Perimeter Bridges can contain only GCP projects as members, a single GCP
          project may belong to multiple Service Perimeter Bridges.

        To get more information about ServicePerimeter, see:

        * [API documentation](https://cloud.google.com/access-context-manager/docs/reference/rest/v1/accessPolicies.servicePerimeters)
        * How-to Guides
            * [Service Perimeter Quickstart](https://cloud.google.com/vpc-service-controls/docs/quickstart)

        > **Warning:** If you are using User ADCs (Application Default Credentials) with this resource,
        you must specify a `billing_project` and set `user_project_override` to true
        in the provider configuration. Otherwise the ACM API will return a 403 error.
        Your account must have the `serviceusage.services.use` permission on the
        `billing_project` you defined.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the ServicePerimeter and its use. Does not affect
               behavior.
        :param pulumi.Input[str] name: Resource name for the ServicePerimeter. The short_name component must
               begin with a letter and only include alphanumeric and '_'.
               Format: accessPolicies/{policy_id}/servicePerimeters/{short_name}
        :param pulumi.Input[str] parent: The AccessPolicy this ServicePerimeter lives in.
               Format: accessPolicies/{policy_id}
        :param pulumi.Input[str] perimeter_type: Specifies the type of the Perimeter. There are two types: regular and
               bridge. Regular Service Perimeter contains resources, access levels,
               and restricted services. Every resource can be in at most
               ONE regular Service Perimeter.
               In addition to being in a regular service perimeter, a resource can also
               be in zero or more perimeter bridges. A perimeter bridge only contains
               resources. Cross project operations are permitted if all effected
               resources share some perimeter (whether bridge or regular). Perimeter
               Bridge does not contain access levels or services: those are governed
               entirely by the regular perimeter that resource is in.
               Perimeter Bridges are typically useful when building more complex
               topologies with many independent perimeters that need to share some data
               with a common perimeter, but should not be able to share data among
               themselves.
               Default value is `PERIMETER_TYPE_REGULAR`.
               Possible values are `PERIMETER_TYPE_REGULAR` and `PERIMETER_TYPE_BRIDGE`.
        :param pulumi.Input[pulumi.InputType['ServicePerimeterSpecArgs']] spec: Proposed (or dry run) ServicePerimeter configuration.
               This configuration allows to specify and test ServicePerimeter configuration
               without enforcing actual access restrictions. Only allowed to be set when
               the `useExplicitDryRunSpec` flag is set.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['ServicePerimeterStatusArgs']] status: ServicePerimeter configuration. Specifies sets of resources,
               restricted services and access levels that determine
               perimeter content and boundaries.
               Structure is documented below.
        :param pulumi.Input[str] title: Human readable title. Must be unique within the Policy.
        :param pulumi.Input[bool] use_explicit_dry_run_spec: Use explicit dry run spec flag. Ordinarily, a dry-run spec implicitly exists
               for all Service Perimeters, and that spec is identical to the status for those
               Service Perimeters. When this flag is set, it inhibits the generation of the
               implicit spec, thereby allowing the user to explicitly provide a
               configuration ("spec") to use in a dry-run version of the Service Perimeter.
               This allows the user to test changes to the enforced config ("status") without
               actually enforcing them. This testing is done through analyzing the differences
               between currently enforced and suggested restrictions. useExplicitDryRunSpec must
               bet set to True if any of the fields in the spec are set to non-default values.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['description'] = description
            __props__['name'] = name
            if parent is None:
                raise TypeError("Missing required property 'parent'")
            __props__['parent'] = parent
            __props__['perimeter_type'] = perimeter_type
            __props__['spec'] = spec
            __props__['status'] = status
            if title is None:
                raise TypeError("Missing required property 'title'")
            __props__['title'] = title
            __props__['use_explicit_dry_run_spec'] = use_explicit_dry_run_spec
            __props__['create_time'] = None
            __props__['update_time'] = None
        super(ServicePerimeter, __self__).__init__(
            'gcp:accesscontextmanager/servicePerimeter:ServicePerimeter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            parent: Optional[pulumi.Input[str]] = None,
            perimeter_type: Optional[pulumi.Input[str]] = None,
            spec: Optional[pulumi.Input[pulumi.InputType['ServicePerimeterSpecArgs']]] = None,
            status: Optional[pulumi.Input[pulumi.InputType['ServicePerimeterStatusArgs']]] = None,
            title: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None,
            use_explicit_dry_run_spec: Optional[pulumi.Input[bool]] = None) -> 'ServicePerimeter':
        """
        Get an existing ServicePerimeter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_time: Time the AccessPolicy was created in UTC.
        :param pulumi.Input[str] description: Description of the ServicePerimeter and its use. Does not affect
               behavior.
        :param pulumi.Input[str] name: Resource name for the ServicePerimeter. The short_name component must
               begin with a letter and only include alphanumeric and '_'.
               Format: accessPolicies/{policy_id}/servicePerimeters/{short_name}
        :param pulumi.Input[str] parent: The AccessPolicy this ServicePerimeter lives in.
               Format: accessPolicies/{policy_id}
        :param pulumi.Input[str] perimeter_type: Specifies the type of the Perimeter. There are two types: regular and
               bridge. Regular Service Perimeter contains resources, access levels,
               and restricted services. Every resource can be in at most
               ONE regular Service Perimeter.
               In addition to being in a regular service perimeter, a resource can also
               be in zero or more perimeter bridges. A perimeter bridge only contains
               resources. Cross project operations are permitted if all effected
               resources share some perimeter (whether bridge or regular). Perimeter
               Bridge does not contain access levels or services: those are governed
               entirely by the regular perimeter that resource is in.
               Perimeter Bridges are typically useful when building more complex
               topologies with many independent perimeters that need to share some data
               with a common perimeter, but should not be able to share data among
               themselves.
               Default value is `PERIMETER_TYPE_REGULAR`.
               Possible values are `PERIMETER_TYPE_REGULAR` and `PERIMETER_TYPE_BRIDGE`.
        :param pulumi.Input[pulumi.InputType['ServicePerimeterSpecArgs']] spec: Proposed (or dry run) ServicePerimeter configuration.
               This configuration allows to specify and test ServicePerimeter configuration
               without enforcing actual access restrictions. Only allowed to be set when
               the `useExplicitDryRunSpec` flag is set.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['ServicePerimeterStatusArgs']] status: ServicePerimeter configuration. Specifies sets of resources,
               restricted services and access levels that determine
               perimeter content and boundaries.
               Structure is documented below.
        :param pulumi.Input[str] title: Human readable title. Must be unique within the Policy.
        :param pulumi.Input[str] update_time: Time the AccessPolicy was updated in UTC.
        :param pulumi.Input[bool] use_explicit_dry_run_spec: Use explicit dry run spec flag. Ordinarily, a dry-run spec implicitly exists
               for all Service Perimeters, and that spec is identical to the status for those
               Service Perimeters. When this flag is set, it inhibits the generation of the
               implicit spec, thereby allowing the user to explicitly provide a
               configuration ("spec") to use in a dry-run version of the Service Perimeter.
               This allows the user to test changes to the enforced config ("status") without
               actually enforcing them. This testing is done through analyzing the differences
               between currently enforced and suggested restrictions. useExplicitDryRunSpec must
               bet set to True if any of the fields in the spec are set to non-default values.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["create_time"] = create_time
        __props__["description"] = description
        __props__["name"] = name
        __props__["parent"] = parent
        __props__["perimeter_type"] = perimeter_type
        __props__["spec"] = spec
        __props__["status"] = status
        __props__["title"] = title
        __props__["update_time"] = update_time
        __props__["use_explicit_dry_run_spec"] = use_explicit_dry_run_spec
        return ServicePerimeter(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time the AccessPolicy was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the ServicePerimeter and its use. Does not affect
        behavior.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name for the ServicePerimeter. The short_name component must
        begin with a letter and only include alphanumeric and '_'.
        Format: accessPolicies/{policy_id}/servicePerimeters/{short_name}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output[str]:
        """
        The AccessPolicy this ServicePerimeter lives in.
        Format: accessPolicies/{policy_id}
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter(name="perimeterType")
    def perimeter_type(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the type of the Perimeter. There are two types: regular and
        bridge. Regular Service Perimeter contains resources, access levels,
        and restricted services. Every resource can be in at most
        ONE regular Service Perimeter.
        In addition to being in a regular service perimeter, a resource can also
        be in zero or more perimeter bridges. A perimeter bridge only contains
        resources. Cross project operations are permitted if all effected
        resources share some perimeter (whether bridge or regular). Perimeter
        Bridge does not contain access levels or services: those are governed
        entirely by the regular perimeter that resource is in.
        Perimeter Bridges are typically useful when building more complex
        topologies with many independent perimeters that need to share some data
        with a common perimeter, but should not be able to share data among
        themselves.
        Default value is `PERIMETER_TYPE_REGULAR`.
        Possible values are `PERIMETER_TYPE_REGULAR` and `PERIMETER_TYPE_BRIDGE`.
        """
        return pulumi.get(self, "perimeter_type")

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Output[Optional['outputs.ServicePerimeterSpec']]:
        """
        Proposed (or dry run) ServicePerimeter configuration.
        This configuration allows to specify and test ServicePerimeter configuration
        without enforcing actual access restrictions. Only allowed to be set when
        the `useExplicitDryRunSpec` flag is set.
        Structure is documented below.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional['outputs.ServicePerimeterStatus']]:
        """
        ServicePerimeter configuration. Specifies sets of resources,
        restricted services and access levels that determine
        perimeter content and boundaries.
        Structure is documented below.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[str]:
        """
        Human readable title. Must be unique within the Policy.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Time the AccessPolicy was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="useExplicitDryRunSpec")
    def use_explicit_dry_run_spec(self) -> pulumi.Output[Optional[bool]]:
        """
        Use explicit dry run spec flag. Ordinarily, a dry-run spec implicitly exists
        for all Service Perimeters, and that spec is identical to the status for those
        Service Perimeters. When this flag is set, it inhibits the generation of the
        implicit spec, thereby allowing the user to explicitly provide a
        configuration ("spec") to use in a dry-run version of the Service Perimeter.
        This allows the user to test changes to the enforced config ("status") without
        actually enforcing them. This testing is done through analyzing the differences
        between currently enforced and suggested restrictions. useExplicitDryRunSpec must
        bet set to True if any of the fields in the spec are set to non-default values.
        """
        return pulumi.get(self, "use_explicit_dry_run_spec")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

